# Generated by Django 2.2.9 on 2020-02-10 10:05

from django.db import migrations

from weblate.addons.events import EVENT_COMPONENT_UPDATE, EVENT_POST_UPDATE
from weblate.addons.utils import adjust_addon_events


def update_addon(apps, schema_editor):
    """Update the repo_scope flag."""
    adjust_addon_events(
        apps,
        schema_editor,
        ("weblate.autotranslate.autotranslate", "weblate.flags.bulk"),
        [EVENT_COMPONENT_UPDATE],
        [EVENT_POST_UPDATE],
    )


class Migration(migrations.Migration):

    dependencies = [("addons", "0019_auto_20200210_0957")]

    operations = [
        migrations.RunPython(update_addon, migrations.RunPython.noop, elidable=True)
    ]
