# Generated by Django 1.11.13 on 2018-06-21 13:03

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [("trans", "0001_squashed_0143_auto_20180609_1655")]

    operations = [
        migrations.CreateModel(
            name="Billing",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                )
            ],
        ),
        migrations.CreateModel(
            name="Plan",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("price", models.IntegerField(default=0)),
                ("limit_strings", models.IntegerField(default=0)),
                ("limit_languages", models.IntegerField(default=0)),
                ("limit_repositories", models.IntegerField(default=0)),
                ("limit_projects", models.IntegerField(default=0)),
                ("yearly_price", models.IntegerField(default=0)),
                ("display_limit_languages", models.IntegerField(default=0)),
                ("display_limit_projects", models.IntegerField(default=0)),
                ("display_limit_repositories", models.IntegerField(default=0)),
                ("display_limit_strings", models.IntegerField(default=0)),
                ("change_access_control", models.BooleanField(default=True)),
            ],
            options={"ordering": ["price"]},
        ),
        migrations.AddField(
            model_name="billing",
            name="plan",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="billing.Plan"
            ),
        ),
        migrations.AddField(
            model_name="billing",
            name="projects",
            field=models.ManyToManyField(blank=True, to="trans.Project"),
        ),
        migrations.CreateModel(
            name="Invoice",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("start", models.DateField()),
                ("end", models.DateField()),
                ("payment", models.FloatField()),
                (
                    "currency",
                    models.IntegerField(
                        choices=[(0, "EUR"), (1, "mBTC"), (2, "USD"), (3, "CZK")],
                        default=0,
                    ),
                ),
                ("ref", models.CharField(blank=True, max_length=50)),
                ("note", models.TextField(blank=True)),
                (
                    "billing",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="billing.Billing",
                    ),
                ),
            ],
            options={"ordering": ["billing", "-start"]},
        ),
        migrations.AddField(
            model_name="billing",
            name="state",
            field=models.IntegerField(
                choices=[(0, "Active"), (1, "Trial"), (2, "Expired")], default=0
            ),
        ),
    ]
