# Generated by Django 3.0.4 on 2020-03-20 10:06

from django.db import migrations
from django.utils.text import slugify


def update_slug(apps, schema_editor):
    db_alias = schema_editor.connection.alias

    Plan = apps.get_model("billing", "Plan")
    for plan in Plan.objects.using(db_alias).filter(slug="").iterator():
        plan.slug = slugify(plan.name)
        plan.save(update_fields=["slug"])


class Migration(migrations.Migration):

    dependencies = [
        ("billing", "0018_plan_slug"),
    ]

    operations = [
        migrations.RunPython(update_slug, migrations.RunPython.noop, elidable=True)
    ]
