# Generated by Django 3.0.5 on 2020-04-16 11:17

import django.db.models.deletion
from django.db import migrations, models

import weblate.lang.models
import weblate.utils.validators


class Migration(migrations.Migration):

    replaces = [
        ("lang", "0001_squashed_0011_auto_20180215_1158"),
        ("lang", "0002_auto_20190516_1245"),
        ("lang", "0003_auto_20190721_1810"),
        ("lang", "0004_auto_20190809_0930"),
        ("lang", "0005_auto_20200212_1239"),
        ("lang", "0006_auto_20200309_1436"),
        ("lang", "0007_auto_20200404_1111"),
        ("lang", "0008_auto_20200408_0436"),
    ]

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Language",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.SlugField(unique=True, verbose_name="Language code")),
                (
                    "name",
                    models.CharField(max_length=100, verbose_name="Language name"),
                ),
                (
                    "direction",
                    models.CharField(
                        choices=[
                            ("", ""),
                            ("ltr", "Left to right"),
                            ("rtl", "Right to left"),
                        ],
                        default="",
                        max_length=3,
                        verbose_name="Text direction",
                    ),
                ),
            ],
            options={"verbose_name": "Language", "verbose_name_plural": "Languages"},
        ),
        migrations.AlterModelManagers(
            name="language",
            managers=[("objects", weblate.lang.models.LanguageManager())],
        ),
        migrations.CreateModel(
            name="Plural",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "source",
                    models.SmallIntegerField(
                        choices=[
                            (0, "Default plural"),
                            (1, "Plural gettext formula"),
                            (2, "Manually entered formula"),
                        ],
                        default=0,
                        verbose_name="Plural definition source",
                    ),
                ),
                (
                    "number",
                    models.SmallIntegerField(
                        default=2, verbose_name="Number of plurals"
                    ),
                ),
                (
                    "formula",
                    models.CharField(
                        default="n != 1",
                        max_length=600,
                        validators=[weblate.utils.validators.validate_plural_formula],
                        verbose_name="Plural formula",
                    ),
                ),
                (
                    "type",
                    models.IntegerField(
                        choices=[
                            (0, "None"),
                            (1, "One/other (classic plural)"),
                            (2, "One/few/other (Slavic languages)"),
                            (3, "Arabic languages"),
                            (11, "Zero/one/other"),
                            (4, "One/two/other"),
                            (14, "One/other/two"),
                            (6, "One/two/few/other"),
                            (13, "Other/one/two/few"),
                            (5, "One/two/three/other"),
                            (7, "One/other/zero"),
                            (8, "One/few/many/other"),
                            (9, "Two/other"),
                            (10, "One/two/few/many/other"),
                            (666, "Unknown"),
                            (12, "Zero/one/two/few/many/other"),
                        ],
                        default=1,
                        editable=False,
                        verbose_name="Plural type",
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="lang.Language"
                    ),
                ),
            ],
            options={
                "verbose_name": "Plural form",
                "verbose_name_plural": "Plural forms",
            },
        ),
    ]
