#
# Copyright © 2012 - 2020 Michal Čihař <michal@cihar.com>
#
# This file is part of Weblate <https://weblate.org/>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

"""Language data definitions.

This is an automatically generated file, see scripts/generate-language-data

Do not edit, please adjust language definitions in following repository:
https://github.com/WeblateOrg/language-data
"""
# pylint: disable=line-too-long,too-many-lines


# Language aliases
ALIASES = {
    "arabic": "ar",
    "braz_por": "pt_BR",
    "chinese_chs": "zh_Hans",
    "schinese": "zh_Hans",
    "chinese_zh": "zh_Hant",
    "tchinese": "zh_Hant",
    "korean": "ko",
    "dutch_be": "nl_BE",
    "english": "en",
    "english_uk": "en_GB",
    "portuguese_br": "pt_BR",
    "portuguese_portugal": "pt_PT",
    "russian": "ru",
    "serbo_croatian": "sr_Latn",
    "serbian": "sr",
    "indonesian": "id",
    "norwegian": "nb_NO",
    "spanish": "es",
    "german": "de",
    "french": "fr",
    "polish": "pl",
    "be_rby": "be_Latn",
    "val_es": "ca@valencia",
    "no_nb": "nb_NO",
    "no_no": "nb_NO",
    "es_eu": "eu",
    "ru_r": "ru",
    "ru_rr": "ru",
    "ar_ar": "ar",
    "jp": "ja",
    "ba_ck": "ba",
    "ca_ps": "ca",
    "by": "be",
    "ua": "uk",
    "en_en": "en",
    "cn": "zh_Hans",
    "sl_sl": "sl",
    "in": "id",
    "iw": "he",
    "iw_il": "he",
    "in_id": "id",
    "ji": "yi",
    "jw": "jv",
    "mo": "ro_MD",
    "scc": "sr",
    "scr": "hr",
    "sh": "sr_Latn",
    "no": "nb_NO",
    "sr_cs": "sr",
    "sr_latn_rs": "sr_Latn",
    "bs_latn_ba": "bs_Latn",
    "nb": "nb_NO",
    "be@latin": "be_Latn",
    "sr@latin": "sr_Latn",
    "sr_rs@latin": "sr_Latn",
    "sr@cyrillic": "sr_Cyrl",
    "sr_rs@cyrillic": "sr_Cyrl",
    "uz@latin": "uz_Latn",
    "zh": "zh_Hans",
    "zhcn": "zh_Hans",
    "zh_cn": "zh_Hans",
    "zh_chs": "zh_Hans",
    "zh_sg": "zh_Hans_SG",
    "zhtw": "zh_Hant",
    "zh_tw": "zh_Hant",
    "zh_hant_tw": "zh_Hant",
    "cmn": "zh_Hans",
    "zh_hk": "zh_Hant_HK",
    "zh_hans_cn": "zh_Hans",
    "zh_cmn_hans": "zh_Hans",
    "zh_cmn_hant": "zh_Hant",
    "zh_latn_pinyin": "zh_Latn",
    "zh_latn@pinyin": "zh_Latn",
    "base": "en",
    "source": "en",
    "de_fo": "de_form",
    "dk": "da",
    "gr": "el",
    "rs": "sr",
    "kz": "kk",
    "ca_es@valencia": "ca@valencia",
    "svk": "sk",
    "aar": "aa",
    "abk": "ab",
    "afr": "af",
    "aka": "ak",
    "alb": "sq",
    "amh": "am",
    "ara": "ar",
    "arg": "an",
    "arm": "hy",
    "asm": "as",
    "ava": "av",
    "ave": "ae",
    "aym": "ay",
    "aze": "az",
    "bak": "ba",
    "bam": "bm",
    "baq": "eu",
    "bel": "be",
    "ben": "bn",
    "bih": "bh",
    "bis": "bi",
    "bod": "bo",
    "bos": "bs",
    "bre": "br",
    "bul": "bg",
    "bur": "my",
    "cat": "ca",
    "ces": "cs",
    "cha": "ch",
    "che": "ce",
    "chi": "zh",
    "chu": "cu",
    "chv": "cv",
    "cor": "kw",
    "cos": "co",
    "cre": "cr",
    "cym": "cy",
    "cze": "cs",
    "dan": "da",
    "deu": "de",
    "div": "dv",
    "dut": "nl",
    "dzo": "dz",
    "ell": "el",
    "eng": "en",
    "epo": "eo",
    "est": "et",
    "eus": "eu",
    "ewe": "ee",
    "fao": "fo",
    "fas": "fa",
    "fij": "fj",
    "fin": "fi",
    "fra": "fr",
    "fre": "fr",
    "fry": "fy",
    "ful": "ff",
    "geo": "ka",
    "ger": "de",
    "gla": "gd",
    "gle": "ga",
    "glg": "gl",
    "glv": "gv",
    "gre": "el",
    "grn": "gn",
    "guj": "gu",
    "hat": "ht",
    "hau": "ha",
    "hbs": "sh",
    "heb": "he",
    "her": "hz",
    "hin": "hi",
    "hmo": "ho",
    "hrv": "hr",
    "hun": "hu",
    "hye": "hy",
    "ibo": "ig",
    "ice": "is",
    "ido": "io",
    "iii": "ii",
    "iku": "iu",
    "ile": "ie",
    "ina": "ia",
    "ind": "id",
    "ipk": "ik",
    "isl": "is",
    "ita": "it",
    "jav": "jv",
    "jpn": "ja",
    "kal": "kl",
    "kan": "kn",
    "kas": "ks",
    "kat": "ka",
    "kau": "kr",
    "kaz": "kk",
    "khm": "km",
    "kik": "ki",
    "kin": "rw",
    "kir": "ky",
    "kom": "kv",
    "kon": "kg",
    "kor": "ko",
    "kua": "kj",
    "kur": "ku",
    "lao": "lo",
    "lat": "la",
    "lav": "lv",
    "lim": "li",
    "lin": "ln",
    "lit": "lt",
    "ltz": "lb",
    "lub": "lu",
    "lug": "lg",
    "mac": "mk",
    "mah": "mh",
    "mal": "ml",
    "mao": "mi",
    "mar": "mr",
    "may": "ms",
    "mkd": "mk",
    "mlg": "mg",
    "mlt": "mt",
    "mon": "mn",
    "mri": "mi",
    "msa": "ms",
    "mya": "my",
    "nau": "na",
    "nav": "nv",
    "nbl": "nr",
    "nde": "nd",
    "ndo": "ng",
    "nep": "ne",
    "nld": "nl",
    "nno": "nn",
    "nob": "nb",
    "nor": "no",
    "nya": "ny",
    "oci": "oc",
    "oji": "oj",
    "ori": "or",
    "orm": "om",
    "oss": "os",
    "pan": "pa",
    "per": "fa",
    "pli": "pi",
    "pol": "pl",
    "por": "pt",
    "pus": "ps",
    "que": "qu",
    "roh": "rm",
    "ron": "ro",
    "rum": "ro",
    "run": "rn",
    "rus": "ru",
    "sag": "sg",
    "san": "sa",
    "sin": "si",
    "slk": "sk",
    "slo": "sk",
    "slv": "sl",
    "sme": "se",
    "smo": "sm",
    "sna": "sn",
    "snd": "sd",
    "som": "so",
    "sot": "st",
    "spa": "es",
    "sqi": "sq",
    "srd": "sc",
    "srp": "sr",
    "ssw": "ss",
    "sun": "su",
    "swa": "sw",
    "swe": "sv",
    "tah": "ty",
    "tam": "ta",
    "tat": "tt",
    "tel": "te",
    "tgk": "tg",
    "tgl": "tl",
    "tha": "th",
    "tib": "bo",
    "tir": "ti",
    "ton": "to",
    "tsn": "tn",
    "tso": "ts",
    "tuk": "tk",
    "tur": "tr",
    "twi": "tw",
    "uig": "ug",
    "ukr": "uk",
    "urd": "ur",
    "uzb": "uz",
    "ven": "ve",
    "vie": "vi",
    "vol": "vo",
    "wel": "cy",
    "wln": "wa",
    "wol": "wo",
    "xho": "xh",
    "yid": "yi",
    "yor": "yo",
    "zha": "za",
    "zho": "zh_Hant",
    "zul": "zu",
}
