# Generated by Django 2.2.1 on 2019-05-15 04:46

from django.db import migrations


def migrate_alert_change(apps, schema_editor):
    Change = apps.get_model("trans", "Change")
    db_alias = schema_editor.connection.alias
    for change in Change.objects.using(db_alias).filter(action=47).exclude(target=""):
        change.details = {"alert": change.target}
        change.target = ""
        change.save()


class Migration(migrations.Migration):

    dependencies = [("trans", "0025_auto_20190426_0941")]

    operations = [
        migrations.RunPython(
            migrate_alert_change, migrations.RunPython.noop, elidable=True
        )
    ]
