# Generated by Django 2.2.1 on 2019-05-21 18:16

from django.db import migrations

from weblate.utils.db import table_has_row


def migrate_votes(apps, schema_editor):
    if not table_has_row(schema_editor.connection, "trans_vote", "positive"):
        return
    Vote = apps.get_model("trans", "Vote")
    db_alias = schema_editor.connection.alias
    Vote.objects.using(db_alias).filter(positive=True).update(value=1)
    Vote.objects.using(db_alias).filter(positive=False).update(value=-1)


class Migration(migrations.Migration):

    dependencies = [("trans", "0028_vote_value")]

    operations = [migrations.RunPython(migrate_votes, elidable=True)]
