# Generated by Django 2.2.5 on 2019-11-25 09:44

from django.db import migrations


def migrate_comments(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    Change = apps.get_model("trans", "Change")
    # Filter for ACTION_COMMENT
    for change in Change.objects.using(db_alias).filter(action=3):
        if not change.comment:
            # Removed comment
            continue
        change.details = {"comment": change.comment.comment}
        change.save(update_fields=["details"])


class Migration(migrations.Migration):

    dependencies = [("trans", "0048_auto_20191108_1349")]

    operations = [
        migrations.RunPython(migrate_comments, migrations.RunPython.noop, elidable=True)
    ]
