# Generated by Django 2.2.5 on 2019-12-10 13:43


from django.db import migrations

from weblate.utils.licenses import convert_license


def migrate_licenses(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    Component = apps.get_model("trans", "Component")
    for component in Component.objects.using(db_alias).exclude(license=""):
        converted = convert_license(component.license)
        if converted == component.license:
            continue
        if converted == "proprietary":
            print(
                'WARNING: Converted {}/{} license "{}" to "{}"'.format(
                    component.project.slug, component.slug, component.license, converted
                )
            )
        component.license = converted
        component.save(update_fields=["license"])


class Migration(migrations.Migration):

    dependencies = [("trans", "0049_change_comment")]

    operations = [
        migrations.RunPython(migrate_licenses, migrations.RunPython.noop, elidable=True)
    ]
