# Generated by Django 3.1 on 2020-02-18 11:08

from django.db import migrations, models

import weblate.trans.validators
import weblate.utils.validators


class Migration(migrations.Migration):

    dependencies = [("trans", "0060_component_enforced_checks")]

    operations = [
        migrations.AlterField(
            model_name="component",
            name="filemask",
            field=models.CharField(
                help_text="Path of files to translate relative to repository root, use * instead of language code, for example: po/*.po or locale/*/LC_MESSAGES/django.po.",
                max_length=400,
                validators=[
                    weblate.trans.validators.validate_filemask,
                    weblate.utils.validators.validate_filename,
                ],
                verbose_name="Filemask",
            ),
        ),
        migrations.AlterField(
            model_name="component",
            name="new_base",
            field=models.CharField(
                blank=True,
                help_text="Filename of file used for creating new translations. For gettext choose .pot file.",
                max_length=400,
                validators=[weblate.utils.validators.validate_filename],
                verbose_name="Template for new translations",
            ),
        ),
        migrations.AlterField(
            model_name="component",
            name="template",
            field=models.CharField(
                blank=True,
                help_text="Filename of translation base file, containing all strings and their source; it is recommended for monolingual translation formats.",
                max_length=400,
                validators=[weblate.utils.validators.validate_filename],
                verbose_name="Monolingual base language file",
            ),
        ),
    ]
