# Generated by Django 3.0.4 on 2020-03-16 08:46

from django.db import migrations


def migrate_changes(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    Change = apps.get_model("trans", "Change")
    for change in (
        Change.objects.using(db_alias)
        .filter(language=None)
        .exclude(dictionary=None)
        .prefetch_related("dictionary")
    ):
        change.language = change.dictionary.language
        change.save(update_fields=["language"])

    for change in (
        Change.objects.using(db_alias)
        .filter(language=None)
        .exclude(translation=None)
        .prefetch_related("translation")
    ):
        change.language = change.translation.language
        change.save(update_fields=["language"])


class Migration(migrations.Migration):

    dependencies = [
        ("trans", "0066_change_language"),
    ]

    operations = [
        migrations.RunPython(migrate_changes, migrations.RunPython.noop, elidable=True)
    ]
