# The PEP 484 type hints stub file for the QtPurchasing module.
#
# Generated by SIP 6.7.12
#
# Copyright (c) 2023 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQtPurchasing.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing

import PyQt5.sip

from PyQt5 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., Any], QtCore.pyqtBoundSignal]


class QInAppProduct(QtCore.QObject):

    class ProductType(int):
        Consumable = ... # type: QInAppProduct.ProductType
        Unlockable = ... # type: QInAppProduct.ProductType

    def purchase(self) -> None: ...
    def description(self) -> str: ...
    def title(self) -> str: ...
    def price(self) -> str: ...
    def productType(self) -> 'QInAppProduct.ProductType': ...
    def identifier(self) -> str: ...


class QInAppStore(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    transactionReady: typing.ClassVar[QtCore.pyqtSignal]
    productUnknown: typing.ClassVar[QtCore.pyqtSignal]
    productRegistered: typing.ClassVar[QtCore.pyqtSignal]
    def setPlatformProperty(self, propertyName: typing.Optional[str], value: typing.Optional[str]) -> None: ...
    def registeredProduct(self, identifier: typing.Optional[str]) -> typing.Optional[QInAppProduct]: ...
    def registerProduct(self, productType: QInAppProduct.ProductType, identifier: typing.Optional[str]) -> None: ...
    def restorePurchases(self) -> None: ...


class QInAppTransaction(QtCore.QObject):

    class FailureReason(int):
        NoFailure = ... # type: QInAppTransaction.FailureReason
        CanceledByUser = ... # type: QInAppTransaction.FailureReason
        ErrorOccurred = ... # type: QInAppTransaction.FailureReason

    class TransactionStatus(int):
        Unknown = ... # type: QInAppTransaction.TransactionStatus
        PurchaseApproved = ... # type: QInAppTransaction.TransactionStatus
        PurchaseFailed = ... # type: QInAppTransaction.TransactionStatus
        PurchaseRestored = ... # type: QInAppTransaction.TransactionStatus

    def status(self) -> 'QInAppTransaction.TransactionStatus': ...
    def platformProperty(self, propertyName: typing.Optional[str]) -> str: ...
    def finalize(self) -> None: ...
    def timestamp(self) -> QtCore.QDateTime: ...
    def errorString(self) -> str: ...
    def failureReason(self) -> 'QInAppTransaction.FailureReason': ...
    def orderId(self) -> str: ...
    def product(self) -> typing.Optional[QInAppProduct]: ...


PYQT_PURCHASING_VERSION = ... # type: int
PYQT_PURCHASING_VERSION_STR = ... # type: str
QTPURCHASING_VERSION = ... # type: int
QTPURCHASING_VERSION_STR = ... # type: str
