"""
This file is automatically generated.

Do not modify.
"""
import sys
import functools
import warnings
import json

try:
    from typing import List, Optional
    from ceph.mon_command_api import CommandResult
except ImportError:
    pass

if sys.version_info > (3, 0):
    from typing import overload


def deprecated(func):
    @functools.wraps(func)
    def new_func(*args, **kwargs):
        warnings.simplefilter('always', DeprecationWarning)  # turn off filter
        warnings.warn("Call to deprecated function {}.".format(func.__name__),
                      category=DeprecationWarning,
                      stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)  # reset filter
        return func(*args, **kwargs)
    return new_func


class MonCommandApi(object):
    """
    MonCommandApi is a class that provides access to the whole Ceph command line API in a 
    type save way. 
    
    Usage:
    
    >>> import rados
    ... from ceph_command_api import MonCommandApi
    ... cluster = rados.Rados(conffile='/etc/ceph/ceph.conf')
    ... cluster.connect()
    ... print(MonCommandApi(cluster).version())
    """
    def __init__(self, rados):
        self._rados = rados
        
    def _mon_command(self, cmd, inbuf=b'', target=None):
        res = self._rados.mon_command(json.dumps(cmd), inbuf=inbuf, target=target)
        return CommandResult(*res)
    
    def ansible_set_ssl_certificate(self, mgr_id: Optional[str]=None):
        """
        Example command:
        
        .. code-block:: bash
        
            ceph ansible set-ssl-certificate --mgr_id=string
        
        module=mgr perm=w flags=mgr
        
        :param mgr_id:
        """
        prefix = 'ansible set-ssl-certificate'
        _args = {'prefix': prefix, 'mgr_id': mgr_id}
        return self._mon_command(_args)
    
    def ansible_set_ssl_certificate_key(self, mgr_id: Optional[str]=None):
        """
        Example command:
        
        .. code-block:: bash
        
            ceph ansible set-ssl-certificate-key --mgr_id=string
        
        module=mgr perm=w flags=mgr
        
        :param mgr_id:
        """
        prefix = 'ansible set-ssl-certificate-key'
        _args = {'prefix': prefix, 'mgr_id': mgr_id}
        return self._mon_command(_args)
    
    def auth_add(self, entity: str, caps: Optional[List[str]]=None):
        """
        add auth info for <entity> from input file, or random key if no input
        is given, and/or any caps specified in the command
        
        Example command:
        
        .. code-block:: bash
        
            ceph auth add --entity=string --caps=string
        
        module=auth perm=rwx flags=
        
        :param entity:
        :param caps:
        """
        prefix = 'auth add'
        _args = {'prefix': prefix, 'entity': entity, 'caps': caps}
        return self._mon_command(_args)
    
    def auth_caps(self, entity: str, caps: List[str]):
        """
        update caps for <name> from caps specified in the command
        
        Example command:
        
        .. code-block:: bash
        
            ceph auth caps --entity=string --caps=string
        
        module=auth perm=rwx flags=
        
        :param entity:
        :param caps:
        """
        prefix = 'auth caps'
        _args = {'prefix': prefix, 'entity': entity, 'caps': caps}
        return self._mon_command(_args)
    
    @deprecated
    def auth_del(self, entity: str):
        """
        delete all caps for <name>
        
        Example command:
        
        .. code-block:: bash
        
            ceph auth del --entity=string
        
        module=auth perm=rwx flags=deprecated
        
        :param entity:
        """
        prefix = 'auth del'
        _args = {'prefix': prefix, 'entity': entity}
        return self._mon_command(_args)
    
    def auth_export(self, entity: Optional[str]=None):
        """
        write keyring for requested entity, or master keyring if none given
        
        Example command:
        
        .. code-block:: bash
        
            ceph auth export --entity=string
        
        module=auth perm=rx flags=
        
        :param entity:
        """
        prefix = 'auth export'
        _args = {'prefix': prefix, 'entity': entity}
        return self._mon_command(_args)
    
    def auth_get(self, entity: str):
        """
        write keyring file with requested key
        
        Example command:
        
        .. code-block:: bash
        
            ceph auth get --entity=string
        
        module=auth perm=rx flags=
        
        :param entity:
        """
        prefix = 'auth get'
        _args = {'prefix': prefix, 'entity': entity}
        return self._mon_command(_args)
    
    def auth_get_key(self, entity: str):
        """
        display requested key
        
        Example command:
        
        .. code-block:: bash
        
            ceph auth get-key --entity=string
        
        module=auth perm=rx flags=
        
        :param entity:
        """
        prefix = 'auth get-key'
        _args = {'prefix': prefix, 'entity': entity}
        return self._mon_command(_args)
    
    def auth_get_or_create(self, entity: str, caps: Optional[List[str]]=None):
        """
        add auth info for <entity> from input file, or random key if no input
        given, and/or any caps specified in the command
        
        Example command:
        
        .. code-block:: bash
        
            ceph auth get-or-create --entity=string --caps=string
        
        module=auth perm=rwx flags=
        
        :param entity:
        :param caps:
        """
        prefix = 'auth get-or-create'
        _args = {'prefix': prefix, 'entity': entity, 'caps': caps}
        return self._mon_command(_args)
    
    def auth_get_or_create_key(self, entity: str, caps: Optional[List[str]]=None):
        """
        get, or add, key for <name> from system/caps pairs specified in the
        command.  If key already exists, any given caps must match the
        existing caps for that key.
        
        Example command:
        
        .. code-block:: bash
        
            ceph auth get-or-create-key --entity=string --caps=string
        
        module=auth perm=rwx flags=
        
        :param entity:
        :param caps:
        """
        prefix = 'auth get-or-create-key'
        _args = {'prefix': prefix, 'entity': entity, 'caps': caps}
        return self._mon_command(_args)
    
    def auth_import(self):
        """
        auth import: read keyring file from -i <file>
        
        Example command:
        
        .. code-block:: bash
        
            ceph auth import
        
        module=auth perm=rwx flags=
        """
        prefix = 'auth import'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    @deprecated
    def auth_list(self):
        """
        list authentication state
        
        Example command:
        
        .. code-block:: bash
        
            ceph auth list
        
        module=auth perm=rx flags=deprecated
        """
        prefix = 'auth list'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def auth_ls(self):
        """
        list authentication state
        
        Example command:
        
        .. code-block:: bash
        
            ceph auth ls
        
        module=auth perm=rx flags=
        """
        prefix = 'auth ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    # 
    # @overload  # todo
    # def auth_print_key(self, entity: str):
    #     """
    #     display requested key
    #     
    #     Example command:
    #     
    #     .. code-block:: bash
    #     
    #         ceph auth print-key --entity=string
    #     
    #     module=auth perm=rx flags=
    #     
    #     :param entity:
    #     """
    #     prefix = 'auth print-key'
    #     _args = {'prefix': prefix, 'entity': entity}
    #     return self._mon_command(_args)
    # 
    # @overload  # todo
    # def auth_print_key(self, entity: str):
    #     """
    #     display requested key
    #     
    #     Example command:
    #     
    #     .. code-block:: bash
    #     
    #         ceph auth print_key --entity=string
    #     
    #     module=auth perm=rx flags=
    #     
    #     :param entity:
    #     """
    #     prefix = 'auth print_key'
    #     _args = {'prefix': prefix, 'entity': entity}
    #     return self._mon_command(_args)
    
    def auth_rm(self, entity: str):
        """
        remove all caps for <name>
        
        Example command:
        
        .. code-block:: bash
        
            ceph auth rm --entity=string
        
        module=auth perm=rwx flags=
        
        :param entity:
        """
        prefix = 'auth rm'
        _args = {'prefix': prefix, 'entity': entity}
        return self._mon_command(_args)
    
    def balancer_dump(self, plan: str):
        """
        Show an optimization plan
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer dump --plan=string
        
        module=mgr perm=r flags=mgr
        
        :param plan:
        """
        prefix = 'balancer dump'
        _args = {'prefix': prefix, 'plan': plan}
        return self._mon_command(_args)
    
    def balancer_eval(self, option: Optional[str]=None):
        """
        Evaluate data distribution for the current cluster or specific pool or
        specific plan
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer eval --option=string
        
        module=mgr perm=r flags=mgr
        
        :param option:
        """
        prefix = 'balancer eval'
        _args = {'prefix': prefix, 'option': option}
        return self._mon_command(_args)
    
    def balancer_eval_verbose(self, option: Optional[str]=None):
        """
        Evaluate data distribution for the current cluster or specific pool or
        specific plan (verbosely)
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer eval-verbose --option=string
        
        module=mgr perm=r flags=mgr
        
        :param option:
        """
        prefix = 'balancer eval-verbose'
        _args = {'prefix': prefix, 'option': option}
        return self._mon_command(_args)
    
    def balancer_execute(self, plan: str):
        """
        Execute an optimization plan
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer execute --plan=string
        
        module=mgr perm=rw flags=mgr
        
        :param plan:
        """
        prefix = 'balancer execute'
        _args = {'prefix': prefix, 'plan': plan}
        return self._mon_command(_args)
    
    def balancer_ls(self):
        """
        List all plans
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer ls
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'balancer ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def balancer_mode(self, mode: str):
        """
        Set balancer mode
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer mode --mode=choice
        
        module=mgr perm=rw flags=mgr
        
        :param mode: CephChoices strings=none|crush-compat|upmap
        """
        prefix = 'balancer mode'
        _args = {'prefix': prefix, 'mode': mode}
        return self._mon_command(_args)
    
    def balancer_off(self):
        """
        Disable automatic balancing
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer off
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'balancer off'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def balancer_on(self):
        """
        Enable automatic balancing
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer on
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'balancer on'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def balancer_optimize(self, plan: str, pools: Optional[List[str]]=None):
        """
        Run optimizer to create a new plan
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer optimize --plan=string --pools=string
        
        module=mgr perm=rw flags=mgr
        
        :param plan:
        :param pools:
        """
        prefix = 'balancer optimize'
        _args = {'prefix': prefix, 'plan': plan, 'pools': pools}
        return self._mon_command(_args)
    
    def balancer_pool_add(self, pools: List[str]):
        """
        Enable automatic balancing for specific pools
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer pool add --pools=string
        
        module=mgr perm=rw flags=mgr
        
        :param pools:
        """
        prefix = 'balancer pool add'
        _args = {'prefix': prefix, 'pools': pools}
        return self._mon_command(_args)
    
    def balancer_pool_ls(self):
        """
        List automatic balancing pools. Note that empty list means all
        existing pools will be automatic balancing targets, which is the
        default behaviour of balancer.
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer pool ls
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'balancer pool ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def balancer_pool_rm(self, pools: List[str]):
        """
        Disable automatic balancing for specific pools
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer pool rm --pools=string
        
        module=mgr perm=rw flags=mgr
        
        :param pools:
        """
        prefix = 'balancer pool rm'
        _args = {'prefix': prefix, 'pools': pools}
        return self._mon_command(_args)
    
    def balancer_reset(self):
        """
        Discard all optimization plans
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer reset
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'balancer reset'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def balancer_rm(self, plan: str):
        """
        Discard an optimization plan
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer rm --plan=string
        
        module=mgr perm=rw flags=mgr
        
        :param plan:
        """
        prefix = 'balancer rm'
        _args = {'prefix': prefix, 'plan': plan}
        return self._mon_command(_args)
    
    def balancer_show(self, plan: str):
        """
        Show details of an optimization plan
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer show --plan=string
        
        module=mgr perm=r flags=mgr
        
        :param plan:
        """
        prefix = 'balancer show'
        _args = {'prefix': prefix, 'plan': plan}
        return self._mon_command(_args)
    
    def balancer_status(self):
        """
        Show balancer status
        
        Example command:
        
        .. code-block:: bash
        
            ceph balancer status
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'balancer status'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    @deprecated
    def compact(self):
        """
        cause compaction of monitor's leveldb/rocksdb storage
        
        Example command:
        
        .. code-block:: bash
        
            ceph compact
        
        module=mon perm=rw flags=deprecated, no_forward
        """
        prefix = 'compact'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def config_assimilate_conf(self):
        """
        Assimilate options from a conf, and return a new, minimal conf file
        
        Example command:
        
        .. code-block:: bash
        
            ceph config assimilate-conf
        
        module=config perm=rw flags=
        """
        prefix = 'config assimilate-conf'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def config_dump(self):
        """
        Show all configuration option(s)
        
        Example command:
        
        .. code-block:: bash
        
            ceph config dump
        
        module=mon perm=r flags=
        """
        prefix = 'config dump'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def config_generate_minimal_conf(self):
        """
        Generate a minimal ceph.conf file
        
        Example command:
        
        .. code-block:: bash
        
            ceph config generate-minimal-conf
        
        module=config perm=r flags=
        """
        prefix = 'config generate-minimal-conf'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def config_get(self, who: str, key: str):
        """
        Show configuration option(s) for an entity
        
        Example command:
        
        .. code-block:: bash
        
            ceph config get --who=string --key=string
        
        module=config perm=r flags=
        
        :param who:
        :param key:
        """
        prefix = 'config get'
        _args = {'prefix': prefix, 'who': who, 'key': key}
        return self._mon_command(_args)
    
    def config_help(self, key: str):
        """
        Describe a configuration option
        
        Example command:
        
        .. code-block:: bash
        
            ceph config help --key=string
        
        module=config perm=r flags=
        
        :param key:
        """
        prefix = 'config help'
        _args = {'prefix': prefix, 'key': key}
        return self._mon_command(_args)
    
    def config_log(self, num: int):
        """
        Show recent history of config changes
        
        Example command:
        
        .. code-block:: bash
        
            ceph config log --num=1
        
        module=config perm=r flags=
        
        :param num: CephInt
        """
        prefix = 'config log'
        _args = {'prefix': prefix, 'num': num}
        return self._mon_command(_args)
    
    def config_ls(self):
        """
        List available configuration options
        
        Example command:
        
        .. code-block:: bash
        
            ceph config ls
        
        module=config perm=r flags=
        """
        prefix = 'config ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def config_reset(self, num: int):
        """
        Revert configuration to a historical version specified by <num>
        
        Example command:
        
        .. code-block:: bash
        
            ceph config reset --num=1
        
        module=config perm=rw flags=
        
        :param num: CephInt range= ``0``
        """
        prefix = 'config reset'
        _args = {'prefix': prefix, 'num': num}
        return self._mon_command(_args)
    
    def config_rm(self, who: str, name: str):
        """
        Clear a configuration option for one or more entities
        
        Example command:
        
        .. code-block:: bash
        
            ceph config rm --who=string --name=string
        
        module=config perm=rw flags=
        
        :param who:
        :param name:
        """
        prefix = 'config rm'
        _args = {'prefix': prefix, 'who': who, 'name': name}
        return self._mon_command(_args)
    
    def config_set(self, who: str, name: str, value: str, force:
                   Optional[bool]=None):
        """
        Set a configuration option for one or more entities
        
        Example command:
        
        .. code-block:: bash
        
            ceph config set --who=string --name=string --value=string --force=true
        
        module=config perm=rw flags=
        
        :param who:
        :param name:
        :param value:
        :param force: CephBool
        """
        prefix = 'config set'
        _args = {'prefix': prefix, 'who': who, 'name': name, 'value': value, 'force': force}
        return self._mon_command(_args)
    
    def config_show(self, who: str, key: str):
        """
        Show running configuration
        
        Example command:
        
        .. code-block:: bash
        
            ceph config show --who=string --key=string
        
        module=mgr perm=r flags=mgr
        
        :param who:
        :param key:
        """
        prefix = 'config show'
        _args = {'prefix': prefix, 'who': who, 'key': key}
        return self._mon_command(_args)
    
    def config_show_with_defaults(self, who: str):
        """
        Show running configuration (including compiled-in defaults)
        
        Example command:
        
        .. code-block:: bash
        
            ceph config show-with-defaults --who=string
        
        module=mgr perm=r flags=mgr
        
        :param who:
        """
        prefix = 'config show-with-defaults'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    @deprecated
    def config_key_del(self, key: str):
        """
        delete <key>
        
        Example command:
        
        .. code-block:: bash
        
            ceph config-key del --key=string
        
        module=config-key perm=rw flags=deprecated
        
        :param key:
        """
        prefix = 'config-key del'
        _args = {'prefix': prefix, 'key': key}
        return self._mon_command(_args)
    
    def config_key_dump(self, key: Optional[str]=None):
        """
        dump keys and values (with optional prefix)
        
        Example command:
        
        .. code-block:: bash
        
            ceph config-key dump --key=string
        
        module=config-key perm=r flags=
        
        :param key:
        """
        prefix = 'config-key dump'
        _args = {'prefix': prefix, 'key': key}
        return self._mon_command(_args)
    
    def config_key_exists(self, key: str):
        """
        check for <key>'s existence
        
        Example command:
        
        .. code-block:: bash
        
            ceph config-key exists --key=string
        
        module=config-key perm=r flags=
        
        :param key:
        """
        prefix = 'config-key exists'
        _args = {'prefix': prefix, 'key': key}
        return self._mon_command(_args)
    
    def config_key_get(self, key: str):
        """
        get <key>
        
        Example command:
        
        .. code-block:: bash
        
            ceph config-key get --key=string
        
        module=config-key perm=r flags=
        
        :param key:
        """
        prefix = 'config-key get'
        _args = {'prefix': prefix, 'key': key}
        return self._mon_command(_args)
    
    @deprecated
    def config_key_list(self):
        """
        list keys
        
        Example command:
        
        .. code-block:: bash
        
            ceph config-key list
        
        module=config-key perm=r flags=deprecated
        """
        prefix = 'config-key list'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def config_key_ls(self):
        """
        list keys
        
        Example command:
        
        .. code-block:: bash
        
            ceph config-key ls
        
        module=config-key perm=r flags=
        """
        prefix = 'config-key ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    @deprecated
    def config_key_put(self, key: str, val: Optional[str]=None):
        """
        put <key>, value <val>
        
        Example command:
        
        .. code-block:: bash
        
            ceph config-key put --key=string --val=string
        
        module=config-key perm=rw flags=deprecated
        
        :param key:
        :param val:
        """
        prefix = 'config-key put'
        _args = {'prefix': prefix, 'key': key, 'val': val}
        return self._mon_command(_args)
    
    def config_key_rm(self, key: str):
        """
        rm <key>
        
        Example command:
        
        .. code-block:: bash
        
            ceph config-key rm --key=string
        
        module=config-key perm=rw flags=
        
        :param key:
        """
        prefix = 'config-key rm'
        _args = {'prefix': prefix, 'key': key}
        return self._mon_command(_args)
    
    def config_key_set(self, key: str, val: Optional[str]=None):
        """
        set <key> to value <val>
        
        Example command:
        
        .. code-block:: bash
        
            ceph config-key set --key=string --val=string
        
        module=config-key perm=rw flags=
        
        :param key:
        :param val:
        """
        prefix = 'config-key set'
        _args = {'prefix': prefix, 'key': key, 'val': val}
        return self._mon_command(_args)
    
    def count(self, num: int):
        """
        Do some counting
        
        Example command:
        
        .. code-block:: bash
        
            ceph count --num=1
        
        module=mgr perm=r flags=mgr
        
        :param num: CephInt
        """
        prefix = 'count'
        _args = {'prefix': prefix, 'num': num}
        return self._mon_command(_args)
    
    def crash_archive(self, id_1: str):
        """
        Acknowledge a crash and silence health warning(s)
        
        Example command:
        
        .. code-block:: bash
        
            ceph crash archive --id=string
        
        module=mgr perm=w flags=mgr
        
        :param id_1: Real name is ``id``
        """
        prefix = 'crash archive'
        _args = {'prefix': prefix, 'id': id_1}
        return self._mon_command(_args)
    
    def crash_archive_all(self):
        """
        Acknowledge all new crashes and silence health warning(s)
        
        Example command:
        
        .. code-block:: bash
        
            ceph crash archive-all
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'crash archive-all'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def crash_info(self, id_1: str):
        """
        show crash dump metadata
        
        Example command:
        
        .. code-block:: bash
        
            ceph crash info --id=string
        
        module=mgr perm=r flags=mgr
        
        :param id_1: Real name is ``id``
        """
        prefix = 'crash info'
        _args = {'prefix': prefix, 'id': id_1}
        return self._mon_command(_args)
    
    def crash_json_report(self, hours: str):
        """
        Crashes in the last <hours> hours
        
        Example command:
        
        .. code-block:: bash
        
            ceph crash json_report --hours=string
        
        module=mgr perm=r flags=mgr
        
        :param hours:
        """
        prefix = 'crash json_report'
        _args = {'prefix': prefix, 'hours': hours}
        return self._mon_command(_args)
    
    def crash_ls(self):
        """
        Show new and archived crash dumps
        
        Example command:
        
        .. code-block:: bash
        
            ceph crash ls
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'crash ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def crash_ls_new(self):
        """
        Show new crash dumps
        
        Example command:
        
        .. code-block:: bash
        
            ceph crash ls-new
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'crash ls-new'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def crash_post(self):
        """
        Add a crash dump (use -i <jsonfile>)
        
        Example command:
        
        .. code-block:: bash
        
            ceph crash post
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'crash post'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def crash_prune(self, keep: str):
        """
        Remove crashes older than <keep> days
        
        Example command:
        
        .. code-block:: bash
        
            ceph crash prune --keep=string
        
        module=mgr perm=rw flags=mgr
        
        :param keep:
        """
        prefix = 'crash prune'
        _args = {'prefix': prefix, 'keep': keep}
        return self._mon_command(_args)
    
    def crash_rm(self, id_1: str):
        """
        Remove a saved crash <id>
        
        Example command:
        
        .. code-block:: bash
        
            ceph crash rm --id=string
        
        module=mgr perm=rw flags=mgr
        
        :param id_1: Real name is ``id``
        """
        prefix = 'crash rm'
        _args = {'prefix': prefix, 'id': id_1}
        return self._mon_command(_args)
    
    def crash_stat(self):
        """
        Summarize recorded crashes
        
        Example command:
        
        .. code-block:: bash
        
            ceph crash stat
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'crash stat'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_ac_role_add_scope_perms(self, rolename: str, scopename: str, permissions: List[str]):
        """
        Add the scope permissions for a role
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-role-add-scope-perms --rolename=string --scopename=string --permissions=string
        
        module=mgr perm=w flags=mgr
        
        :param rolename:
        :param scopename:
        :param permissions:
        """
        prefix = 'dashboard ac-role-add-scope-perms'
        _args = {'prefix': prefix, 'rolename': rolename, 'scopename': scopename, 'permissions':
                 permissions}
        return self._mon_command(_args)
    
    def dashboard_ac_role_create(self, rolename: str, description: Optional[str]=None):
        """
        Create a new access control role
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-role-create --rolename=string --description=string
        
        module=mgr perm=w flags=mgr
        
        :param rolename:
        :param description:
        """
        prefix = 'dashboard ac-role-create'
        _args = {'prefix': prefix, 'rolename': rolename, 'description': description}
        return self._mon_command(_args)
    
    def dashboard_ac_role_del_scope_perms(self, rolename: str, scopename: str):
        """
        Delete the scope permissions for a role
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-role-del-scope-perms --rolename=string --scopename=string
        
        module=mgr perm=w flags=mgr
        
        :param rolename:
        :param scopename:
        """
        prefix = 'dashboard ac-role-del-scope-perms'
        _args = {'prefix': prefix, 'rolename': rolename, 'scopename': scopename}
        return self._mon_command(_args)
    
    def dashboard_ac_role_delete(self, rolename: str):
        """
        Delete an access control role
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-role-delete --rolename=string
        
        module=mgr perm=w flags=mgr
        
        :param rolename:
        """
        prefix = 'dashboard ac-role-delete'
        _args = {'prefix': prefix, 'rolename': rolename}
        return self._mon_command(_args)
    
    def dashboard_ac_role_show(self, rolename: Optional[str]=None):
        """
        Show role info
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-role-show --rolename=string
        
        module=mgr perm=r flags=mgr
        
        :param rolename:
        """
        prefix = 'dashboard ac-role-show'
        _args = {'prefix': prefix, 'rolename': rolename}
        return self._mon_command(_args)
    
    def dashboard_ac_user_add_roles(self, username: str, roles: List[str]):
        """
        Add roles to user
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-user-add-roles --username=string --roles=string
        
        module=mgr perm=w flags=mgr
        
        :param username:
        :param roles:
        """
        prefix = 'dashboard ac-user-add-roles'
        _args = {'prefix': prefix, 'username': username, 'roles': roles}
        return self._mon_command(_args)
    
    def dashboard_ac_user_create(self, username: str, password: Optional[str]=None, rolename:
                                 Optional[str]=None, name: Optional[str]=None, email:
                                 Optional[str]=None, enabled: Optional[bool]=None):
        """
        Create a user
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-user-create --username=string --password=string --rolename=string --name=string --email=string --enabled=true
        
        module=mgr perm=w flags=mgr
        
        :param username:
        :param password:
        :param rolename:
        :param name:
        :param email:
        :param enabled: CephBool
        """
        prefix = 'dashboard ac-user-create'
        _args = {'prefix': prefix, 'username': username, 'password': password, 'rolename':
                 rolename, 'name': name, 'email': email, 'enabled': enabled}
        return self._mon_command(_args)
    
    def dashboard_ac_user_del_roles(self, username: str, roles: List[str]):
        """
        Delete roles from user
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-user-del-roles --username=string --roles=string
        
        module=mgr perm=w flags=mgr
        
        :param username:
        :param roles:
        """
        prefix = 'dashboard ac-user-del-roles'
        _args = {'prefix': prefix, 'username': username, 'roles': roles}
        return self._mon_command(_args)
    
    def dashboard_ac_user_delete(self, username: str):
        """
        Delete user
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-user-delete --username=string
        
        module=mgr perm=w flags=mgr
        
        :param username:
        """
        prefix = 'dashboard ac-user-delete'
        _args = {'prefix': prefix, 'username': username}
        return self._mon_command(_args)
    
    def dashboard_ac_user_disable(self, username: str):
        """
        Disable a user
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-user-disable --username=string
        
        module=mgr perm=w flags=mgr
        
        :param username:
        """
        prefix = 'dashboard ac-user-disable'
        _args = {'prefix': prefix, 'username': username}
        return self._mon_command(_args)
    
    def dashboard_ac_user_enable(self, username: str):
        """
        Enable a user
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-user-enable --username=string
        
        module=mgr perm=w flags=mgr
        
        :param username:
        """
        prefix = 'dashboard ac-user-enable'
        _args = {'prefix': prefix, 'username': username}
        return self._mon_command(_args)
    
    def dashboard_ac_user_set_info(self, username: str, name: str, email: str):
        """
        Set user info
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-user-set-info --username=string --name=string --email=string
        
        module=mgr perm=w flags=mgr
        
        :param username:
        :param name:
        :param email:
        """
        prefix = 'dashboard ac-user-set-info'
        _args = {'prefix': prefix, 'username': username, 'name': name, 'email': email}
        return self._mon_command(_args)
    
    def dashboard_ac_user_set_password(self, username: str, password: str):
        """
        Set user password
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-user-set-password --username=string --password=string
        
        module=mgr perm=w flags=mgr
        
        :param username:
        :param password:
        """
        prefix = 'dashboard ac-user-set-password'
        _args = {'prefix': prefix, 'username': username, 'password': password}
        return self._mon_command(_args)
    
    def dashboard_ac_user_set_password_hash(self, username: str, hashed_password: str):
        """
        Set user password bcrypt hash
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-user-set-password-hash --username=string --hashed_password=string
        
        module=mgr perm=w flags=mgr
        
        :param username:
        :param hashed_password:
        """
        prefix = 'dashboard ac-user-set-password-hash'
        _args = {'prefix': prefix, 'username': username, 'hashed_password': hashed_password}
        return self._mon_command(_args)
    
    def dashboard_ac_user_set_roles(self, username: str, roles: List[str]):
        """
        Set user roles
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-user-set-roles --username=string --roles=string
        
        module=mgr perm=w flags=mgr
        
        :param username:
        :param roles:
        """
        prefix = 'dashboard ac-user-set-roles'
        _args = {'prefix': prefix, 'username': username, 'roles': roles}
        return self._mon_command(_args)
    
    def dashboard_ac_user_show(self, username: Optional[str]=None):
        """
        Show user info
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard ac-user-show --username=string
        
        module=mgr perm=r flags=mgr
        
        :param username:
        """
        prefix = 'dashboard ac-user-show'
        _args = {'prefix': prefix, 'username': username}
        return self._mon_command(_args)
    
    def dashboard_create_self_signed_cert(self):
        """
        Create self signed certificate
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard create-self-signed-cert
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard create-self-signed-cert'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_feature(self, action: str, features: Optional[List[str]]=None):
        """
        Enable or disable features in Ceph-Mgr Dashboard
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard feature --action=choice --features=choice
        
        module=mgr perm=rw flags=mgr
        
        :param action: CephChoices strings=enable|disable|status
        :param features: CephChoices strings=rbd|mirroring|iscsi|cephfs|rgw
        """
        prefix = 'dashboard feature'
        _args = {'prefix': prefix, 'action': action, 'features': features}
        return self._mon_command(_args)
    
    def dashboard_get_alertmanager_api_host(self):
        """
        Get the ALERTMANAGER_API_HOST option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-alertmanager-api-host
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-alertmanager-api-host'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_audit_api_enabled(self):
        """
        Get the AUDIT_API_ENABLED option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-audit-api-enabled
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-audit-api-enabled'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_audit_api_log_payload(self):
        """
        Get the AUDIT_API_LOG_PAYLOAD option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-audit-api-log-payload
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-audit-api-log-payload'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_enable_browsable_api(self):
        """
        Get the ENABLE_BROWSABLE_API option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-enable-browsable-api
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-enable-browsable-api'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_ganesha_clusters_rados_pool_namespace(self):
        """
        Get the GANESHA_CLUSTERS_RADOS_POOL_NAMESPACE option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-ganesha-clusters-rados-pool-namespace
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-ganesha-clusters-rados-pool-namespace'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_grafana_api_password(self):
        """
        Get the GRAFANA_API_PASSWORD option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-grafana-api-password
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-grafana-api-password'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_grafana_api_url(self):
        """
        Get the GRAFANA_API_URL option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-grafana-api-url
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-grafana-api-url'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_grafana_api_username(self):
        """
        Get the GRAFANA_API_USERNAME option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-grafana-api-username
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-grafana-api-username'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_grafana_update_dashboards(self):
        """
        Get the GRAFANA_UPDATE_DASHBOARDS option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-grafana-update-dashboards
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-grafana-update-dashboards'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_iscsi_api_ssl_verification(self):
        """
        Get the ISCSI_API_SSL_VERIFICATION option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-iscsi-api-ssl-verification
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-iscsi-api-ssl-verification'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_jwt_token_ttl(self):
        """
        Get the JWT token TTL in seconds
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-jwt-token-ttl
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-jwt-token-ttl'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_prometheus_api_host(self):
        """
        Get the PROMETHEUS_API_HOST option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-prometheus-api-host
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-prometheus-api-host'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_rest_requests_timeout(self):
        """
        Get the REST_REQUESTS_TIMEOUT option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-rest-requests-timeout
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-rest-requests-timeout'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_rgw_api_access_key(self):
        """
        Get the RGW_API_ACCESS_KEY option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-rgw-api-access-key
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-rgw-api-access-key'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_rgw_api_admin_resource(self):
        """
        Get the RGW_API_ADMIN_RESOURCE option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-rgw-api-admin-resource
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-rgw-api-admin-resource'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_rgw_api_host(self):
        """
        Get the RGW_API_HOST option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-rgw-api-host
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-rgw-api-host'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_rgw_api_port(self):
        """
        Get the RGW_API_PORT option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-rgw-api-port
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-rgw-api-port'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_rgw_api_scheme(self):
        """
        Get the RGW_API_SCHEME option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-rgw-api-scheme
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-rgw-api-scheme'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_rgw_api_secret_key(self):
        """
        Get the RGW_API_SECRET_KEY option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-rgw-api-secret-key
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-rgw-api-secret-key'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_rgw_api_ssl_verify(self):
        """
        Get the RGW_API_SSL_VERIFY option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-rgw-api-ssl-verify
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-rgw-api-ssl-verify'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_get_rgw_api_user_id(self):
        """
        Get the RGW_API_USER_ID option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard get-rgw-api-user-id
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard get-rgw-api-user-id'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_grafana_dashboards_update(self):
        """
        Push dashboards to Grafana
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard grafana dashboards update
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard grafana dashboards update'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_iscsi_gateway_add(self, service_url: str):
        """
        Add iSCSI gateway configuration
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard iscsi-gateway-add --service_url=string
        
        module=mgr perm=w flags=mgr
        
        :param service_url:
        """
        prefix = 'dashboard iscsi-gateway-add'
        _args = {'prefix': prefix, 'service_url': service_url}
        return self._mon_command(_args)
    
    def dashboard_iscsi_gateway_list(self):
        """
        List iSCSI gateways
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard iscsi-gateway-list
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard iscsi-gateway-list'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_iscsi_gateway_rm(self, name: str):
        """
        Remove iSCSI gateway configuration
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard iscsi-gateway-rm --name=string
        
        module=mgr perm=w flags=mgr
        
        :param name:
        """
        prefix = 'dashboard iscsi-gateway-rm'
        _args = {'prefix': prefix, 'name': name}
        return self._mon_command(_args)
    
    def dashboard_reset_alertmanager_api_host(self):
        """
        Reset the ALERTMANAGER_API_HOST option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-alertmanager-api-host
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-alertmanager-api-host'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_audit_api_enabled(self):
        """
        Reset the AUDIT_API_ENABLED option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-audit-api-enabled
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-audit-api-enabled'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_audit_api_log_payload(self):
        """
        Reset the AUDIT_API_LOG_PAYLOAD option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-audit-api-log-payload
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-audit-api-log-payload'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_enable_browsable_api(self):
        """
        Reset the ENABLE_BROWSABLE_API option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-enable-browsable-api
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-enable-browsable-api'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_ganesha_clusters_rados_pool_namespace(self):
        """
        Reset the GANESHA_CLUSTERS_RADOS_POOL_NAMESPACE option to its default
        value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-ganesha-clusters-rados-pool-namespace
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-ganesha-clusters-rados-pool-namespace'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_grafana_api_password(self):
        """
        Reset the GRAFANA_API_PASSWORD option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-grafana-api-password
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-grafana-api-password'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_grafana_api_url(self):
        """
        Reset the GRAFANA_API_URL option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-grafana-api-url
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-grafana-api-url'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_grafana_api_username(self):
        """
        Reset the GRAFANA_API_USERNAME option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-grafana-api-username
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-grafana-api-username'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_grafana_update_dashboards(self):
        """
        Reset the GRAFANA_UPDATE_DASHBOARDS option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-grafana-update-dashboards
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-grafana-update-dashboards'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_iscsi_api_ssl_verification(self):
        """
        Reset the ISCSI_API_SSL_VERIFICATION option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-iscsi-api-ssl-verification
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-iscsi-api-ssl-verification'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_prometheus_api_host(self):
        """
        Reset the PROMETHEUS_API_HOST option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-prometheus-api-host
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-prometheus-api-host'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_rest_requests_timeout(self):
        """
        Reset the REST_REQUESTS_TIMEOUT option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-rest-requests-timeout
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-rest-requests-timeout'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_rgw_api_access_key(self):
        """
        Reset the RGW_API_ACCESS_KEY option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-rgw-api-access-key
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-rgw-api-access-key'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_rgw_api_admin_resource(self):
        """
        Reset the RGW_API_ADMIN_RESOURCE option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-rgw-api-admin-resource
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-rgw-api-admin-resource'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_rgw_api_host(self):
        """
        Reset the RGW_API_HOST option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-rgw-api-host
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-rgw-api-host'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_rgw_api_port(self):
        """
        Reset the RGW_API_PORT option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-rgw-api-port
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-rgw-api-port'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_rgw_api_scheme(self):
        """
        Reset the RGW_API_SCHEME option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-rgw-api-scheme
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-rgw-api-scheme'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_rgw_api_secret_key(self):
        """
        Reset the RGW_API_SECRET_KEY option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-rgw-api-secret-key
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-rgw-api-secret-key'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_rgw_api_ssl_verify(self):
        """
        Reset the RGW_API_SSL_VERIFY option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-rgw-api-ssl-verify
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-rgw-api-ssl-verify'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_reset_rgw_api_user_id(self):
        """
        Reset the RGW_API_USER_ID option to its default value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard reset-rgw-api-user-id
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard reset-rgw-api-user-id'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_set_alertmanager_api_host(self, value: str):
        """
        Set the ALERTMANAGER_API_HOST option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-alertmanager-api-host --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-alertmanager-api-host'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_audit_api_enabled(self, value: str):
        """
        Set the AUDIT_API_ENABLED option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-audit-api-enabled --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-audit-api-enabled'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_audit_api_log_payload(self, value: str):
        """
        Set the AUDIT_API_LOG_PAYLOAD option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-audit-api-log-payload --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-audit-api-log-payload'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_enable_browsable_api(self, value: str):
        """
        Set the ENABLE_BROWSABLE_API option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-enable-browsable-api --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-enable-browsable-api'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_ganesha_clusters_rados_pool_namespace(self, value: str):
        """
        Set the GANESHA_CLUSTERS_RADOS_POOL_NAMESPACE option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-ganesha-clusters-rados-pool-namespace --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-ganesha-clusters-rados-pool-namespace'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_grafana_api_password(self, value: str):
        """
        Set the GRAFANA_API_PASSWORD option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-grafana-api-password --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-grafana-api-password'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_grafana_api_url(self, value: str):
        """
        Set the GRAFANA_API_URL option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-grafana-api-url --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-grafana-api-url'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_grafana_api_username(self, value: str):
        """
        Set the GRAFANA_API_USERNAME option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-grafana-api-username --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-grafana-api-username'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_grafana_update_dashboards(self, value: str):
        """
        Set the GRAFANA_UPDATE_DASHBOARDS option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-grafana-update-dashboards --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-grafana-update-dashboards'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_iscsi_api_ssl_verification(self, value: str):
        """
        Set the ISCSI_API_SSL_VERIFICATION option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-iscsi-api-ssl-verification --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-iscsi-api-ssl-verification'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_jwt_token_ttl(self, seconds: int):
        """
        Set the JWT token TTL in seconds
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-jwt-token-ttl --seconds=1
        
        module=mgr perm=w flags=mgr
        
        :param seconds: CephInt
        """
        prefix = 'dashboard set-jwt-token-ttl'
        _args = {'prefix': prefix, 'seconds': seconds}
        return self._mon_command(_args)
    
    def dashboard_set_login_credentials(self, username: str, password: str):
        """
        Set the login credentials
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-login-credentials --username=string --password=string
        
        module=mgr perm=w flags=mgr
        
        :param username:
        :param password:
        """
        prefix = 'dashboard set-login-credentials'
        _args = {'prefix': prefix, 'username': username, 'password': password}
        return self._mon_command(_args)
    
    def dashboard_set_prometheus_api_host(self, value: str):
        """
        Set the PROMETHEUS_API_HOST option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-prometheus-api-host --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-prometheus-api-host'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_rest_requests_timeout(self, value: int):
        """
        Set the REST_REQUESTS_TIMEOUT option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-rest-requests-timeout --value=1
        
        module=mgr perm=w flags=mgr
        
        :param value: CephInt
        """
        prefix = 'dashboard set-rest-requests-timeout'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_rgw_api_access_key(self, value: str):
        """
        Set the RGW_API_ACCESS_KEY option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-rgw-api-access-key --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-rgw-api-access-key'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_rgw_api_admin_resource(self, value: str):
        """
        Set the RGW_API_ADMIN_RESOURCE option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-rgw-api-admin-resource --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-rgw-api-admin-resource'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_rgw_api_host(self, value: str):
        """
        Set the RGW_API_HOST option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-rgw-api-host --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-rgw-api-host'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_rgw_api_port(self, value: int):
        """
        Set the RGW_API_PORT option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-rgw-api-port --value=1
        
        module=mgr perm=w flags=mgr
        
        :param value: CephInt
        """
        prefix = 'dashboard set-rgw-api-port'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_rgw_api_scheme(self, value: str):
        """
        Set the RGW_API_SCHEME option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-rgw-api-scheme --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-rgw-api-scheme'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_rgw_api_secret_key(self, value: str):
        """
        Set the RGW_API_SECRET_KEY option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-rgw-api-secret-key --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-rgw-api-secret-key'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_rgw_api_ssl_verify(self, value: str):
        """
        Set the RGW_API_SSL_VERIFY option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-rgw-api-ssl-verify --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-rgw-api-ssl-verify'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_rgw_api_user_id(self, value: str):
        """
        Set the RGW_API_USER_ID option value
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-rgw-api-user-id --value=string
        
        module=mgr perm=w flags=mgr
        
        :param value:
        """
        prefix = 'dashboard set-rgw-api-user-id'
        _args = {'prefix': prefix, 'value': value}
        return self._mon_command(_args)
    
    def dashboard_set_ssl_certificate(self, mgr_id: Optional[str]=None):
        """
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-ssl-certificate --mgr_id=string
        
        module=mgr perm=w flags=mgr
        
        :param mgr_id:
        """
        prefix = 'dashboard set-ssl-certificate'
        _args = {'prefix': prefix, 'mgr_id': mgr_id}
        return self._mon_command(_args)
    
    def dashboard_set_ssl_certificate_key(self, mgr_id: Optional[str]=None):
        """
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard set-ssl-certificate-key --mgr_id=string
        
        module=mgr perm=w flags=mgr
        
        :param mgr_id:
        """
        prefix = 'dashboard set-ssl-certificate-key'
        _args = {'prefix': prefix, 'mgr_id': mgr_id}
        return self._mon_command(_args)
    
    def dashboard_sso_disable(self):
        """
        Disable Single Sign-On
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard sso disable
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard sso disable'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_sso_enable_saml2(self):
        """
        Enable SAML2 Single Sign-On
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard sso enable saml2
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'dashboard sso enable saml2'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_sso_setup_saml2(self, ceph_dashboard_base_url: str, idp_metadata: str,
                                  idp_username_attribute: Optional[str]=None, idp_entity_id:
                                  Optional[str]=None, sp_x_509_cert: Optional[str]=None,
                                  sp_private_key: Optional[str]=None):
        """
        Setup SAML2 Single Sign-On
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard sso setup saml2 --ceph_dashboard_base_url=string --idp_metadata=string --idp_username_attribute=string --idp_entity_id=string --sp_x_509_cert=string --sp_private_key=string
        
        module=mgr perm=w flags=mgr
        
        :param ceph_dashboard_base_url:
        :param idp_metadata:
        :param idp_username_attribute:
        :param idp_entity_id:
        :param sp_x_509_cert:
        :param sp_private_key:
        """
        prefix = 'dashboard sso setup saml2'
        _args = {'prefix': prefix, 'ceph_dashboard_base_url': ceph_dashboard_base_url,
                 'idp_metadata': idp_metadata, 'idp_username_attribute':
                 idp_username_attribute, 'idp_entity_id': idp_entity_id,
                 'sp_x_509_cert': sp_x_509_cert, 'sp_private_key':
                 sp_private_key}
        return self._mon_command(_args)
    
    def dashboard_sso_show_saml2(self):
        """
        Show SAML2 configuration
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard sso show saml2
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard sso show saml2'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def dashboard_sso_status(self):
        """
        Get Single Sign-On status
        
        Example command:
        
        .. code-block:: bash
        
            ceph dashboard sso status
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'dashboard sso status'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def deepsea_config_set(self, key: str, value: str):
        """
        Set a configuration value
        
        Example command:
        
        .. code-block:: bash
        
            ceph deepsea config-set --key=string --value=string
        
        module=mgr perm=rw flags=mgr
        
        :param key:
        :param value:
        """
        prefix = 'deepsea config-set'
        _args = {'prefix': prefix, 'key': key, 'value': value}
        return self._mon_command(_args)
    
    def deepsea_config_show(self):
        """
        Show current configuration
        
        Example command:
        
        .. code-block:: bash
        
            ceph deepsea config-show
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'deepsea config-show'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def device_check_health(self):
        """
        Check life expectancy of devices
        
        Example command:
        
        .. code-block:: bash
        
            ceph device check-health
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'device check-health'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def device_debug_metrics_forced(self):
        """
        Run metrics agent forced
        
        Example command:
        
        .. code-block:: bash
        
            ceph device debug metrics-forced
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'device debug metrics-forced'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def device_debug_smart_forced(self):
        """
        Run smart agent forced
        
        Example command:
        
        .. code-block:: bash
        
            ceph device debug smart-forced
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'device debug smart-forced'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def device_get_health_metrics(self, devid: str, sample: str):
        """
        Show stored device metrics for the device
        
        Example command:
        
        .. code-block:: bash
        
            ceph device get-health-metrics --devid=string --sample=string
        
        module=mgr perm=r flags=mgr
        
        :param devid:
        :param sample:
        """
        prefix = 'device get-health-metrics'
        _args = {'prefix': prefix, 'devid': devid, 'sample': sample}
        return self._mon_command(_args)
    
    def device_info(self, devid: str):
        """
        Show information about a device
        
        Example command:
        
        .. code-block:: bash
        
            ceph device info --devid=string
        
        module=mgr perm=r flags=mgr
        
        :param devid:
        """
        prefix = 'device info'
        _args = {'prefix': prefix, 'devid': devid}
        return self._mon_command(_args)
    
    def device_ls(self):
        """
        Show devices
        
        Example command:
        
        .. code-block:: bash
        
            ceph device ls
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'device ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def device_ls_by_daemon(self, who: str):
        """
        Show devices associated with a daemon
        
        Example command:
        
        .. code-block:: bash
        
            ceph device ls-by-daemon --who=string
        
        module=mgr perm=r flags=mgr
        
        :param who:
        """
        prefix = 'device ls-by-daemon'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def device_ls_by_host(self, host: str):
        """
        Show devices on a host
        
        Example command:
        
        .. code-block:: bash
        
            ceph device ls-by-host --host=string
        
        module=mgr perm=r flags=mgr
        
        :param host:
        """
        prefix = 'device ls-by-host'
        _args = {'prefix': prefix, 'host': host}
        return self._mon_command(_args)
    
    def device_monitoring_off(self):
        """
        Disable device health monitoring
        
        Example command:
        
        .. code-block:: bash
        
            ceph device monitoring off
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'device monitoring off'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def device_monitoring_on(self):
        """
        Enable device health monitoring
        
        Example command:
        
        .. code-block:: bash
        
            ceph device monitoring on
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'device monitoring on'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def device_predict_life_expectancy(self, devid: str):
        """
        Predict life expectancy with local predictor
        
        Example command:
        
        .. code-block:: bash
        
            ceph device predict-life-expectancy --devid=string
        
        module=mgr perm=r flags=mgr
        
        :param devid:
        """
        prefix = 'device predict-life-expectancy'
        _args = {'prefix': prefix, 'devid': devid}
        return self._mon_command(_args)
    
    def device_query_daemon_health_metrics(self, who: str):
        """
        Get device health metrics for a given daemon
        
        Example command:
        
        .. code-block:: bash
        
            ceph device query-daemon-health-metrics --who=string
        
        module=mgr perm=r flags=mgr
        
        :param who:
        """
        prefix = 'device query-daemon-health-metrics'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def device_rm_life_expectancy(self, devid: str):
        """
        Clear predicted device life expectancy
        
        Example command:
        
        .. code-block:: bash
        
            ceph device rm-life-expectancy --devid=string
        
        module=mgr perm=rw flags=mgr
        
        :param devid:
        """
        prefix = 'device rm-life-expectancy'
        _args = {'prefix': prefix, 'devid': devid}
        return self._mon_command(_args)
    
    def device_scrape_daemon_health_metrics(self, who: str):
        """
        Scrape and store device health metrics for a given daemon
        
        Example command:
        
        .. code-block:: bash
        
            ceph device scrape-daemon-health-metrics --who=string
        
        module=mgr perm=r flags=mgr
        
        :param who:
        """
        prefix = 'device scrape-daemon-health-metrics'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def device_scrape_health_metrics(self, devid: str):
        """
        Scrape and store health metrics
        
        Example command:
        
        .. code-block:: bash
        
            ceph device scrape-health-metrics --devid=string
        
        module=mgr perm=r flags=mgr
        
        :param devid:
        """
        prefix = 'device scrape-health-metrics'
        _args = {'prefix': prefix, 'devid': devid}
        return self._mon_command(_args)
    
    def device_set_cloud_prediction_config(self, server: str, user: str, password: str, certfile: str,
                                           port: Optional[str]=None):
        """
        Configure Disk Prediction service
        
        Example command:
        
        .. code-block:: bash
        
            ceph device set-cloud-prediction-config --server=string --user=string --password=string --certfile=string --port=string
        
        module=mgr perm=rw flags=mgr
        
        :param server:
        :param user:
        :param password:
        :param certfile:
        :param port:
        """
        prefix = 'device set-cloud-prediction-config'
        _args = {'prefix': prefix, 'server': server, 'user': user, 'password': password,
                 'certfile': certfile, 'port': port}
        return self._mon_command(_args)
    
    def device_set_life_expectancy(self, devid: str, from_1: str, to: str):
        """
        Set predicted device life expectancy
        
        Example command:
        
        .. code-block:: bash
        
            ceph device set-life-expectancy --devid=string --from=string --to=string
        
        module=mgr perm=rw flags=mgr
        
        :param devid:
        :param from_1: Real name is ``from``
        :param to:
        """
        prefix = 'device set-life-expectancy'
        _args = {'prefix': prefix, 'devid': devid, 'from': from_1, 'to': to}
        return self._mon_command(_args)
    
    def device_show_prediction_config(self):
        """
        Prints diskprediction configuration
        
        Example command:
        
        .. code-block:: bash
        
            ceph device show-prediction-config
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'device show-prediction-config'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def df(self, detail: Optional[str]=None):
        """
        show cluster free space stats
        
        Example command:
        
        .. code-block:: bash
        
            ceph df --detail=choice
        
        module=mon perm=r flags=
        
        :param detail: CephChoices strings=detail
        """
        prefix = 'df'
        _args = {'prefix': prefix, 'detail': detail}
        return self._mon_command(_args)
    
    def diskprediction_cloud_status(self):
        """
        Check diskprediction_cloud status
        
        Example command:
        
        .. code-block:: bash
        
            ceph diskprediction_cloud status
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'diskprediction_cloud status'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def features(self):
        """
        report of connected features
        
        Example command:
        
        .. code-block:: bash
        
            ceph features
        
        module=mon perm=r flags=
        """
        prefix = 'features'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def fs_add_data_pool(self, fs_name: str, pool: str):
        """
        add data pool <pool>
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs add_data_pool --fs_name=string --pool=string
        
        module=mds perm=rw flags=
        
        :param fs_name:
        :param pool:
        """
        prefix = 'fs add_data_pool'
        _args = {'prefix': prefix, 'fs_name': fs_name, 'pool': pool}
        return self._mon_command(_args)
    
    def fs_authorize(self, filesystem: str, entity: str, caps: List[str]):
        """
        add auth for <entity> to access file system <filesystem> based on
        following directory and permissions pairs
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs authorize --filesystem=string --entity=string --caps=string
        
        module=auth perm=rwx flags=
        
        :param filesystem:
        :param entity:
        :param caps:
        """
        prefix = 'fs authorize'
        _args = {'prefix': prefix, 'filesystem': filesystem, 'entity': entity, 'caps': caps}
        return self._mon_command(_args)
    
    def fs_dump(self, epoch: Optional[int]=None):
        """
        dump all CephFS status, optionally from epoch
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs dump --epoch=1
        
        module=mds perm=r flags=
        
        :param epoch: CephInt range= ``0``
        """
        prefix = 'fs dump'
        _args = {'prefix': prefix, 'epoch': epoch}
        return self._mon_command(_args)
    
    def fs_fail(self, fs_name: str):
        """
        bring the file system down and all of its ranks
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs fail --fs_name=string
        
        module=fs perm=rw flags=
        
        :param fs_name:
        """
        prefix = 'fs fail'
        _args = {'prefix': prefix, 'fs_name': fs_name}
        return self._mon_command(_args)
    
    def fs_flag_set(self, flag_name: str, val: str, yes_i_really_mean_it:
                    Optional[bool]=None):
        """
        Set a global CephFS flag
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs flag set --flag_name=choice --val=string --yes_i_really_mean_it=true
        
        module=fs perm=rw flags=
        
        :param flag_name: CephChoices strings=enable_multiple
        :param val:
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'fs flag set'
        _args = {'prefix': prefix, 'flag_name': flag_name, 'val': val, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def fs_get(self, fs_name: str):
        """
        get info about one filesystem
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs get --fs_name=string
        
        module=fs perm=r flags=
        
        :param fs_name:
        """
        prefix = 'fs get'
        _args = {'prefix': prefix, 'fs_name': fs_name}
        return self._mon_command(_args)
    
    def fs_ls(self):
        """
        list filesystems
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs ls
        
        module=fs perm=r flags=
        """
        prefix = 'fs ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def fs_new(self, fs_name: str, metadata: str, data: str, force:
               Optional[bool]=None, allow_dangerous_metadata_overlay:
               Optional[bool]=None):
        """
        make new filesystem using named pools <metadata> and <data>
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs new --fs_name=string --metadata=string --data=string --force=true --allow_dangerous_metadata_overlay=true
        
        module=fs perm=rw flags=
        
        :param fs_name:
        :param metadata:
        :param data:
        :param force: CephBool
        :param allow_dangerous_metadata_overlay: CephBool
        """
        prefix = 'fs new'
        _args = {'prefix': prefix, 'fs_name': fs_name, 'metadata': metadata, 'data': data,
                 'force': force, 'allow_dangerous_metadata_overlay':
                 allow_dangerous_metadata_overlay}
        return self._mon_command(_args)
    
    def fs_reset(self, fs_name: str, yes_i_really_mean_it:
                 Optional[bool]=None):
        """
        disaster recovery only: reset to a single-MDS map
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs reset --fs_name=string --yes_i_really_mean_it=true
        
        module=fs perm=rw flags=
        
        :param fs_name:
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'fs reset'
        _args = {'prefix': prefix, 'fs_name': fs_name, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def fs_rm(self, fs_name: str, yes_i_really_mean_it:
              Optional[bool]=None):
        """
        disable the named filesystem
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs rm --fs_name=string --yes_i_really_mean_it=true
        
        module=fs perm=rw flags=
        
        :param fs_name:
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'fs rm'
        _args = {'prefix': prefix, 'fs_name': fs_name, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def fs_rm_data_pool(self, fs_name: str, pool: str):
        """
        remove data pool <pool>
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs rm_data_pool --fs_name=string --pool=string
        
        module=mds perm=rw flags=
        
        :param fs_name:
        :param pool:
        """
        prefix = 'fs rm_data_pool'
        _args = {'prefix': prefix, 'fs_name': fs_name, 'pool': pool}
        return self._mon_command(_args)
    
    def fs_set(self, fs_name: str, var: str, val: str,
               yes_i_really_mean_it: Optional[bool]=None):
        """
        set fs parameter <var> to <val>
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs set --fs_name=string --var=choice --val=string --yes_i_really_mean_it=true
        
        module=mds perm=rw flags=
        
        :param fs_name:
        :param var: CephChoices strings=max_mds|max_file_size|allow_new_snaps|
            inline_data|cluster_down|allow_dirfrags|balancer|standby_count_wanted|
            session_timeout|session_autoclose|allow_standby_replay|down|joinable|m
            in_compat_client
        :param val:
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'fs set'
        _args = {'prefix': prefix, 'fs_name': fs_name, 'var': var, 'val': val,
                 'yes_i_really_mean_it': yes_i_really_mean_it}
        return self._mon_command(_args)
    # 
    # @overload  # todo
    # def fs_set_default(self, fs_name: str):
    #     """
    #     set the default to the named filesystem
    #     
    #     Example command:
    #     
    #     .. code-block:: bash
    #     
    #         ceph fs set-default --fs_name=string
    #     
    #     module=fs perm=rw flags=
    #     
    #     :param fs_name:
    #     """
    #     prefix = 'fs set-default'
    #     _args = {'prefix': prefix, 'fs_name': fs_name}
    #     return self._mon_command(_args)
    # 
    # @deprecated
    # @overload  # todo
    # def fs_set_default(self, fs_name: str):
    #     """
    #     set the default to the named filesystem
    #     
    #     Example command:
    #     
    #     .. code-block:: bash
    #     
    #         ceph fs set_default --fs_name=string
    #     
    #     module=fs perm=rw flags=deprecated
    #     
    #     :param fs_name:
    #     """
    #     prefix = 'fs set_default'
    #     _args = {'prefix': prefix, 'fs_name': fs_name}
    #     return self._mon_command(_args)
    
    def fs_status(self, fs: Optional[str]=None):
        """
        Show the status of a CephFS filesystem
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs status --fs=string
        
        module=mgr perm=r flags=mgr
        
        :param fs:
        """
        prefix = 'fs status'
        _args = {'prefix': prefix, 'fs': fs}
        return self._mon_command(_args)
    
    def fs_subvolume_create(self, vol_name: str, sub_name: str, size:
                            Optional[int]=None, group_name: Optional[str]=None,
                            pool_layout: Optional[str]=None, mode: Optional[str]=None):
        """
        Create a CephFS subvolume in a volume, and optionally, with a specific
        size (in bytes), a specific data pool layout, a specific mode, and in
        a specific subvolume group
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs subvolume create --vol_name=string --sub_name=string --size=1 --group_name=string --pool_layout=string --mode=string
        
        module=mgr perm=rw flags=mgr
        
        :param vol_name:
        :param sub_name:
        :param size: CephInt
        :param group_name:
        :param pool_layout:
        :param mode:
        """
        prefix = 'fs subvolume create'
        _args = {'prefix': prefix, 'vol_name': vol_name, 'sub_name': sub_name, 'size': size,
                 'group_name': group_name, 'pool_layout': pool_layout,
                 'mode': mode}
        return self._mon_command(_args)
    
    def fs_subvolume_getpath(self, vol_name: str, sub_name: str, group_name:
                             Optional[str]=None):
        """
        Get the mountpath of a CephFS subvolume in a volume, and optionally,
        in a specific subvolume group
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs subvolume getpath --vol_name=string --sub_name=string --group_name=string
        
        module=mgr perm=rw flags=mgr
        
        :param vol_name:
        :param sub_name:
        :param group_name:
        """
        prefix = 'fs subvolume getpath'
        _args = {'prefix': prefix, 'vol_name': vol_name, 'sub_name': sub_name, 'group_name':
                 group_name}
        return self._mon_command(_args)
    
    def fs_subvolume_rm(self, vol_name: str, sub_name: str, group_name:
                        Optional[str]=None, force: Optional[bool]=None):
        """
        Delete a CephFS subvolume in a volume, and optionally, in a specific
        subvolume group
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs subvolume rm --vol_name=string --sub_name=string --group_name=string --force=true
        
        module=mgr perm=rw flags=mgr
        
        :param vol_name:
        :param sub_name:
        :param group_name:
        :param force: CephBool
        """
        prefix = 'fs subvolume rm'
        _args = {'prefix': prefix, 'vol_name': vol_name, 'sub_name': sub_name, 'group_name':
                 group_name, 'force': force}
        return self._mon_command(_args)
    
    def fs_subvolume_snapshot_create(self, vol_name: str, sub_name: str, snap_name: str,
                                     group_name: Optional[str]=None):
        """
        Create a snapshot of a CephFS subvolume in a volume, and optionally,
        in a specific subvolume group
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs subvolume snapshot create --vol_name=string --sub_name=string --snap_name=string --group_name=string
        
        module=mgr perm=rw flags=mgr
        
        :param vol_name:
        :param sub_name:
        :param snap_name:
        :param group_name:
        """
        prefix = 'fs subvolume snapshot create'
        _args = {'prefix': prefix, 'vol_name': vol_name, 'sub_name': sub_name, 'snap_name':
                 snap_name, 'group_name': group_name}
        return self._mon_command(_args)
    
    def fs_subvolume_snapshot_rm(self, vol_name: str, sub_name: str, snap_name: str,
                                 group_name: Optional[str]=None, force: Optional[bool]=None):
        """
        Delete a snapshot of a CephFS subvolume in a volume, and optionally,
        in a specific subvolume group
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs subvolume snapshot rm --vol_name=string --sub_name=string --snap_name=string --group_name=string --force=true
        
        module=mgr perm=rw flags=mgr
        
        :param vol_name:
        :param sub_name:
        :param snap_name:
        :param group_name:
        :param force: CephBool
        """
        prefix = 'fs subvolume snapshot rm'
        _args = {'prefix': prefix, 'vol_name': vol_name, 'sub_name': sub_name, 'snap_name':
                 snap_name, 'group_name': group_name, 'force': force}
        return self._mon_command(_args)
    
    def fs_subvolumegroup_create(self, vol_name: str, group_name: str, pool_layout:
                                 Optional[str]=None, mode: Optional[str]=None):
        """
        Create a CephFS subvolume group in a volume, and optionally, with a
        specific data pool layout, and a specific numeric mode
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs subvolumegroup create --vol_name=string --group_name=string --pool_layout=string --mode=string
        
        module=mgr perm=rw flags=mgr
        
        :param vol_name:
        :param group_name:
        :param pool_layout:
        :param mode:
        """
        prefix = 'fs subvolumegroup create'
        _args = {'prefix': prefix, 'vol_name': vol_name, 'group_name': group_name,
                 'pool_layout': pool_layout, 'mode': mode}
        return self._mon_command(_args)
    
    def fs_subvolumegroup_getpath(self, vol_name: str, group_name: str):
        """
        Get the mountpath of a CephFS subvolume group in a volume
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs subvolumegroup getpath --vol_name=string --group_name=string
        
        module=mgr perm=r flags=mgr
        
        :param vol_name:
        :param group_name:
        """
        prefix = 'fs subvolumegroup getpath'
        _args = {'prefix': prefix, 'vol_name': vol_name, 'group_name': group_name}
        return self._mon_command(_args)
    
    def fs_subvolumegroup_rm(self, vol_name: str, group_name: str, force:
                             Optional[bool]=None):
        """
        Delete a CephFS subvolume group in a volume
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs subvolumegroup rm --vol_name=string --group_name=string --force=true
        
        module=mgr perm=rw flags=mgr
        
        :param vol_name:
        :param group_name:
        :param force: CephBool
        """
        prefix = 'fs subvolumegroup rm'
        _args = {'prefix': prefix, 'vol_name': vol_name, 'group_name': group_name, 'force':
                 force}
        return self._mon_command(_args)
    
    def fs_subvolumegroup_snapshot_create(self, vol_name: str, group_name: str, snap_name: str):
        """
        Create a snapshot of a CephFS subvolume group in a volume
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs subvolumegroup snapshot create --vol_name=string --group_name=string --snap_name=string
        
        module=mgr perm=rw flags=mgr
        
        :param vol_name:
        :param group_name:
        :param snap_name:
        """
        prefix = 'fs subvolumegroup snapshot create'
        _args = {'prefix': prefix, 'vol_name': vol_name, 'group_name': group_name, 'snap_name':
                 snap_name}
        return self._mon_command(_args)
    
    def fs_subvolumegroup_snapshot_rm(self, vol_name: str, group_name: str, snap_name: str, force:
                                      Optional[bool]=None):
        """
        Delete a snapshot of a CephFS subvolume group in a volume
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs subvolumegroup snapshot rm --vol_name=string --group_name=string --snap_name=string --force=true
        
        module=mgr perm=rw flags=mgr
        
        :param vol_name:
        :param group_name:
        :param snap_name:
        :param force: CephBool
        """
        prefix = 'fs subvolumegroup snapshot rm'
        _args = {'prefix': prefix, 'vol_name': vol_name, 'group_name': group_name, 'snap_name':
                 snap_name, 'force': force}
        return self._mon_command(_args)
    
    def fs_volume_create(self, name: str):
        """
        Create a CephFS volume
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs volume create --name=string
        
        module=mgr perm=rw flags=mgr
        
        :param name:
        """
        prefix = 'fs volume create'
        _args = {'prefix': prefix, 'name': name}
        return self._mon_command(_args)
    
    def fs_volume_ls(self):
        """
        List volumes
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs volume ls
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'fs volume ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def fs_volume_rm(self, vol_name: str):
        """
        Delete a CephFS volume
        
        Example command:
        
        .. code-block:: bash
        
            ceph fs volume rm --vol_name=string
        
        module=mgr perm=rw flags=mgr
        
        :param vol_name:
        """
        prefix = 'fs volume rm'
        _args = {'prefix': prefix, 'vol_name': vol_name}
        return self._mon_command(_args)
    
    def fsid(self):
        """
        show cluster FSID/UUID
        
        Example command:
        
        .. code-block:: bash
        
            ceph fsid
        
        module=mon perm=r flags=
        """
        prefix = 'fsid'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def health(self, detail: Optional[str]=None):
        """
        show cluster health
        
        Example command:
        
        .. code-block:: bash
        
            ceph health --detail=choice
        
        module=mon perm=r flags=
        
        :param detail: CephChoices strings=detail
        """
        prefix = 'health'
        _args = {'prefix': prefix, 'detail': detail}
        return self._mon_command(_args)
    
    def health_mute(self, code: str, ttl: Optional[str]=None, sticky:
                    Optional[bool]=None):
        """
        mute health alert
        
        Example command:
        
        .. code-block:: bash
        
            ceph health mute --code=string --ttl=string --sticky=true
        
        module=mon perm=w flags=
        
        :param code:
        :param ttl:
        :param sticky: CephBool
        """
        prefix = 'health mute'
        _args = {'prefix': prefix, 'code': code, 'ttl': ttl, 'sticky': sticky}
        return self._mon_command(_args)
    
    def health_unmute(self, code: Optional[str]=None):
        """
        unmute existing health alert mute(s)
        
        Example command:
        
        .. code-block:: bash
        
            ceph health unmute --code=string
        
        module=mon perm=w flags=
        
        :param code:
        """
        prefix = 'health unmute'
        _args = {'prefix': prefix, 'code': code}
        return self._mon_command(_args)
    
    def heap(self, heapcmd: str):
        """
        show heap usage info (available only if compiled with tcmalloc)
        
        Example command:
        
        .. code-block:: bash
        
            ceph heap --heapcmd=choice
        
        module=mon perm=rw flags=no_forward
        
        :param heapcmd: CephChoices
            strings=dump|start_profiler|stop_profiler|release|stats
        """
        prefix = 'heap'
        _args = {'prefix': prefix, 'heapcmd': heapcmd}
        return self._mon_command(_args)
    
    def hello(self, person_name: Optional[str]=None):
        """
        Say hello
        
        Example command:
        
        .. code-block:: bash
        
            ceph hello --person_name=string
        
        module=mgr perm=r flags=mgr
        
        :param person_name:
        """
        prefix = 'hello'
        _args = {'prefix': prefix, 'person_name': person_name}
        return self._mon_command(_args)
    
    def influx_config_set(self, key: str, value: str):
        """
        Set a configuration value
        
        Example command:
        
        .. code-block:: bash
        
            ceph influx config-set --key=string --value=string
        
        module=mgr perm=rw flags=mgr
        
        :param key:
        :param value:
        """
        prefix = 'influx config-set'
        _args = {'prefix': prefix, 'key': key, 'value': value}
        return self._mon_command(_args)
    
    def influx_config_show(self):
        """
        Show current configuration
        
        Example command:
        
        .. code-block:: bash
        
            ceph influx config-show
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'influx config-show'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def influx_send(self):
        """
        Force sending data to Influx
        
        Example command:
        
        .. code-block:: bash
        
            ceph influx send
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'influx send'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def injectargs(self, injected_args: List[str]):
        """
        inject config arguments into monitor
        
        Example command:
        
        .. code-block:: bash
        
            ceph injectargs --injected_args=string
        
        module=mon perm=rw flags=no_forward
        
        :param injected_args:
        """
        prefix = 'injectargs'
        _args = {'prefix': prefix, 'injected_args': injected_args}
        return self._mon_command(_args)
    
    def insights(self):
        """
        Retrieve insights report
        
        Example command:
        
        .. code-block:: bash
        
            ceph insights
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'insights'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def insights_prune_health(self, hours: str):
        """
        Remove health history older than <hours> hours
        
        Example command:
        
        .. code-block:: bash
        
            ceph insights prune-health --hours=string
        
        module=mgr perm=rw flags=mgr
        
        :param hours:
        """
        prefix = 'insights prune-health'
        _args = {'prefix': prefix, 'hours': hours}
        return self._mon_command(_args)
    
    def iostat(self):
        """
        Get IO rates
        
        Example command:
        
        .. code-block:: bash
        
            ceph iostat
        
        module=mgr perm=r flags=mgr, poll
        """
        prefix = 'iostat'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def log(self, logtext: List[str]):
        """
        log supplied text to the monitor log
        
        Example command:
        
        .. code-block:: bash
        
            ceph log --logtext=string
        
        module=mon perm=rw flags=
        
        :param logtext:
        """
        prefix = 'log'
        _args = {'prefix': prefix, 'logtext': logtext}
        return self._mon_command(_args)
    
    def log_last(self, num: Optional[int]=None, level: Optional[str]=None,
                 channel: Optional[str]=None):
        """
        print last few lines of the cluster log
        
        Example command:
        
        .. code-block:: bash
        
            ceph log last --num=1 --level=choice --channel=choice
        
        module=mon perm=r flags=
        
        :param num: CephInt range= ``1``
        :param level: CephChoices strings=debug|info|sec|warn|error
        :param channel: CephChoices strings=*|cluster|audit
        """
        prefix = 'log last'
        _args = {'prefix': prefix, 'num': num, 'level': level, 'channel': channel}
        return self._mon_command(_args)
    
    @deprecated
    def mds_add_data_pool(self, pool: str):
        """
        add data pool <pool>
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds add_data_pool --pool=string
        
        module=mds perm=rw flags=obsolete
        
        :param pool:
        """
        prefix = 'mds add_data_pool'
        _args = {'prefix': prefix, 'pool': pool}
        return self._mon_command(_args)
    
    @deprecated
    def mds_cluster_down(self):
        """
        take MDS cluster down
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds cluster_down
        
        module=mds perm=rw flags=obsolete
        """
        prefix = 'mds cluster_down'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    @deprecated
    def mds_cluster_up(self):
        """
        bring MDS cluster up
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds cluster_up
        
        module=mds perm=rw flags=obsolete
        """
        prefix = 'mds cluster_up'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mds_compat_rm_compat(self, feature: int):
        """
        remove compatible feature
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds compat rm_compat --feature=1
        
        module=mds perm=rw flags=
        
        :param feature: CephInt range= ``0``
        """
        prefix = 'mds compat rm_compat'
        _args = {'prefix': prefix, 'feature': feature}
        return self._mon_command(_args)
    
    def mds_compat_rm_incompat(self, feature: int):
        """
        remove incompatible feature
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds compat rm_incompat --feature=1
        
        module=mds perm=rw flags=
        
        :param feature: CephInt range= ``0``
        """
        prefix = 'mds compat rm_incompat'
        _args = {'prefix': prefix, 'feature': feature}
        return self._mon_command(_args)
    
    def mds_compat_show(self):
        """
        show mds compatibility settings
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds compat show
        
        module=mds perm=r flags=
        """
        prefix = 'mds compat show'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mds_count_metadata(self, property_1: str):
        """
        count MDSs by metadata field property
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds count-metadata --property=string
        
        module=mds perm=r flags=
        
        :param property_1: Real name is ``property``
        """
        prefix = 'mds count-metadata'
        _args = {'prefix': prefix, 'property': property_1}
        return self._mon_command(_args)
    
    @deprecated
    def mds_deactivate(self, role: str):
        """
        clean up specified MDS rank (use with `set max_mds` to shrink cluster)
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds deactivate --role=string
        
        module=mds perm=rw flags=obsolete
        
        :param role:
        """
        prefix = 'mds deactivate'
        _args = {'prefix': prefix, 'role': role}
        return self._mon_command(_args)
    
    @deprecated
    def mds_dump(self, epoch: Optional[int]=None):
        """
        dump legacy MDS cluster info, optionally from epoch
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds dump --epoch=1
        
        module=mds perm=r flags=obsolete
        
        :param epoch: CephInt range= ``0``
        """
        prefix = 'mds dump'
        _args = {'prefix': prefix, 'epoch': epoch}
        return self._mon_command(_args)
    
    def mds_fail(self, role_or_gid: str):
        """
        Mark MDS failed: trigger a failover if a standby is available
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds fail --role_or_gid=string
        
        module=mds perm=rw flags=
        
        :param role_or_gid:
        """
        prefix = 'mds fail'
        _args = {'prefix': prefix, 'role_or_gid': role_or_gid}
        return self._mon_command(_args)
    
    def mds_freeze(self, role_or_gid: str, val: str):
        """
        freeze MDS yes/no
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds freeze --role_or_gid=string --val=string
        
        module=mds perm=rw flags=hidden
        
        :param role_or_gid:
        :param val:
        """
        prefix = 'mds freeze'
        _args = {'prefix': prefix, 'role_or_gid': role_or_gid, 'val': val}
        return self._mon_command(_args)
    
    @deprecated
    def mds_getmap(self, epoch: Optional[int]=None):
        """
        get MDS map, optionally from epoch
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds getmap --epoch=1
        
        module=mds perm=r flags=obsolete
        
        :param epoch: CephInt range= ``0``
        """
        prefix = 'mds getmap'
        _args = {'prefix': prefix, 'epoch': epoch}
        return self._mon_command(_args)
    
    def mds_metadata(self, who: Optional[str]=None):
        """
        fetch metadata for mds <role>
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds metadata --who=string
        
        module=mds perm=r flags=
        
        :param who:
        """
        prefix = 'mds metadata'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    @deprecated
    def mds_newfs(self, metadata: int, data: int, yes_i_really_mean_it:
                  Optional[bool]=None):
        """
        make new filesystem using pools <metadata> and <data>
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds newfs --metadata=1 --data=1 --yes_i_really_mean_it=true
        
        module=mds perm=rw flags=obsolete
        
        :param metadata: CephInt range= ``0``
        :param data: CephInt range= ``0``
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'mds newfs'
        _args = {'prefix': prefix, 'metadata': metadata, 'data': data, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def mds_ok_to_stop(self, ids: List[str]):
        """
        check whether stopping the specified MDS would reduce immediate
        availability
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds ok-to-stop --ids=string
        
        module=mds perm=r flags=
        
        :param ids:
        """
        prefix = 'mds ok-to-stop'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    @deprecated
    def mds_remove_data_pool(self, pool: str):
        """
        remove data pool <pool>
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds remove_data_pool --pool=string
        
        module=mds perm=rw flags=obsolete
        
        :param pool:
        """
        prefix = 'mds remove_data_pool'
        _args = {'prefix': prefix, 'pool': pool}
        return self._mon_command(_args)
    
    def mds_repaired(self, role: str):
        """
        mark a damaged MDS rank as no longer damaged
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds repaired --role=string
        
        module=mds perm=rw flags=
        
        :param role:
        """
        prefix = 'mds repaired'
        _args = {'prefix': prefix, 'role': role}
        return self._mon_command(_args)
    
    def mds_rm(self, gid: int):
        """
        remove nonactive mds
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds rm --gid=1
        
        module=mds perm=rw flags=
        
        :param gid: CephInt range= ``0``
        """
        prefix = 'mds rm'
        _args = {'prefix': prefix, 'gid': gid}
        return self._mon_command(_args)
    
    @deprecated
    def mds_rm_data_pool(self, pool: str):
        """
        remove data pool <pool>
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds rm_data_pool --pool=string
        
        module=mds perm=rw flags=obsolete
        
        :param pool:
        """
        prefix = 'mds rm_data_pool'
        _args = {'prefix': prefix, 'pool': pool}
        return self._mon_command(_args)
    
    def mds_rmfailed(self, role: str, yes_i_really_mean_it: Optional[bool]=None):
        """
        remove failed rank
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds rmfailed --role=string --yes_i_really_mean_it=true
        
        module=mds perm=rw flags=hidden
        
        :param role:
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'mds rmfailed'
        _args = {'prefix': prefix, 'role': role, 'yes_i_really_mean_it': yes_i_really_mean_it}
        return self._mon_command(_args)
    
    @deprecated
    def mds_set(self, var: str, val: str, yes_i_really_mean_it:
                Optional[bool]=None):
        """
        set mds parameter <var> to <val>
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds set --var=choice --val=string --yes_i_really_mean_it=true
        
        module=mds perm=rw flags=obsolete
        
        :param var: CephChoices strings=max_mds|max_file_size|inline_data|allo
            w_new_snaps|allow_multimds|allow_multimds_snaps|allow_dirfrags
        :param val:
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'mds set'
        _args = {'prefix': prefix, 'var': var, 'val': val, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    @deprecated
    def mds_set_max_mds(self, maxmds: int):
        """
        set max MDS index
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds set_max_mds --maxmds=1
        
        module=mds perm=rw flags=obsolete
        
        :param maxmds: CephInt range= ``0``
        """
        prefix = 'mds set_max_mds'
        _args = {'prefix': prefix, 'maxmds': maxmds}
        return self._mon_command(_args)
    
    def mds_set_state(self, gid: int, state: int):
        """
        set mds state of <gid> to <numeric-state>
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds set_state --gid=1 --state=1
        
        module=mds perm=rw flags=hidden
        
        :param gid: CephInt range= ``0``
        :param state: CephInt range= ``0..20``
        """
        prefix = 'mds set_state'
        _args = {'prefix': prefix, 'gid': gid, 'state': state}
        return self._mon_command(_args)
    
    def mds_stat(self):
        """
        show MDS status
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds stat
        
        module=mds perm=r flags=hidden
        """
        prefix = 'mds stat'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    @deprecated
    def mds_stop(self, role: str):
        """
        stop mds
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds stop --role=string
        
        module=mds perm=rw flags=obsolete
        
        :param role:
        """
        prefix = 'mds stop'
        _args = {'prefix': prefix, 'role': role}
        return self._mon_command(_args)
    
    @deprecated
    def mds_tell(self, who: str, args: List[str]):
        """
        send command to particular mds
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds tell --who=string --args=string
        
        module=mds perm=rw flags=obsolete
        
        :param who:
        :param args:
        """
        prefix = 'mds tell'
        _args = {'prefix': prefix, 'who': who, 'args': args}
        return self._mon_command(_args)
    
    def mds_versions(self):
        """
        check running versions of MDSs
        
        Example command:
        
        .. code-block:: bash
        
            ceph mds versions
        
        module=mds perm=r flags=
        """
        prefix = 'mds versions'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mgr_count_metadata(self, property_1: str):
        """
        count ceph-mgr daemons by metadata field property
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr count-metadata --property=string
        
        module=mgr perm=r flags=
        
        :param property_1: Real name is ``property``
        """
        prefix = 'mgr count-metadata'
        _args = {'prefix': prefix, 'property': property_1}
        return self._mon_command(_args)
    
    def mgr_dump(self, epoch: Optional[int]=None):
        """
        dump the latest MgrMap
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr dump --epoch=1
        
        module=mgr perm=r flags=
        
        :param epoch: CephInt range= ``0``
        """
        prefix = 'mgr dump'
        _args = {'prefix': prefix, 'epoch': epoch}
        return self._mon_command(_args)
    
    def mgr_fail(self, who: str):
        """
        treat the named manager daemon as failed
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr fail --who=string
        
        module=mgr perm=rw flags=
        
        :param who:
        """
        prefix = 'mgr fail'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def mgr_metadata(self, who: Optional[str]=None):
        """
        dump metadata for all daemons or a specific daemon
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr metadata --who=string
        
        module=mgr perm=r flags=
        
        :param who:
        """
        prefix = 'mgr metadata'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def mgr_module_disable(self, module: str):
        """
        disable mgr module
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr module disable --module=string
        
        module=mgr perm=rw flags=
        
        :param module:
        """
        prefix = 'mgr module disable'
        _args = {'prefix': prefix, 'module': module}
        return self._mon_command(_args)
    
    def mgr_module_enable(self, module: str, force: Optional[str]=None):
        """
        enable mgr module
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr module enable --module=string --force=choice
        
        module=mgr perm=rw flags=
        
        :param module:
        :param force: CephChoices strings=--force
        """
        prefix = 'mgr module enable'
        _args = {'prefix': prefix, 'module': module, 'force': force}
        return self._mon_command(_args)
    
    def mgr_module_ls(self):
        """
        list active mgr modules
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr module ls
        
        module=mgr perm=r flags=
        """
        prefix = 'mgr module ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mgr_self_test_background_start(self, workload: str):
        """
        Activate a background workload (one of command_spam, throw_exception)
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr self-test background start --workload=string
        
        module=mgr perm=rw flags=mgr
        
        :param workload:
        """
        prefix = 'mgr self-test background start'
        _args = {'prefix': prefix, 'workload': workload}
        return self._mon_command(_args)
    
    def mgr_self_test_background_stop(self):
        """
        Stop background workload if any is running
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr self-test background stop
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'mgr self-test background stop'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mgr_self_test_cluster_log(self, channel: str, priority: str, message: str):
        """
        Create an audit log record.
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr self-test cluster-log --channel=string --priority=string --message=string
        
        module=mgr perm=rw flags=mgr
        
        :param channel:
        :param priority:
        :param message:
        """
        prefix = 'mgr self-test cluster-log'
        _args = {'prefix': prefix, 'channel': channel, 'priority': priority, 'message': message}
        return self._mon_command(_args)
    
    def mgr_self_test_config_get(self, key: str):
        """
        Peek at a configuration value
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr self-test config get --key=string
        
        module=mgr perm=rw flags=mgr
        
        :param key:
        """
        prefix = 'mgr self-test config get'
        _args = {'prefix': prefix, 'key': key}
        return self._mon_command(_args)
    
    def mgr_self_test_config_get_localized(self, key: str):
        """
        Peek at a configuration value (localized variant)
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr self-test config get_localized --key=string
        
        module=mgr perm=rw flags=mgr
        
        :param key:
        """
        prefix = 'mgr self-test config get_localized'
        _args = {'prefix': prefix, 'key': key}
        return self._mon_command(_args)
    
    def mgr_self_test_health_clear(self, checks: List[str]):
        """
        Clear health checks by name. If no names provided, clear all.
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr self-test health clear --checks=string
        
        module=mgr perm=rw flags=mgr
        
        :param checks:
        """
        prefix = 'mgr self-test health clear'
        _args = {'prefix': prefix, 'checks': checks}
        return self._mon_command(_args)
    
    def mgr_self_test_health_set(self, checks: str):
        """
        Set a health check from a JSON-formatted description.
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr self-test health set --checks=string
        
        module=mgr perm=rw flags=mgr
        
        :param checks:
        """
        prefix = 'mgr self-test health set'
        _args = {'prefix': prefix, 'checks': checks}
        return self._mon_command(_args)
    
    def mgr_self_test_insights_set_now_offset(self, hours: str):
        """
        Set the now time for the insights module.
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr self-test insights_set_now_offset --hours=string
        
        module=mgr perm=rw flags=mgr
        
        :param hours:
        """
        prefix = 'mgr self-test insights_set_now_offset'
        _args = {'prefix': prefix, 'hours': hours}
        return self._mon_command(_args)
    
    def mgr_self_test_module(self, module: str):
        """
        Run another module's self_test() method
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr self-test module --module=string
        
        module=mgr perm=rw flags=mgr
        
        :param module:
        """
        prefix = 'mgr self-test module'
        _args = {'prefix': prefix, 'module': module}
        return self._mon_command(_args)
    
    def mgr_self_test_remote(self):
        """
        Test inter-module calls
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr self-test remote
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'mgr self-test remote'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mgr_self_test_run(self):
        """
        Run mgr python interface tests
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr self-test run
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'mgr self-test run'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mgr_services(self):
        """
        list service endpoints provided by mgr modules
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr services
        
        module=mgr perm=r flags=
        """
        prefix = 'mgr services'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mgr_versions(self):
        """
        check running versions of ceph-mgr daemons
        
        Example command:
        
        .. code-block:: bash
        
            ceph mgr versions
        
        module=mgr perm=r flags=
        """
        prefix = 'mgr versions'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mon_add(self, name: str, addr: str):
        """
        add new monitor named <name> at <addr>
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon add --name=string --addr=0.0.0.0
        
        module=mon perm=rw flags=
        
        :param name:
        :param addr: CephIPAddr
        """
        prefix = 'mon add'
        _args = {'prefix': prefix, 'name': name, 'addr': addr}
        return self._mon_command(_args)
    
    def mon_compact(self):
        """
        cause compaction of monitor's leveldb/rocksdb storage
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon compact
        
        module=mon perm=rw flags=no_forward
        """
        prefix = 'mon compact'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mon_count_metadata(self, property_1: str):
        """
        count mons by metadata field property
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon count-metadata --property=string
        
        module=mon perm=r flags=
        
        :param property_1: Real name is ``property``
        """
        prefix = 'mon count-metadata'
        _args = {'prefix': prefix, 'property': property_1}
        return self._mon_command(_args)
    
    def mon_dump(self, epoch: Optional[int]=None):
        """
        dump formatted monmap (optionally from epoch)
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon dump --epoch=1
        
        module=mon perm=r flags=
        
        :param epoch: CephInt range= ``0``
        """
        prefix = 'mon dump'
        _args = {'prefix': prefix, 'epoch': epoch}
        return self._mon_command(_args)
    
    def mon_enable_msgr2(self):
        """
        enable the msgr2 protocol on port 3300
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon enable-msgr2
        
        module=mon perm=rw flags=
        """
        prefix = 'mon enable-msgr2'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mon_feature_ls(self, with_value: Optional[str]=None):
        """
        list available mon map features to be set/unset
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon feature ls --with_value=choice
        
        module=mon perm=r flags=
        
        :param with_value: CephChoices strings=--with-value
        """
        prefix = 'mon feature ls'
        _args = {'prefix': prefix, 'with_value': with_value}
        return self._mon_command(_args)
    
    def mon_feature_set(self, feature_name: str, yes_i_really_mean_it:
                        Optional[bool]=None):
        """
        set provided feature on mon map
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon feature set --feature_name=string --yes_i_really_mean_it=true
        
        module=mon perm=rw flags=
        
        :param feature_name:
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'mon feature set'
        _args = {'prefix': prefix, 'feature_name': feature_name, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def mon_getmap(self, epoch: Optional[int]=None):
        """
        get monmap
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon getmap --epoch=1
        
        module=mon perm=r flags=
        
        :param epoch: CephInt range= ``0``
        """
        prefix = 'mon getmap'
        _args = {'prefix': prefix, 'epoch': epoch}
        return self._mon_command(_args)
    
    def mon_metadata(self, id_1: Optional[str]=None):
        """
        fetch metadata for mon <id>
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon metadata --id=string
        
        module=mon perm=r flags=
        
        :param id_1: Real name is ``id``
        """
        prefix = 'mon metadata'
        _args = {'prefix': prefix, 'id': id_1}
        return self._mon_command(_args)
    
    def mon_ok_to_add_offline(self):
        """
        check whether adding a mon and not starting it would break quorum
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon ok-to-add-offline
        
        module=mon perm=r flags=
        """
        prefix = 'mon ok-to-add-offline'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mon_ok_to_rm(self, id_1: str):
        """
        check whether removing the specified mon would break quorum
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon ok-to-rm --id=string
        
        module=mon perm=r flags=
        
        :param id_1: Real name is ``id``
        """
        prefix = 'mon ok-to-rm'
        _args = {'prefix': prefix, 'id': id_1}
        return self._mon_command(_args)
    
    def mon_ok_to_stop(self, ids: List[str]):
        """
        check whether mon(s) can be safely stopped without reducing immediate
        availability
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon ok-to-stop --ids=string
        
        module=mon perm=r flags=
        
        :param ids:
        """
        prefix = 'mon ok-to-stop'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    @deprecated
    def mon_remove(self, name: str):
        """
        remove monitor named <name>
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon remove --name=string
        
        module=mon perm=rw flags=deprecated
        
        :param name:
        """
        prefix = 'mon remove'
        _args = {'prefix': prefix, 'name': name}
        return self._mon_command(_args)
    
    def mon_rm(self, name: str):
        """
        remove monitor named <name>
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon rm --name=string
        
        module=mon perm=rw flags=
        
        :param name:
        """
        prefix = 'mon rm'
        _args = {'prefix': prefix, 'name': name}
        return self._mon_command(_args)
    
    def mon_scrub(self):
        """
        scrub the monitor stores
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon scrub
        
        module=mon perm=rw flags=
        """
        prefix = 'mon scrub'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mon_set_addrs(self, name: str, addrs: str):
        """
        set the addrs (IPs and ports) a specific monitor binds to
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon set-addrs --name=string --addrs=string
        
        module=mon perm=rw flags=
        
        :param name:
        :param addrs:
        """
        prefix = 'mon set-addrs'
        _args = {'prefix': prefix, 'name': name, 'addrs': addrs}
        return self._mon_command(_args)
    
    def mon_set_rank(self, name: str, rank: int):
        """
        set the rank for the specified mon
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon set-rank --name=string --rank=1
        
        module=mon perm=rw flags=
        
        :param name:
        :param rank: CephInt
        """
        prefix = 'mon set-rank'
        _args = {'prefix': prefix, 'name': name, 'rank': rank}
        return self._mon_command(_args)
    
    def mon_set_weight(self, name: str, weight: int):
        """
        set the weight for the specified mon
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon set-weight --name=string --weight=1
        
        module=mon perm=rw flags=
        
        :param name:
        :param weight: CephInt range= ``0..65535``
        """
        prefix = 'mon set-weight'
        _args = {'prefix': prefix, 'name': name, 'weight': weight}
        return self._mon_command(_args)
    
    def mon_stat(self):
        """
        summarize monitor status
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon stat
        
        module=mon perm=r flags=
        """
        prefix = 'mon stat'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mon_sync_force(self, yes_i_really_mean_it: Optional[bool]=None,
                       i_know_what_i_am_doing: Optional[bool]=None):
        """
        force sync of and clear monitor store
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon sync force --yes_i_really_mean_it=true --i_know_what_i_am_doing=true
        
        module=mon perm=rw flags=no_forward
        
        :param yes_i_really_mean_it: CephBool
        :param i_know_what_i_am_doing: CephBool
        """
        prefix = 'mon sync force'
        _args = {'prefix': prefix, 'yes_i_really_mean_it': yes_i_really_mean_it,
                 'i_know_what_i_am_doing': i_know_what_i_am_doing}
        return self._mon_command(_args)
    
    def mon_versions(self):
        """
        check running versions of monitors
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon versions
        
        module=mon perm=r flags=
        """
        prefix = 'mon versions'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def mon_status(self):
        """
        report status of monitors
        
        Example command:
        
        .. code-block:: bash
        
            ceph mon_status
        
        module=mon perm=r flags=no_forward
        """
        prefix = 'mon_status'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def node_ls(self, type_1: Optional[str]=None):
        """
        list all nodes in cluster [type]
        
        Example command:
        
        .. code-block:: bash
        
            ceph node ls --type=choice
        
        module=mon perm=r flags=
        
        :param type_1: CephChoices strings=all|osd|mon|mds|mgr Real name is
            ``type``
        """
        prefix = 'node ls'
        _args = {'prefix': prefix, 'type': type_1}
        return self._mon_command(_args)
    
    def orchestrator_device_ls(self, host: Optional[List[str]]=None, format:
                               Optional[str]=None, refresh: Optional[bool]=None):
        """
        List devices on a node
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator device ls --host=string --format=choice --refresh=true
        
        module=mgr perm=r flags=mgr
        
        :param host:
        :param format: CephChoices strings=json|plain
        :param refresh: CephBool
        """
        prefix = 'orchestrator device ls'
        _args = {'prefix': prefix, 'host': host, 'format': format, 'refresh': refresh}
        return self._mon_command(_args)
    
    def orchestrator_host_add(self, host: str):
        """
        Add a host
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator host add --host=string
        
        module=mgr perm=rw flags=mgr
        
        :param host:
        """
        prefix = 'orchestrator host add'
        _args = {'prefix': prefix, 'host': host}
        return self._mon_command(_args)
    
    def orchestrator_host_ls(self):
        """
        List hosts
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator host ls
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'orchestrator host ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def orchestrator_host_rm(self, host: str):
        """
        Remove a host
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator host rm --host=string
        
        module=mgr perm=rw flags=mgr
        
        :param host:
        """
        prefix = 'orchestrator host rm'
        _args = {'prefix': prefix, 'host': host}
        return self._mon_command(_args)
    
    def orchestrator_mds_add(self, svc_arg: str):
        """
        Create an MDS service
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator mds add --svc_arg=string
        
        module=mgr perm=rw flags=mgr
        
        :param svc_arg:
        """
        prefix = 'orchestrator mds add'
        _args = {'prefix': prefix, 'svc_arg': svc_arg}
        return self._mon_command(_args)
    
    def orchestrator_mds_rm(self, svc_id: str):
        """
        Remove an MDS service
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator mds rm --svc_id=string
        
        module=mgr perm=rw flags=mgr
        
        :param svc_id:
        """
        prefix = 'orchestrator mds rm'
        _args = {'prefix': prefix, 'svc_id': svc_id}
        return self._mon_command(_args)
    
    def orchestrator_mgr_update(self, num: int, hosts: Optional[List[str]]=None):
        """
        Update the number of manager instances
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator mgr update --num=1 --hosts=string
        
        module=mgr perm=rw flags=mgr
        
        :param num: CephInt
        :param hosts:
        """
        prefix = 'orchestrator mgr update'
        _args = {'prefix': prefix, 'num': num, 'hosts': hosts}
        return self._mon_command(_args)
    
    def orchestrator_mon_update(self, num: int, hosts: Optional[List[str]]=None):
        """
        Update the number of monitor instances
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator mon update --num=1 --hosts=string
        
        module=mgr perm=rw flags=mgr
        
        :param num: CephInt
        :param hosts:
        """
        prefix = 'orchestrator mon update'
        _args = {'prefix': prefix, 'num': num, 'hosts': hosts}
        return self._mon_command(_args)
    
    def orchestrator_nfs_add(self, svc_arg: str, pool: str, namespace: Optional[str]=None):
        """
        Create an NFS service
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator nfs add --svc_arg=string --pool=string --namespace=string
        
        module=mgr perm=rw flags=mgr
        
        :param svc_arg:
        :param pool:
        :param namespace:
        """
        prefix = 'orchestrator nfs add'
        _args = {'prefix': prefix, 'svc_arg': svc_arg, 'pool': pool, 'namespace': namespace}
        return self._mon_command(_args)
    
    def orchestrator_nfs_rm(self, svc_id: str):
        """
        Remove an NFS service
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator nfs rm --svc_id=string
        
        module=mgr perm=rw flags=mgr
        
        :param svc_id:
        """
        prefix = 'orchestrator nfs rm'
        _args = {'prefix': prefix, 'svc_id': svc_id}
        return self._mon_command(_args)
    
    def orchestrator_nfs_update(self, svc_id: str, num: int):
        """
        Scale an NFS service
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator nfs update --svc_id=string --num=1
        
        module=mgr perm=rw flags=mgr
        
        :param svc_id:
        :param num: CephInt
        """
        prefix = 'orchestrator nfs update'
        _args = {'prefix': prefix, 'svc_id': svc_id, 'num': num}
        return self._mon_command(_args)
    
    def orchestrator_osd_create(self, svc_arg: Optional[str]=None):
        """
        Create an OSD service. Either --svc_arg=host:drives or -i
        <drive_group>
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator osd create --svc_arg=string
        
        module=mgr perm=rw flags=mgr
        
        :param svc_arg:
        """
        prefix = 'orchestrator osd create'
        _args = {'prefix': prefix, 'svc_arg': svc_arg}
        return self._mon_command(_args)
    
    def orchestrator_osd_rm(self, svc_id: List[str]):
        """
        Remove OSD services
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator osd rm --svc_id=string
        
        module=mgr perm=rw flags=mgr
        
        :param svc_id:
        """
        prefix = 'orchestrator osd rm'
        _args = {'prefix': prefix, 'svc_id': svc_id}
        return self._mon_command(_args)
    
    def orchestrator_rgw_add(self, zone_name: Optional[str]=None):
        """
        Create an RGW service. A complete <rgw_spec> can be provided using
        <-i> to customize completelly the RGW service
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator rgw add --zone_name=string
        
        module=mgr perm=rw flags=mgr
        
        :param zone_name:
        """
        prefix = 'orchestrator rgw add'
        _args = {'prefix': prefix, 'zone_name': zone_name}
        return self._mon_command(_args)
    
    def orchestrator_rgw_rm(self, svc_id: str):
        """
        Remove an RGW service
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator rgw rm --svc_id=string
        
        module=mgr perm=rw flags=mgr
        
        :param svc_id:
        """
        prefix = 'orchestrator rgw rm'
        _args = {'prefix': prefix, 'svc_id': svc_id}
        return self._mon_command(_args)
    
    def orchestrator_service(self, action: str, svc_type: str, svc_name: str):
        """
        Start, stop or reload an entire service (i.e. all daemons)
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator service --action=choice --svc_type=string --svc_name=string
        
        module=mgr perm=rw flags=mgr
        
        :param action: CephChoices strings=start|stop|reload
        :param svc_type:
        :param svc_name:
        """
        prefix = 'orchestrator service'
        _args = {'prefix': prefix, 'action': action, 'svc_type': svc_type, 'svc_name': svc_name}
        return self._mon_command(_args)
    
    def orchestrator_service_ls(self, host: Optional[str]=None, svc_type:
                                Optional[str]=None, svc_id: Optional[str]=None, format:
                                Optional[str]=None, refresh: Optional[bool]=None):
        """
        List services known to orchestrator
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator service ls --host=string --svc_type=choice --svc_id=string --format=choice --refresh=true
        
        module=mgr perm=r flags=mgr
        
        :param host:
        :param svc_type: CephChoices
            strings=mon|mgr|osd|mds|iscsi|nfs|rgw|rbd-mirror
        :param svc_id:
        :param format: CephChoices strings=json|plain
        :param refresh: CephBool
        """
        prefix = 'orchestrator service ls'
        _args = {'prefix': prefix, 'host': host, 'svc_type': svc_type, 'svc_id': svc_id,
                 'format': format, 'refresh': refresh}
        return self._mon_command(_args)
    
    def orchestrator_service_instance(self, action: str, svc_type: str, svc_id: str):
        """
        Start, stop or reload a specific service instance
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator service-instance --action=choice --svc_type=string --svc_id=string
        
        module=mgr perm=rw flags=mgr
        
        :param action: CephChoices strings=start|stop|reload
        :param svc_type:
        :param svc_id:
        """
        prefix = 'orchestrator service-instance'
        _args = {'prefix': prefix, 'action': action, 'svc_type': svc_type, 'svc_id': svc_id}
        return self._mon_command(_args)
    
    def orchestrator_set_backend(self, module_name: str):
        """
        Select orchestrator module backend
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator set backend --module_name=string
        
        module=mgr perm=rw flags=mgr
        
        :param module_name:
        """
        prefix = 'orchestrator set backend'
        _args = {'prefix': prefix, 'module_name': module_name}
        return self._mon_command(_args)
    
    def orchestrator_status(self):
        """
        Report configured backend and its status
        
        Example command:
        
        .. code-block:: bash
        
            ceph orchestrator status
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'orchestrator status'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    @deprecated
    def osd_add_nodown(self, ids: List[str]):
        """
        mark osd(s) <id> [<id>...] as nodown, or use <all|any> to mark all
        osds as nodown
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd add-nodown --ids=string
        
        module=osd perm=rw flags=deprecated
        
        :param ids:
        """
        prefix = 'osd add-nodown'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    @deprecated
    def osd_add_noin(self, ids: List[str]):
        """
        mark osd(s) <id> [<id>...] as noin, or use <all|any> to mark all osds
        as noin
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd add-noin --ids=string
        
        module=osd perm=rw flags=deprecated
        
        :param ids:
        """
        prefix = 'osd add-noin'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    @deprecated
    def osd_add_noout(self, ids: List[str]):
        """
        mark osd(s) <id> [<id>...] as noout, or use <all|any> to mark all osds
        as noout
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd add-noout --ids=string
        
        module=osd perm=rw flags=deprecated
        
        :param ids:
        """
        prefix = 'osd add-noout'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    @deprecated
    def osd_add_noup(self, ids: List[str]):
        """
        mark osd(s) <id> [<id>...] as noup, or use <all|any> to mark all osds
        as noup
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd add-noup --ids=string
        
        module=osd perm=rw flags=deprecated
        
        :param ids:
        """
        prefix = 'osd add-noup'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    def osd_blacklist(self, blacklistop: str, addr: str, expire:
                      Optional[float]=None):
        """
        add (optionally until <expire> seconds from now) or remove <addr> from
        blacklist
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd blacklist --blacklistop=choice --addr=entityaddr --expire=0.0
        
        module=osd perm=rw flags=
        
        :param blacklistop: CephChoices strings=add|rm
        :param addr: CephEntityAddr
        :param expire: CephFloat range= ``0.0``
        """
        prefix = 'osd blacklist'
        _args = {'prefix': prefix, 'blacklistop': blacklistop, 'addr': addr, 'expire': expire}
        return self._mon_command(_args)
    
    def osd_blacklist_clear(self):
        """
        clear all blacklisted clients
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd blacklist clear
        
        module=osd perm=rw flags=
        """
        prefix = 'osd blacklist clear'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_blacklist_ls(self):
        """
        show blacklisted clients
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd blacklist ls
        
        module=osd perm=r flags=
        """
        prefix = 'osd blacklist ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_blocked_by(self):
        """
        print histogram of which OSDs are blocking their peers
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd blocked-by
        
        module=osd perm=r flags=mgr
        """
        prefix = 'osd blocked-by'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_count_metadata(self, property_1: str):
        """
        count OSDs by metadata field property
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd count-metadata --property=string
        
        module=osd perm=r flags=
        
        :param property_1: Real name is ``property``
        """
        prefix = 'osd count-metadata'
        _args = {'prefix': prefix, 'property': property_1}
        return self._mon_command(_args)
    
    @deprecated
    def osd_create(self, uuid: Optional[str]=None, id_1: Optional[str]=None):
        """
        create new osd (with optional UUID and ID)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd create --uuid=uuid --id=osd.0
        
        module=osd perm=rw flags=deprecated
        
        :param uuid: CephUUID
        :param id_1: CephOsdName Real name is ``id``
        """
        prefix = 'osd create'
        _args = {'prefix': prefix, 'uuid': uuid, 'id': id_1}
        return self._mon_command(_args)
    
    def osd_crush_add(self, id_1: str, weight: float, args: List[str]):
        """
        add or update crushmap position and weight for <name> with <weight>
        and location <args>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush add --id=osd.0 --weight=0.0 --args=string
        
        module=osd perm=rw flags=
        
        :param id_1: CephOsdName Real name is ``id``
        :param weight: CephFloat range= ``0.0``
        :param args: goodchars= ``[A-Za-z0-9-_.=]``
        """
        prefix = 'osd crush add'
        _args = {'prefix': prefix, 'id': id_1, 'weight': weight, 'args': args}
        return self._mon_command(_args)
    
    def osd_crush_add_bucket(self, name: str, type_1: str, args: Optional[List[str]]=None):
        """
        add no-parent (probably root) crush bucket <name> of type <type> to
        location <args>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush add-bucket --name=string --type=string --args=string
        
        module=osd perm=rw flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        :param type_1: Real name is ``type``
        :param args: goodchars= ``[A-Za-z0-9-_.=]``
        """
        prefix = 'osd crush add-bucket'
        _args = {'prefix': prefix, 'name': name, 'type': type_1, 'args': args}
        return self._mon_command(_args)
    
    def osd_crush_class_create(self, class_1: str):
        """
        create crush device class <class>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush class create --class=string
        
        module=osd perm=rw flags=
        
        :param class_1: goodchars= ``[A-Za-z0-9-_]`` Real name is ``class``
        """
        prefix = 'osd crush class create'
        _args = {'prefix': prefix, 'class': class_1}
        return self._mon_command(_args)
    
    def osd_crush_class_ls(self):
        """
        list all crush device classes
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush class ls
        
        module=osd perm=r flags=
        """
        prefix = 'osd crush class ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_crush_class_ls_osd(self, class_1: str):
        """
        list all osds belonging to the specific <class>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush class ls-osd --class=string
        
        module=osd perm=r flags=
        
        :param class_1: goodchars= ``[A-Za-z0-9-_]`` Real name is ``class``
        """
        prefix = 'osd crush class ls-osd'
        _args = {'prefix': prefix, 'class': class_1}
        return self._mon_command(_args)
    
    def osd_crush_class_rename(self, srcname: str, dstname: str):
        """
        rename crush device class <srcname> to <dstname>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush class rename --srcname=string --dstname=string
        
        module=osd perm=rw flags=
        
        :param srcname: goodchars= ``[A-Za-z0-9-_]``
        :param dstname: goodchars= ``[A-Za-z0-9-_]``
        """
        prefix = 'osd crush class rename'
        _args = {'prefix': prefix, 'srcname': srcname, 'dstname': dstname}
        return self._mon_command(_args)
    
    def osd_crush_class_rm(self, class_1: str):
        """
        remove crush device class <class>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush class rm --class=string
        
        module=osd perm=rw flags=
        
        :param class_1: goodchars= ``[A-Za-z0-9-_]`` Real name is ``class``
        """
        prefix = 'osd crush class rm'
        _args = {'prefix': prefix, 'class': class_1}
        return self._mon_command(_args)
    
    def osd_crush_create_or_move(self, id_1: str, weight: float, args: List[str]):
        """
        create entry or move existing entry for <name> <weight> at/to location
        <args>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush create-or-move --id=osd.0 --weight=0.0 --args=string
        
        module=osd perm=rw flags=
        
        :param id_1: CephOsdName Real name is ``id``
        :param weight: CephFloat range= ``0.0``
        :param args: goodchars= ``[A-Za-z0-9-_.=]``
        """
        prefix = 'osd crush create-or-move'
        _args = {'prefix': prefix, 'id': id_1, 'weight': weight, 'args': args}
        return self._mon_command(_args)
    
    def osd_crush_dump(self):
        """
        dump crush map
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush dump
        
        module=osd perm=r flags=
        """
        prefix = 'osd crush dump'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_crush_get_device_class(self, ids: List[str]):
        """
        get classes of specified osd(s) <id> [<id>...]
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush get-device-class --ids=string
        
        module=osd perm=r flags=
        
        :param ids:
        """
        prefix = 'osd crush get-device-class'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    def osd_crush_get_tunable(self, tunable: str):
        """
        get crush tunable <tunable>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush get-tunable --tunable=choice
        
        module=osd perm=r flags=
        
        :param tunable: CephChoices strings=straw_calc_version
        """
        prefix = 'osd crush get-tunable'
        _args = {'prefix': prefix, 'tunable': tunable}
        return self._mon_command(_args)
    
    def osd_crush_link(self, name: str, args: List[str]):
        """
        link existing entry for <name> under location <args>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush link --name=string --args=string
        
        module=osd perm=rw flags=
        
        :param name:
        :param args: goodchars= ``[A-Za-z0-9-_.=]``
        """
        prefix = 'osd crush link'
        _args = {'prefix': prefix, 'name': name, 'args': args}
        return self._mon_command(_args)
    
    def osd_crush_ls(self, node: str):
        """
        list items beneath a node in the CRUSH tree
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush ls --node=string
        
        module=osd perm=r flags=
        
        :param node: goodchars= ``[A-Za-z0-9-_.]``
        """
        prefix = 'osd crush ls'
        _args = {'prefix': prefix, 'node': node}
        return self._mon_command(_args)
    
    def osd_crush_move(self, name: str, args: List[str]):
        """
        move existing entry for <name> to location <args>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush move --name=string --args=string
        
        module=osd perm=rw flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        :param args: goodchars= ``[A-Za-z0-9-_.=]``
        """
        prefix = 'osd crush move'
        _args = {'prefix': prefix, 'name': name, 'args': args}
        return self._mon_command(_args)
    
    @deprecated
    def osd_crush_remove(self, name: str, ancestor: Optional[str]=None):
        """
        remove <name> from crush map (everywhere, or just at <ancestor>)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush remove --name=string --ancestor=string
        
        module=osd perm=rw flags=deprecated
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        :param ancestor: goodchars= ``[A-Za-z0-9-_.]``
        """
        prefix = 'osd crush remove'
        _args = {'prefix': prefix, 'name': name, 'ancestor': ancestor}
        return self._mon_command(_args)
    
    def osd_crush_rename_bucket(self, srcname: str, dstname: str):
        """
        rename bucket <srcname> to <dstname>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush rename-bucket --srcname=string --dstname=string
        
        module=osd perm=rw flags=
        
        :param srcname: goodchars= ``[A-Za-z0-9-_.]``
        :param dstname: goodchars= ``[A-Za-z0-9-_.]``
        """
        prefix = 'osd crush rename-bucket'
        _args = {'prefix': prefix, 'srcname': srcname, 'dstname': dstname}
        return self._mon_command(_args)
    
    def osd_crush_reweight(self, name: str, weight: float):
        """
        change <name>'s weight to <weight> in crush map
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush reweight --name=string --weight=0.0
        
        module=osd perm=rw flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        :param weight: CephFloat range= ``0.0``
        """
        prefix = 'osd crush reweight'
        _args = {'prefix': prefix, 'name': name, 'weight': weight}
        return self._mon_command(_args)
    
    def osd_crush_reweight_all(self):
        """
        recalculate the weights for the tree to ensure they sum correctly
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush reweight-all
        
        module=osd perm=rw flags=
        """
        prefix = 'osd crush reweight-all'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_crush_reweight_subtree(self, name: str, weight: float):
        """
        change all leaf items beneath <name> to <weight> in crush map
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush reweight-subtree --name=string --weight=0.0
        
        module=osd perm=rw flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        :param weight: CephFloat range= ``0.0``
        """
        prefix = 'osd crush reweight-subtree'
        _args = {'prefix': prefix, 'name': name, 'weight': weight}
        return self._mon_command(_args)
    
    def osd_crush_rm(self, name: str, ancestor: Optional[str]=None):
        """
        remove <name> from crush map (everywhere, or just at <ancestor>)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush rm --name=string --ancestor=string
        
        module=osd perm=rw flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        :param ancestor: goodchars= ``[A-Za-z0-9-_.]``
        """
        prefix = 'osd crush rm'
        _args = {'prefix': prefix, 'name': name, 'ancestor': ancestor}
        return self._mon_command(_args)
    
    def osd_crush_rm_device_class(self, ids: List[str]):
        """
        remove class of the osd(s) <id> [<id>...],or use <all|any> to remove
        all.
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush rm-device-class --ids=string
        
        module=osd perm=rw flags=
        
        :param ids:
        """
        prefix = 'osd crush rm-device-class'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    def osd_crush_rule_create_erasure(self, name: str, profile: Optional[str]=None):
        """
        create crush rule <name> for erasure coded pool created with <profile>
        (default default)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush rule create-erasure --name=string --profile=string
        
        module=osd perm=rw flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        :param profile: goodchars= ``[A-Za-z0-9-_.=]``
        """
        prefix = 'osd crush rule create-erasure'
        _args = {'prefix': prefix, 'name': name, 'profile': profile}
        return self._mon_command(_args)
    
    def osd_crush_rule_create_replicated(self, name: str, root: str, type_1: str, class_1:
                                         Optional[str]=None):
        """
        create crush rule <name> for replicated pool to start from <root>,
        replicate across buckets of type <type>, use devices of type <class>
        (ssd or hdd)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush rule create-replicated --name=string --root=string --type=string --class=string
        
        module=osd perm=rw flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        :param root: goodchars= ``[A-Za-z0-9-_.]``
        :param type_1: goodchars= ``[A-Za-z0-9-_.]`` Real name is ``type``
        :param class_1: goodchars= ``[A-Za-z0-9-_.]`` Real name is ``class``
        """
        prefix = 'osd crush rule create-replicated'
        _args = {'prefix': prefix, 'name': name, 'root': root, 'type': type_1, 'class': class_1}
        return self._mon_command(_args)
    
    def osd_crush_rule_create_simple(self, name: str, root: str, type_1: str, mode:
                                     Optional[str]=None):
        """
        create crush rule <name> to start from <root>, replicate across
        buckets of type <type>, using a choose mode of <firstn|indep> (default
        firstn; indep best for erasure pools)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush rule create-simple --name=string --root=string --type=string --mode=choice
        
        module=osd perm=rw flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        :param root: goodchars= ``[A-Za-z0-9-_.]``
        :param type_1: goodchars= ``[A-Za-z0-9-_.]`` Real name is ``type``
        :param mode: CephChoices strings=firstn|indep
        """
        prefix = 'osd crush rule create-simple'
        _args = {'prefix': prefix, 'name': name, 'root': root, 'type': type_1, 'mode': mode}
        return self._mon_command(_args)
    
    def osd_crush_rule_dump(self, name: Optional[str]=None):
        """
        dump crush rule <name> (default all)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush rule dump --name=string
        
        module=osd perm=r flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        """
        prefix = 'osd crush rule dump'
        _args = {'prefix': prefix, 'name': name}
        return self._mon_command(_args)
    
    @deprecated
    def osd_crush_rule_list(self):
        """
        list crush rules
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush rule list
        
        module=osd perm=r flags=deprecated
        """
        prefix = 'osd crush rule list'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_crush_rule_ls(self):
        """
        list crush rules
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush rule ls
        
        module=osd perm=r flags=
        """
        prefix = 'osd crush rule ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_crush_rule_ls_by_class(self, class_1: str):
        """
        list all crush rules that reference the same <class>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush rule ls-by-class --class=string
        
        module=osd perm=r flags=
        
        :param class_1: goodchars= ``[A-Za-z0-9-_.]`` Real name is ``class``
        """
        prefix = 'osd crush rule ls-by-class'
        _args = {'prefix': prefix, 'class': class_1}
        return self._mon_command(_args)
    
    def osd_crush_rule_rename(self, srcname: str, dstname: str):
        """
        rename crush rule <srcname> to <dstname>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush rule rename --srcname=string --dstname=string
        
        module=osd perm=rw flags=
        
        :param srcname: goodchars= ``[A-Za-z0-9-_.]``
        :param dstname: goodchars= ``[A-Za-z0-9-_.]``
        """
        prefix = 'osd crush rule rename'
        _args = {'prefix': prefix, 'srcname': srcname, 'dstname': dstname}
        return self._mon_command(_args)
    
    def osd_crush_rule_rm(self, name: str):
        """
        remove crush rule <name>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush rule rm --name=string
        
        module=osd perm=rw flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        """
        prefix = 'osd crush rule rm'
        _args = {'prefix': prefix, 'name': name}
        return self._mon_command(_args)
    # 
    # @overload  # todo
    # def osd_crush_set(self, prior_version: Optional[int]=None):
    #     """
    #     set crush map from input file
    #     
    #     Example command:
    #     
    #     .. code-block:: bash
    #     
    #         ceph osd crush set --prior_version=1
    #     
    #     module=osd perm=rw flags=
    #     
    #     :param prior_version: CephInt
    #     """
    #     prefix = 'osd crush set'
    #     _args = {'prefix': prefix, 'prior_version': prior_version}
    #     return self._mon_command(_args)
    # 
    # @overload  # todo
    # def osd_crush_set(self, id_1: str, weight: float, args: List[str]):
    #     """
    #     update crushmap position and weight for <name> to <weight> with
    #     location <args>
    #     
    #     Example command:
    #     
    #     .. code-block:: bash
    #     
    #         ceph osd crush set --id=osd.0 --weight=0.0 --args=string
    #     
    #     module=osd perm=rw flags=
    #     
    #     :param id_1: CephOsdName Real name is ``id``
    #     :param weight: CephFloat range= ``0.0``
    #     :param args: goodchars= ``[A-Za-z0-9-_.=]``
    #     """
    #     prefix = 'osd crush set'
    #     _args = {'prefix': prefix, 'id': id_1, 'weight': weight, 'args': args}
    #     return self._mon_command(_args)
    
    def osd_crush_set_all_straw_buckets_to_straw2(self):
        """
        convert all CRUSH current straw buckets to use the straw2 algorithm
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush set-all-straw-buckets-to-straw2
        
        module=osd perm=rw flags=
        """
        prefix = 'osd crush set-all-straw-buckets-to-straw2'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_crush_set_device_class(self, class_1: str, ids: List[str]):
        """
        set the <class> of the osd(s) <id> [<id>...],or use <all|any> to set
        all.
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush set-device-class --class=string --ids=string
        
        module=osd perm=rw flags=
        
        :param class_1: Real name is ``class``
        :param ids:
        """
        prefix = 'osd crush set-device-class'
        _args = {'prefix': prefix, 'class': class_1, 'ids': ids}
        return self._mon_command(_args)
    
    def osd_crush_set_tunable(self, tunable: str, value: int):
        """
        set crush tunable <tunable> to <value>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush set-tunable --tunable=choice --value=1
        
        module=osd perm=rw flags=
        
        :param tunable: CephChoices strings=straw_calc_version
        :param value: CephInt
        """
        prefix = 'osd crush set-tunable'
        _args = {'prefix': prefix, 'tunable': tunable, 'value': value}
        return self._mon_command(_args)
    
    def osd_crush_show_tunables(self):
        """
        show current crush tunables
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush show-tunables
        
        module=osd perm=r flags=
        """
        prefix = 'osd crush show-tunables'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_crush_swap_bucket(self, source: str, dest: str, yes_i_really_mean_it:
                              Optional[bool]=None):
        """
        swap existing bucket contents from (orphan) bucket <source> and
        <target>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush swap-bucket --source=string --dest=string --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=
        
        :param source: goodchars= ``[A-Za-z0-9-_.]``
        :param dest: goodchars= ``[A-Za-z0-9-_.]``
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd crush swap-bucket'
        _args = {'prefix': prefix, 'source': source, 'dest': dest, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_crush_tree(self, shadow: Optional[str]=None):
        """
        dump crush buckets and items in a tree view
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush tree --shadow=choice
        
        module=osd perm=r flags=
        
        :param shadow: CephChoices strings=--show-shadow
        """
        prefix = 'osd crush tree'
        _args = {'prefix': prefix, 'shadow': shadow}
        return self._mon_command(_args)
    
    def osd_crush_tunables(self, profile: str):
        """
        set crush tunables values to <profile>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush tunables --profile=choice
        
        module=osd perm=rw flags=
        
        :param profile: CephChoices
            strings=legacy|argonaut|bobtail|firefly|hammer|jewel|optimal|default
        """
        prefix = 'osd crush tunables'
        _args = {'prefix': prefix, 'profile': profile}
        return self._mon_command(_args)
    
    def osd_crush_unlink(self, name: str, ancestor: Optional[str]=None):
        """
        unlink <name> from crush map (everywhere, or just at <ancestor>)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush unlink --name=string --ancestor=string
        
        module=osd perm=rw flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        :param ancestor: goodchars= ``[A-Za-z0-9-_.]``
        """
        prefix = 'osd crush unlink'
        _args = {'prefix': prefix, 'name': name, 'ancestor': ancestor}
        return self._mon_command(_args)
    
    def osd_crush_weight_set_create(self, pool: str, mode: str):
        """
        create a weight-set for a given pool
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush weight-set create --pool=poolname --mode=choice
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param mode: CephChoices strings=flat|positional
        """
        prefix = 'osd crush weight-set create'
        _args = {'prefix': prefix, 'pool': pool, 'mode': mode}
        return self._mon_command(_args)
    
    def osd_crush_weight_set_create_compat(self):
        """
        create a default backward-compatible weight-set
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush weight-set create-compat
        
        module=osd perm=rw flags=
        """
        prefix = 'osd crush weight-set create-compat'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_crush_weight_set_dump(self):
        """
        dump crush weight sets
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush weight-set dump
        
        module=osd perm=r flags=
        """
        prefix = 'osd crush weight-set dump'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_crush_weight_set_ls(self):
        """
        list crush weight sets
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush weight-set ls
        
        module=osd perm=r flags=
        """
        prefix = 'osd crush weight-set ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_crush_weight_set_reweight(self, pool: str, item: str, weight: List[float]):
        """
        set weight for an item (bucket or osd) in a pool's weight-set
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush weight-set reweight --pool=poolname --item=string --weight=0.0
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param item:
        :param weight: CephFloat range= ``0.0``
        """
        prefix = 'osd crush weight-set reweight'
        _args = {'prefix': prefix, 'pool': pool, 'item': item, 'weight': weight}
        return self._mon_command(_args)
    
    def osd_crush_weight_set_reweight_compat(self, item: str, weight: List[float]):
        """
        set weight for an item (bucket or osd) in the backward-compatible
        weight-set
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush weight-set reweight-compat --item=string --weight=0.0
        
        module=osd perm=rw flags=
        
        :param item:
        :param weight: CephFloat range= ``0.0``
        """
        prefix = 'osd crush weight-set reweight-compat'
        _args = {'prefix': prefix, 'item': item, 'weight': weight}
        return self._mon_command(_args)
    
    def osd_crush_weight_set_rm(self, pool: str):
        """
        remove the weight-set for a given pool
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush weight-set rm --pool=poolname
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        """
        prefix = 'osd crush weight-set rm'
        _args = {'prefix': prefix, 'pool': pool}
        return self._mon_command(_args)
    
    def osd_crush_weight_set_rm_compat(self):
        """
        remove the backward-compatible weight-set
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd crush weight-set rm-compat
        
        module=osd perm=rw flags=
        """
        prefix = 'osd crush weight-set rm-compat'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_deep_scrub(self, who: str):
        """
        initiate deep scrub on osd <who>, or use <all|any> to deep scrub all
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd deep-scrub --who=string
        
        module=osd perm=rw flags=mgr
        
        :param who:
        """
        prefix = 'osd deep-scrub'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def osd_destroy(self, id_1: str, force: Optional[bool]=None,
                    yes_i_really_mean_it: Optional[bool]=None):
        """
        mark osd as being destroyed. Keeps the ID intact (allowing reuse), but
        removes cephx keys, config-key data and lockbox keys, rendering data
        permanently unreadable.
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd destroy --id=osd.0 --force=true --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=mgr
        
        :param id_1: CephOsdName Real name is ``id``
        :param force: CephBool
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd destroy'
        _args = {'prefix': prefix, 'id': id_1, 'force': force, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_destroy_actual(self, id_1: str, yes_i_really_mean_it: Optional[bool]=None):
        """
        mark osd as being destroyed. Keeps the ID intact (allowing reuse), but
        removes cephx keys, config-key data and lockbox keys, rendering data
        permanently unreadable.
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd destroy-actual --id=osd.0 --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=hidden
        
        :param id_1: CephOsdName Real name is ``id``
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd destroy-actual'
        _args = {'prefix': prefix, 'id': id_1, 'yes_i_really_mean_it': yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_df(self, output_method: Optional[str]=None, filter_by:
               Optional[str]=None, filter: Optional[str]=None):
        """
        show OSD utilization
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd df --output_method=choice --filter_by=choice --filter=string
        
        module=osd perm=r flags=mgr
        
        :param output_method: CephChoices strings=plain|tree
        :param filter_by: CephChoices strings=class|name
        :param filter:
        """
        prefix = 'osd df'
        _args = {'prefix': prefix, 'output_method': output_method, 'filter_by': filter_by,
                 'filter': filter}
        return self._mon_command(_args)
    
    def osd_down(self, ids: List[str], definitely_dead: Optional[bool]=None):
        """
        set osd(s) <id> [<id>...] down, or use <any|all> to set all osds down
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd down --ids=string --definitely_dead=true
        
        module=osd perm=rw flags=
        
        :param ids:
        :param definitely_dead: CephBool
        """
        prefix = 'osd down'
        _args = {'prefix': prefix, 'ids': ids, 'definitely_dead': definitely_dead}
        return self._mon_command(_args)
    
    def osd_dump(self, epoch: Optional[int]=None):
        """
        print summary of OSD map
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd dump --epoch=1
        
        module=osd perm=r flags=
        
        :param epoch: CephInt range= ``0``
        """
        prefix = 'osd dump'
        _args = {'prefix': prefix, 'epoch': epoch}
        return self._mon_command(_args)
    
    def osd_erasure_code_profile_get(self, name: str):
        """
        get erasure code profile <name>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd erasure-code-profile get --name=string
        
        module=osd perm=r flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        """
        prefix = 'osd erasure-code-profile get'
        _args = {'prefix': prefix, 'name': name}
        return self._mon_command(_args)
    
    def osd_erasure_code_profile_ls(self):
        """
        list all erasure code profiles
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd erasure-code-profile ls
        
        module=osd perm=r flags=
        """
        prefix = 'osd erasure-code-profile ls'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_erasure_code_profile_rm(self, name: str):
        """
        remove erasure code profile <name>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd erasure-code-profile rm --name=string
        
        module=osd perm=rw flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        """
        prefix = 'osd erasure-code-profile rm'
        _args = {'prefix': prefix, 'name': name}
        return self._mon_command(_args)
    
    def osd_erasure_code_profile_set(self, name: str, profile: Optional[List[str]]=None, force:
                                     Optional[bool]=None):
        """
        create erasure code profile <name> with [<key[=value]> ...] pairs. Add
        a --force at the end to override an existing profile (VERY DANGEROUS)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd erasure-code-profile set --name=string --profile=string --force=true
        
        module=osd perm=rw flags=
        
        :param name: goodchars= ``[A-Za-z0-9-_.]``
        :param profile:
        :param force: CephBool
        """
        prefix = 'osd erasure-code-profile set'
        _args = {'prefix': prefix, 'name': name, 'profile': profile, 'force': force}
        return self._mon_command(_args)
    
    def osd_find(self, id_1: str):
        """
        find osd <id> in the CRUSH map and show its location
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd find --id=osd.0
        
        module=osd perm=r flags=
        
        :param id_1: CephOsdName Real name is ``id``
        """
        prefix = 'osd find'
        _args = {'prefix': prefix, 'id': id_1}
        return self._mon_command(_args)
    
    def osd_force_create_pg(self, pgid: str, yes_i_really_mean_it: Optional[bool]=None):
        """
        force creation of pg <pgid>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd force-create-pg --pgid=0 --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=
        
        :param pgid: CephPgid
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd force-create-pg'
        _args = {'prefix': prefix, 'pgid': pgid, 'yes_i_really_mean_it': yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_get_require_min_compat_client(self):
        """
        get the minimum client version we will maintain compatibility with
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd get-require-min-compat-client
        
        module=osd perm=r flags=
        """
        prefix = 'osd get-require-min-compat-client'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_getcrushmap(self, epoch: Optional[int]=None):
        """
        get CRUSH map
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd getcrushmap --epoch=1
        
        module=osd perm=r flags=
        
        :param epoch: CephInt range= ``0``
        """
        prefix = 'osd getcrushmap'
        _args = {'prefix': prefix, 'epoch': epoch}
        return self._mon_command(_args)
    
    def osd_getmap(self, epoch: Optional[int]=None):
        """
        get OSD map
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd getmap --epoch=1
        
        module=osd perm=r flags=
        
        :param epoch: CephInt range= ``0``
        """
        prefix = 'osd getmap'
        _args = {'prefix': prefix, 'epoch': epoch}
        return self._mon_command(_args)
    
    def osd_getmaxosd(self):
        """
        show largest OSD id
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd getmaxosd
        
        module=osd perm=r flags=
        """
        prefix = 'osd getmaxosd'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_in(self, ids: List[str]):
        """
        set osd(s) <id> [<id>...] in, can use <any|all> to automatically set
        all previously out osds in
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd in --ids=string
        
        module=osd perm=rw flags=
        
        :param ids:
        """
        prefix = 'osd in'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    def osd_info(self, id_1: Optional[str]=None):
        """
        print osd's {id} information (instead of all osds from map)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd info --id=osd.0
        
        module=osd perm=r flags=
        
        :param id_1: CephOsdName Real name is ``id``
        """
        prefix = 'osd info'
        _args = {'prefix': prefix, 'id': id_1}
        return self._mon_command(_args)
    
    def osd_last_stat_seq(self, id_1: str):
        """
        get the last pg stats sequence number reported for this osd
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd last-stat-seq --id=osd.0
        
        module=osd perm=r flags=
        
        :param id_1: CephOsdName Real name is ``id``
        """
        prefix = 'osd last-stat-seq'
        _args = {'prefix': prefix, 'id': id_1}
        return self._mon_command(_args)
    
    def osd_lost(self, id_1: str, yes_i_really_mean_it: Optional[bool]=None):
        """
        mark osd as permanently lost. THIS DESTROYS DATA IF NO MORE REPLICAS
        EXIST, BE CAREFUL
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd lost --id=osd.0 --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=
        
        :param id_1: CephOsdName Real name is ``id``
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd lost'
        _args = {'prefix': prefix, 'id': id_1, 'yes_i_really_mean_it': yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_ls(self, epoch: Optional[int]=None):
        """
        show all OSD ids
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd ls --epoch=1
        
        module=osd perm=r flags=
        
        :param epoch: CephInt range= ``0``
        """
        prefix = 'osd ls'
        _args = {'prefix': prefix, 'epoch': epoch}
        return self._mon_command(_args)
    
    def osd_ls_tree(self, name: str, epoch: Optional[int]=None):
        """
        show OSD ids under bucket <name> in the CRUSH map
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd ls-tree --name=string --epoch=1
        
        module=osd perm=r flags=
        
        :param name:
        :param epoch: CephInt range= ``0``
        """
        prefix = 'osd ls-tree'
        _args = {'prefix': prefix, 'name': name, 'epoch': epoch}
        return self._mon_command(_args)
    
    @deprecated
    def osd_lspools(self):
        """
        list pools
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd lspools
        
        module=osd perm=r flags=deprecated
        """
        prefix = 'osd lspools'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_map(self, pool: str, object: str, nspace: Optional[str]=None):
        """
        find pg for <object> in <pool> with [namespace]
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd map --pool=poolname --object=objectname --nspace=string
        
        module=osd perm=r flags=
        
        :param pool: CephPoolname
        :param object: CephObjectname
        :param nspace:
        """
        prefix = 'osd map'
        _args = {'prefix': prefix, 'pool': pool, 'object': object, 'nspace': nspace}
        return self._mon_command(_args)
    
    def osd_metadata(self, id_1: Optional[str]=None):
        """
        fetch metadata for osd {id} (default all)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd metadata --id=osd.0
        
        module=osd perm=r flags=
        
        :param id_1: CephOsdName Real name is ``id``
        """
        prefix = 'osd metadata'
        _args = {'prefix': prefix, 'id': id_1}
        return self._mon_command(_args)
    
    def osd_new(self, uuid: str, id_1: Optional[str]=None):
        """
        Create a new OSD. If supplied, the `id` to be replaced needs to exist
        and have been previously destroyed. Reads secrets from JSON file via
        `-i <file>` (see man page).
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd new --uuid=uuid --id=osd.0
        
        module=osd perm=rw flags=
        
        :param uuid: CephUUID
        :param id_1: CephOsdName Real name is ``id``
        """
        prefix = 'osd new'
        _args = {'prefix': prefix, 'uuid': uuid, 'id': id_1}
        return self._mon_command(_args)
    
    def osd_numa_status(self):
        """
        show NUMA status of OSDs
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd numa-status
        
        module=osd perm=r flags=
        """
        prefix = 'osd numa-status'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_ok_to_stop(self, ids: List[str]):
        """
        check whether osd(s) can be safely stopped without reducing immediate
        data availability
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd ok-to-stop --ids=string
        
        module=osd perm=r flags=mgr
        
        :param ids:
        """
        prefix = 'osd ok-to-stop'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    def osd_out(self, ids: List[str]):
        """
        set osd(s) <id> [<id>...] out, or use <any|all> to set all osds out
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd out --ids=string
        
        module=osd perm=rw flags=
        
        :param ids:
        """
        prefix = 'osd out'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    def osd_pause(self):
        """
        pause osd
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pause
        
        module=osd perm=rw flags=
        """
        prefix = 'osd pause'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_perf(self):
        """
        print dump of OSD perf summary stats
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd perf
        
        module=osd perm=r flags=mgr
        """
        prefix = 'osd perf'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_perf_counters_get(self, query_id: int):
        """
        fetch osd perf counters
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd perf counters get --query_id=1
        
        module=mgr perm=w flags=mgr
        
        :param query_id: CephInt
        """
        prefix = 'osd perf counters get'
        _args = {'prefix': prefix, 'query_id': query_id}
        return self._mon_command(_args)
    
    def osd_perf_query_add(self, query: str):
        """
        add osd perf query
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd perf query add --query=choice
        
        module=mgr perm=w flags=mgr
        
        :param query: CephChoices strings=client_id|rbd_image_id|all_subkeys
        """
        prefix = 'osd perf query add'
        _args = {'prefix': prefix, 'query': query}
        return self._mon_command(_args)
    
    def osd_perf_query_remove(self, query_id: int):
        """
        remove osd perf query
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd perf query remove --query_id=1
        
        module=mgr perm=w flags=mgr
        
        :param query_id: CephInt
        """
        prefix = 'osd perf query remove'
        _args = {'prefix': prefix, 'query_id': query_id}
        return self._mon_command(_args)
    
    def osd_pg_temp(self, pgid: str, id_1: Optional[List[str]]=None):
        """
        set pg_temp mapping pgid:[<id> [<id>...]] (developers only)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pg-temp --pgid=0 --id=osd.0
        
        module=osd perm=rw flags=
        
        :param pgid: CephPgid
        :param id_1: CephOsdName Real name is ``id``
        """
        prefix = 'osd pg-temp'
        _args = {'prefix': prefix, 'pgid': pgid, 'id': id_1}
        return self._mon_command(_args)
    
    def osd_pg_upmap(self, pgid: str, id_1: List[str]):
        """
        set pg_upmap mapping <pgid>:[<id> [<id>...]] (developers only)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pg-upmap --pgid=0 --id=osd.0
        
        module=osd perm=rw flags=
        
        :param pgid: CephPgid
        :param id_1: CephOsdName Real name is ``id``
        """
        prefix = 'osd pg-upmap'
        _args = {'prefix': prefix, 'pgid': pgid, 'id': id_1}
        return self._mon_command(_args)
    
    def osd_pg_upmap_items(self, pgid: str, id_1: List[str]):
        """
        set pg_upmap_items mapping <pgid>:{<id> to <id>, [...]} (developers
        only)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pg-upmap-items --pgid=0 --id=osd.0
        
        module=osd perm=rw flags=
        
        :param pgid: CephPgid
        :param id_1: CephOsdName Real name is ``id``
        """
        prefix = 'osd pg-upmap-items'
        _args = {'prefix': prefix, 'pgid': pgid, 'id': id_1}
        return self._mon_command(_args)
    
    def osd_pool_application_disable(self, pool: str, app: str, yes_i_really_mean_it:
                                     Optional[bool]=None):
        """
        disables use of an application <app> on pool <poolname>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool application disable --pool=poolname --app=string --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param app:
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd pool application disable'
        _args = {'prefix': prefix, 'pool': pool, 'app': app, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_pool_application_enable(self, pool: str, app: str, yes_i_really_mean_it:
                                    Optional[bool]=None):
        """
        enable use of an application <app> [cephfs,rbd,rgw] on pool <poolname>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool application enable --pool=poolname --app=string --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param app: goodchars= ``[A-Za-z0-9-_.]``
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd pool application enable'
        _args = {'prefix': prefix, 'pool': pool, 'app': app, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_pool_application_get(self, pool: str, app: Optional[str]=None, key:
                                 Optional[str]=None):
        """
        get value of key <key> of application <app> on pool <poolname>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool application get --pool=poolname --app=string --key=string
        
        module=osd perm=r flags=
        
        :param pool: CephPoolname
        :param app:
        :param key:
        """
        prefix = 'osd pool application get'
        _args = {'prefix': prefix, 'pool': pool, 'app': app, 'key': key}
        return self._mon_command(_args)
    
    def osd_pool_application_rm(self, pool: str, app: str, key: str):
        """
        removes application <app> metadata key <key> on pool <poolname>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool application rm --pool=poolname --app=string --key=string
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param app:
        :param key:
        """
        prefix = 'osd pool application rm'
        _args = {'prefix': prefix, 'pool': pool, 'app': app, 'key': key}
        return self._mon_command(_args)
    
    def osd_pool_application_set(self, pool: str, app: str, key: str, value: str):
        """
        sets application <app> metadata key <key> to <value> on pool
        <poolname>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool application set --pool=poolname --app=string --key=string --value=string
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param app:
        :param key: goodchars= ``[A-Za-z0-9-_.]``
        :param value: goodchars= ``[A-Za-z0-9-_.=]``
        """
        prefix = 'osd pool application set'
        _args = {'prefix': prefix, 'pool': pool, 'app': app, 'key': key, 'value': value}
        return self._mon_command(_args)
    
    def osd_pool_autoscale_status(self):
        """
        report on pool pg_num sizing recommendation and intent
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool autoscale-status
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'osd pool autoscale-status'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_pool_cancel_force_backfill(self, who: List[str]):
        """
        restore normal recovery priority of specified pool <who>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool cancel-force-backfill --who=poolname
        
        module=osd perm=rw flags=mgr
        
        :param who: CephPoolname
        """
        prefix = 'osd pool cancel-force-backfill'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def osd_pool_cancel_force_recovery(self, who: List[str]):
        """
        restore normal recovery priority of specified pool <who>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool cancel-force-recovery --who=poolname
        
        module=osd perm=rw flags=mgr
        
        :param who: CephPoolname
        """
        prefix = 'osd pool cancel-force-recovery'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def osd_pool_create(self, pool: str, pg_num: int, pgp_num: Optional[int]=None,
                        pool_type: Optional[str]=None, erasure_code_profile:
                        Optional[str]=None, rule: Optional[str]=None,
                        expected_num_objects: Optional[int]=None, size:
                        Optional[int]=None, pg_num_min: Optional[int]=None,
                        target_size_bytes: Optional[int]=None, target_size_ratio:
                        Optional[float]=None):
        """
        create pool
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool create --pool=poolname --pg_num=1 --pgp_num=1 --pool_type=choice --erasure_code_profile=string --rule=string --expected_num_objects=1 --size=1 --pg_num_min=1 --target_size_bytes=1 --target_size_ratio=0.0
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param pg_num: CephInt range= ``0``
        :param pgp_num: CephInt range= ``0``
        :param pool_type: CephChoices strings=replicated|erasure
        :param erasure_code_profile: goodchars= ``[A-Za-z0-9-_.]``
        :param rule:
        :param expected_num_objects: CephInt
        :param size: CephInt
        :param pg_num_min: CephInt range= ``0``
        :param target_size_bytes: CephInt range= ``0``
        :param target_size_ratio: CephFloat range= ``0..1``
        """
        prefix = 'osd pool create'
        _args = {'prefix': prefix, 'pool': pool, 'pg_num': pg_num, 'pgp_num': pgp_num,
                 'pool_type': pool_type, 'erasure_code_profile':
                 erasure_code_profile, 'rule': rule, 'expected_num_objects':
                 expected_num_objects, 'size': size, 'pg_num_min':
                 pg_num_min, 'target_size_bytes': target_size_bytes,
                 'target_size_ratio': target_size_ratio}
        return self._mon_command(_args)
    
    def osd_pool_deep_scrub(self, who: List[str]):
        """
        initiate deep-scrub on pool <who>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool deep-scrub --who=poolname
        
        module=osd perm=rw flags=mgr
        
        :param who: CephPoolname
        """
        prefix = 'osd pool deep-scrub'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    @deprecated
    def osd_pool_delete(self, pool: str, pool2: Optional[str]=None,
                        yes_i_really_really_mean_it: Optional[bool]=None,
                        yes_i_really_really_mean_it_not_faking: Optional[bool]=None):
        """
        delete pool
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool delete --pool=poolname --pool2=poolname --yes_i_really_really_mean_it=true --yes_i_really_really_mean_it_not_faking=true
        
        module=osd perm=rw flags=deprecated
        
        :param pool: CephPoolname
        :param pool2: CephPoolname
        :param yes_i_really_really_mean_it: CephBool
        :param yes_i_really_really_mean_it_not_faking: CephBool
        """
        prefix = 'osd pool delete'
        _args = {'prefix': prefix, 'pool': pool, 'pool2': pool2, 'yes_i_really_really_mean_it':
                 yes_i_really_really_mean_it,
                 'yes_i_really_really_mean_it_not_faking':
                 yes_i_really_really_mean_it_not_faking}
        return self._mon_command(_args)
    
    def osd_pool_force_backfill(self, who: List[str]):
        """
        force backfill of specified pool <who> first
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool force-backfill --who=poolname
        
        module=osd perm=rw flags=mgr
        
        :param who: CephPoolname
        """
        prefix = 'osd pool force-backfill'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def osd_pool_force_recovery(self, who: List[str]):
        """
        force recovery of specified pool <who> first
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool force-recovery --who=poolname
        
        module=osd perm=rw flags=mgr
        
        :param who: CephPoolname
        """
        prefix = 'osd pool force-recovery'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def osd_pool_get(self, pool: str, var: str):
        """
        get pool parameter <var>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool get --pool=poolname --var=choice
        
        module=osd perm=r flags=
        
        :param pool: CephPoolname
        :param var: CephChoices strings=size|min_size|pg_num|pgp_num|crush_rul
            e|hashpspool|nodelete|nopgchange|nosizechange|write_fadvise_dontneed|n
            oscrub|nodeep-scrub|hit_set_type|hit_set_period|hit_set_count|hit_set_
            fpp|use_gmt_hitset|target_max_objects|target_max_bytes|cache_target_di
            rty_ratio|cache_target_dirty_high_ratio|cache_target_full_ratio|cache_
            min_flush_age|cache_min_evict_age|erasure_code_profile|min_read_recenc
            y_for_promote|all|min_write_recency_for_promote|fast_read|hit_set_grad
            e_decay_rate|hit_set_search_last_n|scrub_min_interval|scrub_max_interv
            al|deep_scrub_interval|recovery_priority|recovery_op_priority|scrub_pr
            iority|compression_mode|compression_algorithm|compression_required_rat
            io|compression_max_blob_size|compression_min_blob_size|csum_type|csum_
            min_block|csum_max_block|allow_ec_overwrites|fingerprint_algorithm|pg_
            autoscale_mode|pg_autoscale_bias|pg_num_min|target_size_bytes|target_s
            ize_ratio
        """
        prefix = 'osd pool get'
        _args = {'prefix': prefix, 'pool': pool, 'var': var}
        return self._mon_command(_args)
    
    def osd_pool_get_quota(self, pool: str):
        """
        obtain object or byte limits for pool
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool get-quota --pool=poolname
        
        module=osd perm=r flags=
        
        :param pool: CephPoolname
        """
        prefix = 'osd pool get-quota'
        _args = {'prefix': prefix, 'pool': pool}
        return self._mon_command(_args)
    
    def osd_pool_ls(self, detail: Optional[str]=None):
        """
        list pools
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool ls --detail=choice
        
        module=osd perm=r flags=
        
        :param detail: CephChoices strings=detail
        """
        prefix = 'osd pool ls'
        _args = {'prefix': prefix, 'detail': detail}
        return self._mon_command(_args)
    
    def osd_pool_mksnap(self, pool: str, snap: str):
        """
        make snapshot <snap> in <pool>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool mksnap --pool=poolname --snap=string
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param snap:
        """
        prefix = 'osd pool mksnap'
        _args = {'prefix': prefix, 'pool': pool, 'snap': snap}
        return self._mon_command(_args)
    
    def osd_pool_rename(self, srcpool: str, destpool: str):
        """
        rename <srcpool> to <destpool>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool rename --srcpool=poolname --destpool=poolname
        
        module=osd perm=rw flags=
        
        :param srcpool: CephPoolname
        :param destpool: CephPoolname
        """
        prefix = 'osd pool rename'
        _args = {'prefix': prefix, 'srcpool': srcpool, 'destpool': destpool}
        return self._mon_command(_args)
    
    def osd_pool_repair(self, who: List[str]):
        """
        initiate repair on pool <who>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool repair --who=poolname
        
        module=osd perm=rw flags=mgr
        
        :param who: CephPoolname
        """
        prefix = 'osd pool repair'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def osd_pool_rm(self, pool: str, pool2: Optional[str]=None,
                    yes_i_really_really_mean_it: Optional[bool]=None,
                    yes_i_really_really_mean_it_not_faking: Optional[bool]=None):
        """
        remove pool
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool rm --pool=poolname --pool2=poolname --yes_i_really_really_mean_it=true --yes_i_really_really_mean_it_not_faking=true
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param pool2: CephPoolname
        :param yes_i_really_really_mean_it: CephBool
        :param yes_i_really_really_mean_it_not_faking: CephBool
        """
        prefix = 'osd pool rm'
        _args = {'prefix': prefix, 'pool': pool, 'pool2': pool2, 'yes_i_really_really_mean_it':
                 yes_i_really_really_mean_it,
                 'yes_i_really_really_mean_it_not_faking':
                 yes_i_really_really_mean_it_not_faking}
        return self._mon_command(_args)
    
    def osd_pool_rmsnap(self, pool: str, snap: str):
        """
        remove snapshot <snap> from <pool>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool rmsnap --pool=poolname --snap=string
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param snap:
        """
        prefix = 'osd pool rmsnap'
        _args = {'prefix': prefix, 'pool': pool, 'snap': snap}
        return self._mon_command(_args)
    
    def osd_pool_scrub(self, who: List[str]):
        """
        initiate scrub on pool <who>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool scrub --who=poolname
        
        module=osd perm=rw flags=mgr
        
        :param who: CephPoolname
        """
        prefix = 'osd pool scrub'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def osd_pool_set(self, pool: str, var: str, val: str, yes_i_really_mean_it:
                     Optional[bool]=None):
        """
        set pool parameter <var> to <val>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool set --pool=poolname --var=choice --val=string --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param var: CephChoices strings=size|min_size|pg_num|pgp_num|pgp_num_a
            ctual|crush_rule|hashpspool|nodelete|nopgchange|nosizechange|write_fad
            vise_dontneed|noscrub|nodeep-scrub|hit_set_type|hit_set_period|hit_set
            _count|hit_set_fpp|use_gmt_hitset|target_max_bytes|target_max_objects|
            cache_target_dirty_ratio|cache_target_dirty_high_ratio|cache_target_fu
            ll_ratio|cache_min_flush_age|cache_min_evict_age|min_read_recency_for_
            promote|min_write_recency_for_promote|fast_read|hit_set_grade_decay_ra
            te|hit_set_search_last_n|scrub_min_interval|scrub_max_interval|deep_sc
            rub_interval|recovery_priority|recovery_op_priority|scrub_priority|com
            pression_mode|compression_algorithm|compression_required_ratio|compres
            sion_max_blob_size|compression_min_blob_size|csum_type|csum_min_block|
            csum_max_block|allow_ec_overwrites|fingerprint_algorithm|pg_autoscale_
            mode|pg_autoscale_bias|pg_num_min|target_size_bytes|target_size_ratio
        :param val:
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd pool set'
        _args = {'prefix': prefix, 'pool': pool, 'var': var, 'val': val,
                 'yes_i_really_mean_it': yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_pool_set_quota(self, pool: str, field: str, val: str):
        """
        set object or byte limit on pool
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool set-quota --pool=poolname --field=choice --val=string
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param field: CephChoices strings=max_objects|max_bytes
        :param val:
        """
        prefix = 'osd pool set-quota'
        _args = {'prefix': prefix, 'pool': pool, 'field': field, 'val': val}
        return self._mon_command(_args)
    
    def osd_pool_stats(self, pool_name: Optional[str]=None):
        """
        obtain stats from all pools, or from specified pool
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd pool stats --pool_name=poolname
        
        module=osd perm=r flags=mgr
        
        :param pool_name: CephPoolname
        """
        prefix = 'osd pool stats'
        _args = {'prefix': prefix, 'pool_name': pool_name}
        return self._mon_command(_args)
    
    def osd_primary_affinity(self, id_1: str, weight: float):
        """
        adjust osd primary-affinity from 0.0 <= <weight> <= 1.0
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd primary-affinity --id=osd.0 --weight=0.0
        
        module=osd perm=rw flags=
        
        :param id_1: CephOsdName Real name is ``id``
        :param weight: CephFloat range= ``0.0..1.0``
        """
        prefix = 'osd primary-affinity'
        _args = {'prefix': prefix, 'id': id_1, 'weight': weight}
        return self._mon_command(_args)
    
    def osd_primary_temp(self, pgid: str, id_1: str):
        """
        set primary_temp mapping pgid:<id>|-1 (developers only)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd primary-temp --pgid=0 --id=osd.0
        
        module=osd perm=rw flags=
        
        :param pgid: CephPgid
        :param id_1: CephOsdName Real name is ``id``
        """
        prefix = 'osd primary-temp'
        _args = {'prefix': prefix, 'pgid': pgid, 'id': id_1}
        return self._mon_command(_args)
    
    def osd_purge(self, id_1: str, force: Optional[bool]=None,
                  yes_i_really_mean_it: Optional[bool]=None):
        """
        purge all osd data from the monitors including the OSD id and CRUSH
        position
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd purge --id=osd.0 --force=true --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=mgr
        
        :param id_1: CephOsdName Real name is ``id``
        :param force: CephBool
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd purge'
        _args = {'prefix': prefix, 'id': id_1, 'force': force, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_purge_actual(self, id_1: str, yes_i_really_mean_it: Optional[bool]=None):
        """
        purge all osd data from the monitors. Combines `osd destroy`, `osd
        rm`, and `osd crush rm`.
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd purge-actual --id=osd.0 --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=hidden
        
        :param id_1: CephOsdName Real name is ``id``
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd purge-actual'
        _args = {'prefix': prefix, 'id': id_1, 'yes_i_really_mean_it': yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_purge_new(self, id_1: str, yes_i_really_mean_it: Optional[bool]=None):
        """
        purge all traces of an OSD that was partially created but never
        started
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd purge-new --id=osd.0 --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=
        
        :param id_1: CephOsdName Real name is ``id``
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd purge-new'
        _args = {'prefix': prefix, 'id': id_1, 'yes_i_really_mean_it': yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_repair(self, who: str):
        """
        initiate repair on osd <who>, or use <all|any> to repair all
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd repair --who=string
        
        module=osd perm=rw flags=mgr
        
        :param who:
        """
        prefix = 'osd repair'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def osd_require_osd_release(self, release: str, yes_i_really_mean_it:
                                Optional[bool]=None):
        """
        set the minimum allowed OSD release to participate in the cluster
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd require-osd-release --release=choice --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=
        
        :param release: CephChoices strings=luminous|mimic|nautilus|octopus
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd require-osd-release'
        _args = {'prefix': prefix, 'release': release, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_reweight(self, id_1: str, weight: float):
        """
        reweight osd to 0.0 < <weight> < 1.0
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd reweight --id=osd.0 --weight=0.0
        
        module=osd perm=rw flags=
        
        :param id_1: CephOsdName Real name is ``id``
        :param weight: CephFloat range= ``0.0..1.0``
        """
        prefix = 'osd reweight'
        _args = {'prefix': prefix, 'id': id_1, 'weight': weight}
        return self._mon_command(_args)
    
    def osd_reweight_by_pg(self, oload: Optional[int]=None, max_change:
                           Optional[float]=None, max_osds: Optional[int]=None, pools:
                           Optional[List[str]]=None):
        """
        reweight OSDs by PG distribution [overload-percentage-for-
        consideration, default 120]
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd reweight-by-pg --oload=1 --max_change=0.0 --max_osds=1 --pools=poolname
        
        module=osd perm=rw flags=mgr
        
        :param oload: CephInt
        :param max_change: CephFloat
        :param max_osds: CephInt
        :param pools: CephPoolname
        """
        prefix = 'osd reweight-by-pg'
        _args = {'prefix': prefix, 'oload': oload, 'max_change': max_change, 'max_osds':
                 max_osds, 'pools': pools}
        return self._mon_command(_args)
    
    def osd_reweight_by_utilization(self, oload: Optional[int]=None, max_change:
                                    Optional[float]=None, max_osds: Optional[int]=None,
                                    no_increasing: Optional[str]=None):
        """
        reweight OSDs by utilization [overload-percentage-for-consideration,
        default 120]
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd reweight-by-utilization --oload=1 --max_change=0.0 --max_osds=1 --no_increasing=choice
        
        module=osd perm=rw flags=mgr
        
        :param oload: CephInt
        :param max_change: CephFloat
        :param max_osds: CephInt
        :param no_increasing: CephChoices strings=--no-increasing
        """
        prefix = 'osd reweight-by-utilization'
        _args = {'prefix': prefix, 'oload': oload, 'max_change': max_change, 'max_osds':
                 max_osds, 'no_increasing': no_increasing}
        return self._mon_command(_args)
    
    def osd_reweightn(self, weights: str):
        """
        reweight osds with {<id>: <weight>,...})
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd reweightn --weights=string
        
        module=osd perm=rw flags=
        
        :param weights:
        """
        prefix = 'osd reweightn'
        _args = {'prefix': prefix, 'weights': weights}
        return self._mon_command(_args)
    
    @deprecated
    def osd_rm(self, ids: List[str]):
        """
        remove osd(s) <id> [<id>...], or use <any|all> to remove all osds
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd rm --ids=string
        
        module=osd perm=rw flags=deprecated
        
        :param ids:
        """
        prefix = 'osd rm'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    @deprecated
    def osd_rm_nodown(self, ids: List[str]):
        """
        allow osd(s) <id> [<id>...] to be marked down (if they are currently
        marked as nodown), can use <all|any> to automatically filter out all
        nodown osds
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd rm-nodown --ids=string
        
        module=osd perm=rw flags=deprecated
        
        :param ids:
        """
        prefix = 'osd rm-nodown'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    @deprecated
    def osd_rm_noin(self, ids: List[str]):
        """
        allow osd(s) <id> [<id>...] to be marked in (if they are currently
        marked as noin), can use <all|any> to automatically filter out all
        noin osds
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd rm-noin --ids=string
        
        module=osd perm=rw flags=deprecated
        
        :param ids:
        """
        prefix = 'osd rm-noin'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    @deprecated
    def osd_rm_noout(self, ids: List[str]):
        """
        allow osd(s) <id> [<id>...] to be marked out (if they are currently
        marked as noout), can use <all|any> to automatically filter out all
        noout osds
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd rm-noout --ids=string
        
        module=osd perm=rw flags=deprecated
        
        :param ids:
        """
        prefix = 'osd rm-noout'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    @deprecated
    def osd_rm_noup(self, ids: List[str]):
        """
        allow osd(s) <id> [<id>...] to be marked up (if they are currently
        marked as noup), can use <all|any> to automatically filter out all
        noup osds
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd rm-noup --ids=string
        
        module=osd perm=rw flags=deprecated
        
        :param ids:
        """
        prefix = 'osd rm-noup'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    def osd_rm_pg_upmap(self, pgid: str):
        """
        clear pg_upmap mapping for <pgid> (developers only)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd rm-pg-upmap --pgid=0
        
        module=osd perm=rw flags=
        
        :param pgid: CephPgid
        """
        prefix = 'osd rm-pg-upmap'
        _args = {'prefix': prefix, 'pgid': pgid}
        return self._mon_command(_args)
    
    def osd_rm_pg_upmap_items(self, pgid: str):
        """
        clear pg_upmap_items mapping for <pgid> (developers only)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd rm-pg-upmap-items --pgid=0
        
        module=osd perm=rw flags=
        
        :param pgid: CephPgid
        """
        prefix = 'osd rm-pg-upmap-items'
        _args = {'prefix': prefix, 'pgid': pgid}
        return self._mon_command(_args)
    
    def osd_safe_to_destroy(self, ids: List[str]):
        """
        check whether osd(s) can be safely destroyed without reducing data
        durability
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd safe-to-destroy --ids=string
        
        module=osd perm=r flags=mgr
        
        :param ids:
        """
        prefix = 'osd safe-to-destroy'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    def osd_scrub(self, who: str):
        """
        initiate scrub on osd <who>, or use <all|any> to scrub all
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd scrub --who=string
        
        module=osd perm=rw flags=mgr
        
        :param who:
        """
        prefix = 'osd scrub'
        _args = {'prefix': prefix, 'who': who}
        return self._mon_command(_args)
    
    def osd_set(self, key: str, yes_i_really_mean_it: Optional[bool]=None):
        """
        set <key>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd set --key=choice --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=
        
        :param key: CephChoices strings=full|pause|noup|nodown|noout|noin|noba
            ckfill|norebalance|norecover|noscrub|nodeep-
            scrub|notieragent|nosnaptrim|pglog_hardlimit
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd set'
        _args = {'prefix': prefix, 'key': key, 'yes_i_really_mean_it': yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_set_backfillfull_ratio(self, ratio: float):
        """
        set usage ratio at which OSDs are marked too full to backfill
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd set-backfillfull-ratio --ratio=0.0
        
        module=osd perm=rw flags=
        
        :param ratio: CephFloat range= ``0.0..1.0``
        """
        prefix = 'osd set-backfillfull-ratio'
        _args = {'prefix': prefix, 'ratio': ratio}
        return self._mon_command(_args)
    
    def osd_set_full_ratio(self, ratio: float):
        """
        set usage ratio at which OSDs are marked full
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd set-full-ratio --ratio=0.0
        
        module=osd perm=rw flags=
        
        :param ratio: CephFloat range= ``0.0..1.0``
        """
        prefix = 'osd set-full-ratio'
        _args = {'prefix': prefix, 'ratio': ratio}
        return self._mon_command(_args)
    
    def osd_set_group(self, flags: str, who: List[str]):
        """
        set <flags> for batch osds or crush nodes, <flags> must be a comma-
        separated subset of {noup,nodown,noin,noout}
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd set-group --flags=string --who=string
        
        module=osd perm=rw flags=
        
        :param flags:
        :param who:
        """
        prefix = 'osd set-group'
        _args = {'prefix': prefix, 'flags': flags, 'who': who}
        return self._mon_command(_args)
    
    def osd_set_nearfull_ratio(self, ratio: float):
        """
        set usage ratio at which OSDs are marked near-full
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd set-nearfull-ratio --ratio=0.0
        
        module=osd perm=rw flags=
        
        :param ratio: CephFloat range= ``0.0..1.0``
        """
        prefix = 'osd set-nearfull-ratio'
        _args = {'prefix': prefix, 'ratio': ratio}
        return self._mon_command(_args)
    
    def osd_set_require_min_compat_client(self, version: str, yes_i_really_mean_it:
                                          Optional[bool]=None):
        """
        set the minimum client version we will maintain compatibility with
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd set-require-min-compat-client --version=string --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=
        
        :param version:
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd set-require-min-compat-client'
        _args = {'prefix': prefix, 'version': version, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    def osd_setcrushmap(self, prior_version: Optional[int]=None):
        """
        set crush map from input file
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd setcrushmap --prior_version=1
        
        module=osd perm=rw flags=
        
        :param prior_version: CephInt
        """
        prefix = 'osd setcrushmap'
        _args = {'prefix': prefix, 'prior_version': prior_version}
        return self._mon_command(_args)
    
    def osd_setmaxosd(self, newmax: int):
        """
        set new maximum osd value
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd setmaxosd --newmax=1
        
        module=osd perm=rw flags=
        
        :param newmax: CephInt range= ``0``
        """
        prefix = 'osd setmaxosd'
        _args = {'prefix': prefix, 'newmax': newmax}
        return self._mon_command(_args)
    
    def osd_stat(self):
        """
        print summary of OSD map
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd stat
        
        module=osd perm=r flags=
        """
        prefix = 'osd stat'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_status(self, bucket: Optional[str]=None):
        """
        Show the status of OSDs within a bucket, or all
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd status --bucket=string
        
        module=mgr perm=r flags=mgr
        
        :param bucket:
        """
        prefix = 'osd status'
        _args = {'prefix': prefix, 'bucket': bucket}
        return self._mon_command(_args)
    
    def osd_stop(self, ids: List[str]):
        """
        stop the corresponding osd daemons and mark them as down
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd stop --ids=string
        
        module=osd perm=rw flags=
        
        :param ids:
        """
        prefix = 'osd stop'
        _args = {'prefix': prefix, 'ids': ids}
        return self._mon_command(_args)
    
    def osd_test_reweight_by_pg(self, oload: Optional[int]=None, max_change:
                                Optional[float]=None, max_osds: Optional[int]=None, pools:
                                Optional[List[str]]=None):
        """
        dry run of reweight OSDs by PG distribution [overload-percentage-for-
        consideration, default 120]
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd test-reweight-by-pg --oload=1 --max_change=0.0 --max_osds=1 --pools=poolname
        
        module=osd perm=r flags=mgr
        
        :param oload: CephInt
        :param max_change: CephFloat
        :param max_osds: CephInt
        :param pools: CephPoolname
        """
        prefix = 'osd test-reweight-by-pg'
        _args = {'prefix': prefix, 'oload': oload, 'max_change': max_change, 'max_osds':
                 max_osds, 'pools': pools}
        return self._mon_command(_args)
    
    def osd_test_reweight_by_utilization(self, oload: Optional[int]=None, max_change:
                                         Optional[float]=None, max_osds: Optional[int]=None,
                                         no_increasing: Optional[bool]=None):
        """
        dry run of reweight OSDs by utilization [overload-percentage-for-
        consideration, default 120]
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd test-reweight-by-utilization --oload=1 --max_change=0.0 --max_osds=1 --no_increasing=true
        
        module=osd perm=r flags=mgr
        
        :param oload: CephInt
        :param max_change: CephFloat
        :param max_osds: CephInt
        :param no_increasing: CephBool
        """
        prefix = 'osd test-reweight-by-utilization'
        _args = {'prefix': prefix, 'oload': oload, 'max_change': max_change, 'max_osds':
                 max_osds, 'no_increasing': no_increasing}
        return self._mon_command(_args)
    
    def osd_tier_add(self, pool: str, tierpool: str, force_nonempty:
                     Optional[str]=None):
        """
        add the tier <tierpool> (the second one) to base pool <pool> (the
        first one)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd tier add --pool=poolname --tierpool=poolname --force_nonempty=choice
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param tierpool: CephPoolname
        :param force_nonempty: CephChoices strings=--force-nonempty
        """
        prefix = 'osd tier add'
        _args = {'prefix': prefix, 'pool': pool, 'tierpool': tierpool, 'force_nonempty':
                 force_nonempty}
        return self._mon_command(_args)
    
    def osd_tier_add_cache(self, pool: str, tierpool: str, size: int):
        """
        add a cache <tierpool> (the second one) of size <size> to existing
        pool <pool> (the first one)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd tier add-cache --pool=poolname --tierpool=poolname --size=1
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param tierpool: CephPoolname
        :param size: CephInt range= ``0``
        """
        prefix = 'osd tier add-cache'
        _args = {'prefix': prefix, 'pool': pool, 'tierpool': tierpool, 'size': size}
        return self._mon_command(_args)
    
    def osd_tier_cache_mode(self, pool: str, mode: str, yes_i_really_mean_it:
                            Optional[bool]=None):
        """
        specify the caching mode for cache tier <pool>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd tier cache-mode --pool=poolname --mode=choice --yes_i_really_mean_it=true
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param mode: CephChoices
            strings=none|writeback|forward|readonly|readforward|proxy|readproxy
        :param yes_i_really_mean_it: CephBool
        """
        prefix = 'osd tier cache-mode'
        _args = {'prefix': prefix, 'pool': pool, 'mode': mode, 'yes_i_really_mean_it':
                 yes_i_really_mean_it}
        return self._mon_command(_args)
    
    @deprecated
    def osd_tier_remove(self, pool: str, tierpool: str):
        """
        remove the tier <tierpool> (the second one) from base pool <pool> (the
        first one)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd tier remove --pool=poolname --tierpool=poolname
        
        module=osd perm=rw flags=deprecated
        
        :param pool: CephPoolname
        :param tierpool: CephPoolname
        """
        prefix = 'osd tier remove'
        _args = {'prefix': prefix, 'pool': pool, 'tierpool': tierpool}
        return self._mon_command(_args)
    
    @deprecated
    def osd_tier_remove_overlay(self, pool: str):
        """
        remove the overlay pool for base pool <pool>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd tier remove-overlay --pool=poolname
        
        module=osd perm=rw flags=deprecated
        
        :param pool: CephPoolname
        """
        prefix = 'osd tier remove-overlay'
        _args = {'prefix': prefix, 'pool': pool}
        return self._mon_command(_args)
    
    def osd_tier_rm(self, pool: str, tierpool: str):
        """
        remove the tier <tierpool> (the second one) from base pool <pool> (the
        first one)
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd tier rm --pool=poolname --tierpool=poolname
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param tierpool: CephPoolname
        """
        prefix = 'osd tier rm'
        _args = {'prefix': prefix, 'pool': pool, 'tierpool': tierpool}
        return self._mon_command(_args)
    
    def osd_tier_rm_overlay(self, pool: str):
        """
        remove the overlay pool for base pool <pool>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd tier rm-overlay --pool=poolname
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        """
        prefix = 'osd tier rm-overlay'
        _args = {'prefix': prefix, 'pool': pool}
        return self._mon_command(_args)
    
    def osd_tier_set_overlay(self, pool: str, overlaypool: str):
        """
        set the overlay pool for base pool <pool> to be <overlaypool>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd tier set-overlay --pool=poolname --overlaypool=poolname
        
        module=osd perm=rw flags=
        
        :param pool: CephPoolname
        :param overlaypool: CephPoolname
        """
        prefix = 'osd tier set-overlay'
        _args = {'prefix': prefix, 'pool': pool, 'overlaypool': overlaypool}
        return self._mon_command(_args)
    
    def osd_tree(self, epoch: Optional[int]=None, states:
                 Optional[List[str]]=None):
        """
        print OSD tree
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd tree --epoch=1 --states=choice
        
        module=osd perm=r flags=
        
        :param epoch: CephInt range= ``0``
        :param states: CephChoices strings=up|down|in|out|destroyed
        """
        prefix = 'osd tree'
        _args = {'prefix': prefix, 'epoch': epoch, 'states': states}
        return self._mon_command(_args)
    
    def osd_tree_from(self, bucket: str, epoch: Optional[int]=None, states:
                      Optional[List[str]]=None):
        """
        print OSD tree in bucket
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd tree-from --bucket=string --epoch=1 --states=choice
        
        module=osd perm=r flags=
        
        :param bucket:
        :param epoch: CephInt range= ``0``
        :param states: CephChoices strings=up|down|in|out|destroyed
        """
        prefix = 'osd tree-from'
        _args = {'prefix': prefix, 'bucket': bucket, 'epoch': epoch, 'states': states}
        return self._mon_command(_args)
    
    def osd_unpause(self):
        """
        unpause osd
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd unpause
        
        module=osd perm=rw flags=
        """
        prefix = 'osd unpause'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_unset(self, key: str):
        """
        unset <key>
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd unset --key=choice
        
        module=osd perm=rw flags=
        
        :param key: CephChoices strings=full|pause|noup|nodown|noout|noin|noba
            ckfill|norebalance|norecover|noscrub|nodeep-
            scrub|notieragent|nosnaptrim
        """
        prefix = 'osd unset'
        _args = {'prefix': prefix, 'key': key}
        return self._mon_command(_args)
    
    def osd_unset_group(self, flags: str, who: List[str]):
        """
        unset <flags> for batch osds or crush nodes, <flags> must be a comma-
        separated subset of {noup,nodown,noin,noout}
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd unset-group --flags=string --who=string
        
        module=osd perm=rw flags=
        
        :param flags:
        :param who:
        """
        prefix = 'osd unset-group'
        _args = {'prefix': prefix, 'flags': flags, 'who': who}
        return self._mon_command(_args)
    
    def osd_utilization(self):
        """
        get basic pg distribution stats
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd utilization
        
        module=osd perm=r flags=
        """
        prefix = 'osd utilization'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def osd_versions(self):
        """
        check running versions of OSDs
        
        Example command:
        
        .. code-block:: bash
        
            ceph osd versions
        
        module=osd perm=r flags=
        """
        prefix = 'osd versions'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def pg_cancel_force_backfill(self, pgid: List[str]):
        """
        restore normal backfill priority of <pgid>
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg cancel-force-backfill --pgid=0
        
        module=pg perm=rw flags=mgr
        
        :param pgid: CephPgid
        """
        prefix = 'pg cancel-force-backfill'
        _args = {'prefix': prefix, 'pgid': pgid}
        return self._mon_command(_args)
    
    def pg_cancel_force_recovery(self, pgid: List[str]):
        """
        restore normal recovery priority of <pgid>
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg cancel-force-recovery --pgid=0
        
        module=pg perm=rw flags=mgr
        
        :param pgid: CephPgid
        """
        prefix = 'pg cancel-force-recovery'
        _args = {'prefix': prefix, 'pgid': pgid}
        return self._mon_command(_args)
    
    def pg_debug(self, debugop: str):
        """
        show debug info about pgs
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg debug --debugop=choice
        
        module=pg perm=r flags=mgr
        
        :param debugop: CephChoices
            strings=unfound_objects_exist|degraded_pgs_exist
        """
        prefix = 'pg debug'
        _args = {'prefix': prefix, 'debugop': debugop}
        return self._mon_command(_args)
    
    def pg_deep_scrub(self, pgid: str):
        """
        start deep-scrub on <pgid>
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg deep-scrub --pgid=0
        
        module=pg perm=rw flags=mgr
        
        :param pgid: CephPgid
        """
        prefix = 'pg deep-scrub'
        _args = {'prefix': prefix, 'pgid': pgid}
        return self._mon_command(_args)
    
    def pg_dump(self, dumpcontents: Optional[List[str]]=None):
        """
        show human-readable versions of pg map (only 'all' valid with plain)
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg dump --dumpcontents=choice
        
        module=pg perm=r flags=mgr
        
        :param dumpcontents: CephChoices
            strings=all|summary|sum|delta|pools|osds|pgs|pgs_brief
        """
        prefix = 'pg dump'
        _args = {'prefix': prefix, 'dumpcontents': dumpcontents}
        return self._mon_command(_args)
    
    def pg_dump_json(self, dumpcontents: Optional[List[str]]=None):
        """
        show human-readable version of pg map in json only
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg dump_json --dumpcontents=choice
        
        module=pg perm=r flags=mgr
        
        :param dumpcontents: CephChoices
            strings=all|summary|sum|pools|osds|pgs
        """
        prefix = 'pg dump_json'
        _args = {'prefix': prefix, 'dumpcontents': dumpcontents}
        return self._mon_command(_args)
    
    def pg_dump_pools_json(self):
        """
        show pg pools info in json only
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg dump_pools_json
        
        module=pg perm=r flags=mgr
        """
        prefix = 'pg dump_pools_json'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def pg_dump_stuck(self, stuckops: Optional[List[str]]=None, threshold:
                      Optional[int]=None):
        """
        show information about stuck pgs
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg dump_stuck --stuckops=choice --threshold=1
        
        module=pg perm=r flags=mgr
        
        :param stuckops: CephChoices
            strings=inactive|unclean|stale|undersized|degraded
        :param threshold: CephInt
        """
        prefix = 'pg dump_stuck'
        _args = {'prefix': prefix, 'stuckops': stuckops, 'threshold': threshold}
        return self._mon_command(_args)
    
    def pg_force_backfill(self, pgid: List[str]):
        """
        force backfill of <pgid> first
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg force-backfill --pgid=0
        
        module=pg perm=rw flags=mgr
        
        :param pgid: CephPgid
        """
        prefix = 'pg force-backfill'
        _args = {'prefix': prefix, 'pgid': pgid}
        return self._mon_command(_args)
    
    def pg_force_recovery(self, pgid: List[str]):
        """
        force recovery of <pgid> first
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg force-recovery --pgid=0
        
        module=pg perm=rw flags=mgr
        
        :param pgid: CephPgid
        """
        prefix = 'pg force-recovery'
        _args = {'prefix': prefix, 'pgid': pgid}
        return self._mon_command(_args)
    
    def pg_getmap(self):
        """
        get binary pg map to -o/stdout
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg getmap
        
        module=pg perm=r flags=mgr
        """
        prefix = 'pg getmap'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def pg_ls(self, pool: Optional[int]=None, states:
              Optional[List[str]]=None):
        """
        list pg with specific pool, osd, state
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg ls --pool=1 --states=string
        
        module=pg perm=r flags=mgr
        
        :param pool: CephInt
        :param states:
        """
        prefix = 'pg ls'
        _args = {'prefix': prefix, 'pool': pool, 'states': states}
        return self._mon_command(_args)
    
    def pg_ls_by_osd(self, osd: str, pool: Optional[int]=None, states:
                     Optional[List[str]]=None):
        """
        list pg on osd [osd]
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg ls-by-osd --osd=osd.0 --pool=1 --states=string
        
        module=pg perm=r flags=mgr
        
        :param osd: CephOsdName
        :param pool: CephInt
        :param states:
        """
        prefix = 'pg ls-by-osd'
        _args = {'prefix': prefix, 'osd': osd, 'pool': pool, 'states': states}
        return self._mon_command(_args)
    
    def pg_ls_by_pool(self, poolstr: str, states: Optional[List[str]]=None):
        """
        list pg with pool = [poolname]
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg ls-by-pool --poolstr=string --states=string
        
        module=pg perm=r flags=mgr
        
        :param poolstr:
        :param states:
        """
        prefix = 'pg ls-by-pool'
        _args = {'prefix': prefix, 'poolstr': poolstr, 'states': states}
        return self._mon_command(_args)
    
    def pg_ls_by_primary(self, osd: str, pool: Optional[int]=None, states:
                         Optional[List[str]]=None):
        """
        list pg with primary = [osd]
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg ls-by-primary --osd=osd.0 --pool=1 --states=string
        
        module=pg perm=r flags=mgr
        
        :param osd: CephOsdName
        :param pool: CephInt
        :param states:
        """
        prefix = 'pg ls-by-primary'
        _args = {'prefix': prefix, 'osd': osd, 'pool': pool, 'states': states}
        return self._mon_command(_args)
    
    def pg_map(self, pgid: str):
        """
        show mapping of pg to osds
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg map --pgid=0
        
        module=pg perm=r flags=
        
        :param pgid: CephPgid
        """
        prefix = 'pg map'
        _args = {'prefix': prefix, 'pgid': pgid}
        return self._mon_command(_args)
    
    def pg_repair(self, pgid: str):
        """
        start repair on <pgid>
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg repair --pgid=0
        
        module=pg perm=rw flags=mgr
        
        :param pgid: CephPgid
        """
        prefix = 'pg repair'
        _args = {'prefix': prefix, 'pgid': pgid}
        return self._mon_command(_args)
    
    def pg_repeer(self, pgid: str):
        """
        force a PG to repeer
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg repeer --pgid=0
        
        module=osd perm=rw flags=
        
        :param pgid: CephPgid
        """
        prefix = 'pg repeer'
        _args = {'prefix': prefix, 'pgid': pgid}
        return self._mon_command(_args)
    
    def pg_scrub(self, pgid: str):
        """
        start scrub on <pgid>
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg scrub --pgid=0
        
        module=pg perm=rw flags=mgr
        
        :param pgid: CephPgid
        """
        prefix = 'pg scrub'
        _args = {'prefix': prefix, 'pgid': pgid}
        return self._mon_command(_args)
    
    def pg_stat(self):
        """
        show placement group status.
        
        Example command:
        
        .. code-block:: bash
        
            ceph pg stat
        
        module=pg perm=r flags=mgr
        """
        prefix = 'pg stat'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def progress(self):
        """
        Show progress of recovery operations
        
        Example command:
        
        .. code-block:: bash
        
            ceph progress
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'progress'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def progress_clear(self):
        """
        Reset progress tracking
        
        Example command:
        
        .. code-block:: bash
        
            ceph progress clear
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'progress clear'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def progress_json(self):
        """
        Show machine readable progress information
        
        Example command:
        
        .. code-block:: bash
        
            ceph progress json
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'progress json'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def prometheus_file_sd_config(self):
        """
        Return file_sd compatible prometheus config for mgr cluster
        
        Example command:
        
        .. code-block:: bash
        
            ceph prometheus file_sd_config
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'prometheus file_sd_config'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def quorum(self, quorumcmd: str):
        """
        enter or exit quorum
        
        Example command:
        
        .. code-block:: bash
        
            ceph quorum --quorumcmd=choice
        
        module=mon perm=rw flags=
        
        :param quorumcmd: CephChoices strings=enter|exit
        """
        prefix = 'quorum'
        _args = {'prefix': prefix, 'quorumcmd': quorumcmd}
        return self._mon_command(_args)
    
    def quorum_status(self):
        """
        report status of monitor quorum
        
        Example command:
        
        .. code-block:: bash
        
            ceph quorum_status
        
        module=mon perm=r flags=
        """
        prefix = 'quorum_status'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def rbd_perf_image_counters(self, pool_spec: Optional[str]=None, sort_by:
                                Optional[str]=None):
        """
        Retrieve current RBD IO performance counters
        
        Example command:
        
        .. code-block:: bash
        
            ceph rbd perf image counters --pool_spec=string --sort_by=choice
        
        module=mgr perm=r flags=mgr
        
        :param pool_spec:
        :param sort_by: CephChoices strings=write_ops|write_bytes|write_latenc
            y|read_ops|read_bytes|read_latency
        """
        prefix = 'rbd perf image counters'
        _args = {'prefix': prefix, 'pool_spec': pool_spec, 'sort_by': sort_by}
        return self._mon_command(_args)
    
    def rbd_perf_image_stats(self, pool_spec: Optional[str]=None, sort_by:
                             Optional[str]=None):
        """
        Retrieve current RBD IO performance stats
        
        Example command:
        
        .. code-block:: bash
        
            ceph rbd perf image stats --pool_spec=string --sort_by=choice
        
        module=mgr perm=r flags=mgr
        
        :param pool_spec:
        :param sort_by: CephChoices strings=write_ops|write_bytes|write_latenc
            y|read_ops|read_bytes|read_latency
        """
        prefix = 'rbd perf image stats'
        _args = {'prefix': prefix, 'pool_spec': pool_spec, 'sort_by': sort_by}
        return self._mon_command(_args)
    
    def rbd_task_add_flatten(self, image_spec: str):
        """
        Flatten a cloned image asynchronously in the background
        
        Example command:
        
        .. code-block:: bash
        
            ceph rbd task add flatten --image_spec=string
        
        module=mgr perm=w flags=mgr
        
        :param image_spec:
        """
        prefix = 'rbd task add flatten'
        _args = {'prefix': prefix, 'image_spec': image_spec}
        return self._mon_command(_args)
    
    def rbd_task_add_migration_abort(self, image_spec: str):
        """
        Abort a prepared migration asynchronously in the background
        
        Example command:
        
        .. code-block:: bash
        
            ceph rbd task add migration abort --image_spec=string
        
        module=mgr perm=w flags=mgr
        
        :param image_spec:
        """
        prefix = 'rbd task add migration abort'
        _args = {'prefix': prefix, 'image_spec': image_spec}
        return self._mon_command(_args)
    
    def rbd_task_add_migration_commit(self, image_spec: str):
        """
        Commit an executed migration asynchronously in the background
        
        Example command:
        
        .. code-block:: bash
        
            ceph rbd task add migration commit --image_spec=string
        
        module=mgr perm=w flags=mgr
        
        :param image_spec:
        """
        prefix = 'rbd task add migration commit'
        _args = {'prefix': prefix, 'image_spec': image_spec}
        return self._mon_command(_args)
    
    def rbd_task_add_migration_execute(self, image_spec: str):
        """
        Execute an image migration asynchronously in the background
        
        Example command:
        
        .. code-block:: bash
        
            ceph rbd task add migration execute --image_spec=string
        
        module=mgr perm=w flags=mgr
        
        :param image_spec:
        """
        prefix = 'rbd task add migration execute'
        _args = {'prefix': prefix, 'image_spec': image_spec}
        return self._mon_command(_args)
    
    def rbd_task_add_remove(self, image_spec: str):
        """
        Remove an image asynchronously in the background
        
        Example command:
        
        .. code-block:: bash
        
            ceph rbd task add remove --image_spec=string
        
        module=mgr perm=w flags=mgr
        
        :param image_spec:
        """
        prefix = 'rbd task add remove'
        _args = {'prefix': prefix, 'image_spec': image_spec}
        return self._mon_command(_args)
    
    def rbd_task_add_trash_remove(self, image_id_spec: str):
        """
        Remove an image from the trash asynchronously in the background
        
        Example command:
        
        .. code-block:: bash
        
            ceph rbd task add trash remove --image_id_spec=string
        
        module=mgr perm=w flags=mgr
        
        :param image_id_spec:
        """
        prefix = 'rbd task add trash remove'
        _args = {'prefix': prefix, 'image_id_spec': image_id_spec}
        return self._mon_command(_args)
    
    def rbd_task_cancel(self, task_id: str):
        """
        Cancel a pending or running asynchronous task
        
        Example command:
        
        .. code-block:: bash
        
            ceph rbd task cancel --task_id=string
        
        module=mgr perm=r flags=mgr
        
        :param task_id:
        """
        prefix = 'rbd task cancel'
        _args = {'prefix': prefix, 'task_id': task_id}
        return self._mon_command(_args)
    
    def rbd_task_list(self, task_id: Optional[str]=None):
        """
        List pending or running asynchronous tasks
        
        Example command:
        
        .. code-block:: bash
        
            ceph rbd task list --task_id=string
        
        module=mgr perm=r flags=mgr
        
        :param task_id:
        """
        prefix = 'rbd task list'
        _args = {'prefix': prefix, 'task_id': task_id}
        return self._mon_command(_args)
    
    def report(self, tags: Optional[List[str]]=None):
        """
        report full status of cluster, optional title tag strings
        
        Example command:
        
        .. code-block:: bash
        
            ceph report --tags=string
        
        module=mon perm=r flags=
        
        :param tags:
        """
        prefix = 'report'
        _args = {'prefix': prefix, 'tags': tags}
        return self._mon_command(_args)
    
    @deprecated
    def scrub(self):
        """
        scrub the monitor stores
        
        Example command:
        
        .. code-block:: bash
        
            ceph scrub
        
        module=mon perm=rw flags=deprecated
        """
        prefix = 'scrub'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def service_dump(self):
        """
        dump service map
        
        Example command:
        
        .. code-block:: bash
        
            ceph service dump
        
        module=service perm=r flags=mgr
        """
        prefix = 'service dump'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def service_status(self):
        """
        dump service state
        
        Example command:
        
        .. code-block:: bash
        
            ceph service status
        
        module=service perm=r flags=mgr
        """
        prefix = 'service status'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def smart(self, devid: Optional[str]=None):
        """
        Query health metrics for underlying device
        
        Example command:
        
        .. code-block:: bash
        
            ceph smart --devid=string
        
        module=mon perm=rw flags=hidden
        
        :param devid:
        """
        prefix = 'smart'
        _args = {'prefix': prefix, 'devid': devid}
        return self._mon_command(_args)
    
    def ssh_clear_ssh_config(self):
        """
        Clear the ssh_config file
        
        Example command:
        
        .. code-block:: bash
        
            ceph ssh clear-ssh-config
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'ssh clear-ssh-config'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def ssh_set_ssh_config(self):
        """
        Set the ssh_config file (use -i <ssh_config>)
        
        Example command:
        
        .. code-block:: bash
        
            ceph ssh set-ssh-config
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'ssh set-ssh-config'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def status(self):
        """
        show cluster status
        
        Example command:
        
        .. code-block:: bash
        
            ceph status
        
        module=mon perm=r flags=
        """
        prefix = 'status'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    @deprecated
    def sync_force(self, yes_i_really_mean_it: Optional[bool]=None,
                   i_know_what_i_am_doing: Optional[bool]=None):
        """
        force sync of and clear monitor store
        
        Example command:
        
        .. code-block:: bash
        
            ceph sync force --yes_i_really_mean_it=true --i_know_what_i_am_doing=true
        
        module=mon perm=rw flags=deprecated, no_forward
        
        :param yes_i_really_mean_it: CephBool
        :param i_know_what_i_am_doing: CephBool
        """
        prefix = 'sync force'
        _args = {'prefix': prefix, 'yes_i_really_mean_it': yes_i_really_mean_it,
                 'i_know_what_i_am_doing': i_know_what_i_am_doing}
        return self._mon_command(_args)
    
    def telegraf_config_set(self, key: str, value: str):
        """
        Set a configuration value
        
        Example command:
        
        .. code-block:: bash
        
            ceph telegraf config-set --key=string --value=string
        
        module=mgr perm=rw flags=mgr
        
        :param key:
        :param value:
        """
        prefix = 'telegraf config-set'
        _args = {'prefix': prefix, 'key': key, 'value': value}
        return self._mon_command(_args)
    
    def telegraf_config_show(self):
        """
        Show current configuration
        
        Example command:
        
        .. code-block:: bash
        
            ceph telegraf config-show
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'telegraf config-show'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def telegraf_send(self):
        """
        Force sending data to Telegraf
        
        Example command:
        
        .. code-block:: bash
        
            ceph telegraf send
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'telegraf send'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def telemetry_off(self):
        """
        Disable telemetry reports from this cluster
        
        Example command:
        
        .. code-block:: bash
        
            ceph telemetry off
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'telemetry off'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def telemetry_on(self, license: Optional[str]=None):
        """
        Enable telemetry reports from this cluster
        
        Example command:
        
        .. code-block:: bash
        
            ceph telemetry on --license=string
        
        module=mgr perm=rw flags=mgr
        
        :param license:
        """
        prefix = 'telemetry on'
        _args = {'prefix': prefix, 'license': license}
        return self._mon_command(_args)
    
    def telemetry_send(self):
        """
        Force sending data to Ceph telemetry
        
        Example command:
        
        .. code-block:: bash
        
            ceph telemetry send
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'telemetry send'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def telemetry_show(self, channels: List[str]):
        """
        Show last report or report to be sent
        
        Example command:
        
        .. code-block:: bash
        
            ceph telemetry show --channels=string
        
        module=mgr perm=r flags=mgr
        
        :param channels:
        """
        prefix = 'telemetry show'
        _args = {'prefix': prefix, 'channels': channels}
        return self._mon_command(_args)
    
    def telemetry_status(self):
        """
        Show current configuration
        
        Example command:
        
        .. code-block:: bash
        
            ceph telemetry status
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'telemetry status'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def tell(self, target: str, args: List[str]):
        """
        send a command to a specific daemon
        
        Example command:
        
        .. code-block:: bash
        
            ceph tell --target=name --args=string
        
        module=mon perm=rw flags=
        
        :param target: CephName
        :param args:
        """
        prefix = 'tell'
        _args = {'prefix': prefix, 'target': target, 'args': args}
        return self._mon_command(_args)
    
    def test_orchestrator_load_data(self):
        """
        load dummy data into test orchestrator
        
        Example command:
        
        .. code-block:: bash
        
            ceph test_orchestrator load_data
        
        module=mgr perm=w flags=mgr
        """
        prefix = 'test_orchestrator load_data'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def time_sync_status(self):
        """
        show time sync status
        
        Example command:
        
        .. code-block:: bash
        
            ceph time-sync-status
        
        module=mon perm=r flags=
        """
        prefix = 'time-sync-status'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def version(self):
        """
        show mon daemon version
        
        Example command:
        
        .. code-block:: bash
        
            ceph version
        
        module=mon perm=r flags=no_forward
        """
        prefix = 'version'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def versions(self):
        """
        check running versions of ceph daemons
        
        Example command:
        
        .. code-block:: bash
        
            ceph versions
        
        module=mon perm=r flags=
        """
        prefix = 'versions'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def zabbix_config_set(self, key: str, value: str):
        """
        Set a configuration value
        
        Example command:
        
        .. code-block:: bash
        
            ceph zabbix config-set --key=string --value=string
        
        module=mgr perm=rw flags=mgr
        
        :param key:
        :param value:
        """
        prefix = 'zabbix config-set'
        _args = {'prefix': prefix, 'key': key, 'value': value}
        return self._mon_command(_args)
    
    def zabbix_config_show(self):
        """
        Show current configuration
        
        Example command:
        
        .. code-block:: bash
        
            ceph zabbix config-show
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'zabbix config-show'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def zabbix_discovery(self):
        """
        Discovering Zabbix data
        
        Example command:
        
        .. code-block:: bash
        
            ceph zabbix discovery
        
        module=mgr perm=r flags=mgr
        """
        prefix = 'zabbix discovery'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
    
    def zabbix_send(self):
        """
        Force sending data to Zabbix
        
        Example command:
        
        .. code-block:: bash
        
            ceph zabbix send
        
        module=mgr perm=rw flags=mgr
        """
        prefix = 'zabbix send'
        _args = {'prefix': prefix, }
        return self._mon_command(_args)
