# coding: utf-8

"""
    PurplShip Multi-carrier API

    PurplShip is a Multi-carrier Shipping API that simplifies the integration of logistic carrier services  # noqa: E501

    OpenAPI spec version: v1
    Contact: hello@purplship.com
    Generated by: https://github.com/purplship-api/purplship-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Charge(object):
    """NOTE: This class is auto generated by the purplship code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      purplship_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    purplship_types = {
        'name': 'str',
        'amount': 'float',
        'currency': 'str'
    }

    attribute_map = {
        'name': 'name',
        'amount': 'amount',
        'currency': 'currency'
    }

    def __init__(self, name=None, amount=None, currency=None):  # noqa: E501
        """Charge - a model defined in PurplShip"""  # noqa: E501

        self._name = None
        self._amount = None
        self._currency = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if amount is not None:
            self.amount = amount
        if currency is not None:
            self.currency = currency

    @property
    def name(self):
        """Gets the name of this Charge.  # noqa: E501

        The charge description  # noqa: E501

        :return: The name of this Charge.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Charge.

        The charge description  # noqa: E501

        :param name: The name of this Charge.  # noqa: E501
        :type: str
        """
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def amount(self):
        """Gets the amount of this Charge.  # noqa: E501

        The charge monetary value  # noqa: E501

        :return: The amount of this Charge.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this Charge.

        The charge monetary value  # noqa: E501

        :param amount: The amount of this Charge.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def currency(self):
        """Gets the currency of this Charge.  # noqa: E501

        The charge amount currency  # noqa: E501

        :return: The currency of this Charge.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this Charge.

        The charge amount currency  # noqa: E501

        :param currency: The currency of this Charge.  # noqa: E501
        :type: str
        """
        if currency is not None and len(currency) < 1:
            raise ValueError("Invalid value for `currency`, length must be greater than or equal to `1`")  # noqa: E501

        self._currency = currency

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.purplship_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Charge, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Charge):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
