# coding: utf-8

"""
    PurplShip Multi-carrier API

    PurplShip is a Multi-carrier Shipping API that simplifies the integration of logistic carrier services  # noqa: E501

    OpenAPI spec version: v1
    Contact: hello@purplship.com
    Generated by: https://github.com/purplship-api/purplship-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Payment(object):
    """NOTE: This class is auto generated by the purplship code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      purplship_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    purplship_types = {
        'paid_by': 'str',
        'amount': 'float',
        'currency': 'str',
        'account_number': 'str',
        'credit_card': 'Card',
        'contact': 'Address'
    }

    attribute_map = {
        'paid_by': 'paidBy',
        'amount': 'amount',
        'currency': 'currency',
        'account_number': 'accountNumber',
        'credit_card': 'creditCard',
        'contact': 'contact'
    }

    def __init__(self, paid_by=None, amount=None, currency=None, account_number=None, credit_card=None, contact=None):  # noqa: E501
        """Payment - a model defined in PurplShip"""  # noqa: E501

        self._paid_by = None
        self._amount = None
        self._currency = None
        self._account_number = None
        self._credit_card = None
        self._contact = None
        self.discriminator = None

        self.paid_by = paid_by
        if amount is not None:
            self.amount = amount
        self.currency = currency
        if account_number is not None:
            self.account_number = account_number
        if credit_card is not None:
            self.credit_card = credit_card
        if contact is not None:
            self.contact = contact

    @property
    def paid_by(self):
        """Gets the paid_by of this Payment.  # noqa: E501

        The payment payer  # noqa: E501

        :return: The paid_by of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._paid_by

    @paid_by.setter
    def paid_by(self, paid_by):
        """Sets the paid_by of this Payment.

        The payment payer  # noqa: E501

        :param paid_by: The paid_by of this Payment.  # noqa: E501
        :type: str
        """
        if paid_by is None:
            raise ValueError("Invalid value for `paid_by`, must not be `None`")  # noqa: E501
        allowed_values = ["sender", "recipient", "third_party", "credit_card"]  # noqa: E501
        if paid_by not in allowed_values:
            raise ValueError(
                "Invalid value for `paid_by` ({0}), must be one of {1}"  # noqa: E501
                .format(paid_by, allowed_values)
            )

        self._paid_by = paid_by

    @property
    def amount(self):
        """Gets the amount of this Payment.  # noqa: E501

        The payment amount if known  # noqa: E501

        :return: The amount of this Payment.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this Payment.

        The payment amount if known  # noqa: E501

        :param amount: The amount of this Payment.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def currency(self):
        """Gets the currency of this Payment.  # noqa: E501

        The payment amount currency  # noqa: E501

        :return: The currency of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this Payment.

        The payment amount currency  # noqa: E501

        :param currency: The currency of this Payment.  # noqa: E501
        :type: str
        """
        if currency is None:
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501
        allowed_values = ["EUR", "AED", "USD", "XCD", "AMD", "ANG", "AOA", "ARS", "AUD", "AWG", "AZN", "BAM", "BBD", "BDT", "XOF", "BGN", "BHD", "BIF", "BMD", "BND", "BOB", "BRL", "BSD", "BTN", "BWP", "BYN", "BZD", "CAD", "CDF", "XAF", "CHF", "NZD", "CLP", "CNY", "COP", "CRC", "CUC", "CVE", "CZK", "DJF", "DKK", "DOP", "DZD", "EGP", "ERN", "ETB", "FJD", "GBP", "GEL", "GHS", "GMD", "GNF", "GTQ", "GYD", "HKD", "HNL", "HRK", "HTG", "HUF", "IDR", "ILS", "INR", "IRR", "ISK", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRW", "KWD", "KYD", "KZT", "LAK", "LKR", "LRD", "LSL", "LYD", "MAD", "MDL", "MGA", "MKD", "MMK", "MNT", "MOP", "MRO", "MUR", "MVR", "MWK", "MXN", "MYR", "MZN", "NAD", "XPF", "NGN", "NIO", "NOK", "NPR", "OMR", "PEN", "PGK", "PHP", "PKR", "PLN", "PYG", "QAR", "RSD", "RUB", "RWF", "SAR", "SBD", "SCR", "SDG", "SEK", "SGD", "SHP", "SLL", "SOS", "SRD", "SSP", "STD", "SYP", "SZL", "THB", "TJS", "TND", "TOP", "TRY", "TTD", "TWD", "TZS", "UAH", "UYU", "UZS", "VEF", "VND", "VUV", "WST", "YER", "ZAR"]  # noqa: E501
        if currency not in allowed_values:
            raise ValueError(
                "Invalid value for `currency` ({0}), must be one of {1}"  # noqa: E501
                .format(currency, allowed_values)
            )

        self._currency = currency

    @property
    def account_number(self):
        """Gets the account_number of this Payment.  # noqa: E501

        The selected rate carrier payer account number  # noqa: E501

        :return: The account_number of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._account_number

    @account_number.setter
    def account_number(self, account_number):
        """Sets the account_number of this Payment.

        The selected rate carrier payer account number  # noqa: E501

        :param account_number: The account_number of this Payment.  # noqa: E501
        :type: str
        """
        if account_number is not None and len(account_number) < 1:
            raise ValueError("Invalid value for `account_number`, length must be greater than or equal to `1`")  # noqa: E501

        self._account_number = account_number

    @property
    def credit_card(self):
        """Gets the credit_card of this Payment.  # noqa: E501


        :return: The credit_card of this Payment.  # noqa: E501
        :rtype: Card
        """
        return self._credit_card

    @credit_card.setter
    def credit_card(self, credit_card):
        """Sets the credit_card of this Payment.


        :param credit_card: The credit_card of this Payment.  # noqa: E501
        :type: Card
        """

        self._credit_card = credit_card

    @property
    def contact(self):
        """Gets the contact of this Payment.  # noqa: E501


        :return: The contact of this Payment.  # noqa: E501
        :rtype: Address
        """
        return self._contact

    @contact.setter
    def contact(self, contact):
        """Sets the contact of this Payment.


        :param contact: The contact of this Payment.  # noqa: E501
        :type: Address
        """

        self._contact = contact

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.purplship_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Payment, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Payment):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
