# coding: utf-8

"""
    PurplShip Multi-carrier API

    PurplShip is a Multi-carrier Shipping API that simplifies the integration of logistic carrier services  # noqa: E501

    OpenAPI spec version: v1
    Contact: hello@purplship.com
    Generated by: https://github.com/purplship-api/purplship-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ShipmentRequest(object):
    """NOTE: This class is auto generated by the purplship code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      purplship_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    purplship_types = {
        'selected_rate_id': 'str',
        'rates': 'list[Rate]',
        'shipper': 'Address',
        'recipient': 'Address',
        'parcel': 'Parcel',
        'services': 'list[str]',
        'options': 'dict(str, str)',
        'payment': 'Payment',
        'customs': 'Customs',
        'doc_images': 'list[Doc]',
        'reference': 'str'
    }

    attribute_map = {
        'selected_rate_id': 'selectedRateId',
        'rates': 'rates',
        'shipper': 'shipper',
        'recipient': 'recipient',
        'parcel': 'parcel',
        'services': 'services',
        'options': 'options',
        'payment': 'payment',
        'customs': 'customs',
        'doc_images': 'docImages',
        'reference': 'reference'
    }

    def __init__(self, selected_rate_id=None, rates=None, shipper=None, recipient=None, parcel=None, services=None, options=None, payment=None, customs=None, doc_images=None, reference=None):  # noqa: E501
        """ShipmentRequest - a model defined in PurplShip"""  # noqa: E501

        self._selected_rate_id = None
        self._rates = None
        self._shipper = None
        self._recipient = None
        self._parcel = None
        self._services = None
        self._options = None
        self._payment = None
        self._customs = None
        self._doc_images = None
        self._reference = None
        self.discriminator = None

        self.selected_rate_id = selected_rate_id
        self.rates = rates
        self.shipper = shipper
        self.recipient = recipient
        self.parcel = parcel
        if services is not None:
            self.services = services
        if options is not None:
            self.options = options
        self.payment = payment
        if customs is not None:
            self.customs = customs
        if doc_images is not None:
            self.doc_images = doc_images
        if reference is not None:
            self.reference = reference

    @property
    def selected_rate_id(self):
        """Gets the selected_rate_id of this ShipmentRequest.  # noqa: E501

        The selected shipment rate unique identifier  # noqa: E501

        :return: The selected_rate_id of this ShipmentRequest.  # noqa: E501
        :rtype: str
        """
        return self._selected_rate_id

    @selected_rate_id.setter
    def selected_rate_id(self, selected_rate_id):
        """Sets the selected_rate_id of this ShipmentRequest.

        The selected shipment rate unique identifier  # noqa: E501

        :param selected_rate_id: The selected_rate_id of this ShipmentRequest.  # noqa: E501
        :type: str
        """
        if selected_rate_id is None:
            raise ValueError("Invalid value for `selected_rate_id`, must not be `None`")  # noqa: E501

        self._selected_rate_id = selected_rate_id

    @property
    def rates(self):
        """Gets the rates of this ShipmentRequest.  # noqa: E501

        The list for shipment rates fetched previously  # noqa: E501

        :return: The rates of this ShipmentRequest.  # noqa: E501
        :rtype: list[Rate]
        """
        return self._rates

    @rates.setter
    def rates(self, rates):
        """Sets the rates of this ShipmentRequest.

        The list for shipment rates fetched previously  # noqa: E501

        :param rates: The rates of this ShipmentRequest.  # noqa: E501
        :type: list[Rate]
        """
        if rates is None:
            raise ValueError("Invalid value for `rates`, must not be `None`")  # noqa: E501

        self._rates = rates

    @property
    def shipper(self):
        """Gets the shipper of this ShipmentRequest.  # noqa: E501


        :return: The shipper of this ShipmentRequest.  # noqa: E501
        :rtype: Address
        """
        return self._shipper

    @shipper.setter
    def shipper(self, shipper):
        """Sets the shipper of this ShipmentRequest.


        :param shipper: The shipper of this ShipmentRequest.  # noqa: E501
        :type: Address
        """
        if shipper is None:
            raise ValueError("Invalid value for `shipper`, must not be `None`")  # noqa: E501

        self._shipper = shipper

    @property
    def recipient(self):
        """Gets the recipient of this ShipmentRequest.  # noqa: E501


        :return: The recipient of this ShipmentRequest.  # noqa: E501
        :rtype: Address
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient):
        """Sets the recipient of this ShipmentRequest.


        :param recipient: The recipient of this ShipmentRequest.  # noqa: E501
        :type: Address
        """
        if recipient is None:
            raise ValueError("Invalid value for `recipient`, must not be `None`")  # noqa: E501

        self._recipient = recipient

    @property
    def parcel(self):
        """Gets the parcel of this ShipmentRequest.  # noqa: E501


        :return: The parcel of this ShipmentRequest.  # noqa: E501
        :rtype: Parcel
        """
        return self._parcel

    @parcel.setter
    def parcel(self, parcel):
        """Sets the parcel of this ShipmentRequest.


        :param parcel: The parcel of this ShipmentRequest.  # noqa: E501
        :type: Parcel
        """
        if parcel is None:
            raise ValueError("Invalid value for `parcel`, must not be `None`")  # noqa: E501

        self._parcel = parcel

    @property
    def services(self):
        """Gets the services of this ShipmentRequest.  # noqa: E501

         The requested carrier service for the shipment.  Please consult the reference for specific carriers services.<br/> Note that this is a list because on a Multi-carrier rate request you could specify a service per carrier.   # noqa: E501

        :return: The services of this ShipmentRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._services

    @services.setter
    def services(self, services):
        """Sets the services of this ShipmentRequest.

         The requested carrier service for the shipment.  Please consult the reference for specific carriers services.<br/> Note that this is a list because on a Multi-carrier rate request you could specify a service per carrier.   # noqa: E501

        :param services: The services of this ShipmentRequest.  # noqa: E501
        :type: list[str]
        """

        self._services = services

    @property
    def options(self):
        """Gets the options of this ShipmentRequest.  # noqa: E501

         The options available for the shipment.<br/> Please consult the reference for additional specific carriers options.   # noqa: E501

        :return: The options of this ShipmentRequest.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this ShipmentRequest.

         The options available for the shipment.<br/> Please consult the reference for additional specific carriers options.   # noqa: E501

        :param options: The options of this ShipmentRequest.  # noqa: E501
        :type: dict(str, str)
        """

        self._options = options

    @property
    def payment(self):
        """Gets the payment of this ShipmentRequest.  # noqa: E501


        :return: The payment of this ShipmentRequest.  # noqa: E501
        :rtype: Payment
        """
        return self._payment

    @payment.setter
    def payment(self, payment):
        """Sets the payment of this ShipmentRequest.


        :param payment: The payment of this ShipmentRequest.  # noqa: E501
        :type: Payment
        """
        if payment is None:
            raise ValueError("Invalid value for `payment`, must not be `None`")  # noqa: E501

        self._payment = payment

    @property
    def customs(self):
        """Gets the customs of this ShipmentRequest.  # noqa: E501


        :return: The customs of this ShipmentRequest.  # noqa: E501
        :rtype: Customs
        """
        return self._customs

    @customs.setter
    def customs(self, customs):
        """Sets the customs of this ShipmentRequest.


        :param customs: The customs of this ShipmentRequest.  # noqa: E501
        :type: Customs
        """

        self._customs = customs

    @property
    def doc_images(self):
        """Gets the doc_images of this ShipmentRequest.  # noqa: E501

         The list of documents to attach for a paperless interantional trade.  eg: Invoices...   # noqa: E501

        :return: The doc_images of this ShipmentRequest.  # noqa: E501
        :rtype: list[Doc]
        """
        return self._doc_images

    @doc_images.setter
    def doc_images(self, doc_images):
        """Sets the doc_images of this ShipmentRequest.

         The list of documents to attach for a paperless interantional trade.  eg: Invoices...   # noqa: E501

        :param doc_images: The doc_images of this ShipmentRequest.  # noqa: E501
        :type: list[Doc]
        """

        self._doc_images = doc_images

    @property
    def reference(self):
        """Gets the reference of this ShipmentRequest.  # noqa: E501

        The shipment reference  # noqa: E501

        :return: The reference of this ShipmentRequest.  # noqa: E501
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """Sets the reference of this ShipmentRequest.

        The shipment reference  # noqa: E501

        :param reference: The reference of this ShipmentRequest.  # noqa: E501
        :type: str
        """
        if reference is not None and len(reference) < 1:
            raise ValueError("Invalid value for `reference`, length must be greater than or equal to `1`")  # noqa: E501

        self._reference = reference

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.purplship_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ShipmentRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ShipmentRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
