# coding: utf-8

"""
    PurplShip Multi-carrier API

    PurplShip is a Multi-carrier Shipping API that simplifies the integration of logistic carrier services  # noqa: E501

    OpenAPI spec version: v1
    Contact: hello@purplship.com
    Generated by: https://github.com/purplship-api/purplship-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class TrackingDetails(object):
    """NOTE: This class is auto generated by the purplship code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      purplship_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    purplship_types = {
        'carrier_name': 'str',
        'carrier_id': 'str',
        'tracking_number': 'str',
        'events': 'list[TrackingEvent]'
    }

    attribute_map = {
        'carrier_name': 'carrierName',
        'carrier_id': 'carrierId',
        'tracking_number': 'trackingNumber',
        'events': 'events'
    }

    def __init__(self, carrier_name=None, carrier_id=None, tracking_number=None, events=None):  # noqa: E501
        """TrackingDetails - a model defined in PurplShip"""  # noqa: E501

        self._carrier_name = None
        self._carrier_id = None
        self._tracking_number = None
        self._events = None
        self.discriminator = None

        self.carrier_name = carrier_name
        self.carrier_id = carrier_id
        self.tracking_number = tracking_number
        self.events = events

    @property
    def carrier_name(self):
        """Gets the carrier_name of this TrackingDetails.  # noqa: E501

        The tracking carrier  # noqa: E501

        :return: The carrier_name of this TrackingDetails.  # noqa: E501
        :rtype: str
        """
        return self._carrier_name

    @carrier_name.setter
    def carrier_name(self, carrier_name):
        """Sets the carrier_name of this TrackingDetails.

        The tracking carrier  # noqa: E501

        :param carrier_name: The carrier_name of this TrackingDetails.  # noqa: E501
        :type: str
        """
        if carrier_name is None:
            raise ValueError("Invalid value for `carrier_name`, must not be `None`")  # noqa: E501
        if carrier_name is not None and len(carrier_name) < 1:
            raise ValueError("Invalid value for `carrier_name`, length must be greater than or equal to `1`")  # noqa: E501

        self._carrier_name = carrier_name

    @property
    def carrier_id(self):
        """Gets the carrier_id of this TrackingDetails.  # noqa: E501

        The tracking carrier configured identifier  # noqa: E501

        :return: The carrier_id of this TrackingDetails.  # noqa: E501
        :rtype: str
        """
        return self._carrier_id

    @carrier_id.setter
    def carrier_id(self, carrier_id):
        """Sets the carrier_id of this TrackingDetails.

        The tracking carrier configured identifier  # noqa: E501

        :param carrier_id: The carrier_id of this TrackingDetails.  # noqa: E501
        :type: str
        """
        if carrier_id is None:
            raise ValueError("Invalid value for `carrier_id`, must not be `None`")  # noqa: E501
        if carrier_id is not None and len(carrier_id) < 1:
            raise ValueError("Invalid value for `carrier_id`, length must be greater than or equal to `1`")  # noqa: E501

        self._carrier_id = carrier_id

    @property
    def tracking_number(self):
        """Gets the tracking_number of this TrackingDetails.  # noqa: E501

        The shipment tracking number  # noqa: E501

        :return: The tracking_number of this TrackingDetails.  # noqa: E501
        :rtype: str
        """
        return self._tracking_number

    @tracking_number.setter
    def tracking_number(self, tracking_number):
        """Sets the tracking_number of this TrackingDetails.

        The shipment tracking number  # noqa: E501

        :param tracking_number: The tracking_number of this TrackingDetails.  # noqa: E501
        :type: str
        """
        if tracking_number is None:
            raise ValueError("Invalid value for `tracking_number`, must not be `None`")  # noqa: E501
        if tracking_number is not None and len(tracking_number) < 1:
            raise ValueError("Invalid value for `tracking_number`, length must be greater than or equal to `1`")  # noqa: E501

        self._tracking_number = tracking_number

    @property
    def events(self):
        """Gets the events of this TrackingDetails.  # noqa: E501

        The tracking details events  # noqa: E501

        :return: The events of this TrackingDetails.  # noqa: E501
        :rtype: list[TrackingEvent]
        """
        return self._events

    @events.setter
    def events(self, events):
        """Sets the events of this TrackingDetails.

        The tracking details events  # noqa: E501

        :param events: The events of this TrackingDetails.  # noqa: E501
        :type: list[TrackingEvent]
        """
        if events is None:
            raise ValueError("Invalid value for `events`, must not be `None`")  # noqa: E501

        self._events = events

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.purplship_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TrackingDetails, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TrackingDetails):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
