from simple_rest_client.api import API
from onlyuserclient.settings import api_settings

DEFAULT_API_TIMEOUT = 30 

class BaseAPI(API):
    """
    Base api
    """
    def __init__(self, **kwargs):   
        url = kwargs.pop('api_root_url',api_settings.API_ROOT_URL)
        pfx = kwargs.pop('pfx', None)
        if pfx:
            url = '%s%s'%(url, pfx)
        headers = kwargs.pop('headers',api_settings.API_HEADERS)
        headers.update({'Content-Type': 'application/json'})
        timeout = kwargs.pop('timeout',api_settings.API_TIMEOUT) or DEFAULT_API_TIMEOUT
        json_encode_body = kwargs.pop('json_encode_body ', True)
        append_slash = kwargs.pop('append_slash ', True)
        apikey_header = kwargs.pop('apikey_header', 'apikey')
        apikey = kwargs.pop('apikey', None)
        if apikey:
            headers[apikey_header] = apikey
            
        super().__init__(
            api_root_url=url,
            headers = headers,
            timeout = timeout,
            json_encode_body = json_encode_body,
            append_slash=append_slash,
            **kwargs
        )
