"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Simple function to evaluate CloudFormation intrinsics.
 *
 * Note that this function is not production quality, it exists to support tests.
 */
const cloudformation_lang_1 = require("../lib/private/cloudformation-lang");
function evaluateCFN(object, context = {}) {
    const intrinsics = {
        'Fn::Join'(separator, args) {
            return args.map(evaluate).join(separator);
        },
        'Ref'(logicalId) {
            if (!(logicalId in context)) {
                throw new Error(`Trying to evaluate Ref of '${logicalId}' but not in context!`);
            }
            return context[logicalId];
        },
        'Fn::GetAtt'(logicalId, attributeName) {
            const key = `${logicalId}.${attributeName}`;
            if (!(key in context)) {
                throw new Error(`Trying to evaluate Fn::GetAtt of '${logicalId}.${attributeName}' but not in context!`);
            }
            return context[key];
        },
    };
    return evaluate(object);
    function evaluate(obj) {
        if (Array.isArray(obj)) {
            return obj.map(evaluate);
        }
        if (typeof obj === 'object') {
            const keys = Object.keys(obj);
            if (keys.length === 1 && (cloudformation_lang_1.isNameOfCloudFormationIntrinsic(keys[0]) || keys[0] === 'Ref')) {
                return evaluateIntrinsic(keys[0], obj[keys[0]]);
            }
            const ret = {};
            for (const key of keys) {
                ret[key] = evaluateCFN(obj[key]);
            }
            return ret;
        }
        return obj;
    }
    function evaluateIntrinsic(name, args) {
        if (!(name in intrinsics)) {
            throw new Error(`Intrinsic ${name} not supported here`);
        }
        if (!Array.isArray(args)) {
            args = [args];
        }
        return intrinsics[name].apply(intrinsics, args);
    }
}
exports.evaluateCFN = evaluateCFN;
//# sourceMappingURL=data:application/json;base64,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