"""Add Comment.updated_by

Revision ID: 06552e22f9e7
Revises: fba149993140
Create Date: 2025-02-27 13:44:58.067787

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "06552e22f9e7"
down_revision = "fba149993140"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("comment", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "updated_by",
                sqlalchemy_utils.types.uuid.UUIDType(binary=False),
                default=uuid.uuid4,
                nullable=True,
            )
        )
        batch_op.create_index(
            batch_op.f("ix_comment_updated_by"), ["updated_by"], unique=False
        )
        batch_op.create_foreign_key(
            "comment_updated_by_fkey", "person", ["updated_by"], ["id"]
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("comment", schema=None) as batch_op:
        batch_op.drop_constraint("comment_updated_by_fkey", type_="foreignkey")
        batch_op.drop_index(batch_op.f("ix_comment_updated_by"))
        batch_op.drop_column("updated_by")

    # ### end Alembic commands ###
