"""add entity chat models

Revision ID: 23122f290ca2
Revises: 9b85c14fa8a7
Create Date: 2024-03-08 01:33:18.212645

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "23122f290ca2"
down_revision = "9b85c14fa8a7"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "chat",
        sa.Column(
            "object_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("object_type", sa.String(length=80), nullable=False),
        sa.Column("last_message", sa.DateTime(), nullable=True),
        sa.Column(
            "person_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column(
            "id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["person_id"],
            ["person.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("chat", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_chat_object_id"), ["object_id"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_chat_object_type"), ["object_type"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_chat_person_id"), ["person_id"], unique=False
        )

    op.create_table(
        "chat_message",
        sa.Column(
            "chat_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column(
            "person_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column(
            "id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("text", sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(
            ["chat_id"],
            ["chat.id"],
        ),
        sa.ForeignKeyConstraint(
            ["person_id"],
            ["person.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("chat_message", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_chat_message_chat_id"), ["chat_id"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_chat_message_person_id"),
            ["person_id"],
            unique=False,
        )

    op.create_table(
        "chat_participant",
        sa.Column(
            "chat_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column(
            "person_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["chat_id"],
            ["chat.id"],
        ),
        sa.ForeignKeyConstraint(
            ["person_id"],
            ["person.id"],
        ),
        sa.PrimaryKeyConstraint("chat_id", "person_id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("chat_participant")
    with op.batch_alter_table("chat_message", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_chat_message_person_id"))
        batch_op.drop_index(batch_op.f("ix_chat_message_chat_id"))

    op.drop_table("chat_message")
    with op.batch_alter_table("chat", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_chat_person_id"))
        batch_op.drop_index(batch_op.f("ix_chat_object_type"))
        batch_op.drop_index(batch_op.f("ix_chat_object_id"))

    op.drop_table("chat")
    # ### end Alembic commands ###
