"""Add missing index

Revision ID: fba149993140
Revises: 20a8ad264659
Create Date: 2025-02-19 02:19:27.407568

"""

from alembic import op


# revision identifiers, used by Alembic.
revision = "fba149993140"
down_revision = "20a8ad264659"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("comment_preview_link", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_comment_preview_link_comment"),
            ["comment"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_comment_preview_link_preview_file"),
            ["preview_file"],
            unique=False,
        )

    with op.batch_alter_table("project_person_link", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_project_person_link_person_id"),
            ["person_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_project_person_link_project_id"),
            ["project_id"],
            unique=False,
        )

    with op.batch_alter_table(
        "project_status_automation_link", schema=None
    ) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_project_status_automation_link_project_id"),
            ["project_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f(
                "ix_project_status_automation_link_status_automation_id"
            ),
            ["status_automation_id"],
            unique=False,
        )

    with op.batch_alter_table(
        "project_task_status_link", schema=None
    ) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_project_task_status_link_project_id"),
            ["project_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_project_task_status_link_task_status_id"),
            ["task_status_id"],
            unique=False,
        )

    with op.batch_alter_table(
        "project_task_type_link", schema=None
    ) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_project_task_type_link_project_id"),
            ["project_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_project_task_type_link_task_type_id"),
            ["task_type_id"],
            unique=False,
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "project_task_type_link", schema=None
    ) as batch_op:
        batch_op.drop_index(
            batch_op.f("ix_project_task_type_link_task_type_id")
        )
        batch_op.drop_index(batch_op.f("ix_project_task_type_link_project_id"))

    with op.batch_alter_table(
        "project_task_status_link", schema=None
    ) as batch_op:
        batch_op.drop_index(
            batch_op.f("ix_project_task_status_link_task_status_id")
        )
        batch_op.drop_index(
            batch_op.f("ix_project_task_status_link_project_id")
        )

    with op.batch_alter_table(
        "project_status_automation_link", schema=None
    ) as batch_op:
        batch_op.drop_index(
            batch_op.f(
                "ix_project_status_automation_link_status_automation_id"
            )
        )
        batch_op.drop_index(
            batch_op.f("ix_project_status_automation_link_project_id")
        )

    with op.batch_alter_table("project_person_link", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_project_person_link_project_id"))
        batch_op.drop_index(batch_op.f("ix_project_person_link_person_id"))

    with op.batch_alter_table("comment_preview_link", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_comment_preview_link_preview_file"))
        batch_op.drop_index(batch_op.f("ix_comment_preview_link_comment"))

    # ### end Alembic commands ###
