"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils");
/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom Lambda Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class LambdaDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom lambda deployment configurations
    }
    /**
     * Import a custom Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param props the properties of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static import(_scope, _id, props) {
        return deploymentConfig(props.deploymentConfigName);
    }
}
LambdaDeploymentConfig.AllAtOnce = deploymentConfig('CodeDeployDefault.LambdaAllAtOnce');
LambdaDeploymentConfig.Canary10Percent30Minutes = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent30Minutes');
LambdaDeploymentConfig.Canary10Percent5Minutes = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent5Minutes');
LambdaDeploymentConfig.Canary10Percent10Minutes = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent10Minutes');
LambdaDeploymentConfig.Canary10Percent15Minutes = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent15Minutes');
LambdaDeploymentConfig.Linear10PercentEvery10Minutes = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery10Minutes');
LambdaDeploymentConfig.Linear10PercentEvery1Minute = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery1Minute');
LambdaDeploymentConfig.Linear10PercentEvery2Minutes = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery2Minutes');
LambdaDeploymentConfig.Linear10PercentEvery3Minutes = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery3Minutes');
exports.LambdaDeploymentConfig = LambdaDeploymentConfig;
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name)
    };
}
//# sourceMappingURL=data:application/json;base64,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