import cdk = require('@aws-cdk/cdk');
/**
 * The Deployment Configuration of an EC2/on-premise Deployment Group.
 * The default, pre-defined Configurations are available as constants on the {@link ServerDeploymentConfig} class
 * (`ServerDeploymentConfig.HalfAtATime`, `ServerDeploymentConfig.AllAtOnce`, etc.).
 * To create a custom Deployment Configuration,
 * instantiate the {@link ServerDeploymentConfig} Construct.
 */
export interface IServerDeploymentConfig {
    /**
     * @attribute
     */
    readonly deploymentConfigName: string;
    /**
     * @attribute
     */
    readonly deploymentConfigArn: string;
}
/**
 * Minimum number of healthy hosts for a server deployment.
 */
export declare class MinimumHealthyHosts {
    private readonly json;
    /**
     * The minimum healhty hosts threshold expressed as an absolute number.
     */
    static count(value: number): MinimumHealthyHosts;
    /**
     * The minmum healhty hosts threshold expressed as a percentage of the fleet.
     */
    static percentage(value: number): MinimumHealthyHosts;
    private constructor();
}
/**
 * Construction properties of {@link ServerDeploymentConfig}.
 */
export interface ServerDeploymentConfigProps {
    /**
     * The physical, human-readable name of the Deployment Configuration.
     *
     * @default a name will be auto-generated
     */
    readonly deploymentConfigName?: string;
    /**
     * Minimum number of healthy hosts.
     */
    readonly minimumHealthyHosts: MinimumHealthyHosts;
}
/**
 * A custom Deployment Configuration for an EC2/on-premise Deployment Group.
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
export declare class ServerDeploymentConfig extends cdk.Resource implements IServerDeploymentConfig {
    static readonly OneAtATime: IServerDeploymentConfig;
    static readonly HalfAtATime: IServerDeploymentConfig;
    static readonly AllAtOnce: IServerDeploymentConfig;
    /**
     * Import a custom Deployment Configuration for an EC2/on-premise Deployment Group defined either outside the CDK,
     * or in a different CDK Stack and exported using the {@link #export} method.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param serverDeploymentConfigName the properties of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static fromServerDeploymentConfigName(scope: cdk.Construct, id: string, serverDeploymentConfigName: string): IServerDeploymentConfig;
    readonly deploymentConfigName: string;
    readonly deploymentConfigArn: string;
    constructor(scope: cdk.Construct, id: string, props: ServerDeploymentConfigProps);
}
