"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
function arnForApplication(applicationName) {
    return `arn:${cdk_1.Aws.partition}:codedeploy:${cdk_1.Aws.region}:${cdk_1.Aws.accountId}:application:${applicationName}`;
}
exports.arnForApplication = arnForApplication;
function arnForDeploymentGroup(applicationName, deploymentGroupName) {
    return `arn:${cdk_1.Aws.partition}:codedeploy:${cdk_1.Aws.region}:${cdk_1.Aws.accountId}:deploymentgroup:${applicationName}/${deploymentGroupName}`;
}
exports.arnForDeploymentGroup = arnForDeploymentGroup;
function arnForDeploymentConfig(name) {
    return `arn:${cdk_1.Aws.partition}:codedeploy:${cdk_1.Aws.region}:${cdk_1.Aws.accountId}:deploymentconfig:${name}`;
}
exports.arnForDeploymentConfig = arnForDeploymentConfig;
function renderAlarmConfiguration(alarms, ignorePollAlarmFailure) {
    return alarms.length === 0
        ? undefined
        : {
            alarms: alarms.map(a => ({ name: a.alarmName })),
            enabled: true,
            ignorePollAlarmFailure,
        };
}
exports.renderAlarmConfiguration = renderAlarmConfiguration;
var AutoRollbackEvent;
(function (AutoRollbackEvent) {
    AutoRollbackEvent["DeploymentFailure"] = "DEPLOYMENT_FAILURE";
    AutoRollbackEvent["DeploymentStopOnAlarm"] = "DEPLOYMENT_STOP_ON_ALARM";
    AutoRollbackEvent["DeploymentStopOnRequest"] = "DEPLOYMENT_STOP_ON_REQUEST";
})(AutoRollbackEvent || (AutoRollbackEvent = {}));
function renderAutoRollbackConfiguration(alarms, autoRollbackConfig = {}) {
    const events = new Array();
    // we roll back failed deployments by default
    if (autoRollbackConfig.failedDeployment !== false) {
        events.push(AutoRollbackEvent.DeploymentFailure);
    }
    // we _do not_ roll back stopped deployments by default
    if (autoRollbackConfig.stoppedDeployment === true) {
        events.push(AutoRollbackEvent.DeploymentStopOnRequest);
    }
    // we _do not_ roll back alarm-triggering deployments by default
    // unless the Deployment Group has at least one alarm
    if (autoRollbackConfig.deploymentInAlarm !== false) {
        if (alarms.length > 0) {
            events.push(AutoRollbackEvent.DeploymentStopOnAlarm);
        }
        else if (autoRollbackConfig.deploymentInAlarm === true) {
            throw new Error("The auto-rollback setting 'deploymentInAlarm' does not have any effect unless you associate " +
                "at least one CloudWatch alarm with the Deployment Group");
        }
    }
    return events.length > 0
        ? {
            enabled: true,
            events,
        }
        : undefined;
}
exports.renderAutoRollbackConfiguration = renderAutoRollbackConfiguration;
//# sourceMappingURL=data:application/json;base64,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