"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/cdk");
const codedeploy = require("../../lib");
const path = require("path");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-codedeploy-lambda');
const handler = new lambda.Function(stack, `Handler`, {
    code: lambda.Code.asset(path.join(__dirname, 'handler')),
    handler: 'index.handler',
    runtime: lambda.Runtime.Nodejs810,
});
const version = handler.addVersion('1');
const blueGreenAlias = new lambda.Alias(stack, `Alias`, {
    aliasName: `alias`,
    version
});
const preHook = new lambda.Function(stack, `PreHook`, {
    code: lambda.Code.asset(path.join(__dirname, 'preHook')),
    handler: 'index.handler',
    runtime: lambda.Runtime.Nodejs810
});
const postHook = new lambda.Function(stack, `PostHook`, {
    code: lambda.Code.asset(path.join(__dirname, 'postHook')),
    handler: 'index.handler',
    runtime: lambda.Runtime.Nodejs810
});
new codedeploy.LambdaDeploymentGroup(stack, 'BlueGreenDeployment', {
    alias: blueGreenAlias,
    deploymentConfig: codedeploy.LambdaDeploymentConfig.Linear10PercentEvery1Minute,
    alarms: [
        new cloudwatch.Alarm(stack, 'BlueGreenErrors', {
            comparisonOperator: cloudwatch.ComparisonOperator.GreaterThanThreshold,
            threshold: 1,
            evaluationPeriods: 1,
            metric: blueGreenAlias.metricErrors()
        })
    ],
    preHook,
    postHook
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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