"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/cdk");
const codedeploy = require("../../lib");
module.exports = {
    "CodeDeploy Lambda Application": {
        "can be created"(test) {
            const stack = new cdk.Stack();
            new codedeploy.LambdaApplication(stack, 'MyApp');
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::Application', {
                ComputePlatform: 'Lambda'
            }));
            test.done();
        },
        "can be created with explicit name"(test) {
            const stack = new cdk.Stack();
            new codedeploy.LambdaApplication(stack, 'MyApp', {
                applicationName: 'my-name'
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::Application', {
                ApplicationName: 'my-name',
                ComputePlatform: 'Lambda'
            }));
            test.done();
        },
    }
};
//# sourceMappingURL=data:application/json;base64,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