"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const autoscaling = require("@aws-cdk/aws-autoscaling");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const ec2 = require("@aws-cdk/aws-ec2");
const lb = require("@aws-cdk/aws-elasticloadbalancing");
const cdk = require("@aws-cdk/cdk");
const codedeploy = require("../../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-codedeploy-server-dg');
const vpc = new ec2.Vpc(stack, 'VPC');
const asg = new autoscaling.AutoScalingGroup(stack, 'ASG', {
    instanceType: new ec2.InstanceTypePair(ec2.InstanceClass.M5, ec2.InstanceSize.Large),
    machineImage: new ec2.AmazonLinuxImage(),
    vpc,
});
const elb = new lb.LoadBalancer(stack, 'ELB', { vpc });
elb.addListener({
    externalPort: 80,
});
new codedeploy.ServerDeploymentGroup(stack, 'CodeDeployGroup', {
    deploymentConfig: codedeploy.ServerDeploymentConfig.AllAtOnce,
    autoScalingGroups: [asg],
    loadBalancer: codedeploy.LoadBalancer.classic(elb),
    alarms: [
        new cloudwatch.Alarm(stack, 'Alarm1', {
            metric: new cloudwatch.Metric({
                metricName: 'Errors',
                namespace: 'my.namespace',
            }),
            threshold: 1,
            evaluationPeriods: 1,
        }),
    ],
    autoRollback: {
        failedDeployment: false,
        deploymentInAlarm: false,
    },
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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