"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/cdk");
const codedeploy = require("../../lib");
module.exports = {
    'CodeDeploy DeploymentConfig': {
        "can be created by specifying only minHealthyHostCount"(test) {
            const stack = new cdk.Stack();
            new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {
                minimumHealthyHosts: codedeploy.MinimumHealthyHosts.count(1),
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::DeploymentConfig', {
                "MinimumHealthyHosts": {
                    "Type": "HOST_COUNT",
                    "Value": 1,
                },
            }));
            test.done();
        },
        "can be created by specifying only minHealthyHostPercentage"(test) {
            const stack = new cdk.Stack();
            new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {
                minimumHealthyHosts: codedeploy.MinimumHealthyHosts.percentage(75),
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::DeploymentConfig', {
                "MinimumHealthyHosts": {
                    "Type": "FLEET_PERCENT",
                    "Value": 75,
                },
            }));
            test.done();
        },
        'can be imported'(test) {
            const stack = new cdk.Stack();
            const deploymentConfig = codedeploy.ServerDeploymentConfig.fromServerDeploymentConfigName(stack, 'MyDC', 'MyDC');
            test.notEqual(deploymentConfig, undefined);
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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