const AWS = require('aws-sdk');
const util = require('util');


exports.handler = async (event) => {
    console.log(event)

    const task_name = process.env.ecs_task_arn.split('/')[1].split(':')[0]
    
    const ecs = new AWS.ECS();

    let messages = []
    
    // run an ECS Fargate task
    const params = {
        cluster: `${process.env.ecs_cluster}`,
        launchType: 'FARGATE',
        taskDefinition: `${process.env.ecs_task_arn}`,
        networkConfiguration: {
            awsvpcConfiguration: {
                subnets: [
                    `${process.env.subnet}`,
                ],
                assignPublicIp: "ENABLED",
                securityGroups: [
                    `${process.env.security_group}`,
                ],
            },
        }
    };
    if (typeof event === "string") {
        const body = JSON.parse(event.body)
        console.log(body)
        params["overrides"] = {
            containerOverrides: [{
                name: task_name,
                environment: [{
                    name: "TRIGGER_ID",
                    value: body.triggerId
               }]
            }]
        }
    }



    console.log("running task with taskDefinition:", params.taskDefinition);
    const taskStart = await ecs.runTask(params).promise();

    console.log("task response:");
    console.log(util.inspect(taskStart))
    
    if (!taskStart.tasks || !taskStart.tasks.length) {
        return {
            statusCode: 500,
            body: JSON.stringify(taskStart)
        }
    }

    const message = {
        task: taskStart.tasks[0].taskArn,
        status: "pending"
    };
    messages.push(message)

    return {
        statusCode: 200,
        body: JSON.stringify(messages)
    };
};
