from typing import Any, Generic, TypeVar

from ._describe import Type

_T = TypeVar('_T')

class ValidationError(Exception): ...
class InnerSchemaValidationError(ValidationError): ...

class Serializer(Generic[_T]):
    def __init__(self, py_class: Type, schema: str): ...
    def dump(self, value: _T) -> Any: ...
    def load(self, data: Any) -> _T: ...
    def load_json(self, data: str, validate: bool) -> _T: ...
