/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.Section;
import java.util.ArrayList;
import java.util.Objects;

public class CodeSection
extends Section {
    private final ArrayList<FunctionBody> functionBodies;
    private boolean requiresDataCount = false;

    public CodeSection() {
        this(new ArrayList<FunctionBody>());
    }

    public CodeSection(int estimatedSize) {
        this(new ArrayList<FunctionBody>(estimatedSize));
    }

    private CodeSection(ArrayList<FunctionBody> functionBodies) {
        super(10L);
        this.functionBodies = functionBodies;
    }

    public FunctionBody[] functionBodies() {
        return (FunctionBody[])this.functionBodies.toArray(FunctionBody[]::new);
    }

    public int functionBodyCount() {
        return this.functionBodies.size();
    }

    public FunctionBody getFunctionBody(int idx) {
        return this.functionBodies.get(idx);
    }

    public int addFunctionBody(FunctionBody functionBody) {
        Objects.requireNonNull(functionBody, "functionBody");
        int idx = this.functionBodies.size();
        this.functionBodies.add(functionBody);
        return idx;
    }

    public void setRequiresDataCount(boolean requiresDataCount) {
        this.requiresDataCount = requiresDataCount;
    }

    public boolean isRequiresDataCount() {
        return this.requiresDataCount;
    }
}

