/*
 * Decompiled with CFR 0.152.
 */
package dwarf;

import datastructures.stdcollections.ListsKt;
import datastructures.stdcollections.MapsKt;
import dwarf.InlinedFramesInfo;
import dwarf.InlinedFramesInfoKt;
import dwarf.LlvmSymbolizerOutput;
import dwarf.Symbol;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UInt;
import kotlin.ULong;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import report.CVTAlertReporter;
import report.CVTAlertSeverity;
import report.CVTAlertType;
import spec.cvlast.CVLRange;
import utils.SourcePosition;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004J$\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\r\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0018"}, d2={"Ldwarf/InlinedFramesInfo;", "", "()V", "elfFile", "", "findInnermostInlinedFrame", "Lspec/cvlast/CVLRange$Range;", "address", "Lkotlin/ULong;", "findInnermostInlinedFrame-VKZWuLQ", "(J)Lspec/cvlast/CVLRange$Range;", "getInlinedFrames", "", "", "addresses", "init", "", "llvmSymbolizerOutputToCvlRange", "Lkotlin/Pair;", "llvmSymbolizerOutput", "Ldwarf/LlvmSymbolizerOutput;", "symbolToCVLRange", "symbol", "Ldwarf/Symbol;", "Shared"})
@SourceDebugExtension(value={"SMAP\nInlinedFramesInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlinedFramesInfo.kt\ndwarf/InlinedFramesInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,199:1\n1#2:200\n1#2:220\n1549#3:201\n1620#3,3:202\n1855#3,2:205\n1855#3,2:208\n1603#3,9:210\n1855#3:219\n1856#3:221\n1612#3:222\n96#4:207\n*S KotlinDebug\n*F\n+ 1 InlinedFramesInfo.kt\ndwarf/InlinedFramesInfo\n*L\n130#1:220\n65#1:201\n65#1:202,3\n66#1:205,2\n100#1:208,2\n130#1:210,9\n130#1:219\n130#1:221\n130#1:222\n94#1:207\n*E\n"})
public final class InlinedFramesInfo {
    @NotNull
    public static final InlinedFramesInfo INSTANCE = new InlinedFramesInfo();
    @Nullable
    private static String elfFile;

    private InlinedFramesInfo() {
    }

    public final void init(@NotNull String elfFile) {
        Intrinsics.checkNotNullParameter(elfFile, "elfFile");
        InlinedFramesInfo.elfFile = elfFile;
    }

    @Nullable
    public final CVLRange.Range findInnermostInlinedFrame-VKZWuLQ(long address2) {
        CVLRange.Range range;
        Map<ULong, List<CVLRange.Range>> inlinedFramesMap = this.getInlinedFrames(ListsKt.listOf(ULong.box-impl(address2)));
        List<CVLRange.Range> list = inlinedFramesMap.get(ULong.box-impl(address2));
        if (list != null) {
            List<CVLRange.Range> it2 = list;
            boolean bl = false;
            range = it2.get(0);
        } else {
            range = null;
        }
        return range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ULong, List<CVLRange.Range>> getInlinedFrames(@NotNull List<ULong> addresses) {
        Object it22;
        Object item$iv$iv;
        Iterator $this$mapTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(addresses, "addresses");
        boolean bl2 = bl = elfFile != null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-InlinedFramesInfo$getInlinedFrames$22 = false;
            String $i$a$-assert-InlinedFramesInfo$getInlinedFrames$22 = "called getInlinedFrames before initializing the ELF file path";
            throw new AssertionError((Object)$i$a$-assert-InlinedFramesInfo$getInlinedFrames$22);
        }
        String[] $i$a$-assert-InlinedFramesInfo$getInlinedFrames$22 = new String[]{"llvm-symbolizer", "--output-style", "JSON", "--exe", elfFile, "--inlines"};
        List<String> cmd2 = CollectionsKt.mutableListOf($i$a$-assert-InlinedFramesInfo$getInlinedFrames$22);
        Iterable $this$map$iv = addresses;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void addr;
            item$iv$iv = iterator2.next();
            long l = ((ULong)item$iv$iv).unbox-impl();
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            String string = UStringsKt.toString-JSWoG40((long)addr, 16).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            collection.add("0x" + string);
        }
        List hexAddresses = (List)destination$iv$iv;
        Iterable $this$forEach$iv = hexAddresses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String address2 = (String)element$iv;
            boolean bl4 = false;
            cmd2.add(address2);
        }
        String hexAddressesString = CollectionsKt.joinToString$default(hexAddresses, " ", null, null, 0, null, null, 62, null);
        InlinedFramesInfoKt.access$getDebugSymbolsLogger$p().info((Function0<? extends Object>)new Function0<Object>(hexAddressesString, cmd2){
            final /* synthetic */ String $hexAddressesString;
            final /* synthetic */ List<String> $cmd;
            {
                this.$hexAddressesString = $hexAddressesString;
                this.$cmd = $cmd;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Running command to get addresses " + this.$hexAddressesString + " info: " + CollectionsKt.joinToString$default(this.$cmd, " ", null, null, 0, null, null, 62, null);
            }
        });
        ProcessBuilder pb = new ProcessBuilder(cmd2);
        Process llvmSymbolizerProcess = pb.start();
        InputStream inputStream = llvmSymbolizerProcess.getInputStream();
        Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
        Closeable address2 = inputStream;
        Object bl4 = Charsets.UTF_8;
        item$iv$iv = new InputStreamReader((InputStream)address2, (Charset)bl4);
        int addr = 8192;
        address2 = item$iv$iv instanceof BufferedReader ? (BufferedReader)item$iv$iv : new BufferedReader((Reader)item$iv$iv, addr);
        bl4 = null;
        try {
            it22 = (BufferedReader)address2;
            boolean bl5 = false;
            it22 = TextStreamsKt.readText((Reader)it22);
        }
        catch (Throwable it22) {
            bl4 = it22;
            throw it22;
        }
        finally {
            CloseableKt.closeFinally(address2, (Throwable)bl4);
        }
        Object llvmSymbolizerProcessStdout = it22;
        InlinedFramesInfoKt.access$getDebugSymbolsLogger$p().info((Function0<? extends Object>)new Function0<Object>((String)llvmSymbolizerProcessStdout){
            final /* synthetic */ String $llvmSymbolizerProcessStdout;
            {
                this.$llvmSymbolizerProcessStdout = $llvmSymbolizerProcessStdout;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "llvm-symbolizer process stdout: " + this.$llvmSymbolizerProcessStdout;
            }
        });
        if (llvmSymbolizerProcess.waitFor() != 0) {
            byte[] byArray;
            it22 = llvmSymbolizerProcess.getErrorStream();
            Throwable bl5 = null;
            try {
                InputStream it3 = (InputStream)it22;
                boolean bl6 = false;
                byArray = it3.readAllBytes();
            }
            catch (Throwable throwable) {
                bl5 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)it22, bl5);
            }
            Intrinsics.checkNotNullExpressionValue(byArray, "use(...)");
            bl4 = byArray;
            String errorText = new String((byte[])bl4, Charsets.UTF_8);
            CVTAlertReporter.Companion.reportAlert$default(CVTAlertReporter.Companion, CVTAlertType.DIAGNOSABILITY, CVTAlertSeverity.WARNING, null, "Failed to generate inlined frames for bytecode addresses " + hexAddressesString + " - proceeding without debug information.", null, null, 32, null);
            InlinedFramesInfoKt.access$getDebugSymbolsLogger$p().warn((Function0<? extends Object>)new Function0<Object>(hexAddressesString, errorText){
                final /* synthetic */ String $hexAddressesString;
                final /* synthetic */ String $errorText;
                {
                    this.$hexAddressesString = $hexAddressesString;
                    this.$errorText = $errorText;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Failed to generate inlined frames for bytecode address " + this.$hexAddressesString + " - proceeding without debug information, reason " + this.$errorText;
                }
            });
            return MapsKt.mapOf();
        }
        Json this_$iv = JsonKt.Json$default(null, getInlinedFrames.llvmSymbolizerOutputList.1.INSTANCE, 1, null);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List llvmSymbolizerOutputList2 = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer<LlvmSymbolizerOutput>(LlvmSymbolizerOutput.Companion.serializer()), (String)llvmSymbolizerProcessStdout);
        Map<ULong, List<CVLRange.Range>> inlinedFrames = MapsKt.mutableMapOf();
        Iterable $this$forEach$iv2 = llvmSymbolizerOutputList2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            LlvmSymbolizerOutput llvmSymbolizerOutput = (LlvmSymbolizerOutput)element$iv;
            boolean bl7 = false;
            Pair<ULong, List<CVLRange.Range>> resultEntry = INSTANCE.llvmSymbolizerOutputToCvlRange(llvmSymbolizerOutput);
            if (resultEntry == null) continue;
            inlinedFrames.put(resultEntry.getFirst(), resultEntry.getSecond());
        }
        InlinedFramesInfoKt.access$getDebugSymbolsLogger$p().info((Function0<? extends Object>)new Function0<Object>(inlinedFrames){
            final /* synthetic */ Map<ULong, List<CVLRange.Range>> $inlinedFrames;
            {
                this.$inlinedFrames = $inlinedFrames;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Generated inlined frames: " + this.$inlinedFrames;
            }
        });
        return inlinedFrames;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<ULong, List<CVLRange.Range>> llvmSymbolizerOutputToCvlRange(LlvmSymbolizerOutput llvmSymbolizerOutput) {
        void $this$mapNotNullTo$iv$iv;
        if (llvmSymbolizerOutput.getAddress() == null || llvmSymbolizerOutput.getSymbol() == null) {
            return null;
        }
        if (!StringsKt.startsWith$default(llvmSymbolizerOutput.getAddress(), "0x", false, 2, null)) {
            InlinedFramesInfoKt.access$getDebugSymbolsLogger$p().warn((Function0<? extends Object>)new Function0<Object>(llvmSymbolizerOutput){
                final /* synthetic */ LlvmSymbolizerOutput $llvmSymbolizerOutput;
                {
                    this.$llvmSymbolizerOutput = $llvmSymbolizerOutput;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "address '" + this.$llvmSymbolizerOutput.getAddress() + "' does not start with '0x'";
                }
            });
            return null;
        }
        String string = llvmSymbolizerOutput.getAddress().substring(2);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        ULong uLongAddress = UStringsKt.toULongOrNull(string, 16);
        if (uLongAddress == null) {
            return null;
        }
        Iterable $this$mapNotNull$iv = llvmSymbolizerOutput.getSymbol();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CVLRange.Range it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Symbol symbol = (Symbol)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.symbolToCVLRange(symbol) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List inlinedFrames = (List)destination$iv$iv;
        return inlinedFrames.isEmpty() ? null : new Pair<ULong, List>(uLongAddress, inlinedFrames);
    }

    private final CVLRange.Range symbolToCVLRange(Symbol symbol) {
        if (symbol.getLine-pVg5ArA() == UInt.constructor-impl(0) || symbol.getColumn-pVg5ArA() == UInt.constructor-impl(0)) {
            return null;
        }
        int cvlRangeLineNumber = UInt.constructor-impl(symbol.getLine-pVg5ArA() - UInt.constructor-impl(1));
        int cvlRangeColNumber = UInt.constructor-impl(symbol.getColumn-pVg5ArA() - UInt.constructor-impl(1));
        SourcePosition sourcePositionStart = new SourcePosition(cvlRangeLineNumber, cvlRangeColNumber, null);
        SourcePosition sourcePositionEnd = new SourcePosition(UInt.constructor-impl(cvlRangeLineNumber + UInt.constructor-impl(1)), UInt.constructor-impl(0), null);
        return new CVLRange.Range(symbol.getFileName(), sourcePositionStart, sourcePositionEnd);
    }
}

