/*
 * Decompiled with CFR 0.152.
 */
package evm;

import evm.EVMConstsKt;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\r\u00a8\u0006\u000f"}, d2={"highOnes", "Ljava/math/BigInteger;", "width", "", "lowOnes", "end", "onesRange", "start", "signedIntsWithSameSign", "", "a", "b", "from2s", "", "to2s", "GeneralUtils"})
public final class EVMOpsKt {
    @NotNull
    public static final BigInteger highOnes(int width) {
        BigInteger bigInteger = EVMConstsKt.getMAX_EVM_UINT256().subtract(EVMOpsKt.lowOnes(256 - width));
        Intrinsics.checkNotNullExpressionValue(bigInteger, "subtract(...)");
        return bigInteger;
    }

    @NotNull
    public static final BigInteger lowOnes(int end) {
        BigInteger bigInteger = BigInteger.ONE.shiftLeft(end);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "shiftLeft(...)");
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue(bigInteger3, "ONE");
        BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3);
        Intrinsics.checkNotNullExpressionValue(bigInteger4, "subtract(...)");
        return bigInteger4;
    }

    @NotNull
    public static final BigInteger onesRange(int start, int end) {
        BigInteger bigInteger = EVMOpsKt.lowOnes(end).subtract(EVMOpsKt.lowOnes(start));
        Intrinsics.checkNotNullExpressionValue(bigInteger, "subtract(...)");
        return bigInteger;
    }

    public static final boolean signedIntsWithSameSign(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return a.compareTo(EVMConstsKt.getMAX_EVM_INT256()) > 0 && b.compareTo(EVMConstsKt.getMAX_EVM_INT256()) > 0 || a.compareTo(EVMConstsKt.getMAX_EVM_INT256()) <= 0 && b.compareTo(EVMConstsKt.getMAX_EVM_INT256()) <= 0;
    }

    @NotNull
    public static final BigInteger to2s(@NotNull BigInteger $this$to2s) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter($this$to2s, "<this>");
        BigInteger bigInteger2 = BigInteger.ZERO;
        boolean bl = $this$to2s.compareTo((Object)EVMConstsKt.getMAX_EVM_INT256()) <= 0 ? 0 <= $this$to2s.compareTo((Object)bigInteger2) : false;
        if (bl) {
            bigInteger = $this$to2s;
        } else if (RangesKt.rangeUntil((Comparable)EVMConstsKt.getMIN_EVM_INT256_AS_MATH_INT(), (Comparable)BigInteger.ZERO).contains($this$to2s)) {
            BigInteger bigInteger3 = $this$to2s.add(EVMConstsKt.getEVM_MOD_GROUP256());
            bigInteger = bigInteger3;
            Intrinsics.checkNotNullExpressionValue(bigInteger3, "add(...)");
        } else {
            throw new IllegalStateException(($this$to2s + " is not within the range that can be translated to 2s complement.").toString());
        }
        return bigInteger;
    }

    @NotNull
    public static final BigInteger to2s(int $this$to2s) {
        BigInteger bigInteger = BigInteger.valueOf($this$to2s);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "valueOf(...)");
        return EVMOpsKt.to2s(bigInteger);
    }

    @NotNull
    public static final BigInteger to2s(long $this$to2s) {
        BigInteger bigInteger = BigInteger.valueOf($this$to2s);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "valueOf(...)");
        return EVMOpsKt.to2s(bigInteger);
    }

    @NotNull
    public static final BigInteger from2s(@NotNull BigInteger $this$from2s) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter($this$from2s, "<this>");
        BigInteger bigInteger2 = $this$from2s;
        BigInteger bigInteger3 = BigInteger.ZERO;
        boolean bl = bigInteger2.compareTo((Object)EVMConstsKt.getMAX_EVM_INT256()) <= 0 ? 0 <= bigInteger2.compareTo((Object)bigInteger3) : false;
        if (bl) {
            bigInteger = $this$from2s;
        } else {
            bigInteger3 = EVMConstsKt.getMIN_EVM_INT256_2S_COMPLEMENT();
            boolean bl2 = bigInteger2.compareTo((Object)EVMConstsKt.getMAX_EVM_UINT256()) <= 0 ? 0 <= bigInteger2.compareTo((Object)bigInteger3) : false;
            if (bl2) {
                BigInteger bigInteger4 = $this$from2s.subtract(EVMConstsKt.getEVM_MOD_GROUP256());
                bigInteger = bigInteger4;
                Intrinsics.checkNotNullExpressionValue(bigInteger4, "subtract(...)");
            } else {
                throw new IllegalStateException(($this$from2s + " is not within the range that can be translated from 2s complement.").toString());
            }
        }
        return bigInteger;
    }

    @NotNull
    public static final BigInteger from2s(int $this$from2s) {
        BigInteger bigInteger = BigInteger.valueOf($this$from2s);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "valueOf(...)");
        return EVMOpsKt.from2s(bigInteger);
    }

    @NotNull
    public static final BigInteger from2s(long $this$from2s) {
        BigInteger bigInteger = BigInteger.valueOf($this$from2s);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "valueOf(...)");
        return EVMOpsKt.from2s(bigInteger);
    }
}

