/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastMap
implements Map,
Cloneable,
Serializable {
    private transient EntryImpl[] _entries;
    private transient int _capacity;
    private transient int _mask;
    private transient EntryImpl _poolFirst;
    private transient EntryImpl _mapFirst;
    private transient EntryImpl _mapLast;
    private transient int _size;
    private transient Values _values;
    private transient EntrySet _entrySet;
    private transient KeySet _keySet;

    public FastMap() {
        this.initialize(256);
    }

    public FastMap(Map map2) {
        int capacity = map2 instanceof FastMap ? ((FastMap)map2).capacity() : map2.size();
        this.initialize(capacity);
        this.putAll(map2);
    }

    public FastMap(int capacity) {
        this.initialize(capacity);
    }

    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._capacity;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public boolean containsKey(Object key) {
        EntryImpl entry2 = this._entries[FastMap.keyHash(key) & this._mask];
        while (entry2 != null) {
            if (key.equals(entry2._key)) {
                return true;
            }
            entry2 = entry2._next;
        }
        return false;
    }

    public boolean containsValue(Object value2) {
        EntryImpl entry2 = this._mapFirst;
        while (entry2 != null) {
            if (value2.equals(entry2._value)) {
                return true;
            }
            entry2 = entry2._after;
        }
        return false;
    }

    public Object get(Object key) {
        EntryImpl entry2 = this._entries[FastMap.keyHash(key) & this._mask];
        while (entry2 != null) {
            if (key.equals(entry2._key)) {
                return entry2._value;
            }
            entry2 = entry2._next;
        }
        return null;
    }

    public Map.Entry getEntry(Object key) {
        EntryImpl entry2 = this._entries[FastMap.keyHash(key) & this._mask];
        while (entry2 != null) {
            if (key.equals(entry2._key)) {
                return entry2;
            }
            entry2 = entry2._next;
        }
        return null;
    }

    public Object put(Object key, Object value2) {
        EntryImpl entry2 = this._entries[FastMap.keyHash(key) & this._mask];
        while (entry2 != null) {
            if (key.equals(entry2._key)) {
                Object prevValue = entry2._value;
                entry2._value = value2;
                return prevValue;
            }
            entry2 = entry2._next;
        }
        this.addEntry(key, value2);
        return null;
    }

    public void putAll(Map map2) {
        Iterator i = map2.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.addEntry(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        EntryImpl entry2 = this._entries[FastMap.keyHash(key) & this._mask];
        while (entry2 != null) {
            if (key.equals(entry2._key)) {
                Object prevValue = entry2._value;
                this.removeEntry(entry2);
                return prevValue;
            }
            entry2 = entry2._next;
        }
        return null;
    }

    public void clear() {
        EntryImpl entry2 = this._mapFirst;
        while (entry2 != null) {
            entry2._key = null;
            entry2._value = null;
            entry2._before = null;
            entry2._next = null;
            if (entry2._previous == null) {
                this._entries[((EntryImpl)entry2)._index] = null;
            } else {
                entry2._previous = null;
            }
            entry2 = entry2._after;
        }
        if (this._mapLast != null) {
            this._mapLast._after = this._poolFirst;
            this._poolFirst = this._mapFirst;
            this._mapFirst = null;
            this._mapLast = null;
            this._size = 0;
            this.sizeChanged();
        }
    }

    public void setCapacity(int newCapacity) {
        int tableLength;
        EntryImpl entry2;
        int i;
        if (newCapacity > this._capacity) {
            for (i = this._capacity; i < newCapacity; ++i) {
                entry2 = new EntryImpl();
                entry2._after = this._poolFirst;
                this._poolFirst = entry2;
            }
        } else if (newCapacity < this._capacity) {
            for (i = newCapacity; i < this._capacity && this._poolFirst != null; ++i) {
                entry2 = this._poolFirst;
                this._poolFirst = entry2._after;
                entry2._after = null;
            }
        }
        for (tableLength = 16; tableLength < newCapacity; tableLength <<= 1) {
        }
        if (this._entries.length != tableLength) {
            this._entries = new EntryImpl[tableLength];
            this._mask = tableLength - 1;
            entry2 = this._mapFirst;
            while (entry2 != null) {
                int index = FastMap.keyHash(entry2._key) & this._mask;
                entry2._index = index;
                entry2._previous = null;
                EntryImpl next2 = this._entries[index];
                entry2._next = next2;
                if (next2 != null) {
                    next2._previous = entry2;
                }
                this._entries[index] = entry2;
                entry2 = entry2._after;
            }
        }
        this._capacity = newCapacity;
    }

    public Object clone() {
        try {
            FastMap clone = (FastMap)super.clone();
            clone.initialize(this._capacity);
            clone.putAll((Map)this);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj2) {
        if (obj2 == this) {
            return true;
        }
        if (obj2 instanceof Map) {
            Map that = (Map)obj2;
            if (this.size() == that.size()) {
                EntryImpl entry2 = this._mapFirst;
                while (entry2 != null) {
                    if (!that.entrySet().contains(entry2)) {
                        return false;
                    }
                    entry2 = entry2._after;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int code = 0;
        EntryImpl entry2 = this._mapFirst;
        while (entry2 != null) {
            code += entry2.hashCode();
            entry2 = entry2._after;
        }
        return code;
    }

    public String toString() {
        return this.entrySet().toString();
    }

    public Collection values() {
        return this._values;
    }

    public Set entrySet() {
        return this._entrySet;
    }

    public Set keySet() {
        return this._keySet;
    }

    protected void sizeChanged() {
        if (this.size() > this.capacity()) {
            this.setCapacity(this.capacity() * 2);
        }
    }

    private static int keyHash(Object key) {
        int hashCode = key.hashCode();
        hashCode += ~(hashCode << 9);
        hashCode ^= hashCode >>> 14;
        hashCode += hashCode << 4;
        hashCode ^= hashCode >>> 10;
        return hashCode;
    }

    private void addEntry(Object key, Object value2) {
        EntryImpl entry2 = this._poolFirst;
        if (entry2 != null) {
            this._poolFirst = entry2._after;
            entry2._after = null;
        } else {
            entry2 = new EntryImpl();
        }
        entry2._key = key;
        entry2._value = value2;
        int index = FastMap.keyHash(key) & this._mask;
        entry2._index = index;
        EntryImpl next2 = this._entries[index];
        entry2._next = next2;
        if (next2 != null) {
            next2._previous = entry2;
        }
        this._entries[index] = entry2;
        if (this._mapLast != null) {
            entry2._before = this._mapLast;
            this._mapLast._after = entry2;
        } else {
            this._mapFirst = entry2;
        }
        this._mapLast = entry2;
        ++this._size;
        this.sizeChanged();
    }

    private void removeEntry(EntryImpl entry2) {
        EntryImpl previous = entry2._previous;
        EntryImpl next2 = entry2._next;
        if (previous != null) {
            previous._next = next2;
            entry2._previous = null;
        } else {
            this._entries[((EntryImpl)entry2)._index] = next2;
        }
        if (next2 != null) {
            next2._previous = previous;
            entry2._next = null;
        }
        EntryImpl before = entry2._before;
        EntryImpl after = entry2._after;
        if (before != null) {
            before._after = after;
            entry2._before = null;
        } else {
            this._mapFirst = after;
        }
        if (after != null) {
            after._before = before;
        } else {
            this._mapLast = before;
        }
        entry2._key = null;
        entry2._value = null;
        entry2._after = this._poolFirst;
        this._poolFirst = entry2;
        --this._size;
        this.sizeChanged();
    }

    private void initialize(int capacity) {
        int tableLength;
        for (tableLength = 16; tableLength < capacity; tableLength <<= 1) {
        }
        this._entries = new EntryImpl[tableLength];
        this._mask = tableLength - 1;
        this._capacity = capacity;
        this._size = 0;
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._keySet = new KeySet();
        this._poolFirst = null;
        this._mapFirst = null;
        this._mapLast = null;
        for (int i = 0; i < capacity; ++i) {
            EntryImpl entry2 = new EntryImpl();
            entry2._after = this._poolFirst;
            this._poolFirst = entry2;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int capacity = stream.readInt();
        this.initialize(capacity);
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = stream.readObject();
            Object value2 = stream.readObject();
            this.addEntry(key, value2);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this._capacity);
        stream.writeInt(this._size);
        int count2 = 0;
        EntryImpl entry2 = this._mapFirst;
        while (entry2 != null) {
            stream.writeObject(entry2._key);
            stream.writeObject(entry2._value);
            ++count2;
            entry2 = entry2._after;
        }
        if (count2 != this._size) {
            throw new IOException("FastMap Corrupted");
        }
    }

    private static final class EntryImpl
    implements Map.Entry {
        private Object _key;
        private Object _value;
        private int _index;
        private EntryImpl _previous;
        private EntryImpl _next;
        private EntryImpl _before;
        private EntryImpl _after;

        private EntryImpl() {
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object value2) {
            Object old = this._value;
            this._value = value2;
            return old;
        }

        public boolean equals(Object that) {
            if (that instanceof Map.Entry) {
                Map.Entry entry2 = (Map.Entry)that;
                return this._key.equals(entry2.getKey()) && (this._value != null ? this._value.equals(entry2.getValue()) : entry2.getValue() == null);
            }
            return false;
        }

        public int hashCode() {
            return this._key.hashCode() ^ (this._value != null ? this._value.hashCode() : 0);
        }

        public String toString() {
            return this._key + "=" + this._value;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                EntryImpl after;
                EntryImpl before;
                private final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = this$1;
                    this.after = FastMap.access$900(KeySet.access$1300(this.this$1));
                }

                public void remove() {
                    FastMap.access$1000(KeySet.access$1300(this.this$1), this.before);
                }

                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = EntryImpl.access$300(this.after);
                    return EntryImpl.access$000(this.before);
                }
            };
        }

        public int size() {
            return FastMap.this._size;
        }

        public boolean contains(Object obj2) {
            return FastMap.this.containsKey(obj2);
        }

        public boolean remove(Object obj2) {
            return FastMap.this.remove(obj2) != null;
        }

        public void clear() {
            FastMap.this.clear();
        }

        static /* synthetic */ FastMap access$1300(KeySet x0) {
            return x0.FastMap.this;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                EntryImpl after;
                EntryImpl before;
                private final /* synthetic */ EntrySet this$1;
                {
                    this.this$1 = this$1;
                    this.after = FastMap.access$900(EntrySet.access$1200(this.this$1));
                }

                public void remove() {
                    FastMap.access$1000(EntrySet.access$1200(this.this$1), this.before);
                }

                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = EntryImpl.access$300(this.after);
                    return this.before;
                }
            };
        }

        public int size() {
            return FastMap.this._size;
        }

        public boolean contains(Object obj2) {
            if (obj2 instanceof Map.Entry) {
                Map.Entry entry2 = (Map.Entry)obj2;
                Map.Entry mapEntry = FastMap.this.getEntry(entry2.getKey());
                return ((Object)entry2).equals(mapEntry);
            }
            return false;
        }

        public boolean remove(Object obj2) {
            Map.Entry entry2;
            EntryImpl mapEntry;
            if (obj2 instanceof Map.Entry && (mapEntry = (EntryImpl)FastMap.this.getEntry((entry2 = (Map.Entry)obj2).getKey())) != null && entry2.getValue().equals(mapEntry._value)) {
                FastMap.this.removeEntry(mapEntry);
                return true;
            }
            return false;
        }

        static /* synthetic */ FastMap access$1200(EntrySet x0) {
            return x0.FastMap.this;
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new Iterator(){
                EntryImpl after;
                EntryImpl before;
                {
                    this.after = FastMap.this._mapFirst;
                }

                public void remove() {
                    FastMap.this.removeEntry(this.before);
                }

                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = this.after._after;
                    return this.before._value;
                }
            };
        }

        public int size() {
            return FastMap.this._size;
        }

        public boolean contains(Object o) {
            return FastMap.this.containsValue(o);
        }

        public void clear() {
            FastMap.this.clear();
        }
    }
}

