/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.typechecker;

import datastructures.stdcollections.IterablesKt;
import datastructures.stdcollections.ListsKt;
import evm.SighashInt;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.cvlast.CVLDefinition;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLFunction;
import spec.cvlast.CVLGhostFunction;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLSymbolTable;
import spec.cvlast.CVLType;
import spec.cvlast.CVLTypeEnvironment;
import spec.cvlast.CatchAllSummaryAnnotation;
import spec.cvlast.CatchUnresolvedSummaryAnnotation;
import spec.cvlast.ConcreteMethodBlockAnnotation;
import spec.cvlast.ContractFunction;
import spec.cvlast.EVMBuiltinTypes;
import spec.cvlast.Function;
import spec.cvlast.MethodBlockEntry;
import spec.cvlast.MethodEntryTargetContract;
import spec.cvlast.MethodParameterSignature;
import spec.cvlast.MethodSignature;
import spec.cvlast.SpecCallSummary;
import spec.cvlast.Visibility;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.CVLExpTypeChecker;
import spec.cvlast.typechecker.CVLMethodsBlockTypeChecker;
import spec.cvlast.typechecker.DispatchListContractNotFound;
import spec.cvlast.typechecker.DispatchListNoMatchingMethodFound;
import spec.cvlast.typechecker.DispatcherSummaryNoImplementation;
import spec.cvlast.typechecker.EnvfreeAndWith;
import spec.cvlast.typechecker.WithWrongType;
import spec.cvlast.typedescriptors.ICVLDataInput;
import spec.cvlast.typedescriptors.IConverterOutput;
import spec.cvlast.typedescriptors.ITypeDescriptorConverter;
import spec.cvlast.typedescriptors.ToVMContext;
import spec.cvlast.typedescriptors.VMReferenceTypeDescriptor;
import spec.cvlast.typedescriptors.VMTypeDescriptor;
import spec.cvlast.typedescriptors.VMValueTypeDescriptor;
import utils.AmbiSerializable;
import utils.CollectingResult;
import utils.ErrorCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J4\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u001e\u001a\u00020\u001c2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010 \u001a\u00020#H\u0002J$\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020&H\u0002J$\u0010'\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0002J4\u0010(\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u001e\u001a\u00020)2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u0006\u0010 \u001a\u00020!H\u0002J$\u0010*\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010,\u001a\u00020+H\u0002J,\u0010-\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020.2\u0006\u0010 \u001a\u00020!H\u0002J4\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u001e\u001a\u0002002\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u0006\u0010 \u001a\u00020!H\u0002J.\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u001d0\u001b0\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u00103\u001a\b\u0012\u0004\u0012\u00020%0\u0014J$\u00104\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020%H\u0002J6\u00105\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u001e\u001a\u0002062\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u0006\u0010 \u001a\u00020!H\u0002J$\u00107\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010 \u001a\u00020!H\u0002J@\u00108\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010)2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lspec/cvlast/typechecker/CVLMethodsBlockTypeChecker;", "", "expTypeChecker", "Lspec/cvlast/typechecker/CVLExpTypeChecker;", "(Lspec/cvlast/typechecker/CVLExpTypeChecker;)V", "checkFuncForOverload", "", "info", "Lspec/cvlast/CVLSymbolTable$SymbolInfo;", "sig", "Ljava/math/BigInteger;", "convertibilityErrors", "", "from", "Lspec/cvlast/CVLType$PureCVLType;", "to", "Lspec/cvlast/typedescriptors/VMTypeDescriptor;", "visibility", "Lspec/cvlast/Visibility;", "matchingFunctionsInSymbolTable", "", "Lspec/cvlast/Function;", "symbolTable", "Lspec/cvlast/CVLSymbolTable;", "methodParameterSignatureInCVLSpec", "Lspec/cvlast/MethodParameterSignature;", "typeCheckAlwaysSummary", "Lutils/CollectingResult;", "Lspec/cvlast/SpecCallSummary$Always;", "Lspec/cvlast/typechecker/CVLError;", "summary", "res", "entry", "Lspec/cvlast/ConcreteMethodBlockAnnotation;", "typeCheckCatchAllAnnotation", "Lspec/cvlast/CatchAllSummaryAnnotation;", "typeCheckCatchUnresolvedAnnotation", "Lspec/cvlast/MethodBlockEntry;", "Lspec/cvlast/CatchUnresolvedSummaryAnnotation;", "typeCheckConcreteAnnotation", "typeCheckConstantSummary", "Lspec/cvlast/SpecCallSummary$ExpressibleInCVL;", "typeCheckDispatchListSummary", "Lspec/cvlast/SpecCallSummary$DispatchList;", "dispatchList", "typeCheckDispatcherSummary", "Lspec/cvlast/SpecCallSummary$Dispatcher;", "typeCheckExpSummary", "Lspec/cvlast/SpecCallSummary$Exp;", "declaredReturn", "typeCheckMethodsBlock", "methodsBlock", "typeCheckMethodsEntry", "typeCheckNondetSummary", "Lspec/cvlast/SpecCallSummary$HavocSummary$Nondet;", "typeCheckReturnsClause", "typeCheckSummary", "Shared"})
@SourceDebugExtension(value={"SMAP\nCVLMethodsBlockTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CVLMethodsBlockTypeChecker.kt\nspec/cvlast/typechecker/CVLMethodsBlockTypeChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,473:1\n1549#2:474\n1620#2,3:475\n1747#2,3:478\n1747#2,3:481\n1747#2,3:484\n1360#2:487\n1446#2,2:488\n800#2,11:490\n766#2:501\n857#2,2:502\n1448#2,3:504\n*S KotlinDebug\n*F\n+ 1 CVLMethodsBlockTypeChecker.kt\nspec/cvlast/typechecker/CVLMethodsBlockTypeChecker\n*L\n24#1:474\n24#1:475,3\n166#1:478,3\n269#1:481,3\n379#1:484,3\n410#1:487\n410#1:488,2\n415#1:490,11\n416#1:501\n416#1:502,2\n410#1:504,3\n*E\n"})
public final class CVLMethodsBlockTypeChecker {
    @NotNull
    private final CVLExpTypeChecker expTypeChecker;

    public CVLMethodsBlockTypeChecker(@NotNull CVLExpTypeChecker expTypeChecker) {
        Intrinsics.checkNotNullParameter(expTypeChecker, "expTypeChecker");
        this.expTypeChecker = expTypeChecker;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CollectingResult<MethodBlockEntry, CVLError>> typeCheckMethodsBlock(@NotNull CVLSymbolTable symbolTable, @NotNull List<? extends MethodBlockEntry> methodsBlock) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(methodsBlock, "methodsBlock");
        Iterable $this$map$iv = methodsBlock;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            MethodBlockEntry methodBlockEntry = (MethodBlockEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.typeCheckMethodsEntry(symbolTable, (MethodBlockEntry)it2));
        }
        return (List)destination$iv$iv;
    }

    private final CollectingResult<MethodBlockEntry, CVLError> typeCheckMethodsEntry(CVLSymbolTable symbolTable, MethodBlockEntry entry2) {
        CollectingResult<MethodBlockEntry, CVLError> collectingResult;
        MethodBlockEntry methodBlockEntry = entry2;
        if (methodBlockEntry instanceof ConcreteMethodBlockAnnotation) {
            collectingResult = this.typeCheckConcreteAnnotation(symbolTable, (ConcreteMethodBlockAnnotation)entry2);
        } else if (methodBlockEntry instanceof CatchAllSummaryAnnotation) {
            collectingResult = this.typeCheckCatchAllAnnotation((CatchAllSummaryAnnotation)entry2);
        } else if (methodBlockEntry instanceof CatchUnresolvedSummaryAnnotation) {
            collectingResult = this.typeCheckCatchUnresolvedAnnotation(symbolTable, (CatchUnresolvedSummaryAnnotation)entry2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return collectingResult;
    }

    private final CollectingResult<MethodBlockEntry, CVLError> typeCheckCatchUnresolvedAnnotation(CVLSymbolTable symbolTable, CatchUnresolvedSummaryAnnotation entry2) {
        return CollectingResult.Companion.map(this.typeCheckDispatchListSummary(symbolTable, entry2.getDispatchList()), (Function1)new Function1<SpecCallSummary.DispatchList, CatchUnresolvedSummaryAnnotation>(entry2){
            final /* synthetic */ CatchUnresolvedSummaryAnnotation $entry;
            {
                this.$entry = $entry;
                super(1);
            }

            @NotNull
            public final CatchUnresolvedSummaryAnnotation invoke(@NotNull SpecCallSummary.DispatchList it2) {
                Intrinsics.checkNotNullParameter(it2, "it");
                return this.$entry;
            }
        });
    }

    private final CollectingResult<CatchAllSummaryAnnotation, CVLError> typeCheckCatchAllAnnotation(CatchAllSummaryAnnotation entry2) {
        return ErrorCollector.Companion.collectingErrors((Function1)new Function1<ErrorCollector<CVLError>, CatchAllSummaryAnnotation>(entry2){
            final /* synthetic */ CatchAllSummaryAnnotation $entry;
            {
                this.$entry = $entry;
                super(1);
            }

            @NotNull
            public final CatchAllSummaryAnnotation invoke(@NotNull ErrorCollector<CVLError> $this$collectingErrors) {
                Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                if (!(this.$entry.getSummary() instanceof SpecCallSummary.HavocSummary)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (!(!this.$entry.getAnnot().getVirtual())) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (!(!this.$entry.getAnnot().getEnvFree())) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (!(!this.$entry.getAnnot().getLibrary())) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (!(this.$entry.getAnnot().getVisibility() == Visibility.EXTERNAL)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                return this.$entry;
            }
        });
    }

    private final CollectingResult<ConcreteMethodBlockAnnotation, CVLError> typeCheckConcreteAnnotation(CVLSymbolTable symbolTable, ConcreteMethodBlockAnnotation entry2) {
        return ErrorCollector.Companion.collectingErrors((Function1)new Function1<ErrorCollector<CVLError>, ConcreteMethodBlockAnnotation>(this, entry2, symbolTable){
            final /* synthetic */ CVLMethodsBlockTypeChecker this$0;
            final /* synthetic */ ConcreteMethodBlockAnnotation $entry;
            final /* synthetic */ CVLSymbolTable $symbolTable;
            {
                this.this$0 = $receiver;
                this.$entry = $entry;
                this.$symbolTable = $symbolTable;
                super(1);
            }

            @NotNull
            public final ConcreteMethodBlockAnnotation invoke(@NotNull ErrorCollector<CVLError> $this$collectingErrors) {
                Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                List res2 = (List)$this$collectingErrors.bind(CVLMethodsBlockTypeChecker.access$typeCheckReturnsClause(this.this$0, this.$entry));
                if (this.$entry.getSummary() == null) {
                    return this.$entry;
                }
                SpecCallSummary.ExpressibleInCVL checkedSummary = (SpecCallSummary.ExpressibleInCVL)$this$collectingErrors.bind(CVLMethodsBlockTypeChecker.access$typeCheckSummary(this.this$0, this.$symbolTable, this.$entry.getSummary(), res2, this.$entry));
                return ConcreteMethodBlockAnnotation.copy$default(this.$entry, null, null, null, null, checkedSummary, 15, null);
            }
        });
    }

    private final CollectingResult<List<VMTypeDescriptor>, CVLError> typeCheckReturnsClause(ConcreteMethodBlockAnnotation entry2) {
        return ErrorCollector.Companion.collectingErrors((Function1)new Function1<ErrorCollector<CVLError>, List<? extends VMTypeDescriptor>>(entry2){
            final /* synthetic */ ConcreteMethodBlockAnnotation $entry;
            {
                this.$entry = $entry;
                super(1);
            }

            @Nullable
            public final List<VMTypeDescriptor> invoke(@NotNull ErrorCollector<CVLError> $this$collectingErrors) {
                Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                MethodEntryTargetContract methodEntryTargetContract = this.$entry.getTarget();
                if (methodEntryTargetContract instanceof MethodEntryTargetContract.SpecificTarget) {
                    MethodParameterSignature methodParameterSignature = this.$entry.getMethodParameterSignature();
                    Object object = methodParameterSignature instanceof MethodSignature ? (MethodSignature)methodParameterSignature : null;
                    if (object == null || (object = object.getResType()) == null) {
                        $this$collectingErrors.returnError(new CVLError.General(this.$entry.getCvlRange(), "Cannot specify summary for " + this.$entry.prettyPrint() + " without return type information"));
                        throw new KotlinNothingValueException();
                    }
                    return object;
                }
                if (Intrinsics.areEqual(methodEntryTargetContract, MethodEntryTargetContract.WildcardTarget.INSTANCE)) {
                    if (this.$entry.getMethodParameterSignature() instanceof MethodSignature) {
                        String message2 = "Wildcard method entry " + this.$entry.prettyPrint() + " may not specify return types in the method signature.";
                        if (this.$entry.getSummary() instanceof SpecCallSummary.Exp && ((SpecCallSummary.Exp)this.$entry.getSummary()).getExpectedType() == null) {
                            message2 = message2 + " Instead, indicate the expected return type of the summary by adding expect <type> after the summary.";
                        }
                        $this$collectingErrors.returnError(new CVLError.General(this.$entry.getCvlRange(), message2));
                        throw new KotlinNothingValueException();
                    }
                    return null;
                }
                throw new NoWhenBranchMatchedException();
            }
        });
    }

    private final CollectingResult<SpecCallSummary.ExpressibleInCVL, CVLError> typeCheckSummary(CVLSymbolTable symbolTable, SpecCallSummary.ExpressibleInCVL summary, List<? extends VMTypeDescriptor> res2, ConcreteMethodBlockAnnotation entry2) {
        CollectingResult<SpecCallSummary.DispatchList, CVLError> collectingResult;
        if (summary == null) {
            return CollectingResult.Companion.lift(null);
        }
        if (entry2.getQualifiers().getVisibility() == Visibility.INTERNAL && !(summary instanceof SpecCallSummary.InternalSummary)) {
            String string = "Cannot use summary " + summary.getSummaryName() + " for internal functions.";
            CVLRange cVLRange = summary.getCvlRange();
            return CollectingResult.Companion.asError(new CVLError.General(cVLRange, string));
        }
        SpecCallSummary.ExpressibleInCVL expressibleInCVL = summary;
        if (expressibleInCVL instanceof SpecCallSummary.Always) {
            collectingResult = this.typeCheckAlwaysSummary((SpecCallSummary.Always)summary, res2, entry2);
        } else if (expressibleInCVL instanceof SpecCallSummary.Constant) {
            collectingResult = this.typeCheckConstantSummary(summary, res2, entry2);
        } else if (expressibleInCVL instanceof SpecCallSummary.PerCalleeConstant) {
            collectingResult = this.typeCheckConstantSummary(summary, res2, entry2);
        } else if (expressibleInCVL instanceof SpecCallSummary.Dispatcher) {
            collectingResult = this.typeCheckDispatcherSummary(symbolTable, (SpecCallSummary.Dispatcher)summary, entry2);
        } else if (expressibleInCVL instanceof SpecCallSummary.Exp) {
            collectingResult = this.typeCheckExpSummary((SpecCallSummary.Exp)summary, res2, entry2);
        } else if (expressibleInCVL instanceof SpecCallSummary.HavocSummary.Nondet) {
            collectingResult = this.typeCheckNondetSummary((SpecCallSummary.HavocSummary.Nondet)summary, res2, entry2);
        } else if (expressibleInCVL instanceof SpecCallSummary.HavocSummary) {
            collectingResult = (CollectingResult<SpecCallSummary.DispatchList, CVLError>)CollectingResult.Companion.lift(summary);
        } else if (expressibleInCVL instanceof SpecCallSummary.DispatchList) {
            collectingResult = this.typeCheckDispatchListSummary(symbolTable, (SpecCallSummary.DispatchList)summary);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return collectingResult;
    }

    private final CollectingResult<SpecCallSummary.ExpressibleInCVL, CVLError> typeCheckNondetSummary(SpecCallSummary.HavocSummary.Nondet summary, List<? extends VMTypeDescriptor> res2, ConcreteMethodBlockAnnotation entry2) {
        boolean bl;
        block6: {
            if (entry2.getQualifiers().getVisibility() == Visibility.EXTERNAL) {
                return CollectingResult.Companion.lift(summary);
            }
            List<VMTypeDescriptor> list = res2;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VMTypeDescriptor it2 = (VMTypeDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!(!(it2 instanceof VMValueTypeDescriptor))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            List<? extends VMTypeDescriptor> list = res2;
            Intrinsics.checkNotNull(list);
            String string = "Cannot use NONDET summary for function with return type(s) " + CollectionsKt.joinToString$default(list, ", ", null, null, 0, null, typeCheckNondetSummary.2.INSTANCE, 30, null) + "; using a NONDET summary for reference types causes unsoundness.";
            CVLRange cVLRange = summary.getCvlRange();
            return CollectingResult.Companion.asError(new CVLError.General(cVLRange, string));
        }
        return CollectingResult.Companion.lift(summary);
    }

    private final CollectingResult<SpecCallSummary.Always, CVLError> typeCheckAlwaysSummary(SpecCallSummary.Always summary, List<? extends VMTypeDescriptor> res2, ConcreteMethodBlockAnnotation entry2) {
        return ErrorCollector.Companion.collectingErrors((Function1)new Function1<ErrorCollector<CVLError>, SpecCallSummary.Always>(summary, this, entry2, res2){
            final /* synthetic */ SpecCallSummary.Always $summary;
            final /* synthetic */ CVLMethodsBlockTypeChecker this$0;
            final /* synthetic */ ConcreteMethodBlockAnnotation $entry;
            final /* synthetic */ List<VMTypeDescriptor> $res;
            {
                this.$summary = $summary;
                this.this$0 = $receiver;
                this.$entry = $entry;
                this.$res = $res;
                super(1);
            }

            @NotNull
            public final SpecCallSummary.Always invoke(@NotNull ErrorCollector<CVLError> $this$collectingErrors) {
                SpecCallSummary.Always always2;
                Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                CVLExp summExp = this.$summary.getExp();
                if ((summExp instanceof CVLExp.Constant.BoolLit ? true : summExp instanceof CVLExp.Constant.NumberLit) ? true : summExp instanceof CVLExp.CastExpr) {
                    CVLExp typeCheckedSummExp = $this$collectingErrors.bind(CVLMethodsBlockTypeChecker.access$getExpTypeChecker$p(this.this$0).typeCheck(summExp, CVLTypeEnvironment.Companion.empty(this.$entry.getCvlRange(), CVLScope.Companion.getAstScope())));
                    if (this.$res == null) {
                        if (!(this.$entry.getTarget() instanceof MethodEntryTargetContract.WildcardTarget)) {
                            String string = "Check failed.";
                            throw new IllegalStateException(string.toString());
                        }
                        always2 = SpecCallSummary.Always.copy$default(this.$summary, typeCheckedSummExp, null, null, 6, null);
                    } else {
                        if (this.$res.isEmpty()) {
                            if (!(this.$entry.getTarget() instanceof MethodEntryTargetContract.SpecificTarget)) {
                                String string = "Check failed.";
                                throw new IllegalStateException(string.toString());
                            }
                            $this$collectingErrors.returnError(new CVLError.General(this.$entry.getCvlRange(), this.$entry.prettyPrint() + " is a void function, so can't be summarized with " + this.$summary.getSummaryName()));
                            throw new KotlinNothingValueException();
                        }
                        if (this.$res.size() > 1) {
                            $this$collectingErrors.returnError(new CVLError.General(this.$entry.getCvlRange(), "Cannot use constant summary for function " + this.$entry.prettyPrint() + " that returns multiple values"));
                            throw new KotlinNothingValueException();
                        }
                        VMTypeDescriptor expectedType = (VMTypeDescriptor)IterablesKt.single((Iterable)this.$res);
                        CVLType.PureCVLType actualType = typeCheckedSummExp.getOrInferPureCVLType();
                        String string = CVLMethodsBlockTypeChecker.access$convertibilityErrors(this.this$0, actualType, expectedType, this.$entry.getQualifiers().getVisibility());
                        if (string != null) {
                            String errors2 = string;
                            boolean bl = false;
                            $this$collectingErrors.collectError(new CVLError.Exp(summExp, "Expression " + summExp + " of type " + actualType + " cannot be used for " + expectedType.prettyPrint() + ": " + errors2));
                        }
                        always2 = SpecCallSummary.Always.copy$default(this.$summary, typeCheckedSummExp, null, null, 6, null);
                    }
                } else {
                    $this$collectingErrors.returnError(new CVLError.General(this.$entry.getCvlRange(), "The argument of an ALWAYS summary must be a constant, got `" + summExp + "`"));
                    throw new KotlinNothingValueException();
                }
                return always2;
            }
        });
    }

    private final CollectingResult<SpecCallSummary.ExpressibleInCVL, CVLError> typeCheckConstantSummary(SpecCallSummary.ExpressibleInCVL summary, List<? extends VMTypeDescriptor> res2, ConcreteMethodBlockAnnotation entry2) {
        CollectingResult collectingResult;
        if (!(summary instanceof SpecCallSummary.Constant || summary instanceof SpecCallSummary.PerCalleeConstant)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (res2 == null) {
            collectingResult = CollectingResult.Companion.lift(summary);
        } else {
            boolean bl;
            block6: {
                Iterable $this$any$iv = res2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        VMTypeDescriptor it2 = (VMTypeDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!(it2 instanceof VMReferenceTypeDescriptor && ((VMReferenceTypeDescriptor)it2).isDynamicSize())) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            collectingResult = bl ? (CollectingResult)CollectingResult.Companion.asError(new CVLError.General(entry2.getCvlRange(), entry2.getSummary() + " cannot be used for complex return types specified for " + entry2.prettyPrint())) : (CollectingResult)CollectingResult.Companion.lift(summary);
        }
        return collectingResult;
    }

    private final CollectingResult<SpecCallSummary.Exp, CVLError> typeCheckExpSummary(SpecCallSummary.Exp summary, List<? extends VMTypeDescriptor> declaredReturn, ConcreteMethodBlockAnnotation entry2) {
        return ErrorCollector.Companion.collectingErrors((Function1)new Function1<ErrorCollector<CVLError>, SpecCallSummary.Exp>(entry2, declaredReturn, summary, this){
            final /* synthetic */ ConcreteMethodBlockAnnotation $entry;
            final /* synthetic */ List<VMTypeDescriptor> $declaredReturn;
            final /* synthetic */ SpecCallSummary.Exp $summary;
            final /* synthetic */ CVLMethodsBlockTypeChecker this$0;
            {
                this.$entry = $entry;
                this.$declaredReturn = $declaredReturn;
                this.$summary = $summary;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SpecCallSummary.Exp invoke(@NotNull ErrorCollector<CVLError> $this$collectingErrors) {
                CVLExp typeCheckedBody;
                block19: {
                    CVLType.PureCVLType actualReturn;
                    List<VMTypeDescriptor> expectedReturn;
                    block20: {
                        void $this$forEach$iv;
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv;
                        Object it2;
                        AmbiSerializable ambiSerializable;
                        block18: {
                            List<VMTypeDescriptor> list;
                            Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                            MethodEntryTargetContract methodEntryTargetContract = this.$entry.getTarget();
                            if (methodEntryTargetContract instanceof MethodEntryTargetContract.WildcardTarget) {
                                if (!(this.$declaredReturn == null)) {
                                    String string = "Failed requirement.";
                                    throw new IllegalArgumentException(string.toString());
                                }
                                list = this.$summary.getExpectedType();
                                if (list == null) {
                                    $this$collectingErrors.returnError(new CVLError.General(this.$entry.getCvlRange(), "Wildcard method entry with summary " + this.$summary.getExp() + " must include an expected return type"));
                                    throw new KotlinNothingValueException();
                                }
                            } else if (methodEntryTargetContract instanceof MethodEntryTargetContract.SpecificTarget) {
                                if (!(this.$declaredReturn != null)) {
                                    String string = "Failed requirement.";
                                    throw new IllegalArgumentException(string.toString());
                                }
                                if (this.$summary.getExpectedType() != null) {
                                    $this$collectingErrors.collectError(new CVLError.General(this.$entry.getCvlRange(), "An exact summary target may not contain expected return type in the summary body."));
                                }
                                list = this.$declaredReturn;
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            expectedReturn = list;
                            SpecCallSummary.Exp.WithClause withClause2 = this.$summary.getWithClause();
                            if (withClause2 != null) {
                                SpecCallSummary.Exp.WithClause withClause3 = withClause2;
                                ambiSerializable = this.$entry;
                                it2 = withClause3;
                                boolean bl = false;
                                if (!Intrinsics.areEqual(((SpecCallSummary.Exp.WithClause)it2).getParam().getType(), EVMBuiltinTypes.INSTANCE.getEnv())) {
                                    $this$collectingErrors.collectError(new WithWrongType(((SpecCallSummary.Exp.WithClause)it2).getParam()));
                                }
                                if (ambiSerializable.getQualifiers().getEnvFree()) {
                                    $this$collectingErrors.collectError(new EnvfreeAndWith(((SpecCallSummary.Exp.WithClause)it2).getRange()));
                                }
                            }
                            typeCheckedBody = $this$collectingErrors.bind(CVLMethodsBlockTypeChecker.access$getExpTypeChecker$p(this.this$0).typeCheck(this.$summary.getExp(), new CVLTypeEnvironment(this.$summary.getExp().getRangeOrEmpty(), this.$summary.getExp().getScope(), ListsKt.listOf())));
                            it2 = typeCheckedBody.getCVLType();
                            CVLType.PureCVLType pureCVLType = it2 instanceof CVLType.PureCVLType ? (CVLType.PureCVLType)it2 : null;
                            if (pureCVLType == null) {
                                $this$collectingErrors.returnError(new CVLError.General(this.$entry.getCvlRange(), "Cannot summarize '" + this.$entry.getMethodParameterSignature() + "' with '" + typeCheckedBody + "'. Only CVL constructs (e.g. CVL functions or ghosts) can be used as summaries"));
                                throw new KotlinNothingValueException();
                            }
                            actualReturn = pureCVLType;
                            ambiSerializable = actualReturn;
                            if (!(ambiSerializable instanceof CVLType.PureCVLType.Void)) break block18;
                            if (!(!((Collection)expectedReturn).isEmpty())) break block19;
                            $this$collectingErrors.collectError(new CVLError.Exp(typeCheckedBody, "Summary expression returns 0 values, where " + this.$entry.prettyPrint() + " returns " + expectedReturn.size() + " values."));
                            break block19;
                        }
                        if (!(ambiSerializable instanceof CVLType.PureCVLType.TupleType)) break block20;
                        if (expectedReturn.size() != ((CVLType.PureCVLType.TupleType)actualReturn).getElements().size()) {
                            $this$collectingErrors.returnError(new CVLError.Exp(typeCheckedBody, "Summary expression returns " + ((CVLType.PureCVLType.TupleType)actualReturn).getElements().size() + " values, where " + this.$entry.prettyPrint() + " expects " + expectedReturn.size() + " values"));
                            throw new KotlinNothingValueException();
                        }
                        it2 = CollectionsKt.withIndex((Iterable)CollectionsKt.zip((Iterable)((CVLType.PureCVLType.TupleType)actualReturn).getElements(), (Iterable)expectedReturn));
                        CVLMethodsBlockTypeChecker bl = this.this$0;
                        ConcreteMethodBlockAnnotation concreteMethodBlockAnnotation = this.$entry;
                        boolean $i$f$mapNotNull = false;
                        void var10_16 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            String string;
                            VMTypeDescriptor expectedVM;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator2.next();
                            boolean bl2 = false;
                            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
                            boolean bl3 = false;
                            int ind = indexedValue.component1();
                            Pair typePair = (Pair)indexedValue.component2();
                            CVLType.PureCVLType actualCVL = (CVLType.PureCVLType)typePair.component1();
                            String string2 = CVLMethodsBlockTypeChecker.access$convertibilityErrors(bl, actualCVL, expectedVM = (VMTypeDescriptor)typePair.component2(), concreteMethodBlockAnnotation.getQualifiers().getVisibility());
                            if (string2 != null) {
                                String it3 = string2;
                                boolean bl4 = false;
                                string = "Component " + (ind + 1) + " of the summary expression has type " + actualCVL + ", where " + concreteMethodBlockAnnotation.prettyPrint() + " expected " + expectedVM + " at that position";
                            } else {
                                string = null;
                            }
                            if (string == null) continue;
                            String it$iv$iv = string;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        $this$mapNotNull$iv = (List)destination$iv$iv;
                        boolean $i$f$forEach2 = false;
                        for (E element$iv : $this$forEach$iv) {
                            String msg = (String)element$iv;
                            boolean bl6 = false;
                            $this$collectingErrors.collectError(new CVLError.Exp(typeCheckedBody, msg));
                        }
                        break block19;
                    }
                    if (expectedReturn.size() != 1) {
                        $this$collectingErrors.returnError(new CVLError.Exp(typeCheckedBody, "Summary expression returns 1 values, where " + this.$entry.prettyPrint() + " returns " + expectedReturn.size() + " values."));
                        throw new KotlinNothingValueException();
                    }
                    VMTypeDescriptor vm = (VMTypeDescriptor)IterablesKt.single((Iterable)expectedReturn);
                    String string = CVLMethodsBlockTypeChecker.access$convertibilityErrors(this.this$0, actualReturn, vm, this.$entry.getQualifiers().getVisibility());
                    if (string == null) break block19;
                    String errors2 = string;
                    boolean bl = false;
                    $this$collectingErrors.collectError(new CVLError.Exp(typeCheckedBody, "Summary expression of type " + actualReturn + " cannot be converted to the expected VM type " + vm.prettyPrint() + ": " + errors2));
                }
                return SpecCallSummary.Exp.copy$default(this.$summary, null, typeCheckedBody, null, null, null, null, null, 125, null);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkFuncForOverload(CVLSymbolTable.SymbolInfo info, BigInteger sig) {
        boolean bl;
        if (info == null) return false;
        if (!(info instanceof CVLSymbolTable.SymbolInfo.CVLFunctionInfo)) return false;
        Iterable $this$any$iv = ((CVLSymbolTable.SymbolInfo.CVLFunctionInfo)info).getImpFuncs();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            Function it2 = (Function)element$iv;
            boolean bl2 = false;
            Function function = it2;
            if (function instanceof ContractFunction) {
                bl = Intrinsics.areEqual(((ContractFunction)it2).getSigHash(), sig);
                continue;
            }
            if (!((function instanceof CVLDefinition ? true : function instanceof CVLFunction) ? true : function instanceof CVLGhostFunction)) throw new NoWhenBranchMatchedException();
            bl = false;
        } while (!bl);
        return true;
    }

    private final CollectingResult<SpecCallSummary.Dispatcher, CVLError> typeCheckDispatcherSummary(CVLSymbolTable symbolTable, SpecCallSummary.Dispatcher summary, ConcreteMethodBlockAnnotation entry2) {
        return ErrorCollector.Companion.collectingErrors((Function1)new Function1<ErrorCollector<CVLError>, SpecCallSummary.Dispatcher>(summary, entry2, this, symbolTable){
            final /* synthetic */ SpecCallSummary.Dispatcher $summary;
            final /* synthetic */ ConcreteMethodBlockAnnotation $entry;
            final /* synthetic */ CVLMethodsBlockTypeChecker this$0;
            final /* synthetic */ CVLSymbolTable $symbolTable;
            {
                this.$summary = $summary;
                this.$entry = $entry;
                this.this$0 = $receiver;
                this.$symbolTable = $symbolTable;
                super(1);
            }

            @NotNull
            public final SpecCallSummary.Dispatcher invoke(@NotNull ErrorCollector<CVLError> $this$collectingErrors) {
                Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                if (this.$summary.getSummarizeAllCalls()) {
                    String string = "A summary ALL is not allowed for dispatcher summaries, please remove the ALL keyword or add the UNRESOLVED for the summary " + this.$entry.getSummary();
                    CVLRange cVLRange = this.$entry.getCvlRange();
                    $this$collectingErrors.returnError(new CVLError.General(cVLRange, string));
                    throw new KotlinNothingValueException();
                }
                if (this.$summary.getOptimistic() && CVLMethodsBlockTypeChecker.access$matchingFunctionsInSymbolTable(this.this$0, this.$symbolTable, this.$entry.getMethodParameterSignature()).isEmpty()) {
                    $this$collectingErrors.collectError(new DispatcherSummaryNoImplementation(this.$entry.getCvlRange()));
                }
                return this.$summary;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<Function<?, ?>> matchingFunctionsInSymbolTable(CVLSymbolTable symbolTable, MethodParameterSignature methodParameterSignatureInCVLSpec) {
        void $this$flatMapTo$iv$iv;
        List<CVLScope> scopes = symbolTable.getAllContractScopes();
        Iterable $this$flatMap$iv = scopes;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            CVLScope scope = (CVLScope)element$iv$iv;
            boolean bl = false;
            CVLSymbolTable.SymbolInfo symbolTableElement = symbolTable.lookUpFunctionLikeSymbol(methodParameterSignatureInCVLSpec.getFunctionName(), scope);
            if (symbolTableElement instanceof CVLSymbolTable.SymbolInfo.CVLFunctionInfo) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Iterable iterable2 = ((CVLSymbolTable.SymbolInfo.CVLFunctionInfo)symbolTableElement).getImpFuncs();
                boolean $i$f$filterIsInstance = false;
                void var16_16 = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv2 instanceof ContractFunction)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv2;
                boolean $i$f$filter = false;
                $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    ContractFunction impFunc = (ContractFunction)element$iv$iv2;
                    boolean bl2 = false;
                    if (!impFunc.getMethodSignature().matchesNameAndParams(methodParameterSignatureInCVLSpec)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                list = (List)destination$iv$iv2;
            } else {
                list = ListsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final CollectingResult<SpecCallSummary.DispatchList, CVLError> typeCheckDispatchListSummary(CVLSymbolTable symbolTable, SpecCallSummary.DispatchList dispatchList) {
        return ErrorCollector.Companion.collectingErrors((Function1)new Function1<ErrorCollector<CVLError>, SpecCallSummary.DispatchList>(dispatchList, symbolTable, this){
            final /* synthetic */ SpecCallSummary.DispatchList $dispatchList;
            final /* synthetic */ CVLSymbolTable $symbolTable;
            final /* synthetic */ CVLMethodsBlockTypeChecker this$0;
            {
                this.$dispatchList = $dispatchList;
                this.$symbolTable = $symbolTable;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SpecCallSummary.DispatchList invoke(@NotNull ErrorCollector<CVLError> $this$collectingErrors) {
                Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                if (!(this.$dispatchList.getSummarizationMode() == SpecCallSummary.SummarizationMode.UNRESOLVED_ONLY)) {
                    boolean $i$a$-check-CVLMethodsBlockTypeChecker$typeCheckDispatchListSummary$1$42 = false;
                    String $i$a$-check-CVLMethodsBlockTypeChecker$typeCheckDispatchListSummary$1$42 = "Dispatch list should only be applied to unresolved summaries.";
                    throw new IllegalStateException($i$a$-check-CVLMethodsBlockTypeChecker$typeCheckDispatchListSummary$1$42.toString());
                }
                for (SpecCallSummary.DispatchList.Pattern p2 : this.$dispatchList.getDispatcherList()) {
                    SpecCallSummary.DispatchList.Pattern pattern = p2;
                    if (pattern instanceof SpecCallSummary.DispatchList.Pattern.QualifiedMethod) {
                        if (!(((SpecCallSummary.DispatchList.Pattern.QualifiedMethod)p2).getSig().getSighashInt() != null)) {
                            boolean $i$a$-check-CVLMethodsBlockTypeChecker$typeCheckDispatchListSummary$1$52 = false;
                            String $i$a$-check-CVLMethodsBlockTypeChecker$typeCheckDispatchListSummary$1$52 = "Expecting to always know sighash of methods in dispatch list patterns";
                            throw new IllegalStateException($i$a$-check-CVLMethodsBlockTypeChecker$typeCheckDispatchListSummary$1$52.toString());
                        }
                        if (this.$symbolTable.getContractScope(((SpecCallSummary.DispatchList.Pattern.QualifiedMethod)p2).getSig().getQualifiedMethodName().getHost()) == null) {
                            $this$collectingErrors.collectError(new DispatchListContractNotFound((SpecCallSummary.DispatchList.Pattern.QualifiedMethod)p2));
                            continue;
                        }
                        CVLSymbolTable.SymbolInfo info = this.$symbolTable.lookupMethodInContractEnv(((SpecCallSummary.DispatchList.Pattern.QualifiedMethod)p2).getSig().getQualifiedMethodName().getHost(), ((SpecCallSummary.DispatchList.Pattern.QualifiedMethod)p2).getSig().getQualifiedMethodName().getMethodId());
                        SighashInt sighashInt = ((SpecCallSummary.DispatchList.Pattern.QualifiedMethod)p2).getSig().getSighashInt();
                        Intrinsics.checkNotNull(sighashInt);
                        if (CVLMethodsBlockTypeChecker.access$checkFuncForOverload(this.this$0, info, sighashInt.getN())) continue;
                        $this$collectingErrors.collectError(new DispatchListNoMatchingMethodFound((SpecCallSummary.DispatchList.Pattern.QualifiedMethod)p2));
                        continue;
                    }
                    if (pattern instanceof SpecCallSummary.DispatchList.Pattern.WildcardContract) {
                        boolean anyMatching;
                        boolean bl;
                        block10: {
                            void $this$any$iv;
                            if (!(((SpecCallSummary.DispatchList.Pattern.WildcardContract)p2).getSig().getSighashInt() != null)) {
                                boolean $i$a$-check-CVLMethodsBlockTypeChecker$typeCheckDispatchListSummary$1$62 = false;
                                String $i$a$-check-CVLMethodsBlockTypeChecker$typeCheckDispatchListSummary$1$62 = "Expecting to always know sighash of methods in dispatch list patterns";
                                throw new IllegalStateException($i$a$-check-CVLMethodsBlockTypeChecker$typeCheckDispatchListSummary$1$62.toString());
                            }
                            List<CVLScope> scopes = this.$symbolTable.getAllContractScopes();
                            Iterable iterable = scopes;
                            CVLSymbolTable cVLSymbolTable = this.$symbolTable;
                            CVLMethodsBlockTypeChecker cVLMethodsBlockTypeChecker = this.this$0;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    CVLScope scope = (CVLScope)element$iv;
                                    boolean bl2 = false;
                                    CVLSymbolTable.SymbolInfo info = cVLSymbolTable.lookUpFunctionLikeSymbol(((SpecCallSummary.DispatchList.Pattern.WildcardContract)p2).getSig().getFunctionName(), scope);
                                    SighashInt sighashInt = ((SpecCallSummary.DispatchList.Pattern.WildcardContract)p2).getSig().getSighashInt();
                                    Intrinsics.checkNotNull(sighashInt);
                                    if (!CVLMethodsBlockTypeChecker.access$checkFuncForOverload(cVLMethodsBlockTypeChecker, info, sighashInt.getN())) continue;
                                    bl = true;
                                    break block10;
                                }
                                bl = false;
                            }
                        }
                        if (anyMatching = bl) continue;
                        $this$collectingErrors.collectError(new DispatchListNoMatchingMethodFound((SpecCallSummary.DispatchList.Pattern.WildcardContract)p2));
                        continue;
                    }
                    if (!(pattern instanceof SpecCallSummary.DispatchList.Pattern.WildcardMethod) || this.$symbolTable.getContractNameFromContractId(((SpecCallSummary.DispatchList.Pattern.WildcardMethod)p2).getContract().getContract()) != null) continue;
                    $this$collectingErrors.collectError(new DispatchListContractNotFound((SpecCallSummary.DispatchList.Pattern.WildcardMethod)p2));
                }
                return this.$dispatchList;
            }
        });
    }

    private final String convertibilityErrors(CVLType.PureCVLType from, VMTypeDescriptor to, Visibility visibility) {
        KFunction<CollectingResult<ITypeDescriptorConverter<IConverterOutput, ICVLDataInput, Object>, String>> kFunction;
        switch (WhenMappings.$EnumSwitchMapping$0[visibility.ordinal()]) {
            case 1: {
                kFunction = ToVMContext.InternalSummaryReturn.INSTANCE.getVisitor();
                break;
            }
            case 2: {
                kFunction = ToVMContext.ExternalSummaryReturn.INSTANCE.getVisitor();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KFunction<CollectingResult<ITypeDescriptorConverter<IConverterOutput, ICVLDataInput, Object>, String>> visitor = kFunction;
        List<String> list = to.converterFrom(from, (Function1)((Object)visitor)).errorOrNull();
        return list != null ? CollectionsKt.joinToString$default(list, null, null, null, 0, null, null, 63, null) : null;
    }

    public static final /* synthetic */ CollectingResult access$typeCheckReturnsClause(CVLMethodsBlockTypeChecker $this, ConcreteMethodBlockAnnotation entry2) {
        return $this.typeCheckReturnsClause(entry2);
    }

    public static final /* synthetic */ CollectingResult access$typeCheckSummary(CVLMethodsBlockTypeChecker $this, CVLSymbolTable symbolTable, SpecCallSummary.ExpressibleInCVL summary, List res2, ConcreteMethodBlockAnnotation entry2) {
        return $this.typeCheckSummary(symbolTable, summary, res2, entry2);
    }

    public static final /* synthetic */ CVLExpTypeChecker access$getExpTypeChecker$p(CVLMethodsBlockTypeChecker $this) {
        return $this.expTypeChecker;
    }

    public static final /* synthetic */ String access$convertibilityErrors(CVLMethodsBlockTypeChecker $this, CVLType.PureCVLType from, VMTypeDescriptor to, Visibility visibility) {
        return $this.convertibilityErrors(from, to, visibility);
    }

    public static final /* synthetic */ List access$matchingFunctionsInSymbolTable(CVLMethodsBlockTypeChecker $this, CVLSymbolTable symbolTable, MethodParameterSignature methodParameterSignatureInCVLSpec) {
        return $this.matchingFunctionsInSymbolTable(symbolTable, methodParameterSignatureInCVLSpec);
    }

    public static final /* synthetic */ boolean access$checkFuncForOverload(CVLMethodsBlockTypeChecker $this, CVLSymbolTable.SymbolInfo info, BigInteger sig) {
        return $this.checkFuncForOverload(info, sig);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Visibility.values().length];
            try {
                nArray[Visibility.INTERNAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Visibility.EXTERNAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

