/*
 * Decompiled with CFR 0.152.
 */
package spec.errors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLRange;
import utils.SourcePosition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001d\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lspec/errors/ErrorExample;", "", "lines", "", "", "range", "Lspec/cvlast/CVLRange$Range;", "(Ljava/util/List;Lspec/cvlast/CVLRange$Range;)V", "getRange", "()Lspec/cvlast/CVLRange$Range;", "text", "getText", "()Ljava/lang/String;", "renderWithRange", "Companion", "Shared"})
public final class ErrorExample {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> lines;
    @NotNull
    private final CVLRange.Range range;
    @NotNull
    private final String text;
    public static final char DELIMITER = '#';

    private ErrorExample(List<String> lines, CVLRange.Range range) {
        this.lines = lines;
        this.range = range;
        this.text = CollectionsKt.joinToString$default(this.lines, "", null, null, 0, null, null, 62, null);
    }

    @NotNull
    public final CVLRange.Range getRange() {
        return this.range;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final String renderWithRange(@NotNull CVLRange.Range range) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(range, "range");
        StringBuilder $this$renderWithRange_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int startLine = range.getStart().getLine-pVg5ArA();
        int startChar = range.getStart().getCharByteOffset-pVg5ArA();
        int endLine = range.getEnd().getLine-pVg5ArA();
        int endChar = range.getEnd().getCharByteOffset-pVg5ArA();
        $this$renderWithRange_u24lambda_u240.append(CollectionsKt.joinToString$default(this.lines.subList(0, range.getStart().getLine-pVg5ArA()), "", null, null, 0, null, null, 62, null));
        $this$renderWithRange_u24lambda_u240.append(StringsKt.substring(this.lines.get(startLine), RangesKt.until(0, startChar)));
        $this$renderWithRange_u24lambda_u240.append('#');
        if (range.getStart().getLine-pVg5ArA() == range.getEnd().getLine-pVg5ArA()) {
            $this$renderWithRange_u24lambda_u240.append(StringsKt.substring(this.lines.get(startLine), RangesKt.until(startChar, endChar)));
        } else {
            String string = this.lines.get(startLine).substring(startChar);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            $this$renderWithRange_u24lambda_u240.append(string);
            $this$renderWithRange_u24lambda_u240.append(CollectionsKt.joinToString$default(this.lines.subList(startLine + 1, endLine), "", null, null, 0, null, null, 62, null));
            String string2 = this.lines.get(endLine).substring(0, endChar);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            $this$renderWithRange_u24lambda_u240.append(string2);
        }
        $this$renderWithRange_u24lambda_u240.append('#');
        String string = this.lines.get(endLine).substring(endChar);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        $this$renderWithRange_u24lambda_u240.append(string);
        $this$renderWithRange_u24lambda_u240.append("");
        $this$renderWithRange_u24lambda_u240.append(CollectionsKt.joinToString$default(this.lines.subList(range.getEnd().getLine-pVg5ArA() + 1, this.lines.size()), "", null, null, 0, null, null, 62, null));
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    public /* synthetic */ ErrorExample(List lines, CVLRange.Range range, DefaultConstructorMarker $constructor_marker) {
        this(lines, range);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0086\u0002J(\u0010\n\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\t\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lspec/errors/ErrorExample$Companion;", "", "()V", "DELIMITER", "", "invoke", "Lspec/errors/ErrorExample;", "sourceName", "", "delimitedText", "stripDelimiters", "Lkotlin/Pair;", "", "Lutils/SourcePosition;", "Shared"})
    @SourceDebugExtension(value={"SMAP\nErrorExample.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorExample.kt\nspec/errors/ErrorExample$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1174#2,2:86\n1549#3:88\n1620#3,3:89\n*S KotlinDebug\n*F\n+ 1 ErrorExample.kt\nspec/errors/ErrorExample$Companion\n*L\n36#1:86,2\n52#1:88\n52#1:89,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ErrorExample invoke(@NotNull String sourceName, @NotNull String delimitedText) {
            boolean bl;
            Intrinsics.checkNotNullParameter(sourceName, "sourceName");
            Intrinsics.checkNotNullParameter(delimitedText, "delimitedText");
            Pair<List<String>, List<SourcePosition>> pair2 = this.stripDelimiters(delimitedText);
            List<String> lines = pair2.component1();
            List<SourcePosition> delimiters = pair2.component2();
            boolean bl2 = bl = delimiters.size() == 2;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = StringsKt.trimIndent("\n                CVL Examples must contain exactly two `#` characters; but " + sourceName + " contains " + delimiters.size() + ":\n                " + StringsKt.prependIndent(delimitedText, "  \u2503 ") + "\n                ");
                throw new AssertionError((Object)string);
            }
            return new ErrorExample(lines, new CVLRange.Range(sourceName, delimiters.get(0), delimiters.get(1)), null);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<List<String>, List<SourcePosition>> stripDelimiters(String delimitedText) {
            void $this$mapTo$iv$iv;
            int line = 0;
            line = 0;
            int col = 0;
            col = 0;
            StringBuilder[] stringBuilderArray = new StringBuilder[]{new StringBuilder()};
            List<StringBuilder> lines = CollectionsKt.mutableListOf(stringBuilderArray);
            List delimiters = new ArrayList();
            CharSequence $this$forEach$iv = delimitedText;
            boolean $i$f$forEach = false;
            for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                char element$iv;
                char it2 = element$iv = $this$forEach$iv.charAt(i);
                boolean bl = false;
                char c = it2;
                if (c == '#') {
                    delimiters.add(new SourcePosition(line, col, null));
                    continue;
                }
                if (c == '\n') {
                    col = 0;
                    line = UInt.constructor-impl(line + 1);
                    CollectionsKt.last(lines).append(it2);
                    lines.add(new StringBuilder());
                    continue;
                }
                CollectionsKt.last(lines).append(it2);
                col = UInt.constructor-impl(col + 1);
            }
            Iterable $this$map$iv = lines;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                StringBuilder stringBuilder = (StringBuilder)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it3.toString());
            }
            return TuplesKt.to((List)destination$iv$iv, delimiters);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

