/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u0010\u001a\u00020\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lutils/CanonFile;", "", "path", "", "(Ljava/lang/String;)V", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "canon", "getCanon", "()Ljava/io/File;", "equals", "", "other", "exists", "hashCode", "", "toString", "Shared"})
public final class CanonFile {
    @NotNull
    private final File canon;

    public CanonFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        File file2 = file.getCanonicalFile();
        Intrinsics.checkNotNullExpressionValue(file2, "getCanonicalFile(...)");
        this.canon = file2;
    }

    @NotNull
    public final File getCanon() {
        return this.canon;
    }

    public CanonFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        this(new File(path));
    }

    public CanonFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
        this(file);
    }

    public final boolean exists() {
        return this.canon.exists();
    }

    @NotNull
    public String toString() {
        String string = this.canon.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public int hashCode() {
        return this.canon.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof CanonFile) ? false : Intrinsics.areEqual(this.canon, ((CanonFile)other).canon));
    }
}

