// Generated by paddle/phi/api/generator/tensor_operants_gen.py

#pragma once

#include "paddle/phi/api/include/operants_base.h"
#include "paddle/phi/api/include/tensor.h"
#include "paddle/phi/common/scalar.h"
#include "paddle/phi/common/int_array.h"
#include "paddle/common/macros.h"


namespace paddle {

namespace operants {

using Scalar = paddle::experimental::Scalar;
using IntArray = paddle::experimental::IntArray;

class PhiTensorOperants : public TensorOperantsBase {
 private:
  DISABLE_COPY_AND_ASSIGN(PhiTensorOperants);

 public:
  PhiTensorOperants() = default;

  Tensor add(const Tensor& x, const Scalar& y);

  Tensor subtract(const Tensor& x, const Scalar& y);

  Tensor multiply(const Tensor& x, const Scalar& y);

  Tensor divide(const Tensor& x, const Scalar& y);

  Tensor add(const Scalar& x, const Tensor& y);

  Tensor subtract(const Scalar& x, const Tensor& y);

  Tensor multiply(const Scalar& x, const Tensor& y);

  Tensor divide(const Scalar& x, const Tensor& y);

  Tensor pow(const Tensor& x, const Tensor& y);

  Tensor pow(const Tensor& x, const Scalar& y);


  Tensor abs(const Tensor& x);

  Tensor bitwise_and(const Tensor& x, const Tensor& y);

  Tensor bitwise_not(const Tensor& x);

  Tensor bitwise_or(const Tensor& x, const Tensor& y);

  Tensor bitwise_xor(const Tensor& x, const Tensor& y);

  Tensor exp(const Tensor& x);

  Tensor expand(const Tensor& x, const IntArray& shape = {});

  Tensor floor(const Tensor& x);

  Tensor gather_nd(const Tensor& x, const Tensor& index);

  Tensor log(const Tensor& x);

  Tensor max(const Tensor& x, const IntArray& axis = {}, bool keepdim = false);

  Tensor roll(const Tensor& x, const IntArray& shifts = {}, const std::vector<int64_t>& axis = {});

  Tensor scale(const Tensor& x, const Scalar& scale = 1.0, const Scalar& bias = 0.0, bool bias_after_scale = true);

  Tensor scatter(const Tensor& x, const Tensor& index, const Tensor& updates, bool overwrite = true);

  Tensor scatter_nd_add(const Tensor& x, const Tensor& index, const Tensor& updates);

  Tensor sum(const Tensor& x, const IntArray& axis = {}, DataType dtype = DataType::UNDEFINED, bool keepdim = false);

  Tensor add(const Tensor& x, const Tensor& y);

  Tensor assign(const Tensor& x);

  Tensor divide(const Tensor& x, const Tensor& y);

  Tensor elementwise_pow(const Tensor& x, const Tensor& y);

  Tensor equal(const Tensor& x, const Tensor& y);

  Tensor greater_equal(const Tensor& x, const Tensor& y);

  Tensor greater_than(const Tensor& x, const Tensor& y);

  Tensor less_equal(const Tensor& x, const Tensor& y);

  Tensor less_than(const Tensor& x, const Tensor& y);

  Tensor matmul(const Tensor& x, const Tensor& y, bool transpose_x = false, bool transpose_y = false);

  Tensor maximum(const Tensor& x, const Tensor& y);

  Tensor minimum(const Tensor& x, const Tensor& y);

  Tensor multiply(const Tensor& x, const Tensor& y);

  Tensor not_equal(const Tensor& x, const Tensor& y);

  Tensor subtract(const Tensor& x, const Tensor& y);

  Tensor tile(const Tensor& x, const IntArray& repeat_times = {});
};

}  // namespace operants
}  // namespace paddle

