# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from cognite.seismic.protos import types_pb2 as cognite_dot_seismic_dot_protos_dot_types__pb2
from cognite.seismic.protos.v1 import seismic_service_datatypes_pb2 as cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2
from cognite.seismic.protos.v1 import seismic_service_messages_pb2 as cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2


class SeismicAPIStub(object):
    """*
    Service for querying data and metadata from seismic tracestore in Cognite Data Fusion (CDF) seismic datastore.

    Queries are done primarily on cubes, with some management endpoints for tracestores & partitions.

    Queries are divided in:
    Metadata: General information and headers for surveys and files
    Trace: Retrieve traces, be it by geometry, line or volume
    Artificial sampling: Get the (calculated/interpolated) values of properties in the file/tracestore given arbitrary positions
    Metadata queries
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.CreateSurvey = channel.unary_unary(
                '/com.cognite.seismic.v1.SeismicAPI/CreateSurvey',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.CreateSurveyRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Survey.FromString,
                )
        self.SearchSurveys = channel.unary_stream(
                '/com.cognite.seismic.v1.SeismicAPI/SearchSurveys',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchSurveysRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchSurveyResponse.FromString,
                )
        self.EditSurvey = channel.unary_unary(
                '/com.cognite.seismic.v1.SeismicAPI/EditSurvey',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.EditSurveyRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Survey.FromString,
                )
        self.DeleteSurvey = channel.unary_unary(
                '/com.cognite.seismic.v1.SeismicAPI/DeleteSurvey',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSurveyRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSurveyResponse.FromString,
                )
        self.CreateSeismic = channel.unary_unary(
                '/com.cognite.seismic.v1.SeismicAPI/CreateSeismic',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.CreateSeismicRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Seismic.FromString,
                )
        self.SearchSeismics = channel.unary_stream(
                '/com.cognite.seismic.v1.SeismicAPI/SearchSeismics',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchSeismicsRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Seismic.FromString,
                )
        self.EditSeismic = channel.unary_unary(
                '/com.cognite.seismic.v1.SeismicAPI/EditSeismic',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.EditSeismicRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Seismic.FromString,
                )
        self.DeleteSeismic = channel.unary_unary(
                '/com.cognite.seismic.v1.SeismicAPI/DeleteSeismic',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSeismicRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSeismicResponse.FromString,
                )
        self.SearchSeismicStores = channel.unary_stream(
                '/com.cognite.seismic.v1.SeismicAPI/SearchSeismicStores',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchSeismicStoresRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.SeismicStore.FromString,
                )
        self.EditSeismicStore = channel.unary_unary(
                '/com.cognite.seismic.v1.SeismicAPI/EditSeismicStore',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.EditSeismicStoreRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.SeismicStore.FromString,
                )
        self.DeleteSeismicStore = channel.unary_unary(
                '/com.cognite.seismic.v1.SeismicAPI/DeleteSeismicStore',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSeismicStoreRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSeismicStoreResponse.FromString,
                )
        self.CreatePartition = channel.unary_unary(
                '/com.cognite.seismic.v1.SeismicAPI/CreatePartition',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.CreatePartitionRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Partition.FromString,
                )
        self.SearchPartitions = channel.unary_stream(
                '/com.cognite.seismic.v1.SeismicAPI/SearchPartitions',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchPartitionsRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Partition.FromString,
                )
        self.EditPartition = channel.unary_unary(
                '/com.cognite.seismic.v1.SeismicAPI/EditPartition',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.EditPartitionRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Partition.FromString,
                )
        self.DeletePartition = channel.unary_unary(
                '/com.cognite.seismic.v1.SeismicAPI/DeletePartition',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeletePartitionRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeletePartitionResponse.FromString,
                )
        self.GetVolume = channel.unary_stream(
                '/com.cognite.seismic.v1.SeismicAPI/GetVolume',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.VolumeRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
                )
        self.GetSegYFile = channel.unary_stream(
                '/com.cognite.seismic.v1.SeismicAPI/GetSegYFile',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SegYSeismicRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SegYSeismicResponse.FromString,
                )
        self.SearchFiles = channel.unary_stream(
                '/com.cognite.seismic.v1.SeismicAPI/SearchFiles',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchFilesRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.SourceSegyFile.FromString,
                )
        self.SearchJobStatus = channel.unary_stream(
                '/com.cognite.seismic.v1.SeismicAPI/SearchJobStatus',
                request_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchJobStatusRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.JobStatusResponse.FromString,
                )


class SeismicAPIServicer(object):
    """*
    Service for querying data and metadata from seismic tracestore in Cognite Data Fusion (CDF) seismic datastore.

    Queries are done primarily on cubes, with some management endpoints for tracestores & partitions.

    Queries are divided in:
    Metadata: General information and headers for surveys and files
    Trace: Retrieve traces, be it by geometry, line or volume
    Artificial sampling: Get the (calculated/interpolated) values of properties in the file/tracestore given arbitrary positions
    Metadata queries
    """

    def CreateSurvey(self, request, context):
        """*
        Creates a Survey object in the data model. A Survey object represents a grouping of seismic data
        in the same area and normally sharing acquisition and most processing parameters.
        Capabilities: Requires Seismic:WRITE capability to the CDF tenant.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SearchSurveys(self, request, context):
        """*
        Lists all surveys accessible to the client. Optionally includes Cubes associated with the surveys.

        Can optionally search surveys based on both/either of two criteria:
        Coverage polygon of files in the survey are within an area delimited by a specified polygon
        Filters on metadata of both the survey and the file
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def EditSurvey(self, request, context):
        """*
        Modify the metadata for a survey.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeleteSurvey(self, request, context):
        """*
        Deletes a specified survey. Must have ALL scope and Write capabilities.

        In the case of Surveys, the "name" should be input into the external_ids field of the Identifier.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateSeismic(self, request, context):
        """*
        Create new Seismics and assign them to partitions.
        Seismics are mostly immutable save for their name and metadata. The user needs to delete an existing cutout and create a new one
        if e.g. the definition or the seismic store must be changed
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SearchSeismics(self, request, context):
        """*
        Returns Seismic metadata given its id.
        Can optionally retrieve seismic store & partition info if user has the right scope.
        Use GetVolume to retrieve traces.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def EditSeismic(self, request, context):
        """*
        Edit the specified seismic. Seismic object names and metadata can be changed.
        The cutout definition, however, cannot be changed.
        To modify the definition or the owning partition, delete the seismic object
        and create a new one.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeleteSeismic(self, request, context):
        """*
        Delete seismic objects.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SearchSeismicStores(self, request, context):
        """*
        Search and retrieve seismic stores. Can only retrieve seismic stores you own.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def EditSeismicStore(self, request, context):
        """*
        Set the name of a seismic store object.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeleteSeismicStore(self, request, context):
        """*
        Delete a seismic store. If any seismics still reference the specified seismic store, the request will fail.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreatePartition(self, request, context):
        """*
        Create a data partition, optionally setting a name.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SearchPartitions(self, request, context):
        """*
        Returns the partition(s) specified, with the same search options as the other search endpoints.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def EditPartition(self, request, context):
        """*
        Edit partitions. The only modifiable field is the name
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeletePartition(self, request, context):
        """*
        Delete the specified partition, and return whether it was successfully deleted.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetVolume(self, request, context):
        """*
        Request a volume of traces by range of inlines, crosslines and time
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetSegYFile(self, request, context):
        """*
        Fetch seismic data in SEG-Y format.
        The stream of responses each contain a byte array that must be written sequentially to a
        file to produce a SEG-Y file. The ordering of traces in the output is unspecified.

        The request object can be used to specify whether the file should contain the whole set
        of traces in the source dataset or a subset of the traces (ie. a cropped file). See
        SegYSeismicRequest for more information.
        Returns a stream of SegYSeismicResponse objects, each containing a fragment of a SEG-Y
        data stream.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SearchFiles(self, request, context):
        """*
        Retrieves File objects describing the seismic files registered with the tenant.
        Search criteria can be specified in the SearchFilesRequest, restricting the data retrieved
        to a subset of the files in the tenant. See SearchFilesRequest for more information.
        Returns a stream of file objects, terminating all files matching the search criteria have been
        returned.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SearchJobStatus(self, request, context):
        """*
        Retrieves ingestion job statuses, filtered by the specified criteria.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_SeismicAPIServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'CreateSurvey': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateSurvey,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.CreateSurveyRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Survey.SerializeToString,
            ),
            'SearchSurveys': grpc.unary_stream_rpc_method_handler(
                    servicer.SearchSurveys,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchSurveysRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchSurveyResponse.SerializeToString,
            ),
            'EditSurvey': grpc.unary_unary_rpc_method_handler(
                    servicer.EditSurvey,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.EditSurveyRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Survey.SerializeToString,
            ),
            'DeleteSurvey': grpc.unary_unary_rpc_method_handler(
                    servicer.DeleteSurvey,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSurveyRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSurveyResponse.SerializeToString,
            ),
            'CreateSeismic': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateSeismic,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.CreateSeismicRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Seismic.SerializeToString,
            ),
            'SearchSeismics': grpc.unary_stream_rpc_method_handler(
                    servicer.SearchSeismics,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchSeismicsRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Seismic.SerializeToString,
            ),
            'EditSeismic': grpc.unary_unary_rpc_method_handler(
                    servicer.EditSeismic,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.EditSeismicRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Seismic.SerializeToString,
            ),
            'DeleteSeismic': grpc.unary_unary_rpc_method_handler(
                    servicer.DeleteSeismic,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSeismicRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSeismicResponse.SerializeToString,
            ),
            'SearchSeismicStores': grpc.unary_stream_rpc_method_handler(
                    servicer.SearchSeismicStores,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchSeismicStoresRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.SeismicStore.SerializeToString,
            ),
            'EditSeismicStore': grpc.unary_unary_rpc_method_handler(
                    servicer.EditSeismicStore,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.EditSeismicStoreRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.SeismicStore.SerializeToString,
            ),
            'DeleteSeismicStore': grpc.unary_unary_rpc_method_handler(
                    servicer.DeleteSeismicStore,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSeismicStoreRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSeismicStoreResponse.SerializeToString,
            ),
            'CreatePartition': grpc.unary_unary_rpc_method_handler(
                    servicer.CreatePartition,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.CreatePartitionRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Partition.SerializeToString,
            ),
            'SearchPartitions': grpc.unary_stream_rpc_method_handler(
                    servicer.SearchPartitions,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchPartitionsRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Partition.SerializeToString,
            ),
            'EditPartition': grpc.unary_unary_rpc_method_handler(
                    servicer.EditPartition,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.EditPartitionRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Partition.SerializeToString,
            ),
            'DeletePartition': grpc.unary_unary_rpc_method_handler(
                    servicer.DeletePartition,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeletePartitionRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeletePartitionResponse.SerializeToString,
            ),
            'GetVolume': grpc.unary_stream_rpc_method_handler(
                    servicer.GetVolume,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.VolumeRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.SerializeToString,
            ),
            'GetSegYFile': grpc.unary_stream_rpc_method_handler(
                    servicer.GetSegYFile,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SegYSeismicRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SegYSeismicResponse.SerializeToString,
            ),
            'SearchFiles': grpc.unary_stream_rpc_method_handler(
                    servicer.SearchFiles,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchFilesRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.SourceSegyFile.SerializeToString,
            ),
            'SearchJobStatus': grpc.unary_stream_rpc_method_handler(
                    servicer.SearchJobStatus,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchJobStatusRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.JobStatusResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'com.cognite.seismic.v1.SeismicAPI', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class SeismicAPI(object):
    """*
    Service for querying data and metadata from seismic tracestore in Cognite Data Fusion (CDF) seismic datastore.

    Queries are done primarily on cubes, with some management endpoints for tracestores & partitions.

    Queries are divided in:
    Metadata: General information and headers for surveys and files
    Trace: Retrieve traces, be it by geometry, line or volume
    Artificial sampling: Get the (calculated/interpolated) values of properties in the file/tracestore given arbitrary positions
    Metadata queries
    """

    @staticmethod
    def CreateSurvey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.v1.SeismicAPI/CreateSurvey',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.CreateSurveyRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Survey.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SearchSurveys(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.v1.SeismicAPI/SearchSurveys',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchSurveysRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchSurveyResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def EditSurvey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.v1.SeismicAPI/EditSurvey',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.EditSurveyRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Survey.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeleteSurvey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.v1.SeismicAPI/DeleteSurvey',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSurveyRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSurveyResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def CreateSeismic(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.v1.SeismicAPI/CreateSeismic',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.CreateSeismicRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Seismic.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SearchSeismics(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.v1.SeismicAPI/SearchSeismics',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchSeismicsRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Seismic.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def EditSeismic(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.v1.SeismicAPI/EditSeismic',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.EditSeismicRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Seismic.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeleteSeismic(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.v1.SeismicAPI/DeleteSeismic',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSeismicRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSeismicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SearchSeismicStores(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.v1.SeismicAPI/SearchSeismicStores',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchSeismicStoresRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.SeismicStore.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def EditSeismicStore(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.v1.SeismicAPI/EditSeismicStore',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.EditSeismicStoreRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.SeismicStore.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeleteSeismicStore(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.v1.SeismicAPI/DeleteSeismicStore',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSeismicStoreRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeleteSeismicStoreResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def CreatePartition(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.v1.SeismicAPI/CreatePartition',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.CreatePartitionRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Partition.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SearchPartitions(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.v1.SeismicAPI/SearchPartitions',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchPartitionsRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Partition.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def EditPartition(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.v1.SeismicAPI/EditPartition',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.EditPartitionRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.Partition.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeletePartition(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.v1.SeismicAPI/DeletePartition',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeletePartitionRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.DeletePartitionResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetVolume(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.v1.SeismicAPI/GetVolume',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.VolumeRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_types__pb2.Trace.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetSegYFile(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.v1.SeismicAPI/GetSegYFile',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SegYSeismicRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SegYSeismicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SearchFiles(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.v1.SeismicAPI/SearchFiles',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchFilesRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__datatypes__pb2.SourceSegyFile.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SearchJobStatus(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.cognite.seismic.v1.SeismicAPI/SearchJobStatus',
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.SearchJobStatusRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_v1_dot_seismic__service__messages__pb2.JobStatusResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
