"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_verifiedpermissions_1 = require("aws-cdk-lib/aws-verifiedpermissions");
const core_1 = require("aws-cdk-lib/core");
class PolicyTemplateBase extends core_1.Resource {
}
class PolicyTemplate extends PolicyTemplateBase {
    /**
     * Create a PolicyTemplate construct that represents an external policy template via policy template id.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param policyTemplateId The PolicyTemplate's id.
     */
    static fromPolicyTemplateId(scope, id, policyTemplateId) {
        return PolicyTemplate.fromPolicyTemplateAttributes(scope, id, {
            policyTemplateId,
        });
    }
    /**
     * Creates a PolicyTemplate construct that represents an external Policy Template.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs A `PolicyTemplateAttributes` object.
     */
    static fromPolicyTemplateAttributes(scope, id, attrs) {
        class Import extends PolicyTemplateBase {
            constructor(policyTemplateId) {
                super(scope, id);
                this.policyTemplateId = policyTemplateId;
            }
        }
        let policyTemplateId;
        policyTemplateId = attrs.policyTemplateId;
        return new Import(policyTemplateId);
    }
    constructor(scope, id, props) {
        super(scope, id);
        this.policyTemplate = new aws_verifiedpermissions_1.CfnPolicyTemplate(this, id, {
            statement: props.statement,
            description: props.description,
            policyStoreId: props.policyStore.policyStoreId,
        });
        this.policyTemplateId = this.policyTemplate.attrPolicyTemplateId;
        this.statement = this.policyTemplate.statement;
        this.description = props.description;
        this.policyStore = props.policyStore;
    }
}
exports.PolicyTemplate = PolicyTemplate;
_a = JSII_RTTI_SYMBOL_1;
PolicyTemplate[_a] = { fqn: "@cdklabs/cdk-verified-permissions.PolicyTemplate", version: "0.0.1-alpha.2" };
//# sourceMappingURL=data:application/json;base64,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