"""
Python module generated from Java source file com.google.common.base.Objects

Java source file obtained from artifact guava version 32.1.2-jre

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from com.google.common.annotations import GwtCompatible
from com.google.common.base import *
from java.util import Arrays
from javax.annotation import CheckForNull
from org.checkerframework.checker.nullness.qual import Nullable
from typing import Any, Callable, Iterable, Tuple


class Objects(ExtraObjectsMethodsForWeb):
    """
    Helper functions that can operate on any `Object`.
    
    See the Guava User Guide on <a
    href="https://github.com/google/guava/wiki/CommonObjectUtilitiesExplained">writing `Object`
    methods with `Objects`</a>.

    Author(s)
    - Laurence Gonsalves

    Since
    - 2.0
    """

    @staticmethod
    def equal(a: "Object", b: "Object") -> bool:
        """
        Determines whether two possibly-null objects are equal. Returns:
        
        
          - `True` if `a` and `b` are both null.
          - `True` if `a` and `b` are both non-null and they are equal according to
              Object.equals(Object).
          - `False` in all other situations.
        
        
        This assumes that any non-null objects passed to this function conform to the `equals()` contract.
        
        **Note for Java 7 and later:** This method should be treated as deprecated; use java.util.Objects.equals instead.
        """
        ...


    @staticmethod
    def hashCode(*objects: Tuple["Object", ...]) -> int:
        """
        Generates a hash code for multiple values. The hash code is generated by calling Arrays.hashCode(Object[]). Note that array arguments to this method, with the exception of a
        single Object array, do not get any special handling; their hash codes are based on identity
        and not contents.
        
        This is useful for implementing Object.hashCode(). For example, in an object that
        has three properties, `x`, `y`, and `z`, one could write:
        
        ````public int hashCode() {
          return Objects.hashCode(getX(), getY(), getZ());`
        }```
        
        **Warning:** When a single object is supplied, the returned hash code does not equal the
        hash code of that object.
        
        **Note for Java 7 and later:** This method should be treated as deprecated; use java.util.Objects.hash instead.
        """
        ...
