"""
Python module generated from Java source file com.google.common.collect.ImmutableClassToInstanceMap

Java source file obtained from artifact guava version 32.1.2-jre

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from com.google.common.annotations import GwtIncompatible
from com.google.common.collect import *
from com.google.common.primitives import Primitives
from com.google.errorprone.annotations import CanIgnoreReturnValue
from com.google.errorprone.annotations import DoNotCall
from com.google.errorprone.annotations import Immutable
from java.io import Serializable
from javax.annotation import CheckForNull
from org.checkerframework.checker.nullness.qual import NonNull
from typing import Any, Callable, Iterable, Tuple


class ImmutableClassToInstanceMap(ForwardingMap, ClassToInstanceMap, Serializable):
    """
    A ClassToInstanceMap whose contents will never change, with many other important
    properties detailed at ImmutableCollection.

    Author(s)
    - Kevin Bourrillion

    Since
    - 2.0
    """

    @staticmethod
    def of() -> "ImmutableClassToInstanceMap"["B"]:
        """
        Returns an empty `ImmutableClassToInstanceMap`.
        
        **Performance note:** the instance returned is a singleton.

        Since
        - 19.0
        """
        ...


    @staticmethod
    def of(type: type["T"], value: "T") -> "ImmutableClassToInstanceMap"["B"]:
        """
        Returns an `ImmutableClassToInstanceMap` containing a single entry.

        Since
        - 19.0
        """
        ...


    @staticmethod
    def builder() -> "Builder"["B"]:
        """
        Returns a new builder. The generated builder is equivalent to the builder created by the Builder constructor.
        """
        ...


    @staticmethod
    def copyOf(map: dict[type["S"], "S"]) -> "ImmutableClassToInstanceMap"["B"]:
        """
        Returns an immutable map containing the same entries as `map`. If `map` somehow
        contains entries with duplicate keys (for example, if it is a `SortedMap` whose
        comparator is not *consistent with equals*), the results of this method are undefined.
        
        **Note:** Despite what the method name suggests, if `map` is an `ImmutableClassToInstanceMap`, no copy will actually be performed.

        Raises
        - NullPointerException: if any key or value in `map` is null
        - ClassCastException: if any value is not an instance of the type specified by its key
        """
        ...


    def getInstance(self, type: type["T"]) -> "T":
        ...


    def putInstance(self, type: type["T"], value: "T") -> "T":
        """
        Guaranteed to throw an exception and leave the map unmodified.

        Raises
        - UnsupportedOperationException: always

        Deprecated
        - Unsupported operation.
        """
        ...


    class Builder:
        """
        A builder for creating immutable class-to-instance maps. Example:
        
        ````static final ImmutableClassToInstanceMap<Handler> HANDLERS =
            new ImmutableClassToInstanceMap.Builder<Handler>()
                .put(FooHandler.class, new FooHandler())
                .put(BarHandler.class, new SubBarHandler())
                .put(Handler.class, new QuuxHandler())
                .build();````
        
        After invoking .build() it is still possible to add more entries and build again.
        Thus each map generated by this builder will be a superset of any map generated before it.

        Since
        - 2.0
        """

        def put(self, key: type["T"], value: "T") -> "Builder"["B"]:
            """
            Associates `key` with `value` in the built map. Duplicate keys are not allowed,
            and will cause .build to fail.
            """
            ...


        def putAll(self, map: dict[type["T"], "T"]) -> "Builder"["B"]:
            """
            Associates all of `map's` keys and values in the built map. Duplicate keys are not
            allowed, and will cause .build to fail.

            Raises
            - NullPointerException: if any key or value in `map` is null
            - ClassCastException: if any value is not an instance of the type specified by its key
            """
            ...


        def build(self) -> "ImmutableClassToInstanceMap"["B"]:
            """
            Returns a new immutable class-to-instance map containing the entries provided to this
            builder.

            Raises
            - IllegalArgumentException: if duplicate keys were added
            """
            ...
