"""
Python module generated from Java source file com.google.common.collect.ImmutableTable

Java source file obtained from artifact guava version 32.1.2-jre

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from com.google.common.annotations import GwtCompatible
from com.google.common.annotations import GwtIncompatible
from com.google.common.annotations import J2ktIncompatible
from com.google.common.base import MoreObjects
from com.google.common.collect import *
from com.google.errorprone.annotations import CanIgnoreReturnValue
from com.google.errorprone.annotations import DoNotCall
from com.google.errorprone.annotations import DoNotMock
from java.io import InvalidObjectException
from java.io import ObjectInputStream
from java.io import Serializable
from java.util import Comparator
from java.util import Iterator
from java.util import Spliterator
from java.util.function import BinaryOperator
from java.util.function import Function
from java.util.stream import Collector
from javax.annotation import CheckForNull
from org.checkerframework.checker.nullness.qual import Nullable
from typing import Any, Callable, Iterable, Tuple


class ImmutableTable(AbstractTable, Serializable):
    """
    A Table whose contents will never change, with many other important properties detailed
    at ImmutableCollection.
    
    See the Guava User Guide article on <a href=
    "https://github.com/google/guava/wiki/ImmutableCollectionsExplained">immutable collections</a>.

    Author(s)
    - Gregory Kick

    Since
    - 11.0
    """

    @staticmethod
    def toImmutableTable(rowFunction: "Function"["T", "R"], columnFunction: "Function"["T", "C"], valueFunction: "Function"["T", "V"]) -> "Collector"["T", Any, "ImmutableTable"["R", "C", "V"]]:
        """
        Returns a `Collector` that accumulates elements into an `ImmutableTable`. Each
        input element is mapped to one cell in the returned table, with the rows, columns, and values
        generated by applying the specified functions.
        
        The returned `Collector` will throw a `NullPointerException` at collection time
        if the row, column, or value functions return null on any input.

        Since
        - 21.0
        """
        ...


    @staticmethod
    def toImmutableTable(rowFunction: "Function"["T", "R"], columnFunction: "Function"["T", "C"], valueFunction: "Function"["T", "V"], mergeFunction: "BinaryOperator"["V"]) -> "Collector"["T", Any, "ImmutableTable"["R", "C", "V"]]:
        """
        Returns a `Collector` that accumulates elements into an `ImmutableTable`. Each
        input element is mapped to one cell in the returned table, with the rows, columns, and values
        generated by applying the specified functions. If multiple inputs are mapped to the same row
        and column pair, they will be combined with the specified merging function in encounter order.
        
        The returned `Collector` will throw a `NullPointerException` at collection time
        if the row, column, value, or merging functions return null on any input.

        Since
        - 21.0
        """
        ...


    @staticmethod
    def of() -> "ImmutableTable"["R", "C", "V"]:
        """
        Returns an empty immutable table.
        
        **Performance note:** the instance returned is a singleton.
        """
        ...


    @staticmethod
    def of(rowKey: "R", columnKey: "C", value: "V") -> "ImmutableTable"["R", "C", "V"]:
        """
        Returns an immutable table containing a single cell.
        """
        ...


    @staticmethod
    def copyOf(table: "Table"["R", "C", "V"]) -> "ImmutableTable"["R", "C", "V"]:
        """
        Returns an immutable copy of the provided table.
        
        The Table.cellSet() iteration order of the provided table determines the iteration
        ordering of all views in the returned table. Note that some views of the original table and the
        copied table may have different iteration orders. For more control over the ordering, create a
        Builder and call Builder.orderRowsBy, Builder.orderColumnsBy, and
        Builder.putAll
        
        Despite the method name, this method attempts to avoid actually copying the data when it is
        safe to do so. The exact circumstances under which a copy will or will not be performed are
        undocumented and subject to change.
        """
        ...


    @staticmethod
    def builder() -> "Builder"["R", "C", "V"]:
        """
        Returns a new builder. The generated builder is equivalent to the builder created by the Builder.Builder() ImmutableTable.Builder() constructor.
        """
        ...


    def cellSet(self) -> "ImmutableSet"["Cell"["R", "C", "V"]]:
        ...


    def values(self) -> "ImmutableCollection"["V"]:
        ...


    def column(self, columnKey: "C") -> "ImmutableMap"["R", "V"]:
        """
        Raises
        - NullPointerException: if `columnKey` is `null`
        """
        ...


    def columnKeySet(self) -> "ImmutableSet"["C"]:
        ...


    def columnMap(self) -> "ImmutableMap"["C", dict["R", "V"]]:
        """
        
        
        The value `Map<R, V>` instances in the returned map are ImmutableMap instances
        as well.
        """
        ...


    def row(self, rowKey: "R") -> "ImmutableMap"["C", "V"]:
        """
        Raises
        - NullPointerException: if `rowKey` is `null`
        """
        ...


    def rowKeySet(self) -> "ImmutableSet"["R"]:
        ...


    def rowMap(self) -> "ImmutableMap"["R", dict["C", "V"]]:
        """
        
        
        The value `Map<C, V>` instances in the returned map are ImmutableMap instances
        as well.
        """
        ...


    def contains(self, rowKey: "Object", columnKey: "Object") -> bool:
        ...


    def containsValue(self, value: "Object") -> bool:
        ...


    def clear(self) -> None:
        """
        Guaranteed to throw an exception and leave the table unmodified.

        Raises
        - UnsupportedOperationException: always

        Deprecated
        - Unsupported operation.
        """
        ...


    def put(self, rowKey: "R", columnKey: "C", value: "V") -> "V":
        """
        Guaranteed to throw an exception and leave the table unmodified.

        Raises
        - UnsupportedOperationException: always

        Deprecated
        - Unsupported operation.
        """
        ...


    def putAll(self, table: "Table"["R", "C", "V"]) -> None:
        """
        Guaranteed to throw an exception and leave the table unmodified.

        Raises
        - UnsupportedOperationException: always

        Deprecated
        - Unsupported operation.
        """
        ...


    def remove(self, rowKey: "Object", columnKey: "Object") -> "V":
        """
        Guaranteed to throw an exception and leave the table unmodified.

        Raises
        - UnsupportedOperationException: always

        Deprecated
        - Unsupported operation.
        """
        ...


    class Builder:
        """
        A builder for creating immutable table instances, especially `public static final` tables
        ("constant tables"). Example:
        
        ````static final ImmutableTable<Integer, Character, String> SPREADSHEET =
            new ImmutableTable.Builder<Integer, Character, String>()
                .put(1, 'A', "foo")
                .put(1, 'B', "bar")
                .put(2, 'A', "baz")
                .buildOrThrow();````
        
        By default, the order in which cells are added to the builder determines the iteration
        ordering of all views in the returned table, with .putAll following the Table.cellSet() iteration order. However, if .orderRowsBy or .orderColumnsBy
        is called, the views are sorted by the supplied comparators.
        
        For empty or single-cell immutable tables, .of() and .of(Object, Object,
        Object) are even more convenient.
        
        Builder instances can be reused - it is safe to call .buildOrThrow multiple times to
        build multiple tables in series. Each table is a superset of the tables created before it.

        Since
        - 11.0
        """

        def __init__(self):
            """
            Creates a new builder. The returned builder is equivalent to the builder generated by ImmutableTable.builder.
            """
            ...


        def orderRowsBy(self, rowComparator: "Comparator"["R"]) -> "Builder"["R", "C", "V"]:
            """
            Specifies the ordering of the generated table's rows.
            """
            ...


        def orderColumnsBy(self, columnComparator: "Comparator"["C"]) -> "Builder"["R", "C", "V"]:
            """
            Specifies the ordering of the generated table's columns.
            """
            ...


        def put(self, rowKey: "R", columnKey: "C", value: "V") -> "Builder"["R", "C", "V"]:
            """
            Associates the (`rowKey`, `columnKey`) pair with `value` in the built
            table. Duplicate key pairs are not allowed and will cause .build to fail.
            """
            ...


        def put(self, cell: "Cell"["R", "C", "V"]) -> "Builder"["R", "C", "V"]:
            """
            Adds the given `cell` to the table, making it immutable if necessary. Duplicate key
            pairs are not allowed and will cause .build to fail.
            """
            ...


        def putAll(self, table: "Table"["R", "C", "V"]) -> "Builder"["R", "C", "V"]:
            """
            Associates all of the given table's keys and values in the built table. Duplicate row key
            column key pairs are not allowed, and will cause .build to fail.

            Raises
            - NullPointerException: if any key or value in `table` is null
            """
            ...


        def build(self) -> "ImmutableTable"["R", "C", "V"]:
            """
            Returns a newly-created immutable table.
            
            Prefer the equivalent method .buildOrThrow() to make it explicit that the method
            will throw an exception if there are duplicate key pairs. The `build()` method will
            soon be deprecated.

            Raises
            - IllegalArgumentException: if duplicate key pairs were added
            """
            ...


        def buildOrThrow(self) -> "ImmutableTable"["R", "C", "V"]:
            """
            Returns a newly-created immutable table, or throws an exception if duplicate key pairs were
            added.

            Raises
            - IllegalArgumentException: if duplicate key pairs were added

            Since
            - 31.0
            """
            ...
