"""
Python module generated from Java source file com.google.common.collect.LinkedHashMultimap

Java source file obtained from artifact guava version 32.1.2-jre

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from com.google.common.annotations import GwtCompatible
from com.google.common.annotations import GwtIncompatible
from com.google.common.annotations import J2ktIncompatible
from com.google.common.annotations import VisibleForTesting
from com.google.common.base import Objects
from com.google.common.collect import *
from com.google.errorprone.annotations import CanIgnoreReturnValue
from com.google.j2objc.annotations import WeakOuter
from java.io import IOException
from java.io import ObjectInputStream
from java.io import ObjectOutputStream
from java.util import Arrays
from java.util import ConcurrentModificationException
from java.util import Iterator
from java.util import NoSuchElementException
from java.util import Spliterator
from java.util.function import Consumer
from javax.annotation import CheckForNull
from org.checkerframework.checker.nullness.qual import Nullable
from typing import Any, Callable, Iterable, Tuple


class LinkedHashMultimap(LinkedHashMultimapGwtSerializationDependencies):
    """
    Implementation of `Multimap` that does not allow duplicate key-value entries and that
    returns collections whose iterators follow the ordering in which the data was added to the
    multimap.
    
    The collections returned by `keySet`, `keys`, and `asMap` iterate through
    the keys in the order they were first added to the multimap. Similarly, `get`, `removeAll`, and `replaceValues` return collections that iterate through the values in the
    order they were added. The collections generated by `entries` and `values` iterate
    across the key-value mappings in the order they were added to the multimap.
    
    The iteration ordering of the collections generated by `keySet`, `keys`, and
    `asMap` has a few subtleties. As long as the set of keys remains unchanged, adding or
    removing mappings does not affect the key iteration order. However, if you remove all values
    associated with a key and then add the key back to the multimap, that key will come last in the
    key iteration order.
    
    The multimap does not store duplicate key-value pairs. Adding a new key-value pair equal to an
    existing key-value pair has no effect.
    
    Keys and values may be null. All optional multimap methods are supported, and all returned
    views are modifiable.
    
    This class is not threadsafe when any concurrent operations update the multimap. Concurrent
    read operations will work correctly. To allow concurrent update operations, wrap your multimap
    with a call to Multimaps.synchronizedSetMultimap.
    
    **Warning:** Do not modify either a key *or a value* of a `LinkedHashMultimap`
    in a way that affects its Object.equals behavior. Undefined behavior and bugs will
    result.
    
    See the Guava User Guide article on <a href=
    "https://github.com/google/guava/wiki/NewCollectionTypesExplained#multimap">`Multimap`</a>.

    Author(s)
    - Louis Wasserman

    Since
    - 2.0
    """

    @staticmethod
    def create() -> "LinkedHashMultimap"["K", "V"]:
        """
        Creates a new, empty `LinkedHashMultimap` with the default initial capacities.
        """
        ...


    @staticmethod
    def create(expectedKeys: int, expectedValuesPerKey: int) -> "LinkedHashMultimap"["K", "V"]:
        """
        Constructs an empty `LinkedHashMultimap` with enough capacity to hold the specified
        numbers of keys and values without rehashing.

        Arguments
        - expectedKeys: the expected number of distinct keys
        - expectedValuesPerKey: the expected average number of values per key

        Raises
        - IllegalArgumentException: if `expectedKeys` or `expectedValuesPerKey` is
            negative
        """
        ...


    @staticmethod
    def create(multimap: "Multimap"["K", "V"]) -> "LinkedHashMultimap"["K", "V"]:
        """
        Constructs a `LinkedHashMultimap` with the same mappings as the specified multimap. If a
        key-value mapping appears multiple times in the input multimap, it only appears once in the
        constructed multimap. The new multimap has the same Multimap.entries() iteration order
        as the input multimap, except for excluding duplicate mappings.

        Arguments
        - multimap: the multimap whose contents are copied to this multimap
        """
        ...


    def replaceValues(self, key: "K", values: Iterable["V"]) -> set["V"]:
        """
        
        
        If `values` is not empty and the multimap already contains a mapping for `key`,
        the `keySet()` ordering is unchanged. However, the provided values always come last in
        the .entries() and .values() iteration orderings.
        """
        ...


    def entries(self) -> set["Entry"["K", "V"]]:
        """
        Returns a set of all key-value pairs. Changes to the returned set will update the underlying
        multimap, and vice versa. The entries set does not support the `add` or `addAll`
        operations.
        
        The iterator generated by the returned set traverses the entries in the order they were
        added to the multimap.
        
        Each entry is an immutable snapshot of a key-value mapping in the multimap, taken at the
        time the entry is returned by a method call to the collection or its iterator.
        """
        ...


    def keySet(self) -> set["K"]:
        """
        Returns a view collection of all *distinct* keys contained in this multimap. Note that the
        key set contains a key if and only if this multimap maps that key to at least one value.
        
        The iterator generated by the returned set traverses the keys in the order they were first
        added to the multimap.
        
        Changes to the returned set will update the underlying multimap, and vice versa. However,
        *adding* to the returned set is not possible.
        """
        ...


    def values(self) -> Iterable["V"]:
        """
        Returns a collection of all values in the multimap. Changes to the returned collection will
        update the underlying multimap, and vice versa.
        
        The iterator generated by the returned collection traverses the values in the order they
        were added to the multimap.
        """
        ...


    def clear(self) -> None:
        ...
