"""
Python module generated from Java source file com.google.common.collect.MultimapBuilder

Java source file obtained from artifact guava version 32.1.2-jre

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from com.google.common.annotations import GwtCompatible
from com.google.common.base import Supplier
from com.google.common.collect import *
from java.io import Serializable
from java.util import Comparator
from java.util import EnumMap
from java.util import EnumSet
from java.util import SortedSet
from org.checkerframework.checker.nullness.qual import Nullable
from typing import Any, Callable, Iterable, Tuple


class MultimapBuilder:
    """
    An immutable builder for Multimap instances, letting you independently select the desired
    behaviors (for example, ordering) of the backing map and value-collections. Example:
    
    ````ListMultimap<UserId, ErrorResponse> errorsByUser =
        MultimapBuilder.linkedHashKeys().arrayListValues().build();
    SortedSetMultimap<String, Method> methodsForName =
        MultimapBuilder.treeKeys().treeSetValues(this::compareMethods).build();````
    
    `MultimapBuilder` instances are immutable. Invoking a configuration method has no effect
    on the receiving instance; you must store and use the new builder instance it returns instead.
    
    The generated multimaps are serializable if the key and value types are serializable, unless
    stated otherwise in one of the configuration methods.

    Author(s)
    - Louis Wasserman

    Arguments
    - <K0>: An upper bound on the key type of the generated multimap.
    - <V0>: An upper bound on the value type of the generated multimap.

    Since
    - 16.0
    """

    @staticmethod
    def hashKeys() -> "MultimapBuilderWithKeys"["Object"]:
        """
        Uses a hash table to map keys to value collections.
        """
        ...


    @staticmethod
    def hashKeys(expectedKeys: int) -> "MultimapBuilderWithKeys"["Object"]:
        """
        Uses a hash table to map keys to value collections, initialized to expect the specified number
        of keys.

        Raises
        - IllegalArgumentException: if `expectedKeys < 0`
        """
        ...


    @staticmethod
    def linkedHashKeys() -> "MultimapBuilderWithKeys"["Object"]:
        """
        Uses a hash table to map keys to value collections.
        
        The collections returned by Multimap.keySet(), Multimap.keys(), and Multimap.asMap() will iterate through the keys in the order that they were first added to the
        multimap, save that if all values associated with a key are removed and then the key is added
        back into the multimap, that key will come last in the key iteration order.
        """
        ...


    @staticmethod
    def linkedHashKeys(expectedKeys: int) -> "MultimapBuilderWithKeys"["Object"]:
        """
        Uses an hash table to map keys to value collections, initialized to expect the specified number
        of keys.
        
        The collections returned by Multimap.keySet(), Multimap.keys(), and Multimap.asMap() will iterate through the keys in the order that they were first added to the
        multimap, save that if all values associated with a key are removed and then the key is added
        back into the multimap, that key will come last in the key iteration order.
        """
        ...


    @staticmethod
    def treeKeys() -> "MultimapBuilderWithKeys"["Comparable"]:
        """
        Uses a naturally-ordered TreeMap to map keys to value collections.
        
        The collections returned by Multimap.keySet(), Multimap.keys(), and Multimap.asMap() will iterate through the keys in sorted order.
        
        For all multimaps generated by the resulting builder, the Multimap.keySet() can be
        safely cast to a java.util.SortedSet, and the Multimap.asMap() can safely be
        cast to a java.util.SortedMap.
        """
        ...


    @staticmethod
    def treeKeys(comparator: "Comparator"["K0"]) -> "MultimapBuilderWithKeys"["K0"]:
        """
        Uses a TreeMap sorted by the specified comparator to map keys to value collections.
        
        The collections returned by Multimap.keySet(), Multimap.keys(), and Multimap.asMap() will iterate through the keys in sorted order.
        
        For all multimaps generated by the resulting builder, the Multimap.keySet() can be
        safely cast to a java.util.SortedSet, and the Multimap.asMap() can safely be
        cast to a java.util.SortedMap.
        
        Multimaps generated by the resulting builder will not be serializable if `comparator`
        is not serializable.
        """
        ...


    @staticmethod
    def enumKeys(keyClass: type["K0"]) -> "MultimapBuilderWithKeys"["K0"]:
        """
        Uses an EnumMap to map keys to value collections.

        Since
        - 16.0
        """
        ...


    def build(self) -> "Multimap"["K", "V"]:
        """
        Returns a new, empty `Multimap` with the specified implementation.
        """
        ...


    def build(self, multimap: "Multimap"["K", "V"]) -> "Multimap"["K", "V"]:
        """
        Returns a `Multimap` with the specified implementation, initialized with the entries of
        `multimap`.
        """
        ...


    class MultimapBuilderWithKeys:
        """
        An intermediate stage in a MultimapBuilder in which the key-value collection map
        implementation has been specified, but the value collection implementation has not.

        Arguments
        - <K0>: The upper bound on the key type of the generated multimap.

        Since
        - 16.0
        """

        def arrayListValues(self) -> "ListMultimapBuilder"["K0", "Object"]:
            """
            Uses an ArrayList to store value collections.
            """
            ...


        def arrayListValues(self, expectedValuesPerKey: int) -> "ListMultimapBuilder"["K0", "Object"]:
            """
            Uses an ArrayList to store value collections, initialized to expect the specified
            number of values per key.

            Raises
            - IllegalArgumentException: if `expectedValuesPerKey < 0`
            """
            ...


        def linkedListValues(self) -> "ListMultimapBuilder"["K0", "Object"]:
            """
            Uses a LinkedList to store value collections.
            """
            ...


        def hashSetValues(self) -> "SetMultimapBuilder"["K0", "Object"]:
            """
            Uses a hash-based `Set` to store value collections.
            """
            ...


        def hashSetValues(self, expectedValuesPerKey: int) -> "SetMultimapBuilder"["K0", "Object"]:
            """
            Uses a hash-based `Set` to store value collections, initialized to expect the specified
            number of values per key.

            Raises
            - IllegalArgumentException: if `expectedValuesPerKey < 0`
            """
            ...


        def linkedHashSetValues(self) -> "SetMultimapBuilder"["K0", "Object"]:
            """
            Uses an insertion-ordered hash-based `Set` to store value collections.
            """
            ...


        def linkedHashSetValues(self, expectedValuesPerKey: int) -> "SetMultimapBuilder"["K0", "Object"]:
            """
            Uses an insertion-ordered hash-based `Set` to store value collections, initialized to
            expect the specified number of values per key.

            Raises
            - IllegalArgumentException: if `expectedValuesPerKey < 0`
            """
            ...


        def treeSetValues(self) -> "SortedSetMultimapBuilder"["K0", "Comparable"]:
            """
            Uses a naturally-ordered TreeSet to store value collections.
            """
            ...


        def treeSetValues(self, comparator: "Comparator"["V0"]) -> "SortedSetMultimapBuilder"["K0", "V0"]:
            """
            Uses a TreeSet ordered by the specified comparator to store value collections.
            
            Multimaps generated by the resulting builder will not be serializable if `comparator` is not serializable.
            """
            ...


        def enumSetValues(self, valueClass: type["V0"]) -> "SetMultimapBuilder"["K0", "V0"]:
            """
            Uses an EnumSet to store value collections.
            """
            ...


    class ListMultimapBuilder(MultimapBuilder):
        """
        A specialization of MultimapBuilder that generates ListMultimap instances.

        Since
        - 16.0
        """

        def build(self) -> "ListMultimap"["K", "V"]:
            ...


        def build(self, multimap: "Multimap"["K", "V"]) -> "ListMultimap"["K", "V"]:
            ...


    class SetMultimapBuilder(MultimapBuilder):
        """
        A specialization of MultimapBuilder that generates SetMultimap instances.

        Since
        - 16.0
        """

        def build(self) -> "SetMultimap"["K", "V"]:
            ...


        def build(self, multimap: "Multimap"["K", "V"]) -> "SetMultimap"["K", "V"]:
            ...


    class SortedSetMultimapBuilder(SetMultimapBuilder):
        """
        A specialization of MultimapBuilder that generates SortedSetMultimap instances.

        Since
        - 16.0
        """

        def build(self) -> "SortedSetMultimap"["K", "V"]:
            ...


        def build(self, multimap: "Multimap"["K", "V"]) -> "SortedSetMultimap"["K", "V"]:
            ...
