"""
Python module generated from Java source file com.google.common.hash.HashCode

Java source file obtained from artifact guava version 32.1.2-jre

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from com.google.common.base import Preconditions
from com.google.common.hash import *
from com.google.common.primitives import Ints
from com.google.common.primitives import UnsignedInts
from com.google.errorprone.annotations import CanIgnoreReturnValue
from java.io import Serializable
from javax.annotation import CheckForNull
from typing import Any, Callable, Iterable, Tuple


class HashCode:
    """
    An immutable hash code of arbitrary bit length.

    Author(s)
    - Kurt Alfred Kluever

    Since
    - 11.0
    """

    def bits(self) -> int:
        """
        Returns the number of bits in this hash code; a positive multiple of 8.
        """
        ...


    def asInt(self) -> int:
        """
        Returns the first four bytes of .asBytes() this hashcode's bytes, converted to an
        `int` value in little-endian order.

        Raises
        - IllegalStateException: if `bits() < 32`
        """
        ...


    def asLong(self) -> int:
        """
        Returns the first eight bytes of .asBytes() this hashcode's bytes, converted to a
        `long` value in little-endian order.

        Raises
        - IllegalStateException: if `bits() < 64`
        """
        ...


    def padToLong(self) -> int:
        """
        If this hashcode has enough bits, returns `asLong()`, otherwise returns a `long`
        value with `asBytes()` as the least-significant bytes and `0x00` as the remaining
        most-significant bytes.

        Since
        - 14.0 (since 11.0 as `Hashing.padToLong(HashCode)`)
        """
        ...


    def asBytes(self) -> list[int]:
        ...


    def writeBytesTo(self, dest: list[int], offset: int, maxLength: int) -> int:
        """
        Copies bytes from this hash code into `dest`.

        Arguments
        - dest: the byte array into which the hash code will be written
        - offset: the start offset in the data
        - maxLength: the maximum number of bytes to write

        Returns
        - the number of bytes written to `dest`

        Raises
        - IndexOutOfBoundsException: if there is not enough room in `dest`
        """
        ...


    @staticmethod
    def fromInt(hash: int) -> "HashCode":
        """
        Creates a 32-bit `HashCode` representation of the given int value. The underlying bytes
        are interpreted in little endian order.

        Since
        - 15.0 (since 12.0 in HashCodes)
        """
        ...


    @staticmethod
    def fromLong(hash: int) -> "HashCode":
        """
        Creates a 64-bit `HashCode` representation of the given long value. The underlying bytes
        are interpreted in little endian order.

        Since
        - 15.0 (since 12.0 in HashCodes)
        """
        ...


    @staticmethod
    def fromBytes(bytes: list[int]) -> "HashCode":
        """
        Creates a `HashCode` from a byte array. The array is defensively copied to preserve the
        immutability contract of `HashCode`. The array cannot be empty.

        Since
        - 15.0 (since 12.0 in HashCodes)
        """
        ...


    @staticmethod
    def fromString(string: str) -> "HashCode":
        """
        Creates a `HashCode` from a hexadecimal (`base 16`) encoded string. The string must
        be at least 2 characters long, and contain only valid, lower-cased hexadecimal characters.
        
        This method accepts the exact format generated by .toString. If you require more
        lenient `base 16` decoding, please use com.google.common.io.BaseEncoding.decode
        (and pass the result to .fromBytes).

        Since
        - 15.0
        """
        ...


    def equals(self, object: "Object") -> bool:
        """
        Returns `True` if `object` is a HashCode instance with the identical byte
        representation to this hash code.
        
        **Security note:** this method uses a constant-time (not short-circuiting) implementation
        to protect against <a href="http://en.wikipedia.org/wiki/Timing_attack">timing attacks</a>.
        """
        ...


    def hashCode(self) -> int:
        """
        Returns a "Java hash code" for this `HashCode` instance; this is well-defined (so, for
        example, you can safely put `HashCode` instances into a `HashSet`) but is otherwise
        probably not what you want to use.
        """
        ...


    def toString(self) -> str:
        """
        Returns a string containing each byte of .asBytes, in order, as a two-digit unsigned
        hexadecimal number in lower case.
        
        Note that if the output is considered to be a single hexadecimal number, whether this string
        is big-endian or little-endian depends on the byte order of .asBytes. This may be
        surprising for implementations of `HashCode` that represent the number in big-endian
        since everything else in the hashing API uniformly treats multibyte values as little-endian.
        
        To create a `HashCode` from its string representation, see .fromString.
        """
        ...
