// Code generated by xsdgen. DO NOT EDIT.

package s3api

import (
	"bytes"
	"encoding/base64"
	"encoding/xml"
	"time"
)

type AccessControlList struct {
	Grant []Grant `xml:"Grant,omitempty"`
}

type AccessControlPolicy struct {
	Owner             CanonicalUser     `xml:"Owner"`
	AccessControlList AccessControlList `xml:"AccessControlList"`
}

type AmazonCustomerByEmail struct {
	EmailAddress string `xml:"EmailAddress"`
}

type Anon1 struct {
	Bucket         string    `xml:"Bucket"`
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
	Credential     string    `xml:"Credential,omitempty"`
}

func (t *Anon1) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon1
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon1) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon1
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type Anon10 struct {
}

type Anon11 struct {
	Bucket            string            `xml:"Bucket"`
	AccessControlList AccessControlList `xml:"AccessControlList,omitempty"`
	AWSAccessKeyId    string            `xml:"AWSAccessKeyId,omitempty"`
	Timestamp         time.Time         `xml:"Timestamp,omitempty"`
	Signature         string            `xml:"Signature,omitempty"`
	Credential        string            `xml:"Credential,omitempty"`
}

func (t *Anon11) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon11
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon11) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon11
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type Anon12 struct {
}

type Anon13 struct {
	Bucket         string    `xml:"Bucket"`
	Key            string    `xml:"Key"`
	GetMetadata    bool      `xml:"GetMetadata"`
	GetData        bool      `xml:"GetData"`
	InlineData     bool      `xml:"InlineData"`
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
	Credential     string    `xml:"Credential,omitempty"`
}

func (t *Anon13) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon13
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon13) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon13
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type Anon14 struct {
	GetObjectResponse GetObjectResult `xml:"GetObjectResponse"`
}

type Anon15 struct {
	Bucket                                 string    `xml:"Bucket"`
	Key                                    string    `xml:"Key"`
	GetMetadata                            bool      `xml:"GetMetadata"`
	GetData                                bool      `xml:"GetData"`
	InlineData                             bool      `xml:"InlineData"`
	ByteRangeStart                         int64     `xml:"ByteRangeStart,omitempty"`
	ByteRangeEnd                           int64     `xml:"ByteRangeEnd,omitempty"`
	IfModifiedSince                        time.Time `xml:"IfModifiedSince,omitempty"`
	IfUnmodifiedSince                      time.Time `xml:"IfUnmodifiedSince,omitempty"`
	IfMatch                                []string  `xml:"IfMatch,omitempty"`
	IfNoneMatch                            []string  `xml:"IfNoneMatch,omitempty"`
	ReturnCompleteObjectOnConditionFailure bool      `xml:"ReturnCompleteObjectOnConditionFailure,omitempty"`
	AWSAccessKeyId                         string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp                              time.Time `xml:"Timestamp,omitempty"`
	Signature                              string    `xml:"Signature,omitempty"`
	Credential                             string    `xml:"Credential,omitempty"`
}

func (t *Anon15) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon15
	var layout struct {
		*T
		IfModifiedSince   *xsdDateTime `xml:"IfModifiedSince,omitempty"`
		IfUnmodifiedSince *xsdDateTime `xml:"IfUnmodifiedSince,omitempty"`
		Timestamp         *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.IfModifiedSince = (*xsdDateTime)(&layout.T.IfModifiedSince)
	layout.IfUnmodifiedSince = (*xsdDateTime)(&layout.T.IfUnmodifiedSince)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon15) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon15
	var overlay struct {
		*T
		IfModifiedSince   *xsdDateTime `xml:"IfModifiedSince,omitempty"`
		IfUnmodifiedSince *xsdDateTime `xml:"IfUnmodifiedSince,omitempty"`
		Timestamp         *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.IfModifiedSince = (*xsdDateTime)(&overlay.T.IfModifiedSince)
	overlay.IfUnmodifiedSince = (*xsdDateTime)(&overlay.T.IfUnmodifiedSince)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type Anon16 struct {
	GetObjectResponse GetObjectResult `xml:"GetObjectResponse"`
}

type Anon17 struct {
	Bucket            string            `xml:"Bucket"`
	Key               string            `xml:"Key"`
	Metadata          []MetadataEntry   `xml:"Metadata,omitempty"`
	ContentLength     int64             `xml:"ContentLength"`
	AccessControlList AccessControlList `xml:"AccessControlList,omitempty"`
	StorageClass      StorageClass      `xml:"StorageClass,omitempty"`
	AWSAccessKeyId    string            `xml:"AWSAccessKeyId,omitempty"`
	Timestamp         time.Time         `xml:"Timestamp,omitempty"`
	Signature         string            `xml:"Signature,omitempty"`
	Credential        string            `xml:"Credential,omitempty"`
}

func (t *Anon17) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon17
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon17) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon17
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type Anon18 struct {
	PutObjectResponse PutObjectResult `xml:"PutObjectResponse"`
}

type Anon19 struct {
	Bucket            string            `xml:"Bucket"`
	Key               string            `xml:"Key"`
	Metadata          []MetadataEntry   `xml:"Metadata,omitempty"`
	Data              []byte            `xml:"Data"`
	ContentLength     int64             `xml:"ContentLength"`
	AccessControlList AccessControlList `xml:"AccessControlList,omitempty"`
	StorageClass      StorageClass      `xml:"StorageClass,omitempty"`
	AWSAccessKeyId    string            `xml:"AWSAccessKeyId,omitempty"`
	Timestamp         time.Time         `xml:"Timestamp,omitempty"`
	Signature         string            `xml:"Signature,omitempty"`
	Credential        string            `xml:"Credential,omitempty"`
}

func (t *Anon19) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon19
	var layout struct {
		*T
		Data      *xsdBase64Binary `xml:"Data"`
		Timestamp *xsdDateTime     `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Data = (*xsdBase64Binary)(&layout.T.Data)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon19) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon19
	var overlay struct {
		*T
		Data      *xsdBase64Binary `xml:"Data"`
		Timestamp *xsdDateTime     `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Data = (*xsdBase64Binary)(&overlay.T.Data)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type Anon2 struct {
	GetBucketLoggingStatusResponse BucketLoggingStatus `xml:"GetBucketLoggingStatusResponse"`
}

type Anon20 struct {
	PutObjectInlineResponse PutObjectResult `xml:"PutObjectInlineResponse"`
}

type Anon21 struct {
	Bucket         string    `xml:"Bucket"`
	Key            string    `xml:"Key"`
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
	Credential     string    `xml:"Credential,omitempty"`
}

func (t *Anon21) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon21
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon21) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon21
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type Anon22 struct {
	DeleteObjectResponse Status `xml:"DeleteObjectResponse"`
}

type Anon23 struct {
	Bucket         string    `xml:"Bucket"`
	Prefix         string    `xml:"Prefix,omitempty"`
	Marker         string    `xml:"Marker,omitempty"`
	MaxKeys        int       `xml:"MaxKeys,omitempty"`
	Delimiter      string    `xml:"Delimiter,omitempty"`
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
	Credential     string    `xml:"Credential,omitempty"`
}

func (t *Anon23) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon23
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon23) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon23
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type Anon24 struct {
	ListBucketResponse ListBucketResult `xml:"ListBucketResponse"`
}

type Anon25 struct {
	ListVersionsResponse ListVersionsResult `xml:"ListVersionsResponse"`
}

type Anon26 struct {
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
}

func (t *Anon26) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon26
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon26) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon26
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type Anon27 struct {
	ListAllMyBucketsResponse ListAllMyBucketsResult `xml:"ListAllMyBucketsResponse"`
}

type Anon28 struct {
	Location string `xml:"Location"`
	Bucket   string `xml:"Bucket"`
	Key      string `xml:"Key"`
	ETag     string `xml:"ETag"`
}

type Anon29 struct {
	SourceBucket                string            `xml:"SourceBucket"`
	SourceKey                   string            `xml:"SourceKey"`
	DestinationBucket           string            `xml:"DestinationBucket"`
	DestinationKey              string            `xml:"DestinationKey"`
	MetadataDirective           MetadataDirective `xml:"MetadataDirective,omitempty"`
	Metadata                    []MetadataEntry   `xml:"Metadata,omitempty"`
	AccessControlList           AccessControlList `xml:"AccessControlList,omitempty"`
	CopySourceIfModifiedSince   time.Time         `xml:"CopySourceIfModifiedSince,omitempty"`
	CopySourceIfUnmodifiedSince time.Time         `xml:"CopySourceIfUnmodifiedSince,omitempty"`
	CopySourceIfMatch           []string          `xml:"CopySourceIfMatch,omitempty"`
	CopySourceIfNoneMatch       []string          `xml:"CopySourceIfNoneMatch,omitempty"`
	StorageClass                StorageClass      `xml:"StorageClass,omitempty"`
	AWSAccessKeyId              string            `xml:"AWSAccessKeyId,omitempty"`
	Timestamp                   time.Time         `xml:"Timestamp,omitempty"`
	Signature                   string            `xml:"Signature,omitempty"`
	Credential                  string            `xml:"Credential,omitempty"`
}

func (t *Anon29) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon29
	var layout struct {
		*T
		CopySourceIfModifiedSince   *xsdDateTime `xml:"CopySourceIfModifiedSince,omitempty"`
		CopySourceIfUnmodifiedSince *xsdDateTime `xml:"CopySourceIfUnmodifiedSince,omitempty"`
		Timestamp                   *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.CopySourceIfModifiedSince = (*xsdDateTime)(&layout.T.CopySourceIfModifiedSince)
	layout.CopySourceIfUnmodifiedSince = (*xsdDateTime)(&layout.T.CopySourceIfUnmodifiedSince)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon29) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon29
	var overlay struct {
		*T
		CopySourceIfModifiedSince   *xsdDateTime `xml:"CopySourceIfModifiedSince,omitempty"`
		CopySourceIfUnmodifiedSince *xsdDateTime `xml:"CopySourceIfUnmodifiedSince,omitempty"`
		Timestamp                   *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.CopySourceIfModifiedSince = (*xsdDateTime)(&overlay.T.CopySourceIfModifiedSince)
	overlay.CopySourceIfUnmodifiedSince = (*xsdDateTime)(&overlay.T.CopySourceIfUnmodifiedSince)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type Anon3 struct {
	Bucket              string              `xml:"Bucket"`
	AWSAccessKeyId      string              `xml:"AWSAccessKeyId,omitempty"`
	Timestamp           time.Time           `xml:"Timestamp,omitempty"`
	Signature           string              `xml:"Signature,omitempty"`
	Credential          string              `xml:"Credential,omitempty"`
	BucketLoggingStatus BucketLoggingStatus `xml:"BucketLoggingStatus"`
}

func (t *Anon3) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon3
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon3) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon3
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type Anon30 struct {
	CopyObjectResult CopyObjectResult `xml:"CopyObjectResult"`
}

type Anon4 struct {
}

type Anon5 struct {
	Bucket         string    `xml:"Bucket"`
	Key            string    `xml:"Key"`
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
	Credential     string    `xml:"Credential,omitempty"`
}

func (t *Anon5) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon5
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon5) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon5
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type Anon6 struct {
	GetObjectAccessControlPolicyResponse AccessControlPolicy `xml:"GetObjectAccessControlPolicyResponse"`
}

type Anon7 struct {
	Bucket         string    `xml:"Bucket"`
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
	Credential     string    `xml:"Credential,omitempty"`
}

func (t *Anon7) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon7
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon7) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon7
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type Anon8 struct {
	GetBucketAccessControlPolicyResponse AccessControlPolicy `xml:"GetBucketAccessControlPolicyResponse"`
}

type Anon9 struct {
	Bucket            string            `xml:"Bucket"`
	Key               string            `xml:"Key"`
	AccessControlList AccessControlList `xml:"AccessControlList"`
	AWSAccessKeyId    string            `xml:"AWSAccessKeyId,omitempty"`
	Timestamp         time.Time         `xml:"Timestamp,omitempty"`
	Signature         string            `xml:"Signature,omitempty"`
	Credential        string            `xml:"Credential,omitempty"`
}

func (t *Anon9) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T Anon9
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *Anon9) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T Anon9
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type BucketLoggingStatus struct {
	LoggingEnabled LoggingSettings `xml:"LoggingEnabled,omitempty"`
}

type CanonicalUser struct {
	ID          string `xml:"ID"`
	DisplayName string `xml:"DisplayName,omitempty"`
}

type CopyObject struct {
	SourceBucket                string            `xml:"SourceBucket"`
	SourceKey                   string            `xml:"SourceKey"`
	DestinationBucket           string            `xml:"DestinationBucket"`
	DestinationKey              string            `xml:"DestinationKey"`
	MetadataDirective           MetadataDirective `xml:"MetadataDirective,omitempty"`
	Metadata                    []MetadataEntry   `xml:"Metadata,omitempty"`
	AccessControlList           AccessControlList `xml:"AccessControlList,omitempty"`
	CopySourceIfModifiedSince   time.Time         `xml:"CopySourceIfModifiedSince,omitempty"`
	CopySourceIfUnmodifiedSince time.Time         `xml:"CopySourceIfUnmodifiedSince,omitempty"`
	CopySourceIfMatch           []string          `xml:"CopySourceIfMatch,omitempty"`
	CopySourceIfNoneMatch       []string          `xml:"CopySourceIfNoneMatch,omitempty"`
	StorageClass                StorageClass      `xml:"StorageClass,omitempty"`
	AWSAccessKeyId              string            `xml:"AWSAccessKeyId,omitempty"`
	Timestamp                   time.Time         `xml:"Timestamp,omitempty"`
	Signature                   string            `xml:"Signature,omitempty"`
	Credential                  string            `xml:"Credential,omitempty"`
}

func (t *CopyObject) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T CopyObject
	var layout struct {
		*T
		CopySourceIfModifiedSince   *xsdDateTime `xml:"CopySourceIfModifiedSince,omitempty"`
		CopySourceIfUnmodifiedSince *xsdDateTime `xml:"CopySourceIfUnmodifiedSince,omitempty"`
		Timestamp                   *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.CopySourceIfModifiedSince = (*xsdDateTime)(&layout.T.CopySourceIfModifiedSince)
	layout.CopySourceIfUnmodifiedSince = (*xsdDateTime)(&layout.T.CopySourceIfUnmodifiedSince)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *CopyObject) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T CopyObject
	var overlay struct {
		*T
		CopySourceIfModifiedSince   *xsdDateTime `xml:"CopySourceIfModifiedSince,omitempty"`
		CopySourceIfUnmodifiedSince *xsdDateTime `xml:"CopySourceIfUnmodifiedSince,omitempty"`
		Timestamp                   *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.CopySourceIfModifiedSince = (*xsdDateTime)(&overlay.T.CopySourceIfModifiedSince)
	overlay.CopySourceIfUnmodifiedSince = (*xsdDateTime)(&overlay.T.CopySourceIfUnmodifiedSince)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type CopyObjectResponse struct {
	CopyObjectResult CopyObjectResult `xml:"CopyObjectResult"`
}

type CopyObjectResult struct {
	LastModified time.Time `xml:"LastModified"`
	ETag         string    `xml:"ETag"`
}

func (t *CopyObjectResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T CopyObjectResult
	var layout struct {
		*T
		LastModified *xsdDateTime `xml:"LastModified"`
	}
	layout.T = (*T)(t)
	layout.LastModified = (*xsdDateTime)(&layout.T.LastModified)
	return e.EncodeElement(layout, start)
}
func (t *CopyObjectResult) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T CopyObjectResult
	var overlay struct {
		*T
		LastModified *xsdDateTime `xml:"LastModified"`
	}
	overlay.T = (*T)(t)
	overlay.LastModified = (*xsdDateTime)(&overlay.T.LastModified)
	return d.DecodeElement(&overlay, &start)
}

type CreateBucket struct {
	Bucket            string            `xml:"Bucket"`
	AccessControlList AccessControlList `xml:"AccessControlList,omitempty"`
	AWSAccessKeyId    string            `xml:"AWSAccessKeyId,omitempty"`
	Timestamp         time.Time         `xml:"Timestamp,omitempty"`
	Signature         string            `xml:"Signature,omitempty"`
}

func (t *CreateBucket) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T CreateBucket
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *CreateBucket) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T CreateBucket
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type CreateBucketConfiguration struct {
	LocationConstraint string `xml:"LocationConstraint"`
}

type CreateBucketResponse struct {
	CreateBucketReturn CreateBucketResult `xml:"CreateBucketReturn"`
}

type CreateBucketResult struct {
	BucketName string `xml:"BucketName"`
}

type DeleteBucket struct {
	Bucket         string    `xml:"Bucket"`
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
	Credential     string    `xml:"Credential,omitempty"`
}

func (t *DeleteBucket) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T DeleteBucket
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *DeleteBucket) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T DeleteBucket
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type DeleteBucketResponse struct {
	DeleteBucketResponse Status `xml:"DeleteBucketResponse"`
}

type DeleteMarkerEntry struct {
	Key          string        `xml:"Key"`
	VersionId    string        `xml:"VersionId"`
	IsLatest     bool          `xml:"IsLatest"`
	LastModified time.Time     `xml:"LastModified"`
	Owner        CanonicalUser `xml:"Owner,omitempty"`
}

func (t *DeleteMarkerEntry) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T DeleteMarkerEntry
	var layout struct {
		*T
		LastModified *xsdDateTime `xml:"LastModified"`
	}
	layout.T = (*T)(t)
	layout.LastModified = (*xsdDateTime)(&layout.T.LastModified)
	return e.EncodeElement(layout, start)
}
func (t *DeleteMarkerEntry) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T DeleteMarkerEntry
	var overlay struct {
		*T
		LastModified *xsdDateTime `xml:"LastModified"`
	}
	overlay.T = (*T)(t)
	overlay.LastModified = (*xsdDateTime)(&overlay.T.LastModified)
	return d.DecodeElement(&overlay, &start)
}

type DeleteObject struct {
	Bucket         string    `xml:"Bucket"`
	Key            string    `xml:"Key"`
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
	Credential     string    `xml:"Credential,omitempty"`
}

func (t *DeleteObject) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T DeleteObject
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *DeleteObject) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T DeleteObject
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type DeleteObjectResponse struct {
	DeleteObjectResponse Status `xml:"DeleteObjectResponse"`
}

type GetBucketAccessControlPolicy struct {
	Bucket         string    `xml:"Bucket"`
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
	Credential     string    `xml:"Credential,omitempty"`
}

func (t *GetBucketAccessControlPolicy) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T GetBucketAccessControlPolicy
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *GetBucketAccessControlPolicy) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T GetBucketAccessControlPolicy
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type GetBucketAccessControlPolicyResponse struct {
	GetBucketAccessControlPolicyResponse AccessControlPolicy `xml:"GetBucketAccessControlPolicyResponse"`
}

type GetBucketLoggingStatus struct {
	Bucket         string    `xml:"Bucket"`
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
	Credential     string    `xml:"Credential,omitempty"`
}

func (t *GetBucketLoggingStatus) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T GetBucketLoggingStatus
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *GetBucketLoggingStatus) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T GetBucketLoggingStatus
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type GetBucketLoggingStatusResponse struct {
	GetBucketLoggingStatusResponse BucketLoggingStatus `xml:"GetBucketLoggingStatusResponse"`
}

type GetObject struct {
	Bucket         string    `xml:"Bucket"`
	Key            string    `xml:"Key"`
	GetMetadata    bool      `xml:"GetMetadata"`
	GetData        bool      `xml:"GetData"`
	InlineData     bool      `xml:"InlineData"`
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
	Credential     string    `xml:"Credential,omitempty"`
}

func (t *GetObject) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T GetObject
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *GetObject) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T GetObject
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type GetObjectAccessControlPolicy struct {
	Bucket         string    `xml:"Bucket"`
	Key            string    `xml:"Key"`
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
	Credential     string    `xml:"Credential,omitempty"`
}

func (t *GetObjectAccessControlPolicy) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T GetObjectAccessControlPolicy
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *GetObjectAccessControlPolicy) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T GetObjectAccessControlPolicy
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type GetObjectAccessControlPolicyResponse struct {
	GetObjectAccessControlPolicyResponse AccessControlPolicy `xml:"GetObjectAccessControlPolicyResponse"`
}

type GetObjectExtended struct {
	Bucket                                 string    `xml:"Bucket"`
	Key                                    string    `xml:"Key"`
	GetMetadata                            bool      `xml:"GetMetadata"`
	GetData                                bool      `xml:"GetData"`
	InlineData                             bool      `xml:"InlineData"`
	ByteRangeStart                         int64     `xml:"ByteRangeStart,omitempty"`
	ByteRangeEnd                           int64     `xml:"ByteRangeEnd,omitempty"`
	IfModifiedSince                        time.Time `xml:"IfModifiedSince,omitempty"`
	IfUnmodifiedSince                      time.Time `xml:"IfUnmodifiedSince,omitempty"`
	IfMatch                                []string  `xml:"IfMatch,omitempty"`
	IfNoneMatch                            []string  `xml:"IfNoneMatch,omitempty"`
	ReturnCompleteObjectOnConditionFailure bool      `xml:"ReturnCompleteObjectOnConditionFailure,omitempty"`
	AWSAccessKeyId                         string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp                              time.Time `xml:"Timestamp,omitempty"`
	Signature                              string    `xml:"Signature,omitempty"`
	Credential                             string    `xml:"Credential,omitempty"`
}

func (t *GetObjectExtended) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T GetObjectExtended
	var layout struct {
		*T
		IfModifiedSince   *xsdDateTime `xml:"IfModifiedSince,omitempty"`
		IfUnmodifiedSince *xsdDateTime `xml:"IfUnmodifiedSince,omitempty"`
		Timestamp         *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.IfModifiedSince = (*xsdDateTime)(&layout.T.IfModifiedSince)
	layout.IfUnmodifiedSince = (*xsdDateTime)(&layout.T.IfUnmodifiedSince)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *GetObjectExtended) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T GetObjectExtended
	var overlay struct {
		*T
		IfModifiedSince   *xsdDateTime `xml:"IfModifiedSince,omitempty"`
		IfUnmodifiedSince *xsdDateTime `xml:"IfUnmodifiedSince,omitempty"`
		Timestamp         *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.IfModifiedSince = (*xsdDateTime)(&overlay.T.IfModifiedSince)
	overlay.IfUnmodifiedSince = (*xsdDateTime)(&overlay.T.IfUnmodifiedSince)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type GetObjectExtendedResponse struct {
	GetObjectResponse GetObjectResult `xml:"GetObjectResponse"`
}

type GetObjectResponse struct {
	GetObjectResponse GetObjectResult `xml:"GetObjectResponse"`
}

type GetObjectResult struct {
	Status       Status          `xml:"Status"`
	Metadata     []MetadataEntry `xml:"Metadata,omitempty"`
	Data         []byte          `xml:"Data,omitempty"`
	LastModified time.Time       `xml:"LastModified"`
	ETag         string          `xml:"ETag"`
}

func (t *GetObjectResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T GetObjectResult
	var layout struct {
		*T
		Data         *xsdBase64Binary `xml:"Data,omitempty"`
		LastModified *xsdDateTime     `xml:"LastModified"`
	}
	layout.T = (*T)(t)
	layout.Data = (*xsdBase64Binary)(&layout.T.Data)
	layout.LastModified = (*xsdDateTime)(&layout.T.LastModified)
	return e.EncodeElement(layout, start)
}
func (t *GetObjectResult) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T GetObjectResult
	var overlay struct {
		*T
		Data         *xsdBase64Binary `xml:"Data,omitempty"`
		LastModified *xsdDateTime     `xml:"LastModified"`
	}
	overlay.T = (*T)(t)
	overlay.Data = (*xsdBase64Binary)(&overlay.T.Data)
	overlay.LastModified = (*xsdDateTime)(&overlay.T.LastModified)
	return d.DecodeElement(&overlay, &start)
}

type Grant struct {
	Grantee    Grantee    `xml:"Grantee"`
	Permission Permission `xml:"Permission"`
}

type Group struct {
	URI string `xml:"URI"`
}

type ListAllMyBuckets struct {
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
}

func (t *ListAllMyBuckets) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T ListAllMyBuckets
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *ListAllMyBuckets) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T ListAllMyBuckets
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type ListAllMyBucketsEntry struct {
	Name         string    `xml:"Name"`
	CreationDate time.Time `xml:"CreationDate"`
}

func (t *ListAllMyBucketsEntry) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T ListAllMyBucketsEntry
	var layout struct {
		*T
		CreationDate *xsdDateTime `xml:"CreationDate"`
	}
	layout.T = (*T)(t)
	layout.CreationDate = (*xsdDateTime)(&layout.T.CreationDate)
	return e.EncodeElement(layout, start)
}
func (t *ListAllMyBucketsEntry) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T ListAllMyBucketsEntry
	var overlay struct {
		*T
		CreationDate *xsdDateTime `xml:"CreationDate"`
	}
	overlay.T = (*T)(t)
	overlay.CreationDate = (*xsdDateTime)(&overlay.T.CreationDate)
	return d.DecodeElement(&overlay, &start)
}

type ListAllMyBucketsList struct {
	Bucket []ListAllMyBucketsEntry `xml:"Bucket,omitempty"`
}

type ListAllMyBucketsResponse struct {
	ListAllMyBucketsResponse ListAllMyBucketsResult `xml:"ListAllMyBucketsResponse"`
}

type ListAllMyBucketsResult struct {
	Owner   CanonicalUser        `xml:"Owner"`
	Buckets ListAllMyBucketsList `xml:"Buckets"`
}

type ListBucket struct {
	Bucket         string    `xml:"Bucket"`
	Prefix         string    `xml:"Prefix,omitempty"`
	Marker         string    `xml:"Marker,omitempty"`
	MaxKeys        int       `xml:"MaxKeys,omitempty"`
	Delimiter      string    `xml:"Delimiter,omitempty"`
	AWSAccessKeyId string    `xml:"AWSAccessKeyId,omitempty"`
	Timestamp      time.Time `xml:"Timestamp,omitempty"`
	Signature      string    `xml:"Signature,omitempty"`
	Credential     string    `xml:"Credential,omitempty"`
}

func (t *ListBucket) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T ListBucket
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *ListBucket) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T ListBucket
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type ListBucketResponse struct {
	ListBucketResponse ListBucketResult `xml:"ListBucketResponse"`
}

type ListBucketResult struct {
	Metadata       []MetadataEntry `xml:"Metadata,omitempty"`
	Name           string          `xml:"Name"`
	Prefix         string          `xml:"Prefix"`
	Marker         string          `xml:"Marker"`
	NextMarker     string          `xml:"NextMarker,omitempty"`
	MaxKeys        int             `xml:"MaxKeys"`
	Delimiter      string          `xml:"Delimiter,omitempty"`
	IsTruncated    bool            `xml:"IsTruncated"`
	Contents       []ListEntry     `xml:"Contents,omitempty"`
	CommonPrefixes []PrefixEntry   `xml:"CommonPrefixes,omitempty"`
	EncodingType   string          `xml:"EncodingType"`
}

type ListEntry struct {
	Key          string        `xml:"Key"`
	LastModified time.Time     `xml:"LastModified"`
	ETag         string        `xml:"ETag"`
	Size         int64         `xml:"Size"`
	Owner        CanonicalUser `xml:"Owner,omitempty"`
	StorageClass StorageClass  `xml:"StorageClass"`
}

func (t *ListEntry) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T ListEntry
	var layout struct {
		*T
		LastModified *xsdDateTime `xml:"LastModified"`
	}
	layout.T = (*T)(t)
	layout.LastModified = (*xsdDateTime)(&layout.T.LastModified)
	return e.EncodeElement(layout, start)
}
func (t *ListEntry) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T ListEntry
	var overlay struct {
		*T
		LastModified *xsdDateTime `xml:"LastModified"`
	}
	overlay.T = (*T)(t)
	overlay.LastModified = (*xsdDateTime)(&overlay.T.LastModified)
	return d.DecodeElement(&overlay, &start)
}

type ListVersionsResponse struct {
	ListVersionsResponse ListVersionsResult `xml:"ListVersionsResponse"`
}

type ListVersionsResult struct {
	Metadata            []MetadataEntry   `xml:"Metadata,omitempty"`
	Name                string            `xml:"Name"`
	Prefix              string            `xml:"Prefix"`
	KeyMarker           string            `xml:"KeyMarker"`
	VersionIdMarker     string            `xml:"VersionIdMarker"`
	NextKeyMarker       string            `xml:"NextKeyMarker,omitempty"`
	NextVersionIdMarker string            `xml:"NextVersionIdMarker,omitempty"`
	MaxKeys             int               `xml:"MaxKeys"`
	Delimiter           string            `xml:"Delimiter,omitempty"`
	IsTruncated         bool              `xml:"IsTruncated"`
	Version             VersionEntry      `xml:"Version,omitempty"`
	DeleteMarker        DeleteMarkerEntry `xml:"DeleteMarker,omitempty"`
	CommonPrefixes      []PrefixEntry     `xml:"CommonPrefixes,omitempty"`
}

type LoggingSettings struct {
	TargetBucket string            `xml:"TargetBucket"`
	TargetPrefix string            `xml:"TargetPrefix"`
	TargetGrants AccessControlList `xml:"TargetGrants,omitempty"`
}

// May be one of COPY, REPLACE
type MetadataDirective string

type MetadataEntry struct {
	Name  string `xml:"Name"`
	Value string `xml:"Value"`
}

// May be one of Enabled, Disabled
type MfaDeleteStatus string

type NotificationConfiguration struct {
	TopicConfiguration []TopicConfiguration `xml:"TopicConfiguration,omitempty"`
}

// May be one of BucketOwner, Requester
type Payer string

// May be one of READ, WRITE, READ_ACP, WRITE_ACP, FULL_CONTROL
type Permission string

type PostResponse struct {
	Location string `xml:"Location"`
	Bucket   string `xml:"Bucket"`
	Key      string `xml:"Key"`
	ETag     string `xml:"ETag"`
}

type PrefixEntry struct {
	Prefix string `xml:"Prefix"`
}

type PutObject struct {
	Bucket            string            `xml:"Bucket"`
	Key               string            `xml:"Key"`
	Metadata          []MetadataEntry   `xml:"Metadata,omitempty"`
	ContentLength     int64             `xml:"ContentLength"`
	AccessControlList AccessControlList `xml:"AccessControlList,omitempty"`
	StorageClass      StorageClass      `xml:"StorageClass,omitempty"`
	AWSAccessKeyId    string            `xml:"AWSAccessKeyId,omitempty"`
	Timestamp         time.Time         `xml:"Timestamp,omitempty"`
	Signature         string            `xml:"Signature,omitempty"`
	Credential        string            `xml:"Credential,omitempty"`
}

func (t *PutObject) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T PutObject
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *PutObject) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T PutObject
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type PutObjectInline struct {
	Bucket            string            `xml:"Bucket"`
	Key               string            `xml:"Key"`
	Metadata          []MetadataEntry   `xml:"Metadata,omitempty"`
	Data              []byte            `xml:"Data"`
	ContentLength     int64             `xml:"ContentLength"`
	AccessControlList AccessControlList `xml:"AccessControlList,omitempty"`
	StorageClass      StorageClass      `xml:"StorageClass,omitempty"`
	AWSAccessKeyId    string            `xml:"AWSAccessKeyId,omitempty"`
	Timestamp         time.Time         `xml:"Timestamp,omitempty"`
	Signature         string            `xml:"Signature,omitempty"`
	Credential        string            `xml:"Credential,omitempty"`
}

func (t *PutObjectInline) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T PutObjectInline
	var layout struct {
		*T
		Data      *xsdBase64Binary `xml:"Data"`
		Timestamp *xsdDateTime     `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Data = (*xsdBase64Binary)(&layout.T.Data)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *PutObjectInline) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T PutObjectInline
	var overlay struct {
		*T
		Data      *xsdBase64Binary `xml:"Data"`
		Timestamp *xsdDateTime     `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Data = (*xsdBase64Binary)(&overlay.T.Data)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type PutObjectInlineResponse struct {
	PutObjectInlineResponse PutObjectResult `xml:"PutObjectInlineResponse"`
}

type PutObjectResponse struct {
	PutObjectResponse PutObjectResult `xml:"PutObjectResponse"`
}

type PutObjectResult struct {
	ETag         string    `xml:"ETag"`
	LastModified time.Time `xml:"LastModified"`
}

func (t *PutObjectResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T PutObjectResult
	var layout struct {
		*T
		LastModified *xsdDateTime `xml:"LastModified"`
	}
	layout.T = (*T)(t)
	layout.LastModified = (*xsdDateTime)(&layout.T.LastModified)
	return e.EncodeElement(layout, start)
}
func (t *PutObjectResult) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T PutObjectResult
	var overlay struct {
		*T
		LastModified *xsdDateTime `xml:"LastModified"`
	}
	overlay.T = (*T)(t)
	overlay.LastModified = (*xsdDateTime)(&overlay.T.LastModified)
	return d.DecodeElement(&overlay, &start)
}

type RequestPaymentConfiguration struct {
	Payer Payer `xml:"Payer"`
}

type Result struct {
	Status Status `xml:"Status"`
}

type SetBucketAccessControlPolicy struct {
	Bucket            string            `xml:"Bucket"`
	AccessControlList AccessControlList `xml:"AccessControlList,omitempty"`
	AWSAccessKeyId    string            `xml:"AWSAccessKeyId,omitempty"`
	Timestamp         time.Time         `xml:"Timestamp,omitempty"`
	Signature         string            `xml:"Signature,omitempty"`
	Credential        string            `xml:"Credential,omitempty"`
}

func (t *SetBucketAccessControlPolicy) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T SetBucketAccessControlPolicy
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *SetBucketAccessControlPolicy) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T SetBucketAccessControlPolicy
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type SetBucketAccessControlPolicyResponse struct {
}

type SetBucketLoggingStatus struct {
	Bucket              string              `xml:"Bucket"`
	AWSAccessKeyId      string              `xml:"AWSAccessKeyId,omitempty"`
	Timestamp           time.Time           `xml:"Timestamp,omitempty"`
	Signature           string              `xml:"Signature,omitempty"`
	Credential          string              `xml:"Credential,omitempty"`
	BucketLoggingStatus BucketLoggingStatus `xml:"BucketLoggingStatus"`
}

func (t *SetBucketLoggingStatus) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T SetBucketLoggingStatus
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *SetBucketLoggingStatus) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T SetBucketLoggingStatus
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type SetBucketLoggingStatusResponse struct {
}

type SetObjectAccessControlPolicy struct {
	Bucket            string            `xml:"Bucket"`
	Key               string            `xml:"Key"`
	AccessControlList AccessControlList `xml:"AccessControlList"`
	AWSAccessKeyId    string            `xml:"AWSAccessKeyId,omitempty"`
	Timestamp         time.Time         `xml:"Timestamp,omitempty"`
	Signature         string            `xml:"Signature,omitempty"`
	Credential        string            `xml:"Credential,omitempty"`
}

func (t *SetObjectAccessControlPolicy) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T SetObjectAccessControlPolicy
	var layout struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	layout.T = (*T)(t)
	layout.Timestamp = (*xsdDateTime)(&layout.T.Timestamp)
	return e.EncodeElement(layout, start)
}
func (t *SetObjectAccessControlPolicy) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T SetObjectAccessControlPolicy
	var overlay struct {
		*T
		Timestamp *xsdDateTime `xml:"Timestamp,omitempty"`
	}
	overlay.T = (*T)(t)
	overlay.Timestamp = (*xsdDateTime)(&overlay.T.Timestamp)
	return d.DecodeElement(&overlay, &start)
}

type SetObjectAccessControlPolicyResponse struct {
}

type Status struct {
	Code        int    `xml:"Code"`
	Description string `xml:"Description"`
}

// May be one of STANDARD, REDUCED_REDUNDANCY, GLACIER, UNKNOWN
type StorageClass string

type TopicConfiguration struct {
	Topic string   `xml:"Topic"`
	Event []string `xml:"Event"`
}

type User struct {
}

type VersionEntry struct {
	Key          string        `xml:"Key"`
	VersionId    string        `xml:"VersionId"`
	IsLatest     bool          `xml:"IsLatest"`
	LastModified time.Time     `xml:"LastModified"`
	ETag         string        `xml:"ETag"`
	Size         int64         `xml:"Size"`
	Owner        CanonicalUser `xml:"Owner,omitempty"`
	StorageClass StorageClass  `xml:"StorageClass"`
}

func (t *VersionEntry) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type T VersionEntry
	var layout struct {
		*T
		LastModified *xsdDateTime `xml:"LastModified"`
	}
	layout.T = (*T)(t)
	layout.LastModified = (*xsdDateTime)(&layout.T.LastModified)
	return e.EncodeElement(layout, start)
}
func (t *VersionEntry) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type T VersionEntry
	var overlay struct {
		*T
		LastModified *xsdDateTime `xml:"LastModified"`
	}
	overlay.T = (*T)(t)
	overlay.LastModified = (*xsdDateTime)(&overlay.T.LastModified)
	return d.DecodeElement(&overlay, &start)
}

type VersioningConfiguration struct {
	Status    VersioningStatus `xml:"Status,omitempty"`
	MfaDelete MfaDeleteStatus  `xml:"MfaDelete,omitempty"`
}

// May be one of Enabled, Suspended
type VersioningStatus string

type xsdBase64Binary []byte

func (b *xsdBase64Binary) UnmarshalText(text []byte) (err error) {
	*b, err = base64.StdEncoding.DecodeString(string(text))
	return
}
func (b xsdBase64Binary) MarshalText() ([]byte, error) {
	var buf bytes.Buffer
	enc := base64.NewEncoder(base64.StdEncoding, &buf)
	enc.Write([]byte(b))
	enc.Close()
	return buf.Bytes(), nil
}

type xsdDateTime time.Time

func (t *xsdDateTime) UnmarshalText(text []byte) error {
	return _unmarshalTime(text, (*time.Time)(t), "2006-01-02T15:04:05.999999999")
}
func (t xsdDateTime) MarshalText() ([]byte, error) {
	return _marshalTime((time.Time)(t), "2006-01-02T15:04:05.999999999")
}
func (t xsdDateTime) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	if (time.Time)(t).IsZero() {
		return nil
	}
	m, err := t.MarshalText()
	if err != nil {
		return err
	}
	return e.EncodeElement(m, start)
}
func (t xsdDateTime) MarshalXMLAttr(name xml.Name) (xml.Attr, error) {
	if (time.Time)(t).IsZero() {
		return xml.Attr{}, nil
	}
	m, err := t.MarshalText()
	return xml.Attr{Name: name, Value: string(m)}, err
}
func _unmarshalTime(text []byte, t *time.Time, format string) (err error) {
	s := string(bytes.TrimSpace(text))
	*t, err = time.Parse(format, s)
	if _, ok := err.(*time.ParseError); ok {
		*t, err = time.Parse(format+"Z07:00", s)
	}
	return err
}
func _marshalTime(t time.Time, format string) ([]byte, error) {
	return []byte(t.Format(format + "Z07:00")), nil
}
