/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.classloader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class JPypeClassLoader
extends ClassLoader {
    private static JPypeClassLoader instance;
    private TreeMap<String, byte[]> map = new TreeMap();

    public static JPypeClassLoader getInstance() {
        if (instance == null) {
            instance = new JPypeClassLoader(JPypeClassLoader.getSystemClassLoader());
        }
        return instance;
    }

    private JPypeClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void importClass(String string, byte[] byArray) {
        this.map.put(string, byArray);
    }

    public void importJar(byte[] byArray) {
        try (JarInputStream jarInputStream = new JarInputStream(new ByteArrayInputStream(byArray));){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                int n;
                long l = jarEntry.getSize();
                if (l == 0L) continue;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = jarInputStream.read()) != -1) {
                    byteArrayOutputStream.write(n);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                String string = jarEntry.getName();
                this.importClass(string, byArray2);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Class findClass(String string) throws ClassNotFoundException, ClassFormatError {
        String string2 = string.replace('.', '/') + ".class";
        byte[] byArray = this.map.get(string2);
        if (byArray == null) {
            return super.findClass(string);
        }
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
        if (clazz == null) {
            throw new ClassFormatError("Class load was null");
        }
        return clazz;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        if (this.map.containsKey(string)) {
            return new ByteArrayInputStream(this.map.get(string));
        }
        return super.getResourceAsStream(string);
    }
}

