/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.demos.autoanalysis;

import infodynamics.demos.autoanalysis.AutoAnalyser;
import infodynamics.measures.continuous.ActiveInfoStorageCalculator;
import infodynamics.measures.continuous.InfoMeasureCalculatorContinuous;
import infodynamics.measures.continuous.gaussian.ActiveInfoStorageCalculatorGaussian;
import infodynamics.measures.continuous.kernel.ActiveInfoStorageCalculatorKernel;
import infodynamics.measures.continuous.kraskov.ActiveInfoStorageCalculatorKraskov;
import infodynamics.measures.discrete.ActiveInformationCalculatorDiscrete;
import infodynamics.measures.discrete.InfoMeasureCalculatorDiscrete;
import infodynamics.utils.MatrixUtils;
import java.util.Vector;
import javax.swing.JOptionPane;

public class AutoAnalyserAIS
extends AutoAnalyser {
    private static final long serialVersionUID = 1L;
    protected static final String DISCRETE_PROPNAME_K = "k_HISTORY";
    protected String[] gaussianProperties;
    protected String[] gaussianPropertiesFieldNames;
    protected String[] gaussianPropertyDescriptions;
    protected String[] kernelProperties;
    protected String[] kernelPropertiesFieldNames;
    protected String[] kernelPropertyDescriptions;
    protected String[] kraskovProperties;
    protected String[] kraskovPropertiesFieldNames;
    protected String[] kraskovPropertyDescriptions;

    public AutoAnalyserAIS() {
    }

    public AutoAnalyserAIS(String string) {
        super(string);
    }

    @Override
    protected void makeSpecificInitialisations() {
        this.numVariables = 1;
        this.variableColNumLabels = new String[]{"Variable"};
        this.useAllCombosCheckBox = true;
        this.useStatSigCheckBox = true;
        this.wordForCombinations = "variables";
        this.variableRelationshipFormatString = "col_%d";
        this.disableVariableColTextFieldsForAllCombos = new boolean[]{true};
        this.indentsForAllCombos = 1;
        this.measureAcronym = "AIS";
        this.appletTitle = "JIDT Active Information Storage Auto-Analyser";
        this.calcTypes = new String[]{"Discrete", "Binned", "Gaussian", "Kraskov (KSG)", "Kernel"};
        this.unitsForEachCalc = new String[]{"bits", "bits", "nats", "nats", "bits"};
        this.discreteClass = ActiveInformationCalculatorDiscrete.class;
        this.discreteProperties = new String[]{"base", DISCRETE_PROPNAME_K};
        this.discretePropertyDefaultValues = new String[]{"2", "1"};
        this.discretePropertyDescriptions = new String[]{"Number of discrete states available for each variable (i.e. 2 for binary)", "History embedding length (k_HISTORY)"};
        this.abstractContinuousClass = ActiveInfoStorageCalculator.class;
        this.commonContPropertyNames = new String[]{DISCRETE_PROPNAME_K, "TAU"};
        this.commonContPropertiesFieldNames = new String[]{"K_PROP_NAME", "TAU_PROP_NAME"};
        this.commonContPropertyDescriptions = new String[]{"History embedding length (k_HISTORY)", "History embedding delay (k_TAU)"};
        this.gaussianProperties = new String[0];
        this.gaussianPropertiesFieldNames = new String[0];
        this.gaussianPropertyDescriptions = new String[0];
        this.kernelProperties = new String[]{"KERNEL_WIDTH", "DYN_CORR_EXCL", "NORMALISE"};
        this.kernelPropertiesFieldNames = new String[]{"KERNEL_WIDTH_PROP_NAME", "DYN_CORR_EXCL_TIME_NAME", "NORMALISE_PROP_NAME"};
        this.kernelPropertyDescriptions = new String[]{"Kernel width to be used in the calculation. <br/>If the property NORMALISE is set, then this is a number of standard deviations; otherwise it is an absolute value.", "Dynamic correlation exclusion time or <br/>Theiler window (see Kantz and Schreiber); 0 (default) means no dynamic exclusion window", "(boolean) whether to normalise <br/>each incoming time-series to mean 0, standard deviation 1, or not  (recommended)"};
        this.kraskovProperties = new String[]{"NORMALISE", "k", "NOISE_LEVEL_TO_ADD", "DYN_CORR_EXCL", "NORM_TYPE", "NUM_THREADS", "AUTO_EMBED_METHOD", "AUTO_EMBED_K_SEARCH_MAX", "AUTO_EMBED_TAU_SEARCH_MAX", "AUTO_EMBED_RAGWITZ_NUM_NNS"};
        this.kraskovPropertiesFieldNames = new String[]{"MutualInfoCalculatorMultiVariateKraskov.PROP_NORMALISE", "MutualInfoCalculatorMultiVariateKraskov.PROP_K", "MutualInfoCalculatorMultiVariateKraskov.PROP_ADD_NOISE", "MutualInfoCalculatorMultiVariateKraskov.PROP_DYN_CORR_EXCL_TIME", "MutualInfoCalculatorMultiVariateKraskov.PROP_NORM_TYPE", "MutualInfoCalculatorMultiVariateKraskov.PROP_NUM_THREADS", "PROP_AUTO_EMBED_METHOD", "PROP_K_SEARCH_MAX", "PROP_TAU_SEARCH_MAX", "PROP_RAGWITZ_NUM_NNS"};
        this.kraskovPropertyDescriptions = new String[]{"(boolean) whether to normalise <br/>each incoming time-series to mean 0, standard deviation 1, or not (recommended)", "Number of k nearest neighbours to use <br/>in the full joint kernel space in the KSG algorithm", "Standard deviation for an amount <br/>of random Gaussian noise to add to each variable, to avoid having neighbourhoods with artificially large counts. <br/>(\"false\" may be used to indicate \"0\".). The amount is added in after any normalisation.", "Dynamic correlation exclusion time or <br/>Theiler window (see Kantz and Schreiber); 0 (default) means no dynamic exclusion window", "<br/>Norm type to use in KSG algorithm between the points in each marginal space. <br/>Options are: \"MAX_NORM\" (default), otherwise \"EUCLIDEAN\" or \"EUCLIDEAN_SQUARED\" (both equivalent here)", "Number of parallel threads to use <br/>in computation: an integer > 0 or \"USE_ALL\" (default, to indicate to use all available processors)", "Method to automatically determine embedding length (k_HISTORY)<br/> and delay (k_TAU) for the samples. Default is \"NONE\" meaning values are set manually; other values include: <br/>  -- \"RAGWITZ\" for use of the Ragwitz criteria for both source and destination (searching up to \"AUTO_EMBED_K_SEARCH_MAX\" and \"AUTO_EMBED_TAU_SEARCH_MAX\"); <br/>  -- \"MAX_CORR_AIS\" for maximising the (bias corrected) Active Info Storage (searching up to \"AUTO_EMBED_K_SEARCH_MAX\" and \"AUTO_EMBED_TAU_SEARCH_MAX\"); <br/>Use of values other than \"NONE\" leads to any previous settings for embedding lengths and delays to be overwritten after observations are supplied", "Max. embedding length to search to <br/>if auto embedding (as determined by AUTO_EMBED_METHOD)", "Max. embedding delay to search to <br/>if auto embedding (as determined by AUTO_EMBED_METHOD)", "Number of k nearest neighbours for <br/>Ragwitz auto embedding (if used; defaults to match property \"k\")"};
    }

    @Override
    protected void fillOutAllCombinations(Vector<int[]> vector) {
        int n = 0;
        while (n < this.dataColumns) {
            vector.add(new int[]{n++});
        }
    }

    @Override
    protected String[] setUpLoopsForAllCombos(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) {
        stringBuffer.append("    \n");
        stringBuffer.append("    // Compute for all variables:\n");
        stringBuffer.append("    for (int v = 0; v < " + this.dataColumns + "; v++) {\n");
        String string = "        ";
        stringBuffer.append(string + "// For each variable:\n");
        stringBuffer2.append("\n");
        stringBuffer2.append("# Compute for all variables:\n");
        stringBuffer2.append("for v in range(" + this.dataColumns + "):\n");
        String string2 = "    ";
        stringBuffer2.append(string2 + "# For each variable:\n");
        stringBuffer3.append("\n");
        stringBuffer3.append("% Compute for all variables:\n");
        stringBuffer3.append("for v = 1:" + this.dataColumns + "\n");
        String string3 = "\t";
        stringBuffer3.append(string3 + "% For each variable:\n");
        return new String[]{"v"};
    }

    @Override
    protected void finaliseLoopsForAllCombos(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) {
        stringBuffer.append("    }\n");
        stringBuffer3.append("end\n");
    }

    @Override
    protected String formatStringWithColumnNumbers(String string, int[] nArray) {
        return String.format(string, nArray[0]);
    }

    @Override
    protected boolean skipColumnCombo(int[] nArray) {
        return false;
    }

    @Override
    protected void setObservations(InfoMeasureCalculatorDiscrete infoMeasureCalculatorDiscrete, InfoMeasureCalculatorContinuous infoMeasureCalculatorContinuous, int[] nArray) throws Exception {
        String string = (String)this.calcTypeComboBox.getSelectedItem();
        int n = nArray[0];
        if (string.equalsIgnoreCase("Discrete")) {
            ActiveInformationCalculatorDiscrete activeInformationCalculatorDiscrete = (ActiveInformationCalculatorDiscrete)infoMeasureCalculatorDiscrete;
            activeInformationCalculatorDiscrete.addObservations(MatrixUtils.selectColumn(this.dataDiscrete, n));
        } else if (string.equalsIgnoreCase("Binned")) {
            ActiveInformationCalculatorDiscrete activeInformationCalculatorDiscrete = (ActiveInformationCalculatorDiscrete)infoMeasureCalculatorDiscrete;
            activeInformationCalculatorDiscrete.addObservations(MatrixUtils.discretise(MatrixUtils.selectColumn(this.data, n), Integer.parseInt((String)this.propertyValues.get("base"))));
        } else {
            ActiveInfoStorageCalculator activeInfoStorageCalculator = (ActiveInfoStorageCalculator)infoMeasureCalculatorContinuous;
            activeInfoStorageCalculator.setObservations(MatrixUtils.selectColumn(this.data, n));
        }
    }

    @Override
    protected AutoAnalyser.CalcProperties assignCalcProperties(String string) throws Exception {
        AutoAnalyser.CalcProperties calcProperties = super.assignCalcProperties(string);
        if (calcProperties == null) {
            calcProperties = new AutoAnalyser.CalcProperties();
            calcProperties.calc = this.assignCalcObjectContinuous(string);
            calcProperties.calcClass = calcProperties.calc.getClass();
            if (string.equalsIgnoreCase("Gaussian")) {
                calcProperties.classSpecificPropertyNames = this.gaussianProperties;
                calcProperties.classSpecificPropertiesFieldNames = this.gaussianPropertiesFieldNames;
                calcProperties.classSpecificPropertyDescriptions = this.gaussianPropertyDescriptions;
            } else if (string.equalsIgnoreCase("Kraskov (KSG)")) {
                calcProperties.classSpecificPropertyNames = this.kraskovProperties;
                calcProperties.classSpecificPropertiesFieldNames = this.kraskovPropertiesFieldNames;
                calcProperties.classSpecificPropertyDescriptions = this.kraskovPropertyDescriptions;
            } else if (string.equalsIgnoreCase("Kernel")) {
                calcProperties.classSpecificPropertyNames = this.kernelProperties;
                calcProperties.classSpecificPropertiesFieldNames = this.kernelPropertiesFieldNames;
                calcProperties.classSpecificPropertyDescriptions = this.kernelPropertyDescriptions;
            } else {
                calcProperties = null;
                throw new Exception("No recognised calculator selected: " + string);
            }
        }
        return calcProperties;
    }

    @Override
    protected ActiveInfoStorageCalculator assignCalcObjectContinuous(String string) throws Exception {
        if (string.equalsIgnoreCase("Gaussian")) {
            return new ActiveInfoStorageCalculatorGaussian();
        }
        if (string.equalsIgnoreCase("Kraskov (KSG)")) {
            return new ActiveInfoStorageCalculatorKraskov();
        }
        if (string.equalsIgnoreCase("Kernel")) {
            return new ActiveInfoStorageCalculatorKernel();
        }
        throw new Exception("No recognised continuous calculator selected: " + string);
    }

    @Override
    protected AutoAnalyser.DiscreteCalcAndArguments assignCalcObjectDiscrete() throws Exception {
        int n;
        int n2;
        String string;
        try {
            string = (String)this.propertyValues.get("base");
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Cannot read a value for property base");
            return null;
        }
        try {
            string = (String)this.propertyValues.get(DISCRETE_PROPNAME_K);
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Cannot read a value for property k_HISTORY");
            return null;
        }
        return new AutoAnalyser.DiscreteCalcAndArguments(new ActiveInformationCalculatorDiscrete(n2, n), n2, n2 + ", " + n);
    }

    public static void main(String[] stringArray) {
        new AutoAnalyserAIS();
    }
}

